/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.js;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.oro.text.perl.Perl5Util;
import org.maachang.util.image.ImageConvertor;
import org.maachang.util.image.ImageInfo;

public class BaseValidate {
    private static final String KANA = "\u30a2\u30a3\u30a4\u30a6\u30a6\u30a7\u30a8\u30a9\u30aa\u30ab\u30ac\u30ad\u30ae\u30af\u30b0\u30b1\u30b2\u30b3\u30b4\u30b5\u30b6\u30b7\u30b8\u30b9\u30ba\u30bb\u30bc\u30bd\u30be\u30bf\u30c0\u30c1\u30c2\u30c3\u30c4\u30c5\u30c6\u30c7\u30c8\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d0\u30d1\u30d2\u30d3\u30d4\u30d5\u30d6\u30d7\u30d8\u30d9\u30da\u30db\u30dc\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e3\u30e4\u30e5\u30e6\u30e7\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ee\u30ef\u30f0\u30f2\u30f3\u30fc";
    private static final String HIRA = "\u3042\u3043\u3044\u3045\u3046\u3047\u3048\u3049\u304a\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054\u3055\u3056\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e\u305f\u3060\u3061\u3062\u3063\u3064\u3065\u3066\u3067\u3068\u3069\u306a\u306b\u306c\u306d\u306e\u306f\u3070\u3071\u3072\u3073\u3074\u3075\u3076\u3077\u3078\u3079\u307a\u307b\u307c\u307d\u307e\u307f\u3080\u3081\u3082\u3083\u3084\u3085\u3086\u3087\u3088\u3089\u308a\u308b\u308c\u308d\u308e\u308f\u3090\u3091\u3092\u3093\u30fc";
    private static final int ONLY_NUMBER = 1;
    private static final int ONLY_ALPHABET = 2;
    private static final int ONLY_ASCII = 4;
    private static final int ONLY_KANA = 8;
    private static final int ONLY_HIRA = 16;

    public static final boolean isString(int type, Integer min, Integer max, String src) {
        if (src == null || (src = src.trim()).length() <= 0) {
            src = "";
        }
        if (!BaseValidate.checkType(src, type)) {
            return true;
        }
        if (!BaseValidate.minLength(src, min)) {
            return true;
        }
        return !BaseValidate.maxLength(src, max);
    }

    public static final boolean isDate(String format, String src) {
        if (src == null || (src = src.trim()).length() <= 0 || format == null || (format = format.trim()).length() <= 0) {
            return true;
        }
        boolean ret = false;
        try {
            new SimpleDateFormat(format, Locale.JAPAN).parse(src);
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }

    public static final boolean isMatch(String match, String src) {
        return BaseValidate.isPerl5Util_Match(match, src);
    }

    public static final boolean isZip(String src) {
        return BaseValidate.isPerl5Util_Match("/^\\d{3}\\-\\d{4}$/", src);
    }

    public static final boolean isIsbn(String src) {
        return BaseValidate.isPerl5Util_Match("/ISBN\\x20(?=.{13}$)\\d{1,5}([- ])\\d{1,7}\\1\\d{1,6}\\1(\\d|X)$/", src);
    }

    public static final boolean isIpAddress(String src) {
        return BaseValidate.isPerl5Util_Match("/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$/", src);
    }

    public static final boolean isUrl(String src) {
        return BaseValidate.isPerl5Util_Match("/^(((ht|f)tp(s?))\\:\\/\\/)([0-9a-zA-Z\\-]+\\.)+[a-zA-Z]{2,6}(\\:[0-9]+)?(\\/\\S*)?$/", src);
    }

    public static final boolean isEmail(String src) {
        return BaseValidate.isPerl5Util_Match("/^[_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*(\\.([a-z]){2,4})$/", src);
    }

    public static final boolean isImageWidthHeight(byte[] binary, int width, int height) {
        if (binary == null || binary.length <= 0 || width <= 0 || width > 65535 || height <= 0 || height > 65535) {
            return true;
        }
        try {
            ImageInfo img = ImageConvertor.loadImage((InputStream)new ByteArrayInputStream(binary));
            if (img.getWidth() > width || img.getHeight() > height) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private static boolean checkType(String chkString, int type) {
        char c;
        int len;
        boolean chk = false;
        if ((type & 1) != 0) {
            len = chkString.length();
            int cnt = 0;
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                char c2 = chkString.charAt(i);
                if (c2 < '0' || c2 > '9') {
                    if (cnt == 0) {
                        if (i == 0 && c2 == '-') {
                            cnt = -1;
                        } else {
                            buf.append(chkString.charAt(i));
                        }
                    } else if (cnt != 0 && c2 != '.') {
                        buf.append(chkString.charAt(i));
                    }
                }
                ++cnt;
                ++i;
            }
            chk = true;
            chkString = buf.toString();
        }
        if ((type & 2) != 0) {
            len = chkString.length();
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                c = chkString.charAt(i);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    buf.append(chkString.charAt(i));
                }
                ++i;
            }
            chk = true;
            chkString = buf.toString();
        }
        if ((type & 4) != 0) {
            len = chkString.length();
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                c = chkString.charAt(i);
                if (c > '\u00ff') {
                    buf.append(chkString.charAt(i));
                }
                ++i;
            }
            chk = true;
            chkString = buf.toString();
        }
        if ((type & 8) != 0) {
            len = chkString.length();
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                String c3 = chkString.substring(i, i + 1);
                if (KANA.indexOf(c3) == -1) {
                    buf.append(chkString.charAt(i));
                }
                ++i;
            }
            chk = true;
            chkString = buf.toString();
        }
        if ((type & 0x10) != 0) {
            len = chkString.length();
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < len) {
                String c4 = chkString.substring(i, i + 1);
                if (HIRA.indexOf(c4) == -1) {
                    buf.append(chkString.charAt(i));
                }
                ++i;
            }
            chk = true;
            chkString = buf.toString();
        }
        return !chk || chkString.length() <= 0;
    }

    private static boolean minLength(String chkString, Integer min) {
        if (min == null) {
            return true;
        }
        int len = -1;
        try {
            len = min;
        }
        catch (Exception e) {
            len = -1;
        }
        if (len == -1) {
            return true;
        }
        return chkString.length() > len;
    }

    private static boolean maxLength(String chkString, Integer max) {
        if (max == null) {
            return true;
        }
        int len = -1;
        try {
            len = max;
        }
        catch (Exception e) {
            len = -1;
        }
        if (len == -1) {
            return true;
        }
        return chkString.length() < len;
    }

    private static boolean isPerl5Util_Match(String match, String src) {
        try {
            if (match == null || match.length() <= 0) {
                return true;
            }
            if (src == null || (src = src.trim()).length() <= 0) {
                return true;
            }
            boolean ret = new Perl5Util().match(match, src);
            return !ret;
        }
        catch (Exception e) {
            return true;
        }
    }
}

