/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

class ModelApiManager {
    private static final Log LOG = LogFactory.getLog(ModelApiManager.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[modelApi]";
    protected static final String MODEL_NAME_FOODER = "Model";
    protected static final String MODEL_CUSTOM = "Custom";
    private static final String READ_DIR = ModelApiManager.baseDir();
    private static final long CHECK_TIME = 30000L;
    private long beforeTime;
    private String modelCode;
    private SrcScript srcScript;
    private int packageId;
    private final Object sync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelApiManager() throws Exception {
        block5: {
            this.beforeTime = -1L;
            this.modelCode = null;
            this.srcScript = null;
            this.packageId = -1;
            this.sync = new Object();
            try {
                if (GlobalManager.getValue((String)"DBMS_POOL") == null) break block5;
                Object object = this.sync;
                synchronized (object) {
                    this.loadScript();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"## [modelApi] loadScriptError", (Throwable)e);
                throw e;
            }
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    private static final String baseDir() {
        try {
            return String.valueOf(FileUtil.getFullPath((String)"model/")) + FileUtil.FILE_SPACE;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.beforeTime = -1L;
            this.modelCode = null;
            this.srcScript = null;
            this.packageId = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.loadScript();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useScript() throws Exception {
        long time = System.currentTimeMillis();
        Object object = this.sync;
        synchronized (object) {
            if (GlobalManager.getValue((String)"DBMS_POOL") != null) {
                if (this.packageId != -1 && this.packageId != JsDef.getDefaultPackageId()) {
                    this.loadScript();
                } else if (this.beforeTime + 30000L <= time) {
                    if (this.modelCode == null || !this.modelCode.equals(this.createModelMonitor())) {
                        this.loadScript();
                    } else {
                        this.beforeTime = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript() {
        SrcScript ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.srcScript;
        }
        return ret;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    private void loadScript() throws Exception {
        int cnt = 0;
        String beforeManagerCode = this.modelCode;
        int beforePackageId = this.packageId;
        long beforeBeforeTime = this.beforeTime;
        SimpleScriptContext ctx = null;
        try {
            try {
                String[] models = ScriptDef.getUseScript(READ_DIR);
                if (models != null && models.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    this.modelCode = ScriptDef.getScriptManagerCode(models, READ_DIR);
                    this.packageId = JsDef.pushDefaultPackage(buf);
                    this.beforeTime = System.currentTimeMillis();
                    int len = models.length;
                    int i = 0;
                    while (i < len) {
                        if (models[i].endsWith(".ms")) {
                            models[i] = models[i].substring(0, models[i].length() - ".ms".length());
                        }
                        if (!models[i].endsWith(MODEL_CUSTOM) && models[i].endsWith(MODEL_NAME_FOODER)) {
                            ++cnt;
                            String modelName = models[i].substring(0, models[i].length() - MODEL_NAME_FOODER.length());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">read[model] - " + modelName));
                            }
                            this.putModel(modelName, buf);
                        }
                        ++i;
                    }
                    String script = buf.toString();
                    buf = null;
                    this.srcScript = new SrcScript(script);
                    ExternalBindings bindings = ExternalBindings.getInstance();
                    bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                    ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
                    ctx = new SimpleScriptContext();
                    ctx.setBindings((Bindings)bindings, 100);
                    engine.setContext(ctx);
                    engine.put("javax.script.filename", SCRIPT_NAME);
                    engine.eval(script);
                    Map modelManager = ApiManager.getLocal();
                    bindings.clear();
                    ApiManager.getInstance().setModelMap(modelManager);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"** model-cache\u3092\u8aad\u307f\u8fbc\u307f");
                    }
                }
                if (cnt <= 0) {
                    this.modelCode = null;
                    this.packageId = -1;
                    ApiManager.getInstance().setModelMap(null);
                    this.beforeTime = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                this.modelCode = beforeManagerCode;
                this.packageId = beforePackageId;
                this.beforeTime = beforeBeforeTime;
                throw e;
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }

    private String createModelMonitor() throws Exception {
        String[] models = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(models, READ_DIR);
    }

    private void putModel(String model, StringBuilder buf) throws Exception {
        buf.append("\n\n");
        buf.append("var ").append(model).append(" = baseModel(\"").append(model).append("\");\n");
        String modelScript = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + model + MODEL_NAME_FOODER + ".ms"), (String)"UTF8");
        if (modelScript != null && (modelScript = modelScript.trim()).length() > 0) {
            buf.append(modelScript).append("\n");
        }
        modelScript = null;
        String custom = String.valueOf(READ_DIR) + "/" + model + MODEL_CUSTOM + ".ms";
        if (FileUtil.isFileExists((String)custom) && (modelScript = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + custom), (String)"UTF8")) != null && (modelScript = modelScript.trim()).length() > 0) {
            buf.append("\n").append(modelScript).append("\n");
        }
    }
}

