/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.util.FileUtil;

class LibApiManager {
    private static final Log LOG = LogFactory.getLog(LibApiManager.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[libApi]";
    private static final String READ_DIR = LibApiManager.baseDir();
    private static final long CHECK_TIME = 30000L;
    private long beforeTime = -1L;
    private String libCode = null;
    private SrcScript srcScript = null;
    private int packageId = -1;
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibApiManager() throws Exception {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.loadScript();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## [libApi] loadScriptError", (Throwable)e);
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    private static final String baseDir() {
        try {
            return String.valueOf(FileUtil.getFullPath((String)"lib/")) + FileUtil.FILE_SPACE;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.beforeTime = -1L;
            this.libCode = null;
            this.srcScript = null;
            this.packageId = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.loadScript();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useScript() throws Exception {
        long time = System.currentTimeMillis();
        Object object = this.sync;
        synchronized (object) {
            if (this.packageId != -1 && this.packageId != JsDef.getDefaultPackageId()) {
                this.loadScript();
            } else if (this.beforeTime + 30000L <= time) {
                if (this.libCode == null || !this.libCode.equals(this.createLibMonitor())) {
                    this.loadScript();
                } else {
                    this.beforeTime = System.currentTimeMillis();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript() {
        SrcScript ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.srcScript;
        }
        return ret;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    private void loadScript() throws Exception {
        int cnt = 0;
        String beforeManagerCode = this.libCode;
        int beforePackageId = this.packageId;
        long beforeBeforeTime = this.beforeTime;
        SimpleScriptContext ctx = null;
        try {
            try {
                String[] libs = ScriptDef.getUseScript(READ_DIR);
                if (libs != null && libs.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    this.libCode = ScriptDef.getScriptManagerCode(libs, READ_DIR);
                    this.packageId = JsDef.pushDefaultPackage(buf);
                    this.beforeTime = System.currentTimeMillis();
                    int len = libs.length;
                    int i = 0;
                    while (i < len) {
                        String s = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + libs[i]), (String)"UTF8");
                        if (s != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">read[lib] - " + libs[i]));
                            }
                            if (cnt != 0) {
                                buf.append("\n");
                            }
                            buf.append(s);
                            ++cnt;
                        }
                        ++i;
                    }
                    String script = buf.toString();
                    buf = null;
                    this.srcScript = new SrcScript(script);
                    ExternalBindings bindings = ExternalBindings.getInstance();
                    bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                    ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
                    ctx = new SimpleScriptContext();
                    ctx.setBindings((Bindings)bindings, 100);
                    engine.setContext(ctx);
                    engine.put("javax.script.filename", SCRIPT_NAME);
                    engine.eval(script);
                    Map libManager = ApiManager.getLocal();
                    bindings.clear();
                    ApiManager.getInstance().setLibMap(libManager);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"** lib-cache\u3092\u8aad\u307f\u8fbc\u307f");
                    }
                }
                if (cnt <= 0) {
                    this.libCode = null;
                    this.packageId = -1;
                    ApiManager.getInstance().setLibMap(null);
                    this.beforeTime = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                this.libCode = beforeManagerCode;
                this.packageId = beforePackageId;
                this.beforeTime = beforeBeforeTime;
                throw e;
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }

    private String createLibMonitor() throws Exception {
        String[] libs = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(libs, READ_DIR);
    }
}

