/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.dao.MasterCache;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.manager.GlobalManager;

class CoreApiManager {
    private static final Log LOG = LogFactory.getLog(CoreApiManager.class);
    protected static final String ENGINE_NAME = "js";
    private static final String[] LIST = new String[]{"org/maachang/comet/httpd/engine/script/js/default.js", "org/maachang/comet/httpd/engine/script/js/log.js", "org/maachang/comet/httpd/engine/script/js/exception.js", "org/maachang/comet/httpd/engine/script/js/io.js", "org/maachang/comet/httpd/engine/script/js/file_list.js", "org/maachang/comet/httpd/engine/script/js/html.js", "org/maachang/comet/httpd/engine/script/js/validate.js", "org/maachang/comet/httpd/engine/script/js/tag.js", "org/maachang/comet/httpd/engine/script/js/master_cache.js", "org/maachang/comet/httpd/engine/script/js/record.js", "org/maachang/comet/httpd/engine/script/js/base_model.js", "org/maachang/comet/httpd/engine/script/js/image.js", "org/maachang/comet/httpd/engine/script/js/mdbm.js", "org/maachang/comet/httpd/engine/script/js/http_client.js", "org/maachang/comet/httpd/engine/script/js/mail.js", "org/maachang/comet/httpd/engine/script/js/template.js", "org/maachang/comet/httpd/engine/script/js/rpc.js", "org/maachang/comet/httpd/engine/script/js/utils.js", "org/maachang/comet/httpd/engine/script/js/mttml.js", "org/maachang/comet/httpd/engine/script/js/startup.js"};
    private static final String[] LIST_NAME = new String[]{"*base_script", "*log", "*exception", "*io", "*file_list", "*html", "*validate", "*tag", "*master_cache", "*record", "*base_model", "*image", "*mdbm", "*http_client", "*mail", "*template", "*rpc", "*utils", "*mttml", "*startup"};
    private static final String HEAD = "*";
    private HashMap<String, SrcScript> srcScripts = null;
    private final Object sync = new Object();

    public CoreApiManager() throws Exception {
        try {
            this.loadScripts();
        }
        catch (Exception e) {
            LOG.error((Object)"## [coreApi] loadScriptError", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript(String path) {
        if (!this.isCache(path)) {
            return null;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.srcScripts != null) {
                return this.srcScripts.get(path);
            }
        }
        return null;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.startsWith(HEAD);
    }

    private void loadScripts() throws Exception {
        SimpleScriptContext ctx = null;
        int len = LIST.length;
        try {
            MasterCache masterCache = new MasterCache();
            Map shared = Collections.synchronizedMap(new HashMap());
            GlobalManager.getInstance().put("MASTER_DB_CACHE_MANAGER", (Object)masterCache);
            GlobalManager.getInstance().put("SHARED_MEMORY_MANAGER", shared);
            ExternalBindings bindings = ExternalBindings.getInstance();
            bindings.put("_$script$context", (Object)"");
            bindings.put("_$$maachang_comet_manager", (Object)GlobalManager.getInstance());
            bindings.put("_$cachedb$params", (Object)masterCache);
            bindings.put("_$shared$params", (Object)shared);
            ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
            ctx = new SimpleScriptContext();
            ctx.setBindings((Bindings)bindings, 100);
            engine.setContext(ctx);
            this.srcScripts = new HashMap();
            int i = 0;
            while (i < len) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">read[coreApi] - " + LIST_NAME[i]));
                }
                String script = ScriptDef.getScriptByResource(LIST[i]);
                this.srcScripts.put(LIST_NAME[i], new SrcScript(script));
                engine.put("javax.script.filename", LIST_NAME[i]);
                engine.eval(script);
                ++i;
            }
            Map coreApi = ApiManager.getLocal();
            bindings.clear();
            ApiManager.getInstance().setCoreApiMap(coreApi);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"** coreApi-cache\u3092\u8aad\u307f\u8fbc\u307f");
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }
}

