/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.EnvJavascript;
import org.maachang.comet.httpd.engine.HttpdDef;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.PublicCache;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

class HttpdPublicManager
implements HttpdExecutionManager {
    private static final long NOT_GZIP_LENGTH = 512L;
    private static final long ONE_WRITE_BY_LENGTH = 8192L;
    private String publicDirectory = null;

    private HttpdPublicManager() {
    }

    public HttpdPublicManager(String currentDirectory) throws Exception {
        this.publicDirectory = ScriptDef.trimCurrentDirectory(currentDirectory) + "public/";
    }

    protected void finalize() throws Exception {
        this.publicDirectory = null;
    }

    public HttpdResponse get(HttpdRequest request) throws Exception {
        HttpdResponse ret;
        block41: {
            if (request == null) {
                throw new HttpdStateException(400, "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u4e0d\u6b63\u3067\u3059");
            }
            ret = null;
            try {
                String path = this.getUsePath(request.getUrlPath());
                this.pushUrl(request, path);
                if (HttpdPublicManager.isJsOrCssOrIco(path)) {
                    byte[] data = PublicCache.getInstance().getData(path);
                    if (data == null) break block41;
                    long time = PublicCache.getInstance().getLastTime(path);
                    ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                    ret.setCookieSession(request);
                    ret.getHeader().setHeader("Last-Modified", HttpdTimestamp.getTimestamp(time));
                    ret.setHttpClose(false);
                    if (path.toLowerCase().endsWith(".js")) {
                        String js = new String(data, "UTF8");
                        js = EnvJavascript.convert(request, js);
                        data = js.getBytes("UTF8");
                        js = null;
                    }
                    ret.getHeader().setHeader("Content-Length", String.valueOf(data.length));
                    if ((long)data.length < 512L) {
                        ret.setGzip(false);
                    }
                    OutputStream out = null;
                    try {
                        out = ret.getOutput();
                        out.write(data);
                        out.flush();
                        out.close();
                        out = null;
                        break block41;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!FileUtil.isFileExists((String)path)) break block41;
                if (!FileUtil.isRead((String)path)) {
                    throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306f\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                ret.setCookieSession(request);
                ret.getHeader().setHeader("Last-Modified", HttpdTimestamp.getTimestamp(FileUtil.getLastTime((String)path)));
                long flen = FileUtil.getLength((String)path);
                ret.getHeader().setHeader("Content-Length", String.valueOf(flen));
                ret.setHttpClose(false);
                if (flen < 512L) {
                    ret.setGzip(false);
                }
                if (flen >= 8192L) {
                    BufferedInputStream bi = null;
                    OutputStream out = null;
                    try {
                        bi = new BufferedInputStream(new FileInputStream(path));
                        out = ret.getOutput();
                        byte[] bin = new byte[1024];
                        while (true) {
                            int len;
                            if ((len = bi.read(bin)) <= 0) {
                                if (len > -1) continue;
                                break;
                            }
                            out.write(bin, 0, len);
                        }
                        out.flush();
                        out.flush();
                        out.close();
                        out = null;
                        bi.close();
                        bi = null;
                        break block41;
                    }
                    finally {
                        if (bi != null) {
                            try {
                                bi.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                byte[] bin = FileUtil.getFile((String)path);
                OutputStream out = null;
                try {
                    out = ret.getOutput();
                    out.write(bin);
                    out.flush();
                    out.close();
                    out = null;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    out = null;
                }
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
        }
        return ret;
    }

    public long getFileTime(String path) {
        if (HttpdPublicManager.isJsOrCssOrIco(path = this.getUsePath(path))) {
            try {
                return PublicCache.getInstance().getLastTime(path);
            }
            catch (Exception exception) {
            }
        } else if (FileUtil.isFileExists((String)path) && FileUtil.isRead((String)path)) {
            return FileUtil.getLastTime((String)path);
        }
        return -1L;
    }

    public boolean isPath(String path) {
        if (HttpdPublicManager.isJsOrCssOrIco(path = this.getUsePath(path))) {
            try {
                return PublicCache.getInstance().getLastTime(path) > 0L;
            }
            catch (Exception exception) {
            }
        } else if (FileUtil.isFileExists((String)path)) {
            return true;
        }
        return false;
    }

    public boolean isDirectory(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return FileUtil.isDirExists((String)(path = String.valueOf(this.publicDirectory) + path));
    }

    public boolean isRead(String path) {
        if (HttpdPublicManager.isJsOrCssOrIco(path = this.getUsePath(path))) {
            boolean ret = false;
            try {
                ret = PublicCache.getInstance().getLastTime(path) > 0L;
            }
            catch (Exception e) {
                ret = false;
            }
            return ret;
        }
        if (FileUtil.isFileExists((String)path)) {
            return FileUtil.isRead((String)path);
        }
        return false;
    }

    private final String getUsePath(String path) {
        if ("/favicon.ico".endsWith(path)) {
            path = String.valueOf(this.publicDirectory) + "img/" + "/favicon.ico".substring(1, "/favicon.ico".length());
            if (!FileUtil.isFileExists((String)path)) {
                path = this.publicDirectory + "/favicon.ico".substring(1, "/favicon.ico".length());
            }
        } else {
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            if ((path = String.valueOf(this.publicDirectory) + path).endsWith("/")) {
                int len = HttpdDef.INDEX_HTML.length;
                int i = 0;
                while (i < len) {
                    String ph = String.valueOf(path) + HttpdDef.INDEX_HTML[i];
                    if (FileUtil.isFileExists((String)ph)) {
                        path = ph;
                        break;
                    }
                    ++i;
                }
            }
        }
        return path;
    }

    private final void pushUrl(HttpdRequest request, String path) throws Exception {
        String str = FileUtil.getFullPath((String)"public/");
        path = FileUtil.getFullPath((String)path);
        path = path.substring(str.length(), path.length());
        if (!(path = StringUtil.changeString((String)path, (String)"\\", (String)"/")).startsWith("/")) {
            path = "/" + path;
        }
        request.setUrlPath(path);
    }

    private static final boolean isJsOrCssOrIco(String path) {
        return (path = path.toLowerCase()).endsWith(".js") || path.endsWith(".css") || path.endsWith(".ico");
    }
}

