/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.async;

import java.io.IOException;

class ASyncWriteLock {
    private static final int ETC_MASK = 63;
    private static final long LETC_MASK = 63L;
    private static final int FSS_MASK = -64;
    private static final int RIGHT_SHIFT = 6;
    private long[] sync = null;
    private int waitSize = 0;

    private ASyncWriteLock() {
    }

    public ASyncWriteLock(int size) {
        if (size <= 0) {
            this.sync = null;
        }
        this.sync = new long[ASyncWriteLock.convert(size)];
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        this.sync = null;
    }

    public synchronized void expansion(int size) {
        if (this.sync == null) {
            this.sync = new long[ASyncWriteLock.convert(size)];
        } else {
            int len = ASyncWriteLock.convert(size);
            if (this.sync.length < len) {
                long[] nw = new long[len];
                System.arraycopy(this.sync, 0, nw, 0, this.sync.length);
                this.sync = nw;
            }
        }
    }

    private static final int convert(int size) {
        return ((size & 0xFFFFFFC0) >> 6) + ((size & 0x3F) != 0 ? 1 : 0);
    }

    public synchronized void on(int no) throws Exception {
        if (this.sync != null) {
            long pos = (long)no & 0xFFFFFFFFL;
            long innerPos = pos & 0x3FL;
            int thisPos = (no & 0xFFFFFFC0) >> 6;
            long target = this.sync[thisPos];
            if ((1L << (int)innerPos & target) != 0L) {
                throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bON\u3067\u3059");
            }
            this.sync[thisPos] = 1L << (int)innerPos | target;
            ++this.waitSize;
        }
    }

    public synchronized void off(int no) {
        if (this.sync != null) {
            long pos = (long)no & 0xFFFFFFFFL;
            long innerPos = pos & 0x3FL;
            int thisPos = (no & 0xFFFFFFC0) >> 6;
            long target = this.sync[thisPos];
            if ((1L << (int)innerPos & target) == 0L) {
                return;
            }
            this.sync[thisPos] = (1L << (int)innerPos ^ 0xFFFFFFFFFFFFFFFFL) & target;
            --this.waitSize;
            if (this.waitSize <= 0) {
                this.waitSize = 0;
            }
        }
    }

    public synchronized boolean flag(int no) {
        if (this.sync != null) {
            long pos = (long)no & 0xFFFFFFFFL;
            long innerPos = pos & 0x3FL;
            int thisPos = (no & 0xFFFFFFC0) >> 6;
            long target = this.sync[thisPos];
            return (1L << (int)innerPos & target) != 0L;
        }
        return false;
    }

    public synchronized int size() {
        if (this.sync != null) {
            return this.waitSize;
        }
        return 0;
    }
}

