package org.maachang.dao.dbms.kind;

/**
 * Derby用DBMSサポート定義.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class KindByDerby extends SupportKind {
    
    /**
     * Boolean非サポートフラグ.
     * <BR><BR>
     * Boolean非サポートフラグを取得します.
     * <BR>
     * @return boolean [true]の場合は、サポートしています.
     */
    public boolean isBoolean() {
        return false ;
    }
    
    /**
     * アダプタ名を取得.
     * <BR><BR>
     * アダプタ名を取得します.
     * <BR>
     * @return String アダプタ名が返されます.
     */
    public String getAdapter() {
        return "derby" ;
    }
    
    /**
     * 新しいIDの取得SQL.
     * <BR><BR>
     * 指定モデルに対する新しいIDを取得するSQLが返されます.
     * <BR>
     * @param model 対象のモデル名を設定します.
     * @return String SQLが返されます.
     */
    public String getSequenceId( String model ) {
        return "values IDENTITY_VAL_LOCAL()" ;
    }
}
