package org.maachang.dao.dbms.ctbl;

import org.maachang.conf.Config;

/**
 * テーブル定義.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public interface Table {
    
    /**
     * カラム定義タイプ : BOOLEAN.
     */
    public static final String BOOLEAN = "boolean" ;
    
    /**
     * カラム定義タイプ : Integer.
     */
    public static final String INTEGER = "int" ;
    
    /**
     * カラム定義タイプ : LONG.
     */
    public static final String LONG = "long" ;
    
    /**
     * カラム定義タイプ : FLOAT.
     */
    public static final String FLOAT = "float" ;
    
    /**
     * カラム定義タイプ : DOUBLE.
     */
    public static final String DOUBLE = "double" ;
    
    /**
     * カラム定義タイプ : BINARY.
     */
    public static final String BINARY = "binary" ;
    
    /**
     * カラム定義タイプ : CHAR.
     */
    public static final String CHAR = "char" ;
    
    /**
     * カラム定義タイプ : TEXT.
     */
    public static final String TEXT = "text" ;
    
    /**
     * カラム定義タイプ : DATE.
     */
    public static final String DATE = "date" ;
    
    /**
     * カラム定義タイプ : TIME.
     */
    public static final String TIME = "time" ;
    
    /**
     * カラム定義タイプ : TIMESTAMP.
     */
    public static final String TIMESTAMP = "timestamp" ;
    
    /**
     * カラム定義要素 : index.
     */
    public static final String COLUMN_INDEX = "index" ;
    
    /**
     * カラム定義要素 : key.
     */
    public static final String COLUMN_KEY = "key" ;
    
    /**
     * カラム定義要素 : not null.
     */
    public static final String COLUMN_NOT_NULL = "not_null" ;
    
    /**
     * カラム定義要素 : not null.
     */
    public static final String COLUMN_NOT_NULL2 = "not null" ;
    
    /**
     * カラム定義要素 : unique.
     */
    public static final String COLUMN_UNIQUE = "unique" ;
    
    /**
     * カラム定義要素 : default.
     */
    public static final String COLUMN_DEFAULT = "default" ;
    
    /**
     * テーブルタイプ.
     */
    public static final String TABLE_TYPE = "type" ;
    
    /**
     * 型一覧.
     */
    public static final String[] VALUE_TYPES = {
        BOOLEAN,INTEGER,LONG,FLOAT,DOUBLE,BINARY,CHAR,TEXT,DATE,TIME,TIMESTAMP
    } ;
    
    /**
     * Java変数型一覧.
     */
    public static final String[] VALUE_JAVA_TYPES = {
        "Boolean","Integer","Long","Float","Double","byte[]","String","String",
        "java.sql.Date","java.sql.Time","java.sql.Timestamp" } ;
    
    /**
     * アダプタ名を取得.
     * <BR><BR>
     * アダプタ名を取得します.
     * <BR>
     * @return String アダプタ名が返されます.
     */
    public String getAdapter() ;
    
    /**
     * 指定パラメータから、CreateTable条件を生成.
     * <BR><BR>
     * 指定パラメータから、CreateTable条件を生成します.
     * <BR>
     * @param params 対象のパラメータを設定します.
     * @return String 生成されたCreateTableが返されます.
     */
    public String createTable( Config params ) ;
    
    /**
     * 指定名のテーブル作成SQL文を生成.
     * <BR><BR>
     * 指定名のテーブル作成SQL文を生成します.
     * <BR>
     * @param name 対象のテーブル名を設定します.
     * @param config 対象のコンフィグ情報を設定します.
     * @return String 対象のSQL文が返されます.
     */
    public String createTable( String name,Config config ) ;
    
    /**
     * 指定名のテーブル削除SQL文を生成.
     * <BR><BR>
     * 指定名のテーブル削除SQL文を生成します.
     * <BR>
     * @param name 対象のテーブル名を設定します.
     * @return String 削除用SQL文が返されます.
     */
    public String dropTable( String name ) ;
    
    /**
     * 指定テーブルにカラム追加.
     * <BR><BR>
     * 指定テーブルにカラム追加を行います.
     * <BR>
     * @param table 対象のテーブル名を設定します.
     * @param column 対象のカラム名を設定します.
     * @param config 対象のコンフィグ情報を設定します.
     * @return String 対象のSQL文が返されます.
     */
    public String addColumn( String table,String column,Config config ) ;
    
    /**
     * 指定テーブルにカラム削除.
     * <BR><BR>
     * 指定テーブルから指定カラムを削除します.
     * <BR>
     * @param table 対象のテーブル名を設定します.
     * @param column 対象のカラム名を設定します.
     * @return String 対象のSQL文が返されます.
     */
    public String dropColumn( String table,String column ) ;
    
    /**
     * 指定テーブルのプライマリキーを追加.
     * <BR><BR>
     * 指定テーブルのプライマリキーを追加します.
     * <BR>
     * @param table 対象のテーブル名を設定します.
     * @param config 対象のコンフィグ情報を設定します.
     * @return String 対象のSQL文が返されます.
     */
    public String addPrimaryKey( String table,Config config ) ;
    
    /**
     * 指定テーブルのプライマリキーを削除.
     * <BR><BR>
     * 指定テーブルのプライマリキーを削除します.
     * <BR>
     * @param table 対象のテーブル名を設定します.
     * @return String 対象のSQL文が返されます.
     */
    public String dropPrimaryKey( String table ) ;
    
    /**
     * boolean型を取得.
     * <BR><BR>
     * boolean型を取得します.
     * <BR>
     * @return String boolean型の文字列が返されます.
     */
    public String typeByBoolean() ;
    
    /**
     * intの条件を取得.
     * <BR><BR>
     * intの条件を取得します.
     * <BR>
     * @return String int型の文字列が返されます.
     */
    public String typeByInt() ;
    
    /**
     * longの条件を取得.
     * <BR><BR>
     * longの条件を取得します.
     * <BR>
     * @return String long型の文字列が返されます.
     */
    public String typeByLong() ;
    
    /**
     * floatの条件を取得.
     * <BR><BR>
     * floatの条件を取得します.
     * <BR>
     * @return String float型の文字列が返されます.
     */
    public String typeByFloat() ;
    
    /**
     * doubleの条件を取得.
     * <BR><BR>
     * doubleの条件を取得します.
     * <BR>
     * @return String double型の文字列が返されます.
     */
    public String typeByDouble() ;
    
    /**
     * byte配列の条件を取得.
     * <BR><BR>
     * byte配列の条件を取得します.
     * <BR>
     * @return String byte配列型の文字列が返されます.
     */
    public String typeByBytes() ;
    
    /**
     * char条件を取得.
     * <BR><BR>
     * char条件を取得します.
     * <BR>
     * @return String char型の文字列が返されます.
     */
    public String typeByChar() ;
    
    /**
     * text条件を取得.
     * <BR><BR>
     * text条件を取得します.
     * <BR>
     * @return String text型の文字列が返されます.
     */
    public String typeByText() ;
    
    /**
     * date条件を取得.
     * <BR><BR>
     * date条件を取得します.
     * <BR>
     * @return String date型の文字列が返されます.
     */
    public String typeByDate() ;
    
    /**
     * time条件を取得.
     * <BR><BR>
     * time条件を取得します.
     * <BR>
     * @return String time型の文字列が返されます.
     */
    public String typeByTime() ;
    
    /**
     * timestamp条件を取得.
     * <BR><BR>
     * timestamp条件を取得します.
     * <BR>
     * @return String timestamp型の文字列が返されます.
     */
    public String typeByTimestamp() ;
    
    /**
     * プライマリーキー条件を取得.
     * <BR><BR>
     * プライマリーキー条件を取得します.
     * <BR>
     * @return String プライマリーキー条件の文字列が返されます.
     */
    public String primaryKeyName() ;
    
    /**
     * インデックス条件を取得.
     * <BR><BR>
     * インデックス条件を取得します.
     * <BR>
     * @return String インデックス条件の文字列が返されます.
     */
    public String indexName() ;
    
    /**
     * not_null条件を取得.
     * <BR><BR>
     * not_null条件を取得します.
     * <BR>
     * @return String not_null条件の文字列が返されます.
     */
    public String notNullName() ;
    
    /**
     * unique条件を取得.
     * <BR><BR>
     * unique条件を取得します.
     * <BR>
     * @return String unique条件の文字列が返されます.
     */
    public String uniqueName() ;
    
    /**
     * default条件を取得.
     * <BR><BR>
     * default条件を取得します.
     * <BR>
     * @return Stirng default条件の文字列が返されます.
     */
    public String defaultName() ;
    
    /**
     * BOOLEAN型の型変換情報.
     * <BR><BR>
     * BOOLEAN型での型変換情報を取得します.
     * <BR>
     * @param src 変換元の情報を設定します.
     * @return Object Boolean型となる型情報が返されます.
     */
    public Object getBooleanType( Boolean src ) ;
    
    /**
     * BOOLEAN型[true]情報.
     * <BR><BR>
     * BOOLEAN型の[true]情報が返されます.
     * <BR>
     * @return Object Boolean型の[true]条件が返されます.
     */
    public Object getBooleanByTrue() ;
    
    /**
     * BOOLEAN型[false]情報.
     * <BR><BR>
     * BOOLEAN型の[false]情報が返されます.
     * <BR>
     * @return Object Boolean型の[false]条件が返されます.
     */
    public Object getBooleanByFalse() ;
    
    /**
     * 文字サイズに対するUTF8計算.
     * <BR><BR>
     * 文字サイズに対するUTF8計算処理を行います.
     * @param size 指定サイズを設定します.
     * @return int 計算された結果が返されます.
     */
    public int getUTF8CharSize( int size ) ;
}
