package org.maachang.comet.proxy ;

import java.io.OutputStream;

import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.net.HttpOutputStream;

/**
 * Proxy用コネクションオブジェクト実装.
 * 
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class ProxyHttpConnectionInfoImpl implements HttpConnectionInfo {
    /**
     * HttpSocket.
     */
    private HttpSocket socket = null ;
    
    /**
     * PutputStreamオブジェクト.
     */
    private OutputStream outputStream = null ;
    
    /**
     * コンストラクタ.
     */
    private ProxyHttpConnectionInfoImpl() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * @param socket 対象のソケット情報を設定します.
     * @exception Exception 例外.
     */
    public ProxyHttpConnectionInfoImpl( HttpSocket socket )
        throws Exception {
        if( socket == null || socket.isClosed() == true ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.socket = socket ;
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * コネクションオブジェクトを破棄します.
     */
    public synchronized void destroy() {
        this.cancel() ;
    }
    
    /**
     * コネクションキャンセル.
     * <BR><BR>
     * コネクション処理をキャンセルします.
     */
    public synchronized void cancel() {
    	outputStream = null ;
    }
    
    /**
     * Httpソケットを取得.
     * <BR>
     * @return HttpSocket HttpSocketが返されます.
     */
    public synchronized HttpSocket getSocket() {
        return this.socket ;
    }
    
    /**
     * KeepAliveタイムアウトを設定.
     * <BR>
     * @param KeepAliveタイムアウト値を設定します.
     */
    public synchronized void setTimeout( long timeout ) {
        // 何もしない.
    }
    
    /**
     * KeepAliveカウントを設定.
     * <BR>
     * @param count KeepAliveカウント値をミリ秒で設定します.
     */
    public synchronized void setCount( int count ) {
        // 何もしない.
    }
    
    /**
     * KeepAliveタイムアウト値を取得.
     * <BR><BR>
     * @return long KeepAliveタイムアウト値がミリ秒単位で返されます.
     */
    public synchronized long getTimeout() {
        return 1 ;
    }
    
    /**
     * KeepAliveカウントを取得.
     * <BR><BR>
     * @return int KeepAliveカウント値が返されます.
     */
    public synchronized int getCount() {
        return 1 ;
    }
    
    /**
     * コネクション更新.
     * <BR>
     * @exception Exception 例外.
     */
    public synchronized void update() throws Exception {
        // 何もしない.
    }
    
    /**
     * コネクション再利用.
     */
    public synchronized boolean recyclingConnection() {
        return false ;
    }
    
    /**
     * タイマー初期値に設定.
     */
    public synchronized void resetTimer() {
        // 何もしない.
    }
    
    /**
     * 最終利用時間が返されます.
     * <BR>
     * @return long 最終利用時間が返されます.
     */
    public synchronized long getTimer() {
        return System.currentTimeMillis() ;
    }
    
    /**
     * 送信用ストリームを取得.
     * <BR>
     * @return OutputStream 送信用ストリームが返されます.
     */
    public synchronized OutputStream getOutputStream()
        throws Exception {
    	if( outputStream == null ) {
    		outputStream = new HttpOutputStream( socket.outputStream() ) ;
    	}
    	return outputStream ;
    }
    
    /**
     * コネクションクローズを設定.
     * <BR>
     * @param mode [true]の場合、オブジェクト利用後に
     *             コネクションをクローズするか設定します.
     */
    public synchronized void setCloseFlag( boolean mode ) {
        // 何もしない.
    }
    
    /**
     * コネクションクローズを取得.
     * <BR>
     * @return boolean [true]の場合、コネクションクローズを行います.
     */
    public synchronized boolean isCloseFlag() {
        return true ;
    }
    
    /**
     * 送信用ストリームが生成されているかチェック.
     * <BR>
     * @return boolean [true]の場合、送信ストリームが生成されています.
     */
    public synchronized boolean isOutputStream() {
        return outputStream != null ;
    }
    
    /**
     * オブジェクトが有効かチェック.
     * <BR>
     * @return boolean [true]の場合、有効です.
     */
    public synchronized boolean isUse() {
        return ( socket == null || socket.isClosed() == true ) ? false : true ;
    }
}
