// HttpClientスクリプト.
//

// HttpClientオブジェクト.
HttpClient = function() {} ;

// HTTPサーバに接続.
HttpClient.connection = function( method,url,params,header,userAgent ) {
    if( useString( url ) == false ) {
        return null ;
    }
    if( useString( method ) == false ) {
        method = "GET" ;
    }
    var httpParam = HttpClient.convert( true,params ) ;
    var httpHeader = HttpClient.convert( false,header ) ;
    if( useString( userAgent ) == false ) {
        userAgent = null ;
    }
    var res = null ;
    if( method.toLowerCase() == "post" ) {
        res = org.maachang.comet.httpd.engine.script.service.client.HttpService.post(
            url,httpParam,httpHeader,userAgent ) ;
    }
    else {
        res = org.maachang.comet.httpd.engine.script.service.client.HttpService.get(
            url,httpParam,httpHeader,userAgent ) ;
    }
    if( res != null ) {
        return {"body":res.getBinary(),"state":res.getState(),"mime":res.getContentType()} ;
    }
    return null ;
}

// HTTPサーバにBody情報を付加して接続.
HttpClient.connectionBody = function( url,body,mime,header,params,userAgent ) {
    if( useString( url ) == false || useString( body ) == false ) {
        return null ;
    }
    var httpParam = HttpClient.convert( true,params ) ;
    var httpHeader = HttpClient.convert( false,header ) ;
    if( useString( userAgent ) == false ) {
        userAgent = null ;
    }
    var t = valueof( body ) ;
    if( t == "map" || t == "array" ) {
        var str = new StrBuf ;
        encodeJSON( body,str ) ;
        body = str.toString() ;
        str = null ;
    }
    t = valueof( body ) ;
    if( t == "string" ) {
        body = convertStringByBinary( body,"UTF8" ) ;
    }
    t = valueof( body ) ;
    if( t != "binary" ) {
        return null ;
    }
    var res = null ;
    if( useString( mime ) == true ) {
        res = org.maachang.comet.httpd.engine.script.service.client.HttpService.body(
            url,body,httpParam,httpHeader,mime,userAgent ) ;
    }
    else {
        res = org.maachang.comet.httpd.engine.script.service.client.HttpService.body(
            url,body,httpParam,httpHeader,null,userAgent ) ;
    }
    if( res != null ) {
        return {"body":res.getBinary(),"state":res.getState(),"mime":res.getContentType()} ;
    }
    return null ;
}

// HTTPクライアントオブジェクトに変換.
HttpClient.convert = function( mode,params ) {
    if( isNull( params ) || valueof( params ) != "map" ) {
        return null ;
    }
    if( mode == true ) {// param.
        var ret = new org.maachang.comet.httpd.engine.script.service.client.HttpParam() ;
        for( var k in params ) {
            var t = valueof( params[k] ) ;
            if( t == "array" ) {
                var val = params[k] ;
                var len = val.length ;
                for( var i = 0 ; i < len ; i ++ ) {
                    ret.addParam( k,""+val[i] ) ;
                }
            }
            else if( t == "map" ) {
                continue ;
            }
            else {
                ret.addParam( k,""+params[k] ) ;
            }
        }
        return ret ;
    }
    else {// header.
        var ret = new org.maachang.comet.httpd.engine.script.service.client.HttpHeader() ;
        for( var k in params ) {
            var t = valueof( params[k] ) ;
            if( t == "array" ) {
                var val = params[k] ;
                var len = val.length ;
                for( var i = 0 ; i < len ; i ++ ) {
                    ret.addHeader( k,""+val[i] ) ;
                }
            }
            else if( t == "map" ) {
                continue ;
            }
            else {
                ret.addHeader( k,""+params[k] ) ;
            }
        }
        return ret ;
    }
}

