// model実装.
//

////////////////////////////////////////////////////////////////////////////////
// Model系.
////////////////////////////////////////////////////////////////////////////////

// モデル情報を取得.
script_model = function() {
    return _$script$base_model ;
} ;

// BaseModel生成用.
create_base_model = function() {
    // dummy-baseModelの場合は、生成されたことにする.
    if( script_model().isType() == false ) {
        return true ;
    }
    if( _$$maachang_comet_manager.get( "DBMS_POOL" )  == null ) {
        return false ;
    }
    if( script_model().isCreate() == false ) {
        script_model().create(
            (__$type$script != "console" ),
            _$script$context,
            _$$maachang_comet_manager.get( "DBMS_POOL" ).getRecord() ) ;
    }
    return true ;
} ;

// データベースコミット.
commit = function() {
    if( script_model().isCreate() == true ) {
        script_model().commit() ;
    }
} ;

// データベースロールバック.
rollback = function() {
    if( script_model().isCreate() == true ) {
        script_model().rollback() ;
    }
} ;

// SQL文を実行.
sql = function( sql ) {
    if( create_base_model() == false ) {
        return -1 ;
    }
    if( script_model().isCreate() == true ) {
        var ret = script_model().sql( sql ) ;
        if( ret == null ) {
            return null ;
        }
        else if( ret instanceof java.lang.Integer ) {
            return ""+ret ;
        }
        else if( ret instanceof java.lang.String ) {
            return ""+ret ;
        }
        return SubModel.convertResultByJList( ret ) ;
    }
    return -1 ;
} ;


////////////////////////////////////////////////////////////////////////////////
// BaseModel.
////////////////////////////////////////////////////////////////////////////////

// 基本モデルオブジェクト.
baseModel = function(modelName) {
    if( isNull( modelName ) ) {
        return null ;
    }
    modelName = trim( modelName ) ;
    // modelを有効にする.
    if( create_base_model() == false ) {
        return null ;
    }
    
    // model用データ格納条件.
    var baseMap = new java.util.HashMap() ;
    
    // 楽観的ロックエラーが発生したかチェック.
    baseMap.put( "isOptimisticLock",
        function(params) {
            if( isNull( params[SubModel.ERROR_OPTIMISTIC_LOCK] ) == false ) {
                return true ;
            }
            return false ;
        }
    ) ;
    
    // インスタンス生成用.
    baseMap.put( "bean",
        function() {
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            return SubModel.dbmap( script_model().getMetaByJson(modelName) ) ;
        }
    ) ;
    // 保存用.
    baseMap.put( "save",
        function(params) {
            if( isNull( params ) ) {
                return false ;
            }
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var map = SubModel.convertParamByMap( params ) ;
            if( map == null || map.size() <= 0 ) {
                return false ;
            }
            SubModel.removeManyColumn( map ) ;
            var insertFlag = false ;
            var res = script_model().save( modelName,map ) ;
            if( res <= -1 ) {
                // 楽観的ロック例外.
                params[SubModel.ERROR_OPTIMISTIC_LOCK] = true ;
                return false ;
            }
            if( params[SubModel.COLUMN_ID] == null && res != null && typeof(res) == "object" ) {
                if( res instanceof java.lang.Long ) {
                    params[SubModel.COLUMN_ID]=""+res;
                    insertFlag = true ;
                }
            }
            var tmp = null ;
            var createAt = map.get( SubModel.COLUMN_CREATE_TIME ) ;
            var updateAt = map.get( SubModel.COLUMN_UPDATE_TIME ) ;
            var versionValue = map.get( SubModel.COLUMN_OPTIMISTIC_LOCK ) ;
            if( createAt != null && insertFlag == true ) {
                tmp = org.maachang.comet.httpd.engine.script.dao.DaoUtil.convertDateByString( createAt ) ;
                params[SubModel.COLUMN_CREATE_TIME] = SubModel.createStringByDate( tmp ) ;
            }
            if( updateAt != null ) {
                tmp = org.maachang.comet.httpd.engine.script.dao.DaoUtil.convertDateByString( updateAt ) ;
                params[SubModel.COLUMN_UPDATE_TIME] = SubModel.createStringByDate( tmp ) ;
            }
            if( versionValue != null ) {
                params[SubModel.COLUMN_OPTIMISTIC_LOCK] = ""+versionValue ;
            }
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return true ;
        }
    ) ;
    // 指定更新用.
    baseMap.put( "update",
        function(where,params) {
            if( isNull( where ) ) {
                where = "" ;
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( list == null || list.size() <= 0 ) {
                    list = null ;
                }
            }
            script_model().update( modelName,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return true ;
        }
    ) ;
    // 指定削除用(Join).
    baseMap.put( "rjfind",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,true,true ) ;
        }
    ) ;
    // 指定削除用(Join).
    baseMap.put( "removeFindJoin",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,true,true ) ;
        }
    ) ;
    // 指定削除用(ImageJoin).
    baseMap.put( "rifind",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,false,true ) ;
        }
    ) ;
    // 指定削除用(ImageJoin).
    baseMap.put( "removeFindImageJoin",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,false,true ) ;
        }
    ) ;
    // 指定削除用.
    baseMap.put( "rfind",
        function(where,params) {
            return baseMap.get( "removeFind" )( where,params,false,false ) ;
        }
    ) ;
    // 指定削除用.
    baseMap.put( "removeFind",
        function(where,params,join,imgJoin) {
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = trim( where ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( list == null || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            var imgMap = null ;
            var imgMan = null ;
            if( imgJoin == true ) {
                imgMap = SubModel.getModelByImageJoin( baseMap ) ;
                if( isNull( imgMap ) == false ) {
                    imgMan = script_model().getImageOp() ;
                }
            }
            if( isNull( imgMap ) || isNull( imgMan ) ) {
                imgMap = null ;
                imgMan = null ;
            }
            script_model().remove( modelName,imgMan,imgMap,joinMap,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return true ;
        }
    ) ;
    // 削除用(Join).
    baseMap.put( "removeJoin",
        function(params) {
            return baseMap.get( "remove" )( params,true,true ) ;
        }
    ) ;
    // 削除用(Join).
    baseMap.put( "removej",
        function(params) {
            return baseMap.get( "remove" )( params,true,true ) ;
        }
    ) ;
    // 削除用(ImageJoin).
    baseMap.put( "removeImageJoin",
        function(params) {
            return baseMap.get( "remove" )( params,false,true ) ;
        }
    ) ;
    // 削除用(ImageJoin).
    baseMap.put( "removei",
        function(params) {
            return baseMap.get( "remove" )( params,false,true ) ;
        }
    ) ;
    // 削除用
    baseMap.put( "remove",
        function(params,join,imgJoin) {
            if( isNull( params ) ) {
                return false ;
            }
            if( script_model().isType == false ) {
                return false ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return false ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var map = SubModel.convertParamByMap( params ) ;
            if( map == null || map.size() <= 0 ) {
                return false ;
            }
            SubModel.removeManyColumn( map ) ;
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            var imgMap = null ;
            var imgMan = null ;
            if( imgJoin == true ) {
                imgMap = SubModel.getModelByImageJoin( baseMap ) ;
                if( isNull( imgMap ) == false ) {
                    imgMan = script_model().getImageOp() ;
                }
            }
            if( isNull( imgMap ) || isNull( imgMan ) ) {
                imgMap = null ;
                imgMan = null ;
            }
            script_model().removeData( modelName,imgMan,imgMap,joinMap,map ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return true ;
        }
    ) ;
    // 指定取得用(Join).
    baseMap.put( "findJoin",
        function(where,params,sort) {
            return baseMap.get( "find" )( where,params,sort,true,false ) ;
        }
    ) ;
    // 指定取得用(Many).
    baseMap.put( "findMany",
        function(where,params,sort) {
            return baseMap.get( "find" )( where,params,sort,false,true ) ;
        }
    ) ;
    // 指定取得用.
    baseMap.put( "find",
        function(where,params,sort,join,many) {
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = trim( where ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( list == null || list.size() <= 0 ) {
                    list = null ;
                }
            }
            if( isNull( sort ) ) {
                sort = null ;
            }
            if( sort != null && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelByJoinKeys( baseMap ) ;
            }
            var manyMap = null ;
            if( many == true ) {
                manyMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            var ret = script_model().find( modelName,joinMap,manyMap,where,list ) ;
            ret = SubModel.convertResultByJList( ret ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return ret ;
        }
    ) ;
    // 指定取得用(Join).
    baseMap.put( "limitJoin",
        function(offset,limit,where,params,sort) {
            return baseMap.get( "limit" )( offset,limit,where,params,sort,true,false ) ;
        }
    ) ;
    // 指定取得用(Many).
    baseMap.put( "limitMany",
        function(offset,limit,where,params,sort) {
            return baseMap.get( "limit" )( offset,limit,where,params,sort,true,false ) ;
        }
    ) ;
    // 指定取得用(リミット指定).
    baseMap.put( "limit",
        function(offset,limit,where,params,sort,join,many) {
            if( isNull( offset ) ) {
                offset = 0 ;
            }
            if( isNull( limit ) ) {
                limit = -1 ;
            }
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = trim( where ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( list == null || list.size() <= 0 ) {
                    list = null ;
                }
            }
            if( isNull( sort ) ) {
                sort = null ;
            }
            if( sort != null && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelByJoinKeys( baseMap ) ;
            }
            var manyMap = null ;
            if( many == true ) {
                manyMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            var ret = script_model().limit( modelName,joinMap,manyMap,offset,limit,where,list ) ;
            ret = SubModel.convertResultByJList( ret ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return ret ;
        }
    ) ;
    // 指定取得用(最初の１件目だけを取得)(Join).
    baseMap.put( "firstJoin",
        function(where,params,sort) {
            return baseMap.get( "first" )( where,params,sort,true,false ) ;
        }
    ) ;
    // 指定取得用(最初の１件目だけを取得)(Many).
    baseMap.put( "firstMany",
        function(where,params,sort) {
            return baseMap.get( "first" )( where,params,sort,false,true ) ;
        }
    ) ;
    // 指定取得用(最初の１件目だけを取得).
    baseMap.put( "first",
        function(where,params,sort,join,many) {
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = trim( where ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            if( script_model().isType == false ) {
                return null ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return null ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( list == null || list.size() <= 0 ) {
                    list = null ;
                }
            }
            if( isNull( sort ) ) {
                sort = null ;
            }
            if( sort != null && ( sort = trim( sort ) ).length > 0 ) {
                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                    sort = "order by "+sort ;
                }
                where += " " + sort ;
            }
            var joinMap = null ;
            if( join == true ) {
                joinMap = SubModel.getModelByJoinKeys( baseMap ) ;
            }
            var manyMap = null ;
            if( many == true ) {
                manyMap = SubModel.getModelBySrcJoinKeys( modelName,baseMap ) ;
            }
            var ret = script_model().first( modelName,joinMap,manyMap,where,list ) ;
            ret = SubModel.convertResultByJList( ret ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return ret ;
        }
    ) ;
    // 指定数取得.
    baseMap.put( "count",
        function(where,params) {
            if( isNull( where ) ) {
                where = "" ;
            }
            else {
                where = trim( where ) ;
                if( where.length > 0 && startsWith( where.toLowerCase(),"where " ) == false ) {
                    where = "where " + where ;
                }
            }
            if( isNull( params ) ) {
                params = null ;
            }
            else if( valueof( params ) != "array" ) {
                params = [ params ] ;
            }
            if( script_model().isType == false ) {
                return 0 ;
            }
            if( script_model().isCreate() == false ) {
                create_base_model() ;
                if( script_model().isCreate() == false ) {
                    return 0 ;
                }
            }
            var time = null ;
            if( script_model().isDebug() == true ) {
                time = new Date().getTime() ;
            }
            var list = null ;
            if( params != null ) {
                list = SubModel.convertParamByList( params ) ;
                if( list == null || list.size() <= 0 ) {
                    list = null ;
                }
            }
            var ret = script_model().count( modelName,where,list ) ;
            if( script_model().isDebug() == true ) {
                debugLog( "## [" + ( new Date().getTime() - time ) + "ms]" ) ;
            }
            return parseValue( ret ) ;
        }
    ) ;
    // missing_method対応.
    return JSAdapter({
        __get__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            if( baseMap.get( name ) != null ) {
                return baseMap.get( name ) ;
            } ;
            var missing = null ;
            var pms = name.split( "_" ) ;
            if( pms.length >= 3 ) {
                if( pms[ 1 ].toLowerCase() == "by" ) {
                    var funcName = pms[ 0 ].toLowerCase() ;
                    if( funcName == "find" || funcName == "removefind" ||
                        funcName == "first" || funcName == "count" ||
                        funcName == "findjoin" ||
                        funcName == "rfind" || funcName == "rjfind" || funcName == "rifind" ||
                        funcName == "removefindjoin" || funcName == "removefindimagejoin" ||
                        funcName == "firstjoin" || funcName == "findmany" ||
                        funcName == "firstmany" ) {
                        missing = function(params,sort) {
                            if( isNull( params ) ) {
                                params = null ;
                            }
                            if( isNull( sort ) ) {
                                sort = null ;
                            }
                            var where = "" ;
                            var len = pms.length ;
                            for( var i = 2 ; i < len ; i ++ ) {
                                var columnName = org.maachang.dao.dbms.DbUtil.convertJavaNameByDBName( pms[ i ] ) ;
                                pms[ i ] = pms[ i ].toLowerCase() ;
                                if( ( i & 0x00000001 ) == 0 ) {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        return false ;
                                    }
                                    where += " $"+columnName+"=?" ;
                                }
                                else {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        where += " " + pms[ i ] ;
                                    }
                                    else {
                                        return false ;
                                    }
                                }
                            }
                            if( funcName ==  "find" || funcName ==  "first" ||
                                funcName ==  "findjoin" || funcName ==  "firstjoin" ||
                                funcName ==  "findmany" || funcName ==  "firstmany" ) {
                                if( sort != null && ( sort = trim( sort ) ).length > 0 ) {
                                    if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                                        sort = "order by "+sort ;
                                    }
                                    where += " " + sort ;
                                }
                            }
                            where = "where " + where ;
                            if( funcName == "removefind" ) {
                                funcName = "removeFind" ;
                            }
                            else if( funcName == "rfind" ) {
                                funcName = "rfind" ;
                            }
                            else if( funcName == "rjfind" ) {
                                funcName = "rjfind" ;
                            }
                            else if( funcName == "rifind" ) {
                                funcName = "rifind" ;
                            }
                            else if( funcName == "removefindjoin" ) {
                                funcName = "removeFindJoin" ;
                            }
                            else if( funcName == "removefindimagejoin" ) {
                                funcName = "removeFindImageJoin" ;
                            }
                            else if( endsWith( funcName,"join" ) ) {
                                funcName = funcName.substring( 0,funcName.length - "join".length ) + "Join" ;
                            }
                            else if( endsWith( funcName,"many" ) ) {
                                funcName = funcName.substring( 0,funcName.length - "many".length ) + "Many" ;
                            }
                            return baseMap.get( funcName )( where,params ) ;
                        } ;
                    }
                    else if( funcName == "limit" || funcName == "limitjoin" || funcName == "limitmany" ) {
                        missing = function(offset,limit,params,sort) {
                            if( isNull( offset ) ) {
                                offset = 0 ;
                            }
                            if( isNull( limit ) ) {
                                limit = -1 ;
                            }
                            if( isNull( params ) ) {
                                params = null ;
                            }
                            if( isNull( sort ) ) {
                                sort = null ;
                            }
                            var where = "" ;
                            var len = pms.length ;
                            for( var i = 2 ; i < len ; i ++ ) {
                                var columnName = org.maachang.dao.dbms.DbUtil.convertJavaNameByDBName( pms[ i ] ) ;
                                pms[ i ] = pms[ i ].toLowerCase() ;
                                if( ( i & 0x00000001 ) == 0 ) {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        return false ;
                                    }
                                    where += " $"+columnName+"=?" ;
                                }
                                else {
                                    //if( pms[ i ] == "and" || pms[ i ] == "or" ) {
                                    if( pms[ i ] == "and" ) {
                                        where += " " + pms[ i ] ;
                                    }
                                    else {
                                        return false ;
                                    }
                                }
                            }
                            if( sort != null && ( sort = trim( sort ) ).length > 0 ) {
                                if( startsWith( sort.toLowerCase(),"order by" ) == false ) {
                                    sort = "order by "+sort ;
                                }
                                where += " " + sort ;
                            }
                            where = "where " + where ;
                            if( funcName == "limitjoin" ) {
                                funcName = "limitJoin" ;
                            }
                            if( funcName == "limitmany" ) {
                                funcName = "limitMany" ;
                            }
                            return baseMap.get( funcName )( offset,limit,where,params ) ;
                        } ;
                    }
                }
            }
            return missing ;
        },
        __has__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            return baseMap.containsKey(name);
        },
        __put__ : function (name, value) {
            if( isNull( name ) || isNull( value ) ) {
                return ;
            }
            if( value != null ) {
                baseMap.put( name,value ) ;
            } ;
        },
        __delete__ : function (name) {
            if( isNull( name ) ) {
                return ;
            }
            baseMap.remove( name ) ;
        },
        __getIds__ : function () {
            return null ;
        }
    }) ;
} ;

////////////////////////////////////////////////////////////////////////////////
// Model-Sub定義.
////////////////////////////////////////////////////////////////////////////////

// サブModelメソッド群用オブジェクト.
SubModel = function() {} ;

// 予約カラム名.
SubModel.COLUMN_ID = org.maachang.dao.dbms.DbUtil.convertDBNameByJavaName(
    false,org.maachang.dao.ExecutionDao.SEQ_COLUMN ) ;
SubModel.COLUMN_CREATE_TIME = org.maachang.dao.dbms.DbUtil.convertDBNameByJavaName(
    false,org.maachang.dao.ExecutionDao.CREATE_TIME ) ;
SubModel.COLUMN_UPDATE_TIME = org.maachang.dao.dbms.DbUtil.convertDBNameByJavaName(
    false,org.maachang.dao.ExecutionDao.UPDATE_TIME ) ;
SubModel.COLUMN_OPTIMISTIC_LOCK = org.maachang.dao.dbms.DbUtil.convertDBNameByJavaName(
    false,org.maachang.dao.ExecutionDao.OPTIMISTIC_LOCK_COLUMN ) ;

// 楽観的ロックエラーパラメータ格納名.
SubModel.ERROR_OPTIMISTIC_LOCK = "~error_optimisticLock" ;

// 日付カラムタイプを示すオブジェクト.
SubModel.OUTPUT_DATE_TYPE = "new Date:" ;

// dbmap.
SubModel.dbmap = function(map) {
    if( isNull( map ) || ( map instanceof java.util.Map ) == false ) {
        return null ;
    }
    return new JSAdapter({
        __get__ : function(name) {
            if (map.containsKey(name)) {
                var ret = map.get(name);
                return parseValue( ret ) ;
            }
            else if( name == "toString" ) {
                var ret = "{" ;
                var o = map.keySet().toArray() ;
                if( o != null && o.length > 0 ) {
                    var len = o.length ;
                    var cnt = 0 ;
                    for( var i = 0 ; i < len ; i ++ ) {
                        var x = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                        if( cnt != 0 ) {
                            ret += " ," ;
                        }
                        var v = map.get( x ) ;
                        if( v != null ) {
                            if( className( v ) == "JSAdapter" ) {
                                ret += x + ": " + "\""+v.toString+"\"" ;
                            }
                            else {
                                ret += x + ": " + "\""+v+"\"" ;
                            }
                        }
                        else {
                            ret += x + ": \"\"" ;
                        }
                        cnt ++ ;
                    }
                }
                ret += "}" ;
                return ret ;
            }
            else if( name == "length" ) {
                var ret = map.size() ;
                if( isNull( ret ) == true ) {
                    return null ;
                }
                else if( useString( ret ) == false ) {
                    return "" ;
                }
                return parseValue(ret) ;
            }
            else {
                return null ;
            }
        },
        __has__ :  function(name) {
            return map.containsKey(name);
        },
        __delete__ : function (name) {
            if (map.containsKey(name)) {
                map.remove(name) ;
            }
        },
        __put__ : function(name, value) {
            map.put(name, value);
        },
        __getIds__ : function() {
            return map.keySet().toArray();
        },
        toString: function() {
            var ret = "{" ;
            var it = map.keySet().iterator() ;
            var cnt = 0 ;
            for( var x = it.next() ;it.hasNext() ; x = it.next() ) {
                var v = map.get( x ) ;
                if( v != null ) {
                    if( cnt != 0 ) {
                        ret += " ," ;
                    }
                    var v = map.get( x ) ;
                    if( v != null ) {
                        if( className( v ) == "JSAdapter" ) {
                            ret += x + ": " + "\""+v.toString+"\"" ;
                        }
                        else {
                            ret += x + ": " + "\""+v+"\"" ;
                        }
                    }
                    else {
                        ret += x + ": \"\"" ;
                    }
                    cnt ++ ;
                }
            }
            ret += "}" ;
            return ret ;
        },
        length: function() {
            var ret = map.size() ;
            if( isNull( ret ) == true ) {
                return null ;
            }
            else if( useString( ret ) == false ) {
                return "" ;
            }
            ret = parseValue( ret ) ;
            return ret ;
        }
    });
} ;

// パラメータをHashMapに変換.
SubModel.convertParamByMap = function(params) {
    if( isNull( params ) || params.length <= 0 ) {
        return null ;
    }
    var ret = new java.util.HashMap() ;
    for( var k in params ) {
        if( k == SubModel.ERROR_OPTIMISTIC_LOCK ) {
            continue ;
        }
        var x = params[k] ;
        x = SubModel.convertOneParam( x ) ;
        ret.put( k,x ) ;
    }
    return ret ;
}

// 指定リストをArrayListに変換.
SubModel.convertParamByList = function( params ) {
    if( isNull( params ) || params.length <= 0 ) {
        return null ;
    }
    var ret = new java.util.ArrayList() ;
    var len = params.length ;
    for( var i = 0 ; i < len ; i ++ ) {
        var x = params[ i ] ;
        x = SubModel.convertOneParam( x ) ;
        ret.add( x ) ;
    }
    return ret ;
}

// 指定条件を変換.
SubModel.convertOneParam = function( x ) {
    if( isNull( x ) == false ) {
        var clz_x = className( x ) ;
        var type_x = typeof(x) ;
        if( type_x == "object" ) {
            if( clz_x == "NativeDate" ) {
                x = org.maachang.comet.httpd.engine.script.dao.DaoUtil.convertStringByDate( x.toString() ) ;
            }
        }
        else if( type_x == "function" ) {
            if( clz_x == "JSAdapter" ) {
                var vof = valueof( x ) ;
                if( vof == "array" ) {
                    x = SubModel.convertParamByList( x ) ;
                }
                else if( vof == "map" ) {
                    x = SubModel.convertParamByMap( x ) ;
                }
            }
        }
        else if( type_x == "boolean" ) {
            x = new java.lang.Boolean( x ) ;
        }
        else if( type_x != "string" ) {
            x = "" + x ;
        }
    }
    return x ;
}

// 日付オブジェクトを生成.
SubModel.createStringByDate = function(str) {
    if( isNull( str ) ) {
        return ;
    }
    var lst = str.split( "," ) ;
    return new Date( parseValue(lst[0]),
        parseValue(lst[1])-1,
        parseValue(lst[2]),
        parseValue(lst[3]),
        parseValue(lst[4]),
        parseValue(lst[5]) ) ;
}

// 戻りオブジェクトをjlistに変換.
SubModel.convertResultByJList = function(res) {
    if( isNull( res ) || res.size() <= 0 ) {
        return jlist() ;
    }
    var len = res.size() ;
    if( len > 0 ) {
        var lst = new java.util.ArrayList() ;
        for( var i = 0 ; i < len ; i ++ ) {
            var d = res.get( i ) ;
            lst.add( SubModel.convertResultByJMap( d ) ) ;
        }
        var ret = jlist( lst ) ;
        return ret ;
    }
    return jlist() ;
}

// 戻りオブジェクトをjmapに変換.
SubModel.convertResultByJMap = function(map) {
    if( isNull( map ) || map.size() <= 0 ) {
        return null ;
    }
    var o = map.keySet().toArray() ;
    var len = o.length ;
    for( var i = 0 ; i < len ; i ++ ) {
        var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
        var val = map.get( one ) ;
        if( isNull( val ) ) {
            map.put( one,null ) ;
            continue ;
        }
        else if( valueof(val) == "string" ) {
            if( val instanceof java.lang.String ) {
                val = ""+val ;
            }
            if( val.indexOf( SubModel.OUTPUT_DATE_TYPE ) == 0 ) {
                map.put( one,SubModel.createStringByDate( val.substring( SubModel.OUTPUT_DATE_TYPE.length,val.length ) ) ) ;
            }
        }
        else if( val instanceof java.util.Map ) {// 1件のjoin.
            if( val.size() <= 0 ) {
                map.put( one,SubModel.dbmap() ) ;
            }
            else {
                map.put( one,SubModel.convertResultByJMap( val ) ) ;
            }
        }
        else if( val instanceof java.util.List ) {// join.
            if( val.size() <= 0 ) {
                map.put( one,jlist() ) ;
            }
            else {
                map.put( one,SubModel.convertResultByJList( val ) ) ;
            }
        }
    }
    return SubModel.dbmap( map ) ;
}

// joinキー群を取得.
SubModel.getModelByJoinKeys = function( map ) {
    if( isNull( map ) ) {
        return null ;
    }
    var join = map.get( "join" ) ;
    if( join == null || valueof( join ) != "map" ) {
        return null ;
    }
    var ret = new java.util.HashMap() ;
    for( var k in join ) {
        ret.put( k,join[k] ) ;
    }
    if( ret.size() <= 0 ) {
        return null ;
    }
    return ret ;
}

// ImageJoin群を取得.
SubModel.getModelByImageJoin = function( map ) {
    if( isNull( map ) ) {
        return null ;
    }
    var join = map.get( "imageJoin" ) ;
    if( join == null || valueof( join ) != "array" ) {
        return null ;
    }
    var ret = new java.util.ArrayList() ;
    var len = join.length ;
    for( var i = 0 ; i < len ; i ++ ) {
        ret.add( join[ i ] ) ;
    }
    if( ret.size() <= 0 ) {
        return null ;
    }
    return ret ;
}

// 対象テーブルのSrcJoinキー群を取得.
SubModel.getModelBySrcJoinKeys = function( thisModel,map ) {
    var cnt = 0 ;
    var tables = map.get( "srcJoin" ) ;
    if( isNull( tables ) == false && tables.length > 0 ) {
        var len = tables.length ;
        var ret = new java.util.HashMap() ;
        var bindings = context.getBindings(
            javax.script.ScriptContext.ENGINE_SCOPE ) ;
        for( var i = 0 ; i < len ; i ++ ) {
            var addList = null ;
            var name = tables[i] ;
            var model = bindings.get( name ) ;
            if( isNull( model ) ) {
                continue ;
            }
            var join = model.join ;
            if( isNull( join ) == false ) {
                for( var k in join ) {
                    if( join[k] == thisModel ) {
                        if( addList == null ) {
                            addList = new java.util.ArrayList() ;
                            ret.put( name,addList ) ;
                        }
                        addList.add( k ) ;
                        cnt ++ ;
                    }
                }
            }
        }
    }
    if( cnt <= 0 ) {
        return null ;
    }
    return ret ;
}

// １対他の外部結合条件を削除.
// findManyなどで取得された、データには、結合を示すカラム名($結合テーブル名)となります。
// これらは、saveや、remove時には必要ないので、その内容を省いた形で利用しなければ
// する必要があり、このメソッドで、その処理を実施させます.
SubModel.removeManyColumn = function( map ) {
    if( isNull( map ) ) {
        return ;
    }
    if( map instanceof java.util.Map ) {
        if( map.size() <= 0 ) {
            return ;
        }
        var o = map.keySet().toArray() ;
        var len = o.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
            if( startsWith( one,"$" ) ) {
                map.remove( one ) ;
            }
        }
    }
    else {
        if( map.length <= 0 ) {
            return ;
        }
        for( var k in map ) {
            if( startsWith( k,"$" ) ) {
                delete map[k] ;
            }
        }
    }
}

