package org.maachang.comet;

import org.maachang.util.FileUtil;

/**
 * MaachangCometプロジェクト生成用.
 * 
 * @version 2007/09/20
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class Project {
    
    /**
     * コンストラクタ.
     */
    private Project() {
        
    }
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args Javaからのパラメータが設定されます.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new Project().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args )
        throws Exception {
        if( args == null || args.length <= 0 ) {
            throw new IllegalArgumentException( "MaachangCometディレクトリが必要です" ) ;
        }
        
        System.out.println( "*** maachang comet - プロジェクト生成 - ***" ) ;
        System.out.println() ;
        
        String dir = FileUtil.getFullPath( "." ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        // 指定カレントディレクトリ以下にディレクトリを生成.
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_CONFIG ) ;
        System.out.println( MaachangDef.DIRECTORY_CONFIG + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_APPLICATION ) ;
        System.out.println( MaachangDef.DIRECTORY_APPLICATION + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_MODEL ) ;
        System.out.println( MaachangDef.DIRECTORY_MODEL + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_LIB ) ;
        System.out.println( MaachangDef.DIRECTORY_LIB + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_JAR ) ;
        System.out.println( MaachangDef.DIRECTORY_JAR + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_LOG ) ;
        System.out.println( MaachangDef.DIRECTORY_LOG + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_TABLE ) ;
        System.out.println( MaachangDef.DIRECTORY_TABLE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_ERROR_PAGE ) ;
        System.out.println( MaachangDef.DIRECTORY_ERROR_PAGE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_TEMPLATE ) ;
        System.out.println( MaachangDef.DIRECTORY_TEMPLATE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_STARTUP ) ;
        System.out.println( MaachangDef.DIRECTORY_STARTUP + " を生成" ) ;
        
        System.out.println() ;
        
        // MaachangComet環境変数のディレクトリから、情報をコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_CONFIG + " 内容をコピー" ) ;
        copyByConfig( args[ 0 ] ) ;
        
        // startupディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_STARTUP + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_STARTUP ) ;
        
        // publicディレクトリ内用をコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC + " 内容をコピー" ) ;
        copyByPublic( args[ 0 ] ) ;
        
        // imgディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE ) ;
        
        // cssディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS ) ;
        
        // jsディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS ) ;
        
    }
    
    /**
     * コンフィグファイル内容をコピー.
     */
    private final void copyByConfig( String dir )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/"+MaachangDef.DIRECTORY_CONFIG ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        String destDir = FileUtil.getFullPath( "./"+MaachangDef.DIRECTORY_CONFIG ) ;
        if( destDir.endsWith( "\\" ) || destDir.endsWith( "/" ) ) {
            destDir = destDir.substring( 0,destDir.length()-1 ) ;
        }
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                byte[] bin = FileUtil.getFile( dir+FileUtil.FILE_SPACE+lst[ i ] ) ;
                if( bin != null ) {
                    FileUtil.setFile( destDir+FileUtil.FILE_SPACE+lst[ i ],bin ) ;
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
                bin = null ;
            }
        }
    }
    
    /**
     * publicファイル内容をコピー.
     */
    private final void copyByPublic( String dir )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/"+MaachangDef.DIRECTORY_PUBLIC ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        String destDir = FileUtil.getFullPath( "./"+MaachangDef.DIRECTORY_PUBLIC ) ;
        if( destDir.endsWith( "\\" ) || destDir.endsWith( "/" ) ) {
            destDir = destDir.substring( 0,destDir.length()-1 ) ;
        }
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                byte[] bin = FileUtil.getFile( dir+FileUtil.FILE_SPACE+lst[ i ] ) ;
                if( bin != null ) {
                    FileUtil.setFile( destDir+FileUtil.FILE_SPACE+lst[ i ],bin ) ;
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
                bin = null ;
            }
        }
    }
    
    /**
     * 指定ディレクトリをコピー.
     */
    private final void copyByInnerDir( String dir,String inner )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/"+inner ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        if( FileUtil.isDirExists( dir ) == false ) {
            return ;
        }
        String destDir = FileUtil.getFullPath( "./"+inner ) ;
        if( destDir.endsWith( "\\" ) || destDir.endsWith( "/" ) ) {
            destDir = destDir.substring( 0,destDir.length()-1 ) ;
        }
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                byte[] bin = FileUtil.getFile( dir+FileUtil.FILE_SPACE+lst[ i ] ) ;
                if( bin != null ) {
                    FileUtil.setFile( destDir+FileUtil.FILE_SPACE+lst[ i ],bin ) ;
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
                bin = null ;
            }
        }
    }
    
}
