/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.util.StringUtil;

class TableUtil {
    TableUtil() {
    }

    public static final String getColumnName(Table table, String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return null;
        }
        type = type.toLowerCase();
        String result = null;
        int customSize = -1;
        int p = -1;
        p = type.indexOf("(");
        if (p != -1 && type.indexOf(")", p) > p) {
            String putSizeString = type.substring(p);
            type = type.substring(0, p);
            putSizeString = StringUtil.changeString(putSizeString, "(", "");
            putSizeString = StringUtil.changeString(putSizeString, ")", "");
            putSizeString = StringUtil.changeString(putSizeString, "\u3000", "");
            putSizeString = putSizeString.trim();
            customSize = Integer.parseInt(putSizeString);
        }
        if ("boolean".equals(type)) {
            result = table.typeByBoolean();
            p = result.indexOf("(");
            if (p != -1 && result.indexOf(")", p) > p) {
                customSize = -1;
            }
        } else if ("int".equals(type)) {
            result = table.typeByInt();
        } else if ("long".equals(type)) {
            result = table.typeByLong();
        } else if ("float".equals(type)) {
            result = table.typeByFloat();
        } else if ("double".equals(type)) {
            result = table.typeByDouble();
        } else if ("binary".equals(type)) {
            result = table.typeByBytes();
        } else if ("char".equals(type)) {
            if (customSize > 0) {
                customSize = table.getUTF8CharSize(customSize);
            }
            result = table.typeByChar();
        } else if ("text".equals(type)) {
            if (customSize > 0) {
                customSize = table.getUTF8CharSize(customSize);
            }
            result = table.typeByText();
        } else if ("date".equals(type)) {
            result = table.typeByDate();
        } else if ("time".equals(type)) {
            result = table.typeByTime();
        } else if ("timestamp".equals(type)) {
            result = table.typeByTimestamp();
        }
        if (result != null && customSize > 0) {
            p = result.indexOf("(");
            if (p != -1 && result.indexOf(")", p) > p) {
                result = result.substring(0, p);
            }
            result = result + "(" + customSize + ")";
        }
        return result;
    }

    public static final String getColumnType(int[] mode, boolean booleanType, Table table, String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return null;
        }
        String t = type.toLowerCase();
        if ("not_null".equals(t)) {
            mode[0] = 1;
            return table.notNullName();
        }
        if ("not null".equals(t)) {
            mode[0] = 1;
            return table.notNullName();
        }
        if ("unique".equals(t)) {
            mode[0] = 2;
            return table.uniqueName();
        }
        if (t.startsWith("default")) {
            mode[0] = 3;
            String val = type.substring("default".length(), type.length()).trim();
            if (val.startsWith("\"") && val.endsWith("\"")) {
                val = val.substring(1, val.length() - 1);
            } else if (val.startsWith("'") && val.endsWith("'")) {
                val = val.substring(1, val.length() - 1);
            }
            if (!booleanType) {
                String x = (val = val.trim()).toLowerCase();
                if ("true".equals(x)) {
                    val = "1";
                } else if ("false".equals(x)) {
                    val = "0";
                }
            }
            return table.defaultName() + " " + "'" + val + "'";
        }
        return null;
    }

    public static final boolean isIndex(String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return false;
        }
        return "index".equals(type = type.toLowerCase());
    }

    public static final boolean isKey(String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return false;
        }
        return "key".equals(type = type.toLowerCase());
    }

    public static final boolean isType(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return false;
        }
        return "type".equals(key = key.toLowerCase());
    }
}

