/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import java.util.HashSet;
import org.maachang.conf.Config;
import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.dao.dbms.ctbl.TableUtil;
import org.maachang.util.StringUtil;

public class TablePostgre
implements Table {
    public String getAdapter() {
        return "postgresql";
    }

    public String createTable(Config params) {
        StringBuilder buf = new StringBuilder();
        Object[] sections = params.getSections();
        if (sections != null && sections.length > 0) {
            int len = sections.length;
            int i = 0;
            while (i < len) {
                if (sections[i] != null) {
                    this.createOneSection(buf, (String)sections[i], params);
                }
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public String typeByBoolean() {
        return "BOOL";
    }

    public String typeByInt() {
        return "INT4";
    }

    public String typeByLong() {
        return "INT8";
    }

    public String typeByFloat() {
        return "REAL";
    }

    public String typeByDouble() {
        return "DOUBLE PRECISION";
    }

    public String typeByBytes() {
        return "BYTEA";
    }

    public String typeByChar() {
        return "VARCHAR(255)";
    }

    public String typeByText() {
        return "TEXT";
    }

    public String typeByDate() {
        return "DATE";
    }

    public String typeByTime() {
        return "TIME";
    }

    public String typeByTimestamp() {
        return "TIMESTAMP";
    }

    public String primaryKeyName() {
        return "CONSTRAINT [KEY_NAME] PRIMARY KEY";
    }

    public String indexName() {
        return null;
    }

    public String notNullName() {
        return "NOT NULL";
    }

    public String uniqueName() {
        return "UNIQUE";
    }

    public String defaultName() {
        return "DEFAULT";
    }

    private void createOneSection(StringBuilder buf, String section, Config params) {
        if (section == null) {
            return;
        }
        String[] keys = params.getKeys(section);
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            HashSet<String> primaryKey = new HashSet<String>();
            buf.append(this.dropTable(section));
            buf.append("create table ").append(section).append("(");
            buf.append("id INT8 UNIQUE NOT NULL");
            boolean next = true;
            int i = 0;
            while (i < len) {
                if (next) {
                    buf.append(",");
                    next = false;
                }
                String key = keys[i];
                String type = null;
                String not_null = null;
                String unique = null;
                String def = null;
                String[] one = params.getAll(section, key);
                int lenJ = one.length;
                int[] mode = new int[1];
                if (!"id".equals(key.toLowerCase()) && !TableUtil.isType(key)) {
                    int j = 0;
                    while (j < lenJ) {
                        String tmp = null;
                        tmp = TableUtil.getColumnName(this, one[j]);
                        if (tmp != null) {
                            type = tmp;
                        } else {
                            tmp = TableUtil.getColumnType(mode, true, this, one[j]);
                            if (tmp != null) {
                                switch (mode[0]) {
                                    case 1: {
                                        not_null = tmp;
                                        break;
                                    }
                                    case 2: {
                                        unique = tmp;
                                        break;
                                    }
                                    case 3: {
                                        def = tmp;
                                    }
                                }
                            } else {
                                if (TableUtil.isIndex(one[j])) {
                                    primaryKey.add(key.toLowerCase());
                                    not_null = this.notNullName();
                                }
                                if (TableUtil.isKey(one[j])) {
                                    primaryKey.add(key.toLowerCase());
                                    not_null = this.notNullName();
                                }
                            }
                        }
                        ++j;
                    }
                    if (type != null) {
                        buf.append(key.toLowerCase()).append(" ").append(type);
                        if (unique != null) {
                            buf.append(" ").append(unique);
                        }
                        if (not_null != null) {
                            buf.append(" ").append(not_null);
                        }
                        if (def != null && !this.typeByBytes().equals(type)) {
                            buf.append(" ").append(def);
                        }
                        next = true;
                    }
                }
                ++i;
            }
            if (!buf.toString().endsWith(",")) {
                buf.append(",");
            }
            if (primaryKey.size() > 0) {
                buf.append(StringUtil.changeString(this.primaryKeyName(), "[KEY_NAME]", String.valueOf(section.toLowerCase()) + "_pk")).append("(");
                buf.append("id");
                Object[] vals = primaryKey.toArray();
                int lenI = vals.length;
                int i2 = 0;
                while (i2 < lenI) {
                    buf.append(",").append(vals[i2]);
                    ++i2;
                }
                buf.append(")");
            } else {
                buf.append(StringUtil.changeString(this.primaryKeyName(), "[KEY_NAME]", String.valueOf(section.toLowerCase()) + "_pk"));
                buf.append("(id)");
            }
            buf.append(") ; \n");
            buf.append("create sequence ").append(section.toLowerCase()).append("_id_seq").append("; \n");
        }
    }

    public String createTable(String name, Config config) {
        StringBuilder buf = new StringBuilder();
        this.createOneSection(buf, name, config);
        return buf.toString();
    }

    public String dropTable(String name) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.dropPrimaryKey(name));
        buf.append("drop table ").append(name).append("; \n");
        buf.append("drop sequence ").append(name).append("_id_seq").append("; \n");
        return buf.toString();
    }

    public String addColumn(String table, String column, Config config) {
        if ("id".equals(column.toLowerCase()) || TableUtil.isType(column)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("alter table ").append(table).append(" add ");
        String type = null;
        String not_null = null;
        String unique = null;
        String def = null;
        String[] one = config.getAll(table, column);
        int lenJ = one.length;
        int[] mode = new int[1];
        int j = 0;
        while (j < lenJ) {
            String tmp = null;
            tmp = TableUtil.getColumnName(this, one[j]);
            if (tmp != null) {
                type = tmp;
            } else {
                tmp = TableUtil.getColumnType(mode, true, this, one[j]);
                if (tmp != null) {
                    switch (mode[0]) {
                        case 1: {
                            not_null = tmp;
                            break;
                        }
                        case 2: {
                            unique = tmp;
                            break;
                        }
                        case 3: {
                            def = tmp;
                        }
                    }
                } else if (TableUtil.isIndex(one[j]) || TableUtil.isKey(one[j])) {
                    not_null = this.notNullName();
                }
            }
            ++j;
        }
        if (type == null) {
            return "";
        }
        buf.append(column.toLowerCase()).append(" ").append(type);
        if (unique != null) {
            buf.append(" ").append(unique);
        }
        if (not_null != null) {
            buf.append(" ").append(not_null);
        }
        if (def != null && !this.typeByBytes().equals(type)) {
            buf.append(" ").append(def);
        }
        buf.append("; \n");
        return buf.toString();
    }

    public String dropColumn(String table, String column) {
        if ("id".equals(column.toLowerCase()) || TableUtil.isType(column)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("alter table ").append(table).append(" drop ").append(column).append("; \n");
        return buf.toString();
    }

    public String addPrimaryKey(String table, Config config) {
        String[] keys = config.getKeys(table);
        if (keys != null && keys.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("alter table ").append(table).append(" add ");
            int len = keys.length;
            HashSet<String> primaryKey = new HashSet<String>();
            int i = 0;
            while (i < len) {
                String key = keys[i];
                if (!"id".equals(key.toLowerCase()) && !TableUtil.isType(key)) {
                    String[] one = config.getAll(table, key);
                    int lenJ = one.length;
                    int j = 0;
                    while (j < lenJ) {
                        if (TableUtil.isIndex(one[j]) || TableUtil.isKey(one[j])) {
                            primaryKey.add(key.toLowerCase());
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (primaryKey.size() > 0) {
                buf.append(StringUtil.changeString(this.primaryKeyName(), "[KEY_NAME]", String.valueOf(table.toLowerCase()) + "_pk")).append("(");
                buf.append("id");
                Object[] vals = primaryKey.toArray();
                int lenI = vals.length;
                int i2 = 0;
                while (i2 < lenI) {
                    buf.append(",").append(vals[i2]);
                    ++i2;
                }
                buf.append(")");
            } else {
                buf.append(StringUtil.changeString(this.primaryKeyName(), "[KEY_NAME]", String.valueOf(table.toLowerCase()) + "_pk"));
                buf.append("(id)");
            }
            buf.append(") ; \n");
            return buf.toString();
        }
        return "";
    }

    public String dropPrimaryKey(String table) {
        return "alter table " + table + " drop constraint " + table + "_pk" + "; \n";
    }

    public Object getBooleanType(Boolean src) {
        return src;
    }

    public Object getBooleanByTrue() {
        return null;
    }

    public Object getBooleanByFalse() {
        return null;
    }

    public int getUTF8CharSize(int size) {
        return size * 3;
    }
}

