/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.IOException;
import java.sql.Connection;
import org.maachang.dao.dbms.BaseRecord;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.dao.dbms.pool.ConnectManager;
import org.maachang.dao.dbms.pool.ConnectPoolFactory;

public class RecordFactory {
    private SupportKind kind = null;
    private ConnectManager manager = null;
    private boolean autoCommit = false;
    private boolean debug = false;

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(SupportKind kind, boolean debug, String driver, String url, String user, String passwd, int max, boolean autoCommit, String checkSQL) throws Exception {
        if (driver == null || (driver = driver.trim()).length() <= 0 || url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5fc5\u9808\u6761\u4ef6[adapter or driver or url]\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (kind == null) {
            throw new IllegalArgumentException("\u975e\u30b5\u30dd\u30fc\u30c8\u306eDBMS\u7a2e\u985e\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.kind = kind;
        Class.forName(driver);
        ConnectManager manager = ConnectPoolFactory.get(url, user, passwd, max, checkSQL);
        this.autoCommit = autoCommit;
        this.manager = manager;
        this.debug = debug;
    }

    public void clear() {
        if (this.manager != null) {
            this.manager.destroy();
        }
        this.kind = null;
        this.manager = null;
    }

    public Record getRecord() throws Exception {
        Connection conn = this.manager.getConnection();
        if (conn == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        conn.setAutoCommit(this.autoCommit);
        return new BaseRecord(this.kind, this.debug, conn);
    }

    public SupportKind getSupportKind() {
        return this.kind;
    }

    public ConnectManager getConnectionManager() {
        return this.manager;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }
}

