/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.ResultUtil;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionDao {
    private static final String RESULT_BY_SQL = "select";
    private static final String INSERT_BY_SQL = "insert";
    public static final String SEQ_COLUMN = "id";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";
    public static final String OPTIMISTIC_LOCK_COLUMN = "optimistic_lock";

    public static final int execution(ArrayList<Map<String, Object>> out, Long[] outId, Record record, String model, MetaColumn meta, String sql, int offset, int limit, ArrayList<Object> params) throws Exception {
        Object[] o = null;
        if (params != null && params.size() > 0) {
            int len = params.size();
            o = new Object[len];
            int i = 0;
            while (i < len) {
                o[i] = params.get(i);
                ++i;
            }
        }
        return ExecutionDao.execution(out, outId, record, model, meta, sql, offset, limit, o);
    }

    public static final int execution(ArrayList<Map<String, Object>> out, Long[] outId, Record record, String model, MetaColumn meta, String sql, int offset, int limit, Object[] params) throws Exception {
        String s;
        String s2;
        if (record == null) {
            return 0;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        String lower = sql.toLowerCase();
        boolean selectFlag = lower.startsWith(RESULT_BY_SQL);
        boolean insertFlag = lower.startsWith(INSERT_BY_SQL);
        if (selectFlag) {
            ResultSet rs = null;
            try {
                rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params);
                if (lower.startsWith("select count(*)")) {
                    int count = 0;
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    rs.close();
                    rs = null;
                    int n = count;
                    return n;
                }
                out.clear();
                if (limit <= 0) {
                    limit = Integer.MAX_VALUE;
                }
                if (offset <= 0) {
                    offset = 0;
                }
                ExecutionDao.pushResult(out, model, rs, offset, limit);
                rs.close();
                rs = null;
                int n = out.size();
                return n;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                rs = null;
            }
        }
        boolean seqFlag = ExecutionDao.isSequence(meta);
        Long seq = null;
        if (outId != null && outId.length >= 1 && seqFlag && insertFlag && (s2 = kind.getSequenceId(model)) != null && (seq = ExecutionDao.getSequenceId(record, s2)) != null) {
            params[0] = seq;
        }
        int ret = 0;
        ret = params == null || params.length <= 0 ? record.executeUpdate(sql) : record.executeUpdate(sql, params);
        if (outId != null && outId.length >= 1 && seqFlag && insertFlag && seq != null && (s = kind.getInsertIdBySQL()) != null) {
            seq = ExecutionDao.getInsertId(record, s);
        }
        if (outId != null) {
            outId[0] = seq;
        }
        return ret;
    }

    public static final Object executionStatement(Record record, String sql) throws Exception {
        if (record == null) {
            return null;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        String lower = sql.toLowerCase();
        boolean selectFlag = lower.startsWith(RESULT_BY_SQL);
        if (selectFlag) {
            ResultSet rs = null;
            try {
                rs = record.executeQuery(sql);
                if (lower.startsWith("select count(*)")) {
                    int count = 0;
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    rs.close();
                    rs = null;
                    Integer n = count;
                    return n;
                }
                ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
                ExecutionDao.pushResult(ret, "dummy", rs, 0, Integer.MAX_VALUE);
                rs.close();
                rs = null;
                ArrayList<Map<String, Object>> arrayList = ret;
                return arrayList;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                rs = null;
            }
        }
        return new Integer(record.executeUpdate(sql));
    }

    public static final boolean isSequence(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (SEQ_COLUMN.equals(meta.getColumnName(i).toLowerCase()) && meta.getColumnType(i) == -5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isOptimisticLock(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (OPTIMISTIC_LOCK_COLUMN.equals(meta.getColumnName(i).toLowerCase()) && meta.getColumnType(i) == -5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isCreateTime(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (CREATE_TIME.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isUpdateTime(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (UPDATE_TIME.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final Long getSequenceId(Record record, String sql) throws Exception {
        ResultSet result = null;
        result = record.executeQuery(sql);
        if (result != null) {
            Long ret;
            result.next();
            Long l = ret = Long.valueOf(result.getLong(1));
            return l;
        }
        Long l = null;
        return l;
        {
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final Long getInsertId(Record record, String sql) throws Exception {
        ResultSet result = null;
        result = record.executeQuery(sql);
        if (result != null) {
            Long ret;
            result.next();
            Long l = ret = Long.valueOf(result.getLong(1));
            return l;
        }
        Long l = null;
        return l;
        {
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final void pushResult(ArrayList<Map<String, Object>> out, String model, ResultSet result, int offset, int limit) throws Exception {
        ResultUtil.setPosition(result, offset);
        MetaColumn meta = null;
        int i = 0;
        while (i < limit) {
            if (!result.next()) break;
            if (meta == null) {
                meta = new MetaColumn(model, result.getMetaData());
            }
            HashMap<String, Object> o = new HashMap<String, Object>();
            ExecutionDao.convertResultByObject(o, meta, result);
            out.add(o);
            ++i;
        }
    }

    public static final void convertResultByObject(Map<String, Object> out, MetaColumn meta, ResultSet result) throws Exception {
        if (out == null || meta == null || result == null) {
            return;
        }
        int len = meta.size();
        int i = 0;
        while (i < len) {
            int type = meta.getColumnType(i);
            String name = meta.getColumnName(i);
            Object value = ExecutionDao.getParam(result, type, name);
            String javaName = DbUtil.convertDBNameByJavaName(false, name);
            javaName = StringUtil.changeString(javaName, "?", "");
            if (value != null) {
                String c;
                if (type == 1 && (c = (String)value).length() == 1) {
                    value = c.equals("0") ? new Boolean(false) : new Boolean(true);
                }
                out.put(javaName, value);
            } else {
                out.put(javaName, null);
            }
            ++i;
        }
    }

    private static final Object getParam(ResultSet result, int type, String key) throws Exception {
        if (result.getObject(key) == null) {
            return null;
        }
        Object data = null;
        switch (type) {
            case -7: {
                data = new Boolean(result.getBoolean(key));
                break;
            }
            case 16: {
                data = new Boolean(result.getBoolean(key));
                break;
            }
            case -6: {
                data = new Byte(result.getByte(key));
                if (data == null) break;
                byte b = (Byte)data;
                if (b == 1) {
                    data = new Boolean(true);
                }
                data = new Boolean(false);
                break;
            }
            case 5: {
                data = new Integer(result.getInt(key));
                break;
            }
            case 4: {
                data = new Integer(result.getInt(key));
                break;
            }
            case -5: {
                data = new Long(result.getLong(key));
                break;
            }
            case 6: {
                data = new Float(result.getFloat(key));
                break;
            }
            case 7: {
                data = new Float(result.getFloat(key));
                break;
            }
            case 8: {
                data = new Double(result.getDouble(key));
                break;
            }
            case 2: {
                data = result.getBigDecimal(key);
                break;
            }
            case 3: {
                data = result.getBigDecimal(key);
                break;
            }
            case 1: {
                data = result.getString(key);
                break;
            }
            case 12: {
                data = result.getString(key);
                break;
            }
            case -1: {
                data = result.getString(key);
                break;
            }
            case 91: {
                data = result.getDate(key);
                break;
            }
            case 92: {
                data = result.getTime(key);
                break;
            }
            case 93: {
                data = result.getTimestamp(key);
                break;
            }
            case -2: {
                data = result.getBytes(key);
                break;
            }
            case -3: {
                data = result.getBytes(key);
                break;
            }
            case -4: {
                data = result.getBytes(key);
                break;
            }
            case 2004: {
                data = result.getBlob(key);
                break;
            }
            case 70: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2011: {
                data = result.getString(key);
                break;
            }
            default: {
                data = null;
            }
        }
        if (data == null) {
            return null;
        }
        if (data instanceof Blob) {
            int len;
            BufferedInputStream b = new BufferedInputStream(((Blob)data).getBinaryStream());
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] bin = new byte[4096];
            while ((len = ((InputStream)b).read(bin)) > -1) {
                if (len == 0) continue;
                bo.write(bin, 0, len);
            }
            ((InputStream)b).close();
            b = null;
            data = bo.toByteArray();
            bo.close();
            bo = null;
        }
        return data;
    }
}

