/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmImpl;
import org.maachang.dbm.MDbmOp;
import org.maachang.dbm.MDbmOpImpl;
import org.maachang.dbm.MDbmTransaction;
import org.maachang.dbm.service.MDbmServer;

public class MDbmManager {
    private MDbmImpl impl = null;
    private MDbmServer server = null;
    private static final MDbmManager SNGL = new MDbmManager();

    private MDbmManager() {
    }

    public static final MDbmManager getInstance() {
        return SNGL;
    }

    public synchronized void open(String directory) throws Exception {
        if (this.impl == null) {
            this.impl = new MDbmImpl(directory);
        }
    }

    public synchronized void close() {
        if (this.server != null) {
            this.server.destroy();
        }
        this.server = null;
        if (this.impl != null) {
            this.impl.destroy();
        }
        this.impl = null;
    }

    public synchronized void flush() throws Exception {
        if (this.impl != null) {
            this.impl.flush();
        }
    }

    public synchronized MDbm getMDbm() {
        return this.getMDbm(false);
    }

    public synchronized MDbm getMDbm(boolean mode) {
        if (this.impl != null) {
            if (mode) {
                return new MDbmTransaction(this.impl);
            }
            return this.impl;
        }
        return null;
    }

    public synchronized MDbmOp getMDbmOp() {
        return this.getMDbmOp(false);
    }

    public synchronized MDbmOp getMDbmOp(boolean mode) {
        if (this.impl != null) {
            if (mode) {
                return new MDbmOpImpl(new MDbmTransaction(this.impl));
            }
            return new MDbmOpImpl(this.impl);
        }
        return null;
    }

    public synchronized boolean isClose() {
        return this.impl == null;
    }

    public synchronized String getDirectory() {
        if (this.impl != null) {
            return this.impl.getDirectory();
        }
        return null;
    }

    public synchronized int size() {
        if (this.impl != null) {
            return this.impl.size();
        }
        return -1;
    }

    public synchronized int sectorFile() {
        if (this.impl != null) {
            return this.impl.sectorFile();
        }
        return -1;
    }

    public synchronized int useSector() {
        if (this.impl != null) {
            return this.impl.useSector();
        }
        return -1;
    }

    public synchronized int maxSector() {
        if (this.impl != null) {
            return this.impl.maxSector();
        }
        return -1;
    }

    public synchronized long freeSpace() {
        if (this.impl != null) {
            return this.impl.freeSpace();
        }
        return -1L;
    }

    public synchronized void setServer(MDbmServer server) {
        this.server = server;
    }

    public synchronized MDbmServer getServer() {
        return this.server;
    }
}

