/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.proxy;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.HttpAcceptThread;
import org.maachang.comet.net.HttpCallbackReceive;
import org.maachang.comet.net.HttpSocketManager;
import org.maachang.comet.proxy.ProxyPoolThread;
import org.maachang.comet.proxy.ProxyReceiveThread;
import org.maachang.comet.proxy.ProxyServerImpl;
import org.maachang.util.SequenceSync;

public class ProxyService {
    private static final Log LOG = LogFactory.getLog(ProxyService.class);
    private static final int MIN_POOL = 5;
    private static final int MAX_POOL = 150;
    private HttpAcceptThread accept = null;
    private ProxyReceiveThread server = null;
    private ProxyPoolThread[] pool = null;
    private SequenceSync sequence = null;

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(HttpCallbackReceive executionObject, int maxConnect, int length, int port) throws Exception {
        this.open(executionObject, maxConnect, length, null, port);
    }

    public void open(HttpCallbackReceive executionObject, int maxConnect, int length, InetAddress addr, int port) throws Exception {
        if (executionObject == null) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (length <= 5) {
            length = 5;
        } else if (length >= 150) {
            length = 150;
        }
        this.close();
        try {
            ProxyServerImpl server = new ProxyServerImpl(addr, port, maxConnect);
            HttpSocketManager manager = new HttpSocketManager();
            this.accept = new HttpAcceptThread(server, manager);
            this.sequence = new SequenceSync();
            this.server = new ProxyReceiveThread(manager);
            this.pool = new ProxyPoolThread[length];
            int i = 0;
            while (i < length) {
                this.pool[i] = new ProxyPoolThread(this.server.getUseQueue(), manager, executionObject, this.sequence);
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## error", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void close() {
        if (this.accept != null) {
            this.accept.destroy();
        }
        if (this.server != null) {
            this.server.destroy();
        }
        if (this.pool != null) {
            int len = this.pool.length;
            int i = 0;
            while (i < len) {
                if (this.pool[i] != null) {
                    this.pool[i].destroy();
                }
                this.pool[i] = null;
                ++i;
            }
        }
        this.accept = null;
        this.server = null;
        this.pool = null;
    }
}

