/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.net.HttpServer;
import org.maachang.comet.proxy.ProxyHttpSocketImpl;

class ProxyServerImpl
implements HttpServer {
    private static final int TIMEOUT = 12000;
    private static final int DEFAULT_PORT = 3333;
    protected static final int MIN_LENGTH = 1;
    protected static final int MAX_LENGTH = 150;
    private ServerSocket serverSocket = null;

    private ProxyServerImpl() {
    }

    public ProxyServerImpl(int port, int backlog) throws Exception {
        this(null, port, backlog);
    }

    public ProxyServerImpl(InetAddress addr, int port, int backlog) throws Exception {
        if (backlog <= 1) {
            backlog = 1;
        } else if (backlog > 150) {
            backlog = 150;
        }
        if (port <= 0 || port > 65535) {
            port = 3333;
        }
        ServerSocket server = new ServerSocket();
        server.setReuseAddress(true);
        server.setSoTimeout(12000);
        if (addr == null) {
            server.bind(new InetSocketAddress(port), backlog);
        } else {
            server.bind(new InetSocketAddress(addr, port), backlog);
        }
        this.serverSocket = server;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
    }

    public HttpSocket accept() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30b5\u30fc\u30d0\u30bd\u30b1\u30c3\u30c8\u306f\u5229\u7528\u51fa\u6765\u307e\u305b\u3093");
        }
        ProxyHttpSocketImpl ret = null;
        try {
            Socket s = this.serverSocket.accept();
            ret = new ProxyHttpSocketImpl(s);
        }
        catch (SocketTimeoutException st) {
            ret = null;
        }
        catch (Exception e) {
            throw e;
        }
        return ret;
    }

    public ServerSocket serverSocket() {
        if (this.isClosed()) {
            return null;
        }
        return this.serverSocket;
    }

    public boolean isClosed() {
        boolean ret = false;
        try {
            if (this.serverSocket == null || !this.serverSocket.isBound() || this.serverSocket.isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

