/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.proxy;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpSocket;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.net.HttpCallbackReceive;
import org.maachang.comet.net.HttpInputStream;
import org.maachang.comet.net.HttpSocketManager;
import org.maachang.comet.net.HttpUseQueue;
import org.maachang.comet.net.ReadHttpdRequest;
import org.maachang.comet.proxy.HttpdProxyRequestImpl;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;
import org.maachang.util.GZIPBinary;
import org.maachang.util.SequenceSync;

class ProxyPoolThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(ProxyPoolThread.class);
    private HttpUseQueue queue = null;
    private HttpSocketManager manager = null;
    private HttpCallbackReceive receive = null;
    private SequenceSync sequence = null;
    private volatile boolean stopFlag = true;
    private static final long WAIT_TIME = 30L;

    private ProxyPoolThread() {
    }

    public ProxyPoolThread(HttpUseQueue queue, HttpSocketManager manager, HttpCallbackReceive receive, SequenceSync sequence) throws Exception {
        this.queue = queue;
        this.manager = manager;
        this.receive = receive;
        this.sequence = sequence;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ThreadDeath threadDeach = null;
        boolean errorFlag = false;
        boolean endFlag = false;
        while (true) {
            errorFlag = false;
            HttpSocket conn = null;
            HttpConnectionInfo info = null;
            try {
                try {
                    if (endFlag || this.isStop()) break;
                    conn = this.queue.getQueue();
                    if (conn != null) {
                        info = conn.getConnectionInfo();
                        if (info == null || !info.isUse()) continue;
                        int seqId = this.sequence.getId();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("[px]receive(" + seqId + ") - [" + info.getSocket().socket().getInetAddress().getHostAddress() + ":" + info.getSocket().socket().getPort() + "]"));
                        }
                        this.receive.execution(info, seqId, ProxyPoolThread.readHttpdRequest(conn, seqId));
                        this.manager.append(conn);
                        continue;
                    }
                    ProxyPoolThread.sleep(30L);
                }
                finally {
                    if (!errorFlag || conn == null || conn.isClosed()) continue;
                    try {
                        conn.outputStream().write(ConvertParam.convertInt((int)4));
                        conn.outputStream().flush();
                        this.manager.append(conn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (InterruptedException ie) {
                errorFlag = true;
                endFlag = true;
            }
            catch (CancelledKeyException ck) {
                errorFlag = true;
                LOG.warn((Object)"## cancell - key");
            }
            catch (OutOfMemoryError mem) {
                errorFlag = true;
                LOG.error((Object)"## out-of-memory-error", (Throwable)mem);
            }
            catch (Exception e) {
                errorFlag = true;
                LOG.error((Object)"## error", (Throwable)e);
            }
            catch (ThreadDeath td) {
                errorFlag = true;
                endFlag = true;
                threadDeach = td;
            }
        }
        this.queue = null;
        this.manager = null;
        this.receive = null;
        this.sequence = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    private static final HttpdRequest readHttpdRequest(HttpSocket socket, int seqId) throws Exception {
        if (socket == null || socket.isClosed()) {
            return null;
        }
        BufferedInputStream buf = null;
        try {
            buf = new BufferedInputStream(new HttpInputStream(socket.inputStream()));
            HttpdRequest ret = ProxyPoolThread.receive(buf, seqId);
            buf.close();
            buf = null;
            socket.update();
            HttpdRequest httpdRequest = ret;
            return httpdRequest;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
                buf = null;
            }
        }
    }

    private static final HttpdRequest receive(InputStream inputStream, int seqId) throws Exception {
        int allLen = -1;
        ArrayBinary ret = new ArrayBinary();
        try {
            while (true) {
                if (allLen <= -1) {
                    if (ret.length() >= 4 && (allLen = ret.getByte(0) & 0xFF | (ret.getByte(1) & 0xFF) << 8 | (ret.getByte(2) & 0xFF) << 16 | (ret.getByte(3) & 0xFF) << 24) <= 4) {
                        return null;
                    }
                } else if (allLen <= ret.length()) {
                    Object[] params = new Object[]{ret.getBinary()};
                    ret.destroy();
                    return ProxyPoolThread.convertHttpdRequest(params);
                }
                int n = inputStream.read();
                ret.write(n);
            }
        }
        catch (SocketTimeoutException se) {
            return null;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static final HttpdRequest convertHttpdRequest(Object[] o) throws Exception {
        HttpdProxyRequestImpl ret = new HttpdProxyRequestImpl();
        byte[] bin = (byte[])o[0];
        o[0] = null;
        int allHeaderLen = ConvertParam.convertInt((int)4, (byte[])bin);
        int allBodyLen = ConvertParam.convertInt((int)(8 + allHeaderLen), (byte[])bin);
        if (allBodyLen > 0) {
            byte[] body = new byte[allBodyLen];
            System.arraycopy(bin, 12 + allHeaderLen, body, 0, allBodyLen);
            ret.setBody(GZIPBinary.getInstance().convertGZIPByBinary(body));
        }
        byte[] header = GZIPBinary.getInstance().convertGZIPByBinary(bin, 8, allHeaderLen);
        bin = null;
        int pnt = 0;
        int len = ConvertParam.convertInt((int)pnt, (byte[])header);
        ret.setMethod(ProxyPoolThread.convertString(header, pnt += 4, len));
        pnt += len;
        len = ConvertParam.convertInt((int)pnt, (byte[])header);
        ret.setUrlPath(ProxyPoolThread.convertString(header, pnt += 4, len));
        pnt += len;
        len = ConvertParam.convertInt((int)pnt, (byte[])header);
        ret.setHttpVersion(ProxyPoolThread.convertString(header, pnt += 4, len));
        int headerLen = ConvertParam.convertInt((int)(pnt += len), (byte[])header);
        pnt += 4;
        int i = 0;
        while (i < headerLen) {
            len = ConvertParam.convertInt((int)pnt, (byte[])header);
            String key = ProxyPoolThread.convertString(header, pnt += 4, len);
            int lenJ = ConvertParam.convertInt((int)(pnt += len), (byte[])header);
            pnt += 4;
            int j = 0;
            while (j < lenJ) {
                len = ConvertParam.convertInt((int)pnt, (byte[])header);
                ret.getHeader().addHeader(key, ProxyPoolThread.convertString(header, pnt += 4, len));
                pnt += len;
                ++j;
            }
            ++i;
        }
        header = null;
        ReadHttpdRequest.convertAnalysisQuery(ret);
        byte[] body = ret.getBodyByBinary();
        if (body != null) {
            ReadHttpdRequest.convertBody(ret, body);
        }
        return ret;
    }

    private static final String convertString(byte[] in, int pnt, int length) throws Exception {
        byte[] bin = new byte[length];
        System.arraycopy(in, pnt, bin, 0, length);
        return new String(bin, "ISO-8859-1");
    }
}

