/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpSocket;

public class ProxyHttpSocketImpl
implements HttpSocket {
    public static final int RECEIVE_TIMEOUT = 1200000;
    private static final int BUFFER = 131072;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private HttpConnectionInfo connectionInfo = null;
    private long time = -1L;
    private boolean isCloseSocket = false;
    private Object ioSync = new Object();

    private ProxyHttpSocketImpl() {
    }

    protected ProxyHttpSocketImpl(Socket socket) throws Exception {
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.socket = socket;
        this.inputStream = null;
        this.outputStream = null;
        this.socket.setSendBufferSize(131072);
        this.socket.setReceiveBufferSize(131072);
        this.socket.setKeepAlive(true);
        this.socket.setTcpNoDelay(true);
        this.socket.setReuseAddress(true);
        this.socket.setSoLinger(true, 0);
        this.socket.setSoTimeout(1200000);
        this.time = System.currentTimeMillis();
        this.connectionInfo = null;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connectionInfo != null) {
            this.connectionInfo.destroy();
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.time = -1L;
    }

    public synchronized void setConnectionInfo(HttpConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            return;
        }
        this.connectionInfo = connectionInfo;
    }

    public synchronized HttpConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void update() throws Exception {
        this.time = this.isClosed() ? -1L : System.currentTimeMillis();
    }

    public boolean isReceive() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        boolean ret = false;
        if (this.inputStream().available() > 0) {
            ret = true;
        }
        return ret;
    }

    public Socket socket() {
        if (this.isClosed()) {
            return null;
        }
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream inputStream() throws Exception {
        if (this.isClosed()) {
            return null;
        }
        InputStream ret = null;
        Object object = this.ioSync;
        synchronized (object) {
            if (this.inputStream == null) {
                this.inputStream = new BufferedInputStream(this.socket.getInputStream());
            }
            ret = this.inputStream;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream outputStream() throws Exception {
        if (this.isClosed()) {
            return null;
        }
        OutputStream ret = null;
        Object object = this.ioSync;
        synchronized (object) {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            }
            ret = this.outputStream;
        }
        return ret;
    }

    public long time() {
        if (this.isClosed()) {
            return -1L;
        }
        return this.time;
    }

    public void setCloseFlag(boolean flag) {
        this.isCloseSocket = flag;
    }

    public boolean isCloseFlag() {
        return this.isCloseSocket;
    }

    public boolean isClosed() {
        boolean ret = false;
        try {
            if (this.socket == null || this.socket.isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

