/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import org.maachang.comet.conf.MimeConfig;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpdErrorDef;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdVersionDef;
import org.maachang.comet.httpd.engine.HttpdCookie;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.conf.ConvIniParam;
import org.maachang.manager.GlobalManager;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;
import org.maachang.util.FileUtil;
import org.maachang.util.GZIPBinary;

public class HttpdProxyResponseImpl
implements HttpdResponse {
    protected int state = 200;
    protected String version = "1.1";
    private HttpConnectionInfo connectionInfo = null;
    protected HttpdHeaders header = null;
    protected boolean cacheMode = false;
    protected boolean gzipFlag = true;
    protected String gzipName = null;
    private OutputStream outputStream = null;
    private PrintWriter printWriter = null;
    private ByteArrayOutputStream binaryStream = null;
    private byte[] outputBinary = null;

    private HttpdProxyResponseImpl() {
    }

    public HttpdProxyResponseImpl(HttpdRequest request, String url, long timeout, int count) throws Exception {
        this(request, url, 200, timeout, count);
    }

    public HttpdProxyResponseImpl(HttpdRequest request, String url, int state, long timeout, int count) throws Exception {
        if (request == null || request.getConnectionInfo() == null || !request.getConnectionInfo().isUse()) {
            throw new IOException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.state = state;
        this.connectionInfo = request.getConnectionInfo();
        this.header = new HttpdHeaders();
        HttpdProxyResponseImpl.noSetByContentType(this.header, url);
        if (request.getHeader().getHeader("Accept-Encoding") != null) {
            HttpdHeaders requestHeader = request.getHeader();
            int len = requestHeader.size("Accept-Encoding");
            boolean chkFlag = false;
            if (request.isGzip()) {
                int i = 0;
                while (i < len) {
                    String encode = requestHeader.getHeader("Accept-Encoding", i);
                    if (encode != null && encode.indexOf("gzip") != -1) {
                        if ((encode = encode.trim()).length() <= 0) {
                            this.gzipName = null;
                            chkFlag = false;
                            break;
                        }
                        this.gzipName = encode;
                        chkFlag = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!chkFlag) {
                this.gzipName = null;
            } else {
                String type;
                MimeConfig mimeType = (MimeConfig)GlobalManager.getValue((String)"MIME_TYPE");
                int p = url.lastIndexOf(".");
                String plus = null;
                if (p != -1) {
                    plus = url.substring(p + 1);
                }
                if (plus == null || (plus = plus.trim()).length() <= 0) {
                    plus = "";
                }
                if (!ConvIniParam.getBoolean((String)(type = mimeType.get("gzip." + plus)))) {
                    this.gzipName = null;
                }
            }
        } else {
            this.gzipName = null;
        }
        this.version = request.getVersion();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.flush();
        this.destroyByNoOutputStream();
        if (this.printWriter != null) {
            try {
                this.printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            this.outputBinary = this.binaryStream.toByteArray();
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.binaryStream = null;
                Object[] o = new Object[]{this.outputBinary};
                this.sendProxyServer(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connectionInfo != null) {
            this.connectionInfo.destroy();
        }
        this.header = null;
        this.cacheMode = false;
        this.gzipFlag = true;
        this.gzipName = null;
        this.connectionInfo = null;
        this.outputStream = null;
        this.printWriter = null;
        this.binaryStream = null;
        this.outputBinary = null;
    }

    public void cancel() {
        if (this.connectionInfo != null) {
            this.connectionInfo.cancel();
        }
        this.connectionInfo = null;
        this.header = null;
        this.cacheMode = false;
        this.gzipFlag = true;
        this.gzipName = null;
        this.outputStream = null;
        this.printWriter = null;
    }

    public void flush() {
        if (this.printWriter != null) {
            try {
                this.printWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.outputStream instanceof GZIPOutputStream) {
                try {
                    ((GZIPOutputStream)this.outputStream).finish();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setGzip(boolean flag) {
        this.gzipFlag = flag;
    }

    public boolean getGzip() {
        if (this.gzipName == null) {
            return false;
        }
        return this.gzipFlag;
    }

    public void setHttpCache(boolean cache) {
        this.cacheMode = cache;
    }

    public boolean getHttpCache() {
        return this.cacheMode;
    }

    public void setCookieSession(HttpdRequest request) throws Exception {
        if (request == null) {
            return;
        }
        HttpdSession session = request.getSession();
        if (session != null) {
            int len = 0;
            len = this.header.size("Set-Cookie");
            if (len > 0) {
                int i = len - 1;
                while (i >= 0) {
                    String value = this.header.getHeader("Set-Cookie", i);
                    if (value != null && value.indexOf("maachang-session=") != -1) {
                        this.header.removeHeader("Set-Cookie", i);
                    }
                    --i;
                }
            }
            HttpdSessionManager sessionManager = (HttpdSessionManager)GlobalManager.getValue((String)"SESSION_MANAGER");
            long time = System.currentTimeMillis() + sessionManager.getDeleteTime();
            String value = HttpdCookie.createCookie("maachang-session", session.getSessionId(), "/", time);
            this.header.addHeader("Set-Cookie", value);
        }
    }

    public HttpdHeaders getHeader() {
        return this.header;
    }

    public void setDestroyByClose(boolean mode) {
    }

    public boolean isRequestKeepAlive() {
        return false;
    }

    public void setHttpClose(boolean closeFlag) {
    }

    public boolean getHttpClose() {
        return true;
    }

    public OutputStream getOutput() throws Exception {
        if (this.printWriter != null) {
            return null;
        }
        if (this.outputStream == null) {
            this.header.setHeader("Server", HttpdVersionDef.getPrintServerName());
            this.header.setHeader("Date", HttpdTimestamp.getNowTimestamp());
            if (this.cacheMode) {
                this.header.setHeader("Expires", HttpdTimestamp.getTimestamp(0L));
                this.header.setHeader("Pragma", "no-cache");
                this.header.setHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
                this.header.setHeader("Cache-Control", "private");
                this.header.addHeader("Cache-Control", "no-cache");
                this.header.addHeader("Cache-Control", "no-store");
                this.header.addHeader("Cache-Control", "max-age=0");
            }
            if ("1.1".equals(this.version) && this.getGzip()) {
                this.header.setHeader("Content-Encoding", this.gzipName);
            }
            this.binaryStream = new ByteArrayOutputStream();
            this.outputStream = this.getGzip() ? new GZIPOutputStream(this.binaryStream) : this.binaryStream;
        }
        return this.outputStream;
    }

    public PrintWriter getPrint() throws Exception {
        if (this.printWriter == null) {
            PrintWriter p;
            OutputStream os = this.getOutput();
            this.printWriter = p = new PrintWriter(new OutputStreamWriter(os, "UTF8"));
        }
        return this.printWriter;
    }

    public boolean isOutputStream() {
        return this.outputStream != null;
    }

    public byte[] getBody() {
        byte[] ret = this.outputBinary;
        this.outputBinary = null;
        return ret;
    }

    private boolean destroyByNoOutputStream() {
        if (!this.isOutputStream()) {
            try {
                this.getOutput();
                this.header.setHeader("Content-Length", "0");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void sendProxyServer(Object[] o) throws Exception {
        byte[] body = (byte[])o[0];
        o[0] = null;
        byte[] headerBin = this.createHeaderBinary();
        headerBin = GZIPBinary.getInstance().convertBinaryByGZIP(headerBin);
        int len = headerBin.length + 12;
        if (body != null) {
            len += body.length;
        }
        OutputStream outputStream = this.connectionInfo.getOutputStream();
        outputStream.write(ConvertParam.convertInt((int)len));
        outputStream.write(ConvertParam.convertInt((int)headerBin.length));
        outputStream.write(headerBin);
        headerBin = null;
        if (body != null) {
            outputStream.write(ConvertParam.convertInt((int)body.length));
            outputStream.write(body);
        } else {
            outputStream.write(ConvertParam.convertInt((int)0));
        }
        body = null;
        outputStream.flush();
    }

    private byte[] createHeaderBinary() throws Exception {
        String[] keys = this.header.getKeys();
        int headerLen = keys.length;
        ArrayBinary ret = new ArrayBinary();
        HttpdProxyResponseImpl.putValue(ret, this.version);
        HttpdProxyResponseImpl.putValue(ret, String.valueOf(this.state));
        HttpdProxyResponseImpl.putValue(ret, HttpdErrorDef.convertErrorMessage(this.state));
        ret.write(ConvertParam.convertInt((int)headerLen));
        int i = 0;
        while (i < headerLen) {
            HttpdProxyResponseImpl.putValue(ret, keys[i]);
            int lenJ = this.header.size(keys[i]);
            ret.write(ConvertParam.convertInt((int)lenJ));
            int j = 0;
            while (j < lenJ) {
                String val = this.header.getHeader(keys[i], j);
                HttpdProxyResponseImpl.putValue(ret, val);
                ++j;
            }
            ++i;
        }
        return ret.getBinary();
    }

    private static final void putValue(ArrayBinary out, String value) throws Exception {
        if (value == null || (value = value.trim()).length() <= 0) {
            out.write(ConvertParam.convertInt((int)0));
        } else {
            byte[] tmp = value.getBytes("ISO-8859-1");
            out.write(ConvertParam.convertInt((int)tmp.length));
            out.write(tmp);
        }
    }

    private static final void noSetByContentType(HttpdHeaders header, String url) {
        if ((url = FileUtil.getFileName((String)url)).indexOf(".") == -1 && url.endsWith(".ms")) {
            header.setHeader("Content-Type", "text/xml; charset=utf-8");
        } else if (url.endsWith(".mhtml")) {
            header.setHeader("Content-Type", "text/html; charset=utf-8");
        } else {
            MimeConfig conf = (MimeConfig)GlobalManager.getValue((String)"MIME_TYPE");
            String mime = conf.getNameByMimeType(url);
            if (mime.indexOf("xml") != -1 || mime.indexOf("html") != -1) {
                header.setHeader("Content-Type", String.valueOf(mime) + "; charset=utf-8");
            } else {
                header.setHeader("Content-Type", mime);
            }
        }
    }
}

