/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.proxy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import org.maachang.comet.httpd.HttpConnectionInfo;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.HttpdCookie;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.manager.GlobalManager;

public class HttpdProxyRequestImpl
implements HttpdRequest {
    private String method = null;
    private String httpVersion = null;
    private String urlPath = null;
    private HttpdParams query = null;
    private HttpdHeaders header = null;
    private HttpdSession session = null;
    private byte[] httpBody = null;
    private HttpConnectionInfo conn = null;
    private boolean gzipFlag = false;
    private boolean cookieFlag = false;

    public HttpdProxyRequestImpl() {
        this.query = new HttpdParams();
        this.header = new HttpdHeaders();
    }

    public HttpdProxyRequestImpl(String method, String version, String url, HttpdHeaders header, HttpdParams query) throws Exception {
        if (method == null || (method = method.trim()).length() <= 0 || version == null || (version = version.trim()).length() <= 0 || url == null || (url = url.trim()).length() <= 0 || header == null || header.size() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.method = method;
        this.httpVersion = version;
        this.urlPath = url;
        this.header = header;
        this.query = query == null ? new HttpdParams() : query;
    }

    protected void finalize() throws Exception {
        this.method = null;
        this.httpVersion = null;
        this.urlPath = null;
        this.query = null;
        this.header = null;
        this.session = null;
        this.httpBody = null;
        this.conn = null;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getVersion() {
        return this.httpVersion.substring("HTTP/".length());
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public HttpdParams getQuery() {
        return this.query;
    }

    public HttpdHeaders getHeader() {
        return this.header;
    }

    public HttpdSession getSession() throws Exception {
        if (this.session == null) {
            HttpdSessionManager sessionManager = (HttpdSessionManager)GlobalManager.getValue((String)"SESSION_MANAGER");
            String id = null;
            String cookie = HttpdCookie.getCookie(this);
            if (cookie != null) {
                HashMap<String, String> ana = HttpdCookie.analysisCookie(cookie);
                id = ana.get("maachang-session");
                if (id != null && id.length() == 48) {
                    this.session = sessionManager.getSession(id);
                }
                this.cookieFlag = true;
            }
            if (this.session == null) {
                id = this.query.getParam("_maachang-session");
                this.session = id != null && id.length() == 48 && sessionManager.getSession(id) != null ? sessionManager.getSession(id) : sessionManager.getNewSession();
                this.cookieFlag = false;
            }
        }
        return this.session;
    }

    public InputStream getBody() {
        if (this.httpBody == null) {
            return null;
        }
        return new ByteArrayInputStream(this.httpBody);
    }

    public byte[] getBodyByBinary() {
        if (this.httpBody == null) {
            return null;
        }
        return this.httpBody;
    }

    public void setBody(byte[] body) {
        this.httpBody = (byte[])(body == null || body.length <= 0 ? null : body);
    }

    public void setConnectionInfo(HttpConnectionInfo conn) {
        this.conn = conn;
    }

    public HttpConnectionInfo getConnectionInfo() {
        return this.conn;
    }

    public void setKeepAliveTimeout(long timeout) {
    }

    public long getKeepAliveTimeout() {
        return -1L;
    }

    public void setKeepAliveCount(int count) {
    }

    public int getKeepAliveCount() {
        return -1;
    }

    public void setGzip(boolean flag) {
        this.gzipFlag = flag;
    }

    public boolean isGzip() {
        return this.gzipFlag;
    }

    public boolean isCookie() {
        return this.cookieFlag;
    }

    public boolean isSsl() {
        return false;
    }

    public boolean isUse() {
        return this.conn != null && this.conn.isUse();
    }

    public String toIpPort() {
        Socket soc = this.conn.getSocket().socket();
        return soc.getInetAddress().getHostAddress() + "/" + soc.getPort();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.conn != null && this.conn.getSocket() != null && this.conn.getSocket().socket() != null) {
            Socket soc = this.conn.getSocket().socket();
            buf.append(" ip:[").append(soc.getInetAddress().getHostAddress()).append("] port:").append(soc.getPort());
        }
        buf.append(" method:").append(this.method).append(" httpVersion:").append(this.httpVersion).append(" urlPath:").append(this.urlPath).append(" keepAliveTimeout:").append(this.getKeepAliveTimeout()).append(" keepAliveCount:").append(this.getKeepAliveCount()).append(" header:{").append(this.header).append(" }").append(" query:{").append(this.query).append(" }");
        return buf.toString();
    }
}

