/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.maachang.comet.httpd.HttpdBinary;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.HttpdUtil;
import org.maachang.comet.net.ArrayBinary;
import org.maachang.comet.net.HttpdBaseRequestImpl;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class ReadHttpdRequest {
    private static final int RECV_OVER_COUNT = 32;
    private static final long RECV_OVER_TIMEOUT = 3L;
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String CHARSET = "UTF8";
    private static final byte[] ENTER = new byte[]{13, 10};
    private static final byte[] END_HEADER = new byte[]{13, 10, 13, 10};

    private ReadHttpdRequest() {
    }

    public static final HttpdRequest receiveHttpRequest(InputStream stream, int seqId) throws Exception {
        ArrayBinary buf = new ArrayBinary();
        ArrayBinary chunked = null;
        ArrayBinary chunkedHead = null;
        boolean chunkedHeadFlag = false;
        int chunkedLen = 0;
        int chunkedRecvLen = 0;
        boolean exitChunkedFlag = false;
        boolean noRcv = false;
        int endHeaderPos = -1;
        int noRcvCnt = 32;
        int contentLength = -1;
        int endPlus = END_HEADER.length;
        boolean firstFlag = false;
        HttpdRequest ret = null;
        boolean notReceiveFlag = false;
        while (true) {
            notReceiveFlag = false;
            if (!firstFlag && ReadHttpdRequest.binaryIndexOf(buf.getBinary(), ENTER, 0, buf.getLength()) != -1) {
                String h = new String(buf.getBinary(), CHARSET);
                if (h.indexOf(" HTTP/") == -1) {
                    throw new IOException("The protocol is illegal(" + h + ")");
                }
                firstFlag = true;
            }
            if (noRcvCnt >= 32 || stream.available() > 0) {
                int d = stream.read();
                notReceiveFlag = true;
                if (chunked != null) {
                    if (exitChunkedFlag) continue;
                    if (chunkedHeadFlag) {
                        chunkedHead.write(d);
                        if (chunkedHead.getLength() >= 2 && d == (ENTER[1] & 0xFF) && chunkedHead.getByte(chunkedHead.getLength() - 2) == ENTER[0]) {
                            if (chunkedHead.getLength() <= 2) {
                                chunkedHead.reset();
                            } else {
                                chunkedLen = ReadHttpdRequest.getChunkedLength(chunkedHead);
                                chunkedHead.reset();
                                chunkedRecvLen = 0;
                                chunkedHeadFlag = false;
                                if (chunkedLen == 0) {
                                    exitChunkedFlag = true;
                                }
                            }
                        }
                    } else {
                        chunked.write(d);
                        if (chunkedLen <= ++chunkedRecvLen) {
                            chunkedHeadFlag = true;
                            chunkedLen = -1;
                            chunkedRecvLen = 0;
                        }
                    }
                } else {
                    int nowEndLength;
                    byte[] data;
                    buf.write(d);
                    if (endHeaderPos <= -1 && buf.getLength() >= 4 && d == (ENTER[1] & 0xFF) && (data = buf.getBinary())[(nowEndLength = buf.getLength()) - 4] == END_HEADER[0] && data[nowEndLength - 3] == END_HEADER[1] && data[nowEndLength - 2] == END_HEADER[2] && data[nowEndLength - 1] == END_HEADER[3]) {
                        notReceiveFlag = false;
                    }
                }
                noRcv = true;
                noRcvCnt = 0;
            } else {
                notReceiveFlag = false;
            }
            if (notReceiveFlag) continue;
            if (endHeaderPos <= -1) {
                if (noRcv) {
                    noRcv = false;
                    noRcvCnt = 0;
                    byte[] data = buf.getBinary();
                    int endPos = ReadHttpdRequest.binaryIndexOf(data, END_HEADER, 0, buf.getLength());
                    if (endPos <= -1) continue;
                    endHeaderPos = endPos + endPlus;
                    ret = ReadHttpdRequest.convertHttpdHeader(data, endPos);
                    data = null;
                    if ("GET".equals(ret.getMethod())) {
                        buf.destroy();
                        break;
                    }
                    if ("POST".equals(ret.getMethod())) {
                        if (ret.getHeader().size(TRANSFER_ENCODING) == 1) {
                            String s = ret.getHeader().getHeader(TRANSFER_ENCODING);
                            if (!CHUNKED.equals(s)) {
                                throw new IOException("\u4e0d\u6b63\u306a[Transfer-Encoding=" + s + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                            }
                            contentLength = -1;
                            chunked = new ArrayBinary();
                            chunkedHead = new ArrayBinary();
                            chunkedHeadFlag = true;
                        } else if (ret.getHeader().size(CONTENT_LENGTH) == 1) {
                            String s = ret.getHeader().getHeader(CONTENT_LENGTH);
                            if (s == null || s.length() <= 0) {
                                throw new IOException("\u4e0d\u6b63\u306a[Content-Length]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                            }
                            contentLength = Integer.parseInt(s);
                            if (contentLength >= 0x2000000) {
                                throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u6700\u5927\u5024[33554432]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                            }
                            if (contentLength <= -1) {
                                throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577[" + contentLength + "]\u306f\u4e0d\u6b63\u3067\u3059");
                            }
                        }
                        noRcv = true;
                        noRcvCnt = 0;
                        continue;
                    }
                    throw new IOException("\u4e0d\u6b63\u306a\u30e1\u30bd\u30c3\u30c9[" + ret.getMethod() + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                ++noRcvCnt;
                Thread.sleep(3L);
                continue;
            }
            if (noRcv) {
                noRcv = false;
                noRcvCnt = 0;
                if (exitChunkedFlag && chunked != null) {
                    if (chunked.getLength() > 0) {
                        byte[] body = chunked.getBinary(chunked.getLength());
                        buf.destroy();
                        chunked.destroy();
                        ReadHttpdRequest.convertBody(ret, body);
                        body = null;
                    }
                } else {
                    if (contentLength == -1 || contentLength > buf.getLength() - endHeaderPos) continue;
                    int bodyLen = buf.getLength() - endHeaderPos;
                    if (bodyLen > 0) {
                        byte[] body = new byte[bodyLen];
                        System.arraycopy(buf.getBinary(), endHeaderPos, body, 0, bodyLen);
                        buf.destroy();
                        ReadHttpdRequest.convertBody(ret, body);
                        body = null;
                    }
                }
                break;
            }
            ++noRcvCnt;
            Thread.sleep(3L);
        }
        return ret;
    }

    private static int binaryIndexOf(byte[] binary, String data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length() <= 0) {
            return -1;
        }
        return ReadHttpdRequest.binaryIndexOf(binary, data.getBytes(CHARSET), off, len);
    }

    private static int binaryIndexOf(byte[] binary, byte[] data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length <= 0) {
            return -1;
        }
        int dataLen = data.length;
        if (len <= 0 || len >= binary.length) {
            len = binary.length;
        }
        int ret = -1;
        int i = off;
        while (i < len) {
            if (binary[i] == data[0] && i + dataLen <= len) {
                ret = i;
                int j = 1;
                while (j < dataLen) {
                    if (binary[i + j] != data[j]) {
                        ret = -1;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) {
                    return ret;
                }
            }
            ++i;
        }
        return -1;
    }

    private static final HttpdRequest convertHttpdHeader(byte[] binary, int endPos) throws Exception {
        HttpdBaseRequestImpl ret = new HttpdBaseRequestImpl();
        int p = 0;
        int b = 0;
        int line = 0;
        int enterLen = ENTER.length;
        while (true) {
            if ((p = ReadHttpdRequest.binaryIndexOf(binary, ENTER, b, endPos)) == -1) {
                if (b >= endPos) break;
                p = endPos;
            }
            String one = new String(binary, b, p - b, CHARSET);
            b = p + enterLen;
            if (line == 0) {
                ReadHttpdRequest.convertHttpExecutionAndVersion(ret, one);
                if (ret.getHttpVersion().endsWith("0.9")) {
                    ReadHttpdRequest.convertAnalysisQuery(ret);
                    return ret;
                }
            } else {
                ReadHttpdRequest.convertHttpHeader(ret, one);
            }
            if (p >= endPos) break;
            ++line;
        }
        ReadHttpdRequest.convertAnalysisQuery(ret);
        return ret;
    }

    private static final void convertHttpExecutionAndVersion(HttpdRequest out, String oneLine) {
        int pos1 = oneLine.indexOf(" ");
        int pos2 = oneLine.indexOf(" ", pos1 + 1);
        String exec = oneLine.substring(0, pos1);
        String url = oneLine.substring(pos1 + 1, pos2);
        String version = oneLine.substring(pos2 + 1, oneLine.length());
        out.setMethod(exec.trim());
        out.setUrlPath(url.trim());
        out.setHttpVersion(version.trim());
    }

    private static final void convertHttpHeader(HttpdRequest out, String oneLine) {
        int p = oneLine.indexOf(":");
        if (p == -1) {
            return;
        }
        String key = oneLine.substring(0, p).trim();
        if ((oneLine = oneLine.substring(++p + 1, oneLine.length())) == null || (oneLine = oneLine.trim()).length() <= 0) {
            out.getHeader().addHeader(key, null);
        } else if (key.indexOf("User-Agent") != -1 || key.indexOf("Modified") != -1 || key.indexOf("Date") != -1) {
            out.getHeader().addHeader(key, oneLine);
        } else if (oneLine.indexOf(",") != -1) {
            ArrayList lst = StringUtil.cutString((String)oneLine, (String)",");
            int len = lst.size();
            HttpdHeaders header = out.getHeader();
            int i = 0;
            while (i < len) {
                String o;
                if (i == 0) {
                    o = ((String)lst.get(i)).trim();
                    if (o.length() > 0) {
                        int sp = o.indexOf(" ");
                        if (sp != -1) {
                            boolean flg = false;
                            int j = 0;
                            while (j < sp) {
                                char c = o.charAt(j);
                                if (c == '\"' || c == '\'') {
                                    flg = true;
                                    break;
                                }
                                ++j;
                            }
                            if (flg) {
                                header.addHeader(key, o);
                            } else {
                                header.addHeader(key, o.substring(0, sp).trim());
                                header.addHeader(key, o.substring(sp + 1).trim());
                            }
                        } else {
                            header.addHeader(key, o);
                        }
                    }
                } else {
                    o = ((String)lst.get(i)).trim();
                    if (o.length() > 0) {
                        header.addHeader(key, o);
                    }
                }
                ++i;
            }
        } else if ((oneLine = oneLine.trim()).length() > 0) {
            out.getHeader().addHeader(key, oneLine);
        }
    }

    public static final void convertAnalysisQuery(HttpdRequest out) {
        String query = HttpdUtil.getQueryValue(out.getUrlPath());
        if (query != null && (query = query.trim()).length() > 0) {
            out.setUrlPath(HttpdUtil.getReadName(out.getUrlPath()));
            HttpdUtil.convertQueryByParams(out.getQuery(), query, CHARSET);
        }
    }

    private static final void convertAnalysisBody(HttpdRequest out, String body) {
        if (body != null && (body = body.trim()).length() > 0) {
            HttpdUtil.convertQueryByParams(out.getQuery(), body, CHARSET);
        }
    }

    public static final void convertBody(HttpdRequest out, byte[] binary) throws Exception {
        block27: {
            int p = 0;
            int b = 0;
            int enterLen = ENTER.length;
            int len = out.getHeader().size("Content-Type");
            String multiPartForm = null;
            String dataType = null;
            int i = 0;
            while (i < len) {
                String contentType = out.getHeader().getHeader("Content-Type", i);
                if (multiPartForm == null) {
                    int boundary = -1;
                    boundary = contentType.indexOf("multipart/form-data");
                    if (boundary != -1 && (boundary = contentType.indexOf("boundary=", boundary)) != -1) {
                        multiPartForm = contentType.substring(boundary + "boundary=".length(), contentType.length());
                    }
                }
                if (dataType == null || !contentType.startsWith(FORM_CONTENT_TYPE)) {
                    dataType = contentType;
                }
                ++i;
            }
            if (dataType == null) {
                dataType = FORM_CONTENT_TYPE;
            }
            if (multiPartForm != null) {
                out.setBody(null);
                String target = "--" + multiPartForm;
                String end = String.valueOf(target) + "--";
                String keyName = null;
                String fileName = null;
                String mimeType = null;
                boolean dataFlag = false;
                boolean keyFlag = false;
                int filenameLen = "; filename=\"".length();
                int nameLen = "; name=\"".length();
                while (true) {
                    String one;
                    if (!dataFlag) {
                        int namePnt;
                        int filePnt;
                        p = ReadHttpdRequest.binaryIndexOf(binary, ENTER, b, binary.length);
                        if (p == -1) break block27;
                        if (p == b) {
                            b += enterLen;
                            continue;
                        }
                        one = new String(binary, b, p - b, CHARSET);
                        b = p + enterLen;
                        if (!keyFlag) {
                            if (one.equals(target)) {
                                keyFlag = true;
                                continue;
                            }
                            if (!one.equals(end)) {
                                throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                            }
                            break block27;
                        }
                        if (one.length() <= 0) {
                            dataFlag = true;
                            continue;
                        }
                        if (one.startsWith("Content-Disposition:") && (filePnt = one.indexOf("; filename=\"")) != -1) {
                            String fullPath = one.substring(filePnt += filenameLen, one.indexOf("\"", filePnt)).trim();
                            fileName = FileUtil.getFileName((String)fullPath).trim();
                        }
                        if ((namePnt = one.indexOf("; name=\"")) != -1) {
                            keyName = one.substring(namePnt += nameLen, one.indexOf("\"", namePnt)).trim();
                            continue;
                        }
                        if (one.startsWith("Content-Type:")) {
                            mimeType = one.substring("Content-Type:".length(), one.length()).trim();
                            continue;
                        }
                        throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                    }
                    if (fileName != null) {
                        p = ReadHttpdRequest.binaryIndexOf(binary, target, b, binary.length);
                        if (p == -1) {
                            throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                        }
                        if (fileName == null || (fileName = fileName.trim()).length() <= 0) {
                            b = p;
                        } else {
                            len = p - (b + enterLen);
                            byte[] uploadBinary = new byte[len];
                            System.arraycopy(binary, b, uploadBinary, 0, len);
                            b = p;
                            HttpdBinary bin = new HttpdBinary(fileName, mimeType, uploadBinary);
                            out.getQuery().addParam(keyName, bin);
                        }
                    } else {
                        p = ReadHttpdRequest.binaryIndexOf(binary, target, b, binary.length);
                        if (p == -1) {
                            throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u6761\u4ef6\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                        }
                        one = new String(binary, b, p - (b + enterLen), CHARSET);
                        b = p;
                        out.getQuery().addParam(keyName, one);
                    }
                    keyName = null;
                    fileName = null;
                    mimeType = null;
                    dataFlag = false;
                    keyFlag = false;
                }
            }
            if (dataType != null && dataType.startsWith(FORM_CONTENT_TYPE)) {
                String charset = ReadHttpdRequest.getCharset(dataType);
                out.setBody(binary);
                boolean end = false;
                StringBuilder buf = new StringBuilder();
                while (!end) {
                    p = ReadHttpdRequest.binaryIndexOf(binary, ENTER, b, binary.length);
                    if (p <= -1) {
                        p = binary.length;
                        end = true;
                    }
                    if (p == b) {
                        b += enterLen;
                        continue;
                    }
                    String one = new String(binary, b, p - b, charset);
                    one = StringUtil.changeString((String)one, (String)"\r", (String)"");
                    one = StringUtil.changeString((String)one, (String)"\n", (String)"");
                    b = p + enterLen;
                    if (one.length() <= 0) break;
                    buf.append(one);
                }
                String bodys = buf.toString();
                buf = null;
                ReadHttpdRequest.convertAnalysisBody(out, bodys);
                bodys = null;
            } else {
                out.setBody(binary);
            }
        }
    }

    private static final String getCharset(String contentType) {
        int p = contentType.indexOf("charset=");
        if (p <= -1) {
            return CHARSET;
        }
        return contentType.substring(p + "charset=".length());
    }

    private static final int getChunkedLength(ArrayBinary buf) throws Exception {
        ArrayBinary t = new ArrayBinary();
        int len = buf.getLength();
        int i = 0;
        while (i < len) {
            int d = buf.getByte(i) & 0xFF;
            if (d != 0) {
                t.write(d);
            }
            ++i;
        }
        String s = new String(t.getBinary(), 0, t.getLength() - 2, "ISO-8859-1");
        return Integer.parseInt(s, 16);
    }
}

