/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.service.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.maachang.comet.httpd.engine.script.service.client.HttpHeader;
import org.maachang.comet.httpd.engine.script.service.client.HttpParam;
import org.maachang.comet.httpd.engine.script.service.client.HttpRedirectUrlException;
import org.maachang.comet.httpd.engine.script.service.client.HttpResult;
import org.maachang.util.URLEncode;

public class HttpClientAccess {
    private static final int REDIRECT_RETRY_COUNT = 99;
    private static final Integer DEFAULT_TIMEOUT = new Integer(60000);
    private static final String CONTENT_LENGTH = "content-Length";

    private HttpClientAccess() {
    }

    public static HttpResult connection(boolean mode, String url, Integer timeout, HttpHeader header, HttpParam params, String userAgent) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return HttpClientAccess.executionConnection(mode, url, timeout, null, null, header, params, userAgent);
    }

    public static HttpResult connectionByInputBody(String url, Integer timeout, byte[] body, String bodyType, HttpHeader header, HttpParam params, String userAgent) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0 || body == null || body.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return HttpClientAccess.executionConnection(true, url, timeout, body, bodyType, header, params, userAgent);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpResult executionConnection(boolean mode, String url, Integer timeout, byte[] body, String bodyType, HttpHeader header, HttpParam params, String userAgent) throws Exception {
        if (timeout == null) {
            timeout = DEFAULT_TIMEOUT;
        }
        int rcnt = 0;
        HttpResult ret = null;
        while (true) {
            HttpMethod md;
            block12: {
                md = null;
                try {
                    if (99 <= rcnt) {
                        throw new IOException("\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u6570\u304c\u898f\u5b9a\u5024\u3092\u8d8a\u3057\u307e\u3057\u305f");
                    }
                    HttpClient cl = new HttpClient();
                    cl.getParams().setParameter("http.socket.timeout", (Object)timeout);
                    md = HttpClientAccess.createMethod(mode, url, body, bodyType, header, params);
                    if (userAgent != null && (userAgent = userAgent.trim()).length() > 0) {
                        md.addRequestHeader("User-Agent", userAgent);
                    }
                    cl.getParams().setAuthenticationPreemptive(false);
                    cl.executeMethod(md);
                    ret = HttpClientAccess.getHttpResponse(md);
                    return ret;
                }
                catch (HttpRedirectUrlException hr) {
                    ret = null;
                    url = hr.getRedirectURL();
                    ++rcnt;
                    break block12;
                    catch (Exception e) {
                        ret = null;
                        throw e;
                    }
                }
                finally {
                    if (md != null) {
                        md.releaseConnection();
                    }
                }
            }
            if (md == null) continue;
            md.releaseConnection();
        }
    }

    private static final HttpMethod createMethod(boolean method, String url, byte[] body, String bodyType, HttpHeader headers, HttpParam params) throws Exception {
        String[] keys;
        GetMethod ret = null;
        if (method) {
            PostMethod post;
            if (body != null) {
                url = HttpClientAccess.setParams(false, url, null, params);
                post = new PostMethod(url);
                if (bodyType == null) {
                    post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body));
                } else {
                    post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body, bodyType));
                }
                ret = post;
            } else {
                post = new PostMethod(url);
                HttpClientAccess.setParams(true, url, (HttpMethod)post, params);
                ret = post;
            }
        } else {
            GetMethod get;
            url = HttpClientAccess.setParams(false, url, null, params);
            ret = get = new GetMethod(url);
        }
        if (headers != null && (keys = headers.getKeys()) != null) {
            int len = keys.length;
            int i = 0;
            while (i < len) {
                if (!CONTENT_LENGTH.equals(keys[i])) {
                    int lenJ = headers.size(keys[i]);
                    int j = 0;
                    while (j < lenJ) {
                        String value = headers.getHeader(keys[i], j);
                        if (value == null) {
                            ret.addRequestHeader(keys[i], "");
                        } else {
                            ret.addRequestHeader(keys[i], value);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        ret.setFollowRedirects(false);
        ret.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        ret.setDoAuthentication(false);
        return ret;
    }

    private static final String setParams(boolean mode, String url, HttpMethod method, HttpParam params) throws Exception {
        if (mode) {
            String[] keys;
            PostMethod post = (PostMethod)method;
            if (params != null && params.size() > 0 && (keys = params.getKeys()) != null) {
                int len = keys.length;
                int i = 0;
                while (i < len) {
                    int lenJ = params.size(keys[i]);
                    int j = 0;
                    while (j < lenJ) {
                        String value = params.getParam(keys[i], j);
                        if (value == null) {
                            post.addParameter(keys[i], "");
                        } else {
                            post.addParameter(keys[i], value);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        } else {
            String[] keys;
            if (params != null && params.size() > 0 && (keys = params.getKeys()) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(url).append("?");
                int len = keys.length;
                int i = 0;
                while (i < len) {
                    if (i != 0) {
                        buf.append("&");
                    }
                    int lenJ = params.size(keys[i]);
                    int j = 0;
                    while (j < lenJ) {
                        String value;
                        if (j != 0) {
                            buf.append("&");
                        }
                        if ((value = params.getParam(keys[i], j)) == null) {
                            buf.append(keys[i]).append("=");
                        } else {
                            buf.append(keys[i]).append("=").append(URLEncode.convert((String)value.toString()));
                        }
                        ++j;
                    }
                    ++i;
                }
                url = buf.toString();
            }
            return url;
        }
        return null;
    }

    private static final HttpResult getHttpResponse(HttpMethod method) throws Exception {
        byte[] binary;
        HttpResult ret = null;
        int state = method.getStatusCode();
        if (state == 200 || state == 401 || state == 403 || state == 404 || state >= 500) {
            binary = null;
            InputStream in = method.getResponseBodyAsStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int n;
                byte[] buf = null;
                buf = new byte[8192];
                while ((n = in.read(buf)) >= 0) {
                    if (n <= 0) continue;
                    out.write(buf, 0, n);
                }
                out.flush();
                binary = out.toByteArray();
                out.close();
                out = null;
                in.close();
                in = null;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (state == 301 || state == 302) {
            if (method.getResponseHeader("Location") == null) {
                throw new IOException("\u30ea\u30c0\u30a4\u30ec\u30af\u30c8(" + state + ")\u306b\u5bfe\u3057\u3066[Location]\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            throw new HttpRedirectUrlException(method.getResponseHeader("Location").getValue());
        }
        return null;
        Header header = method.getResponseHeader("Content-Type");
        ret = new HttpResult(binary, state, header == null ? null : header.getValue());
        return ret;
    }
}

