/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.util.FileUtil;

public class ModelScript
implements Script {
    private String name = null;
    private String modelFileName = null;
    private long updateTime = -1L;
    private SrcScript srcScript = null;
    private ExecutionScriptImpl executionScript = null;
    private int packageId = -1;

    private ModelScript() {
    }

    public ModelScript(String name, String currentDirectory) throws Exception {
        String modelFileName;
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u30e2\u30c7\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!name.endsWith(".ms")) {
            name = String.valueOf(name) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(modelFileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + "model/" + name))) {
            throw new HttpdStateException(500, "Model\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.name = name;
        this.modelFileName = modelFileName;
    }

    public synchronized ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.modelFileName)) {
            throw new HttpdStateException(500, "Model\u30d5\u30a1\u30a4\u30eb[" + this.name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript == null || this.updateTime != FileUtil.getLastTime((String)this.modelFileName) || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    public synchronized String getPath() {
        return this.name;
    }

    public synchronized String getScriptName() {
        return this.modelFileName;
    }

    public int getScriptType() {
        return 20;
    }

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    private void readScript() throws Exception {
        StringBuilder buf = new StringBuilder();
        this.packageId = JsDef.pushDefaultPackage(buf);
        buf.append(FileUtil.getFileByString((String)this.modelFileName, (String)"UTF8"));
        String script = buf.toString();
        buf = null;
        this.srcScript = new SrcScript(script);
        this.executionScript = new ExecutionScriptImpl("js", 20, this.getPath(), script);
        buf = null;
        this.updateTime = FileUtil.getLastTime((String)this.modelFileName);
    }
}

