/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.dao;

import java.util.ArrayList;
import org.maachang.dao.dbms.DbUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseSql {
    private static final char[] VALUE_HEAD = new char[]{':', '$'};
    private static final int USE_NON = -1;
    private static final int USE_STRING = 1;
    private static final int USE_OTHER = 2;

    private ParseSql() {
    }

    public static final ArrayList<String> parseSQL(String sql) throws Exception {
        int n;
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = sql.length();
        int n2 = -1;
        int n3 = -1;
        int before = -1;
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char c;
            char c2 = sql.charAt(i);
            if (c != '\uffffffff') {
                if (c == c2) {
                    c = '\uffffffff';
                    if (n != -1) {
                        ret.add(sql.substring(n, i + 1));
                        n = -1;
                    }
                    before = -1;
                }
            } else if (c2 == '\'' || c2 == '\"') {
                if (n != -1) {
                    ret.add(sql.substring(n, i));
                    n = -1;
                }
                c = c2;
                n = i;
                before = -1;
            } else if (c2 == '\r' || c2 == '\n' || c2 == ' ' || c2 == '\t' || c2 == '\u3000') {
                if (n != -1) {
                    ret.add(sql.substring(n, i));
                    n = -1;
                }
                before = -1;
            } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_') {
                if (before == -1) {
                    n = i;
                    before = 1;
                } else if (before != 1) {
                    if (n != -1) {
                        ret.add(sql.substring(n, i));
                    }
                    n = i;
                    before = 1;
                }
            } else if (ParseSql.isValue(c2)) {
                if (before == 1) {
                    if (n != -1) {
                        ret.add(sql.substring(n, i));
                    }
                    n = i;
                    before = 2;
                } else if (before == -1) {
                    if (n != -1) {
                        ret.add(sql.substring(n, i));
                    }
                    n = i;
                    before = 1;
                } else if (before != 1) {
                    if (n != -1) {
                        ret.add(sql.substring(n, i));
                    }
                    n = i;
                    before = 1;
                }
            } else if (before == 1) {
                if (n != -1) {
                    ret.add(sql.substring(n, i));
                }
                n = i;
                before = 2;
            } else if (before == -1) {
                if (n != -1) {
                    ret.add(sql.substring(n, i));
                }
                n = i;
                before = 2;
            }
            ++i;
        }
        if (n != -1) {
            ret.add(sql.substring(n, sql.length()));
        }
        return ret;
    }

    public static final String srcSQL(ArrayList<String> parse) throws Exception {
        if (parse == null || parse.size() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = parse.size();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < len) {
            String code;
            if (i != 0) {
                buf.append(" ");
            }
            if (ParseSql.isValue(code = parse.get(i))) {
                buf.append(DbUtil.convertJavaNameByDBName((String)code.substring(1)));
            } else if ("&&".equals(code)) {
                buf.append("and");
            } else if ("||".equals(code)) {
                buf.append("or");
            } else {
                buf.append(code);
            }
            ++i;
        }
        String ret = buf.toString();
        buf = null;
        if (!ret.endsWith(";")) {
            ret = String.valueOf(ret) + ";";
        }
        return ret;
    }

    public static final ArrayList<String> getValues(ArrayList<String> parse) throws Exception {
        if (parse == null || parse.size() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ArrayList<String> ret = new ArrayList<String>();
        int len = parse.size();
        int i = 0;
        while (i < len) {
            String code = parse.get(i);
            if (ParseSql.isValue(code)) {
                ret.add(code.substring(1, code.length()));
            }
            ++i;
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public static final boolean isValues(ArrayList<String> parse) throws Exception {
        if (parse == null || parse.size() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = parse.size();
        int i = 0;
        while (i < len) {
            String code = parse.get(i);
            if (ParseSql.isValue(code)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean isValue(char c) {
        int len = VALUE_HEAD.length;
        int i = 0;
        while (i < len) {
            if (c == VALUE_HEAD[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean isValue(String code) {
        char c;
        return ParseSql.isValue(code.charAt(0)) && code.length() > 1 && ((c = code.charAt(1)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_');
    }
}

