/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.cache.CacheTable;
import org.maachang.comet.httpd.engine.script.cache.CacheTableWrapper;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

public class CacheModelScript {
    private static final String CACHE_TABLE_NAME = "model";
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[models]";
    private static final String READ_DIR = CacheModelScript.baseDir();
    private static final String CURRENT_DIR = CacheModelScript.currentDir();
    private static final long CHECK_TIME = 30000L;
    private static final Log LOG = LogFactory.getLog(CacheModelScript.class);
    private long beforeTime = -1L;
    private String modelCode = null;
    private SrcScript srcScript = null;
    private int packageId = -1;
    private final Object sync = new Object();

    protected void finalize() throws Exception {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.beforeTime = -1L;
            this.modelCode = null;
            this.srcScript = null;
            this.packageId = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheTableWrapper reload(CacheTableWrapper wrapper) throws Exception {
        if (wrapper == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.sync;
            synchronized (object) {
                this.readScript(wrapper);
            }
            return wrapper;
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheTableWrapper script(CacheTableWrapper wrapper) throws Exception {
        if (wrapper == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.sync;
            synchronized (object) {
                if (GlobalManager.getValue((String)"DBMS_POOL") != null) {
                    if (this.packageId != -1 && this.packageId != JsDef.getDefaultPackageId()) {
                        this.readScript(wrapper);
                    } else if (this.beforeTime + 30000L <= System.currentTimeMillis()) {
                        if (!wrapper.getCacheTable().isParent(CACHE_TABLE_NAME)) {
                            this.readScript(wrapper);
                        } else if (this.modelCode == null) {
                            this.readScript(wrapper);
                        } else if (!this.modelCode.equals(this.createModelMonitor())) {
                            this.readScript(wrapper);
                        }
                    }
                }
            }
            return wrapper;
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript() {
        SrcScript ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.srcScript;
        }
        return ret;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    private String createModelMonitor() throws Exception {
        String[] models = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(models, CURRENT_DIR);
    }

    private void putModel(String model, StringBuilder buf) throws Exception {
        buf.append("var ").append(model).append(" = baseModel(\"").append(model).append("\");\n");
        String modelScript = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + model + ".ms"), (String)"UTF8");
        if (modelScript != null && (modelScript = modelScript.trim()).length() > 0) {
            buf.append(modelScript).append("\n");
        }
    }

    private void readScript(CacheTableWrapper wrapper) throws Exception {
        String[] models = ScriptDef.getUseScript(READ_DIR);
        if (models != null && models.length > 0) {
            String managerCode = ScriptDef.getScriptManagerCode(models, CURRENT_DIR);
            StringBuilder buf = new StringBuilder();
            this.packageId = JsDef.pushDefaultPackage(buf);
            int len = models.length;
            int i = 0;
            while (i < len) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">read[model] - " + models[i]));
                }
                this.putModel(models[i], buf);
                ++i;
            }
            String script = buf.toString();
            buf = null;
            this.srcScript = new SrcScript(script);
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName(ENGINE_NAME);
            CacheTable cacheTable = wrapper.getCacheTable();
            cacheTable.waitByStartUpdate();
            try {
                wrapper.setCacheAppend(true);
                Bindings bindings = new SimpleBindings(wrapper);
                bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                engine.put("javax.script.filename", SCRIPT_NAME);
                engine.eval(script, bindings);
                bindings = cacheTable.getBindings();
                cacheTable.putParent(CACHE_TABLE_NAME, bindings);
            }
            finally {
                wrapper.setCacheAppend(false);
                cacheTable.exitUpdate();
            }
            this.modelCode = managerCode;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"** model-cache\u3092\u8aad\u307f\u8fbc\u307f");
            }
        } else {
            this.modelCode = null;
            this.packageId = -1;
        }
        this.beforeTime = System.currentTimeMillis();
    }

    private static final String baseDir() {
        try {
            return FileUtil.getFullPath((String)"model/");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final String currentDir() {
        try {
            String ret = FileUtil.getFullPath((String)".");
            if (ret.endsWith(".")) {
                ret = ret.substring(0, ret.length() - 1);
            }
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

