/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd;

import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.comet.httpd.HttpdBinary;
import org.maachang.comet.httpd.NullObjectParam;

public class HttpdParams {
    private HashMap<String, ArrayList<Object>> params = null;

    protected void finalize() throws Exception {
        this.params = null;
    }

    public void add(HttpdParams param) {
        if (param == null || param.size() <= 0) {
            return;
        }
        String[] keys = param.getKeys();
        if (keys != null) {
            int len = keys.length;
            int i = 0;
            while (i < len) {
                int lenJ = param.size(keys[i]);
                int j = 0;
                while (j < lenJ) {
                    this.addParam(keys[i], param.getParam(keys[i], j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public void addParam(String key, Object value) {
        this.pushParam(false, key, value);
    }

    public void setParam(String key, Object value) {
        this.pushParam(true, key, value);
    }

    private void pushParam(boolean mode, String key, Object value) {
        Object val = null;
        if (key == null) {
            return;
        }
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (value == null) {
            val = new NullObjectParam();
        } else if (value instanceof String || value instanceof HttpdBinary) {
            val = value;
        } else {
            return;
        }
        if (mode) {
            ArrayList<Object> lst = new ArrayList<Object>();
            lst.add(val);
            this.params.put(key, lst);
        } else {
            ArrayList<Object> lst = this.params.get(key);
            if (lst == null) {
                lst = new ArrayList();
                this.params.put(key, lst);
            }
            lst.add(val);
        }
    }

    public void removeParam(String key) {
        if (key == null || this.params == null) {
            return;
        }
        this.params.remove(key);
    }

    public void removeParam(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return;
        }
        ArrayList<Object> lst = this.params.get(key);
        if (lst == null || lst.size() <= no) {
            return;
        }
        lst.remove(no);
        if (lst.size() <= 0) {
            this.params.remove(key);
        }
    }

    public String getParam(String key) {
        return this.getParam(key, 0);
    }

    public String getParam(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return null;
        }
        ArrayList<Object> lst = this.params.get(key);
        if (lst == null || lst.size() <= no) {
            return null;
        }
        Object ret = lst.get(no);
        if (ret == null || ret instanceof NullObjectParam) {
            return null;
        }
        if (ret instanceof HttpdBinary) {
            return ret.toString();
        }
        return (String)ret;
    }

    public HttpdBinary getParamByBinary(String key) {
        return this.getParamByBinary(key, 0);
    }

    public HttpdBinary getParamByBinary(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return null;
        }
        ArrayList<Object> lst = this.params.get(key);
        if (lst == null || lst.size() <= no) {
            return null;
        }
        Object ret = lst.get(no);
        if (ret == null || ret instanceof NullObjectParam) {
            return null;
        }
        if (ret instanceof HttpdBinary) {
            return (HttpdBinary)ret;
        }
        HttpdBinary bin = null;
        try {
            bin = new HttpdBinary(key, "text/plain", ((String)ret).getBytes("UTF8"));
        }
        catch (Exception e) {
            bin = null;
        }
        return bin;
    }

    public boolean getParamType(String key) {
        return this.getParamType(key, 0);
    }

    public boolean getParamType(String key, int no) {
        if (key == null || this.params == null || no < 0) {
            return false;
        }
        ArrayList<Object> lst = this.params.get(key);
        if (lst == null || lst.size() <= no) {
            return false;
        }
        Object ret = lst.get(no);
        if (ret == null || ret instanceof NullObjectParam) {
            return false;
        }
        return ret instanceof HttpdBinary;
    }

    public int size() {
        return this.params == null ? 0 : this.params.size();
    }

    public int size(String key) {
        if (key == null || this.params == null) {
            return 0;
        }
        ArrayList<Object> lst = this.params.get(key);
        if (lst == null) {
            return 0;
        }
        return lst.size();
    }

    public String[] getKeys() {
        if (this.params == null || this.params.size() <= 0) {
            return null;
        }
        Object[] keys = this.params.keySet().toArray();
        if (keys != null) {
            int len = keys.length;
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public boolean isKey(String key) {
        if (this.params == null) {
            return false;
        }
        return this.params.get(key) != null;
    }

    public String toString() {
        String[] keys = this.getKeys();
        if (keys != null) {
            StringBuilder buf = new StringBuilder();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                ArrayList<Object> lst;
                if (i != 0) {
                    buf.append(",");
                }
                if ((lst = this.params.get(keys[i])) != null) {
                    int lenJ = lst.size();
                    int j = 0;
                    while (j < lenJ) {
                        if (j != 0) {
                            buf.append(",");
                        }
                        Object objs = lst.get(j);
                        buf.append(" [").append(keys[i]).append(":");
                        if (objs == null || objs instanceof NullObjectParam) {
                            buf.append("]");
                        } else if (objs instanceof HttpdBinary) {
                            buf.append(" orginal/").append(((HttpdBinary)objs).getOriginalName()).append(" length/").append(((HttpdBinary)objs).getLength()).append("]");
                        } else {
                            buf.append(objs).append("]");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

