/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.AuthUserByDatabase;
import org.maachang.comet.conf.AuthUsersByConfig;
import org.maachang.comet.conf.BaseConfig;
import org.maachang.comet.conf.DbAuthUsers;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.MailConfig;
import org.maachang.comet.conf.MimeConfig;
import org.maachang.comet.conf.PackagesConfig;
import org.maachang.comet.httpd.engine.auth.HttpdAuthManager;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.conf.Config;
import org.maachang.conf.ConvIniParam;
import org.maachang.dao.DaoSessionFactory;
import org.maachang.dao.InitDao;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.MDbmServer;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

public class StartupConfig {
    private static final Log LOG = LogFactory.getLog(StartupConfig.class);
    private static final String RECORD_SECTION = "dbms";
    private static final String MDBM_SECTION = "mdbm";
    private static final String CONF = ".conf";

    private StartupConfig() {
    }

    public static final void init(String path) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String basePath = StartupConfig.getPath(path);
        path = String.valueOf(basePath) + "conf/";
        path = String.valueOf(FileUtil.getFullPath((String)path)) + FileUtil.FILE_SPACE;
        BaseConfig conf = StartupConfig.getBaseConfig(path);
        GlobalManager nm = GlobalManager.getInstance();
        LOG.info((Object)"@@@ MimeType ... [START]");
        String mime = String.valueOf(path) + conf.getMimes();
        if (!mime.endsWith(CONF)) {
            mime = String.valueOf(mime) + CONF;
        }
        MimeConfig mimeType = new MimeConfig();
        mimeType.open(mime);
        nm.put("MIME_TYPE", (Object)mimeType);
        LOG.info((Object)"@@@ MimeType ... [END]");
        LOG.info((Object)"@@@ Mail-Config ... [START]");
        String mail = String.valueOf(path) + conf.getMail();
        if (!mail.endsWith(CONF)) {
            mail = String.valueOf(mail) + CONF;
        }
        MailConfig mailConfig = new MailConfig();
        mailConfig.open(mail);
        nm.put("MAIL_CONFIG", (Object)mailConfig);
        LOG.info((Object)"@@@ Mail-Config ... [END]");
        LOG.info((Object)"@@@ packages ... [START]");
        String packages = String.valueOf(path) + conf.getPackages();
        if (!packages.endsWith(CONF)) {
            packages = String.valueOf(packages) + CONF;
        }
        PackagesConfig packagesConf = new PackagesConfig();
        packagesConf.open(packages);
        nm.put("PACKAGES_MANAGER", (Object)packagesConf);
        LOG.info((Object)"@@@ packages ... [END]");
        LOG.info((Object)"@@@ read-Conf ... [START]");
        IniFile config = StartupConfig.getEnhancingConfigs(conf, path);
        nm.put("CONFIG_MANAGER", (Object)config);
        LOG.info((Object)"@@@ read-Conf ... [END]");
        LOG.info((Object)"@@@ Record ... [START]");
        RecordFactory recordFactory = StartupConfig.getRecordFactory(true, config);
        LOG.info((Object)"@@@ mdbm ... [START]");
        StartupConfig.createMDbm(true, config);
        LOG.info((Object)"@@@ mdbm ... [END]");
        if (recordFactory != null) {
            nm.put("DBMS_POOL", (Object)recordFactory);
        }
        LOG.info((Object)"@@@ Record ... [END]");
        LOG.info((Object)"@@@ cacheScript ... [START]");
        CacheScriptManager cacheScriptManager = StartupConfig.getCacheScriptManager(config);
        if (cacheScriptManager != null) {
            nm.put("SCRIPT_CACHE_MANAGER", (Object)cacheScriptManager);
        }
        LOG.info((Object)"@@@ cacheScript ... [END]");
        LOG.info((Object)"@@@ AuthUsers ... [START]");
        String auth = conf.getUsers();
        if (auth != null && (auth = auth.trim()).length() > 0) {
            if (!auth.endsWith(CONF)) {
                auth = String.valueOf(auth) + CONF;
            }
            AuthUsersByConfig authUser = new AuthUsersByConfig();
            authUser.open(String.valueOf(path) + auth);
            nm.put("USERS_MANAGER", (Object)authUser);
            LOG.info((Object)"@@@ AuthUsers ... [ByFile]");
        } else {
            auth = conf.getDbUsers();
            if (auth != null && (auth = auth.trim()).length() > 0) {
                if (!auth.endsWith(CONF)) {
                    auth = String.valueOf(auth) + CONF;
                }
                DbAuthUsers dbauth = new DbAuthUsers();
                dbauth.open(String.valueOf(path) + auth);
                AuthUserByDatabase authUser = new AuthUserByDatabase(recordFactory, dbauth.getTable(), dbauth.getUserColumn(), dbauth.getPasswdColumn(), dbauth.getReloadTime());
                nm.put("USERS_MANAGER", (Object)authUser);
                LOG.info((Object)"@@@ AuthUsers ... [ByDB]");
            }
        }
        if (nm.get("USERS_MANAGER") == null) {
            LOG.info((Object)"@@@ AuthUsers ... [NOT]");
        }
        LOG.info((Object)"@@@ AuthUsers ... [END]");
        LOG.info((Object)"@@@ AuthManager ... [START]");
        if (nm.get("USERS_MANAGER") != null) {
            String publicPath = String.valueOf(basePath) + "application/";
            publicPath = String.valueOf(FileUtil.getFullPath((String)publicPath)) + FileUtil.FILE_SPACE;
            HttpdAuthManager authManager = new HttpdAuthManager();
            authManager.create(publicPath);
            nm.put("AUTH_MANAGER", (Object)authManager);
            LOG.info((Object)"@@@ AuthManager ... [END]");
        } else {
            LOG.info((Object)"@@@ AuthManager ... [NOT]");
        }
    }

    public static final void destroy() {
        GlobalManager nm = GlobalManager.getInstance();
        LOG.info((Object)"@@@ (Destroy) mdbm ... [START]");
        MDbmManager.getInstance().close();
        LOG.info((Object)"@@@ (Destroy) mdbm ... [END]");
        LOG.info((Object)"@@@ (Destroy) Record ... [START]");
        RecordFactory recordFactory = (RecordFactory)nm.get("DBMS_POOL");
        if (recordFactory != null) {
            try {
                recordFactory.clear();
            }
            catch (Exception e) {
                LOG.error((Object)"error", (Throwable)e);
            }
        }
        LOG.info((Object)"@@@ (Destroy) Record ... [END]");
    }

    public static final String getPath(String path) throws Exception {
        if (!path.endsWith("\\") && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        path = String.valueOf(FileUtil.getFullPath((String)path)) + FileUtil.FILE_SPACE;
        return path;
    }

    public static final BaseConfig getBaseConfig(String path) throws Exception {
        BaseConfig conf = new BaseConfig();
        conf.open(String.valueOf(path) + "base.conf");
        return conf;
    }

    public static final boolean readConfig(IniFile out, String path, String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            return false;
        }
        if (!name.endsWith(CONF)) {
            name = String.valueOf(name) + CONF;
        }
        out.addOpen(String.valueOf(path) + name);
        return true;
    }

    public static final IniFile getEnhancingConfigs(BaseConfig base, String path) throws Exception {
        int len = base.size();
        IniFile ret = new IniFile();
        int i = 0;
        while (i < len) {
            String name = base.getConfig(i);
            if (name != null && (name = name.trim()).length() > 0) {
                StartupConfig.readConfig(ret, path, name);
            }
            ++i;
        }
        return ret;
    }

    public static final RecordFactory getRecordFactory(boolean mode, IniFile config) throws Exception {
        if (ConvIniParam.getBoolean((String)config.get(RECORD_SECTION, "flag", 0))) {
            boolean debug = ConvIniParam.getBoolean((String)config.get(RECORD_SECTION, "debug", 0));
            String adapter = config.get(RECORD_SECTION, "adapter", 0);
            String driver = config.get(RECORD_SECTION, "driver", 0);
            String url = config.get(RECORD_SECTION, "url", 0);
            String max = config.get(RECORD_SECTION, "max", 0);
            String checksql = config.get(RECORD_SECTION, "checksql", 0);
            String user = config.get(RECORD_SECTION, "user", 0);
            String autoCommit = config.get(RECORD_SECTION, "autoCommit", 0);
            if (mode) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"*** connect database [START]");
                    LOG.info((Object)("debug:" + debug));
                    LOG.info((Object)("adapter:" + adapter));
                    LOG.info((Object)("driver:" + driver));
                    LOG.info((Object)("url:" + url));
                    LOG.info((Object)("max:" + max));
                    LOG.info((Object)("checksql:" + checksql));
                    LOG.info((Object)("user:" + user));
                    LOG.info((Object)("autoCommit:" + autoCommit));
                    LOG.info((Object)"*** connect database [END]");
                }
            } else {
                System.out.println("*** connect database [START]");
                System.out.println("debug:" + debug);
                System.out.println("adapter:" + adapter);
                System.out.println("driver:" + driver);
                System.out.println("url:" + url);
                System.out.println("max:" + max);
                System.out.println("checksql:" + checksql);
                System.out.println("user:" + user);
                System.out.println("autoCommit:" + autoCommit);
                System.out.println("*** connect database [END]");
            }
            InitDao.init((Config)config.getIniParam());
            return DaoSessionFactory.getInstance().getRecordFactory();
        }
        if (mode) {
            LOG.info((Object)"*** RDBMS\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u7121\u52b9\u8a2d\u5b9a\u3067\u3059...");
        } else {
            System.out.println("*** RDBMS\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u7121\u52b9\u8a2d\u5b9a\u3067\u3059...");
        }
        return null;
    }

    public static final void createMDbm(boolean mode, IniFile config) throws Exception {
        String name = config.get(MDBM_SECTION, "directory", 0);
        boolean flag = false;
        if (name == null || (name = name.trim()).length() <= 0) {
            name = MDBM_SECTION;
            flag = false;
        } else {
            flag = ConvIniParam.getBoolean((String)config.get(MDBM_SECTION, "flag", 0));
        }
        MDbmManager.getInstance().open(name);
        if (mode && flag) {
            InetAddress addr = ConvIniParam.getInetAddress((String)config.get(MDBM_SECTION, "bind-addr", 0));
            int port = ConvIniParam.getInt((String)config.get(MDBM_SECTION, "bind-port", 0));
            int max = ConvIniParam.getInt((String)config.get(MDBM_SECTION, "max", 0));
            int pool = ConvIniParam.getInt((String)config.get(MDBM_SECTION, "pool", 0));
            MDbmServer server = new MDbmServer(addr, port, max, pool);
            MDbmManager.getInstance().setServer(server);
        }
    }

    public static final CacheScriptManager getCacheScriptManager(IniFile config) throws Exception {
        CacheScriptManager cman = new CacheScriptManager();
        String[] names = config.getAll("cacheScript", "script");
        if (names != null && names.length > 0) {
            int len = names.length;
            int i = 0;
            while (i < len) {
                String name = names[i];
                if (name != null && (name = name.trim()).length() > 0) {
                    cman.add(name);
                }
                ++i;
            }
        }
        return cman;
    }
}

