/*
 * Decompiled with CFR 0.152.
 */
package jp.common.unitloader;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jp.common.LogPrint;

public class UnitManifest {
    public final String TARGET_UNIT = "Jp-Unit";
    public final String TARGET_UNIT_NAME = "Jp-Unit-Name";
    public final String TARGET_UNIT_GROUP = "Jp-Unit-Group";
    public final String TARGET_UNIT_CLASS_PATH = "Class-Path";
    public final String TARGET_JP_PORT = "Jp-Port";
    public final String filename1 = "MANIFEST.MF";
    public final String filename2 = "manifest.mf";
    private Manifest mfy;

    public UnitManifest() {
    }

    public UnitManifest(String strFile) throws IOException {
        this.setJarManifest(strFile);
    }

    public void setJarManifest(String strFile) throws IOException {
        try {
            JarFile jarFile = new JarFile(strFile);
            this.setJarManifest(jarFile);
        }
        catch (IOException e) {
            LogPrint.setLogPrint("[JarManifest\u53d6\u5f97\u30a8\u30e9\u30fc]file= " + strFile + ":err = " + e, "E");
            throw e;
        }
    }

    public void setJarManifest(JarFile jarFile) throws IOException {
        this.mfy = jarFile.getManifest();
    }

    public Properties getManifestProperties(Class content) {
        Properties props = null;
        JarFile jar = this.getParentJarFile(content);
        if (jar != null) {
            props = this.getJarManifest(jar);
        }
        return props;
    }

    public Properties getManifestProperties(Manifest manifest) {
        Properties props = new Properties();
        Attributes attr = manifest.getMainAttributes();
        for (Object key : attr.keySet()) {
            props.put(key.toString(), attr.get(key).toString());
        }
        return props;
    }

    public Properties getJarManifest(JarFile jarFile) {
        Properties props = null;
        try {
            Manifest mf = jarFile.getManifest();
            if (mf != null) {
                props = this.getManifestProperties(mf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public JarFile getParentJarFile(Class content) {
        JarFile jar = null;
        String className = String.valueOf(content.getName().substring(content.getName().lastIndexOf(46) + 1)) + ".class";
        String jarPath = content.getResource(className).toString();
        if (jarPath.startsWith("jar:file:")) {
            jarPath = jarPath.substring(10, jarPath.lastIndexOf(33));
            try {
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            jarPath = System.getProperty("file.separator").equals("\\") ? jarPath.replaceAll("/", "\\\\") : jarPath.replaceAll("/", System.getProperty("file.separator"));
            try {
                jar = new JarFile(jarPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jar;
    }

    public String getManifestData(String strFile, String strTarget) {
        String strReturn = "";
        try {
            JarFile jarFile = new JarFile(strFile);
            strReturn = this.getManifestData(jarFile, strTarget);
        }
        catch (Exception e) {
            LogPrint.setLogPrint(e.toString(), "E");
        }
        return strReturn;
    }

    public String getManifestData(JarFile jarFile, String strTarget) {
        String strReturn = "";
        try {
            Manifest manifest = jarFile.getManifest();
            strReturn = this.getManifestData(manifest, strTarget);
        }
        catch (Exception e) {
            LogPrint.setLogPrint(e.toString(), "E");
        }
        return strReturn;
    }

    public String getManifestData(Manifest inManifest, String strTarget) {
        this.mfy = inManifest;
        String strReturn = "";
        try {
            Attributes mainAttributes = inManifest.getMainAttributes();
            Set<Object> set = mainAttributes.keySet();
            for (Attributes.Name name : set) {
                String value = mainAttributes.getValue(name);
                if (!name.toString().equals(strTarget)) continue;
                strReturn = value;
            }
        }
        catch (Exception e) {
            LogPrint.setLogPrint(e.toString(), "E");
        }
        return strReturn;
    }

    public String getManifestData(String strTarget) {
        String strReturn = "";
        if (this.mfy != null) {
            try {
                Attributes mainAttributes = this.mfy.getMainAttributes();
                Set<Object> set = mainAttributes.keySet();
                for (Attributes.Name name : set) {
                    String value = mainAttributes.getValue(name);
                    if (!name.toString().equals(strTarget)) continue;
                    strReturn = value;
                }
            }
            catch (Exception e) {
                LogPrint.setLogPrint(e.toString(), "E");
            }
        }
        return strReturn;
    }
}

