/*
 * Decompiled with CFR 0.152.
 */
package jp.common.jpcommand;

import java.util.regex.Pattern;
import jp.common.JpDetailBean;
import jp.common.UnitBaseImpl;
import jp.common.jpcommand.ParsingException;

public class JpPath {
    public static final String DATA_SEPARATOR = "::";
    public static final Pattern PATH_SYNTAX = Pattern.compile("jp(\\.\\w+)+(::\\w+)?;?");
    private boolean is_data;
    private UnitBaseImpl unit;
    private String dataKey;

    protected JpPath(String path) throws ParsingException {
        this(path, false);
    }

    protected JpPath(String path, boolean extract) throws ParsingException {
        if (!PATH_SYNTAX.matcher(path).matches()) {
            throw new ParsingException(path, "\u30b3\u30de\u30f3\u30c9\u306e\u66f8\u5f0f\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (path.indexOf(DATA_SEPARATOR) != -1) {
            String[] str = path.split(DATA_SEPARATOR);
            this.dataKey = str[1];
            this.unit = this.initUnit(str[0], false);
            this.is_data = true;
        } else {
            this.unit = this.initUnit(path, extract);
            this.is_data = false;
        }
    }

    private UnitBaseImpl initUnit(String path, boolean extract) throws ParsingException {
        String[] pathToken = path.split("\\.");
        UnitBaseImpl unitObj = null;
        JpDetailBean JpSystemDetail = null;
        if (pathToken.length > 1 && pathToken[0].equals("jp")) {
            int i = 0;
            while (i < pathToken.length) {
                if (i == 1) {
                    if (pathToken[i].equals("localunit")) {
                        pathToken[i] = JpDetailBean.getlocalunit();
                    }
                    JpSystemDetail = JpDetailBean.getInstance();
                    unitObj = JpSystemDetail.get(pathToken[1]);
                }
                if (i > 1) {
                    UnitBaseImpl u;
                    JpSystemDetail = JpDetailBean.getInstance(unitObj);
                    if (JpSystemDetail == null || (u = JpSystemDetail.get(pathToken[i])) == null) break;
                    unitObj = u;
                }
                ++i;
            }
        }
        if (unitObj == null && !extract) {
            throw new ParsingException(path, "\u5bfe\u8c61\u306e\u30e6\u30cb\u30c3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
        return unitObj;
    }

    public boolean isData() {
        return this.is_data;
    }

    public boolean isUnit() {
        return !this.is_data;
    }

    public boolean isAvailable() {
        return false;
    }

    public Object getDataObject() {
        if (!this.is_data) {
            return null;
        }
        return JpDetailBean.getUnitDetail(this.unit).get(this.dataKey);
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public String geUnitPath() {
        return "jp." + JpDetailBean.getUnitDetail(this.unit).getString("MyJpPath");
    }

    public UnitBaseImpl getUnit() {
        return this.unit;
    }

    protected static JpPath extract(String path) {
        try {
            return new JpPath(path, true);
        }
        catch (ParsingException e) {
            return null;
        }
    }

    public String toString() {
        if (this.is_data) {
            return "jp." + JpDetailBean.getUnitDetail(this.unit).getString("MyJpPath") + DATA_SEPARATOR + this.dataKey;
        }
        return "jp." + JpDetailBean.getUnitDetail(this.unit).getString("MyJpPath");
    }
}

