/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jpmobileutil;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.jpmobileutil.Display;
import jp.sourceforge.jpmobileutil.Mobile;
import jp.sourceforge.jpmobileutil.enums.Carrier;
import jp.sourceforge.jpmobileutil.exception.UnknownMobileException;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.MatchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftBank
extends Mobile {
    private static final int SOFTBANK = 1;
    private static final int SEMULATOR = 2;
    private static final int VODAFONE = 3;
    private static final int VEMULATOR = 4;
    private static final int J_PHONE = 5;
    private static final int J_EMULATOR = 6;
    private static final int MOTOROLA = 7;
    private static final int MOTEMULATOR = 8;
    private static Map<String, Integer> PRIVATE_CARRIERS = new HashMap<String, Integer>();
    private boolean is3G = true;
    private Map<String, String> javaInfo;
    private String msname = "";
    private boolean packetCompliant = false;
    private String serialNumber = null;
    private String vendor = "";
    private String vendorVersion = null;
    private String xJphoneDisplay;
    private String xJphoneColor;
    private String xJphoneMsName;

    static {
        PRIVATE_CARRIERS.put("SoftBank", 1);
        PRIVATE_CARRIERS.put("Semulator", 2);
        PRIVATE_CARRIERS.put("Vodafone", 3);
        PRIVATE_CARRIERS.put("Vemulator", 4);
        PRIVATE_CARRIERS.put("J-PHONE", 5);
        PRIVATE_CARRIERS.put("J-EMULATOR", 6);
        PRIVATE_CARRIERS.put("Motorola", 7);
        PRIVATE_CARRIERS.put("Moteemuator", 8);
    }

    public SoftBank() {
        this.carrier = Carrier.SOFTBANK;
    }

    public Map<String, String> getJavaInfo() {
        return this.javaInfo;
    }

    public String getMsname() {
        return this.msname;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVendorVersion() {
        return this.vendorVersion;
    }

    @Override
    public boolean isJPhone() {
        return this.isSoftBank();
    }

    public boolean isPacketCompliant() {
        return this.packetCompliant;
    }

    @Override
    public boolean isSoftBank() {
        return true;
    }

    public boolean isType3GC() {
        return this.is3G;
    }

    public boolean isTypeC() {
        return !this.is3G && this.matcher.match("/^[32]\\./", this.version);
    }

    public boolean isTypeP() {
        return !this.is3G && this.matcher.match("/^4\\./", this.version);
    }

    public boolean isTypeW() {
        return !this.is3G && this.matcher.match("/^5\\./", this.version);
    }

    @Override
    public boolean isVodafone() {
        return this.isSoftBank();
    }

    @Override
    protected Display makeDisplay() {
        String[] display = StringUtils.split((String)this.xJphoneDisplay, (String)"*");
        int width = Integer.valueOf(display[0]);
        int height = Integer.valueOf(display[1]);
        boolean color = false;
        int depth = 0;
        String colorString = this.xJphoneColor;
        if (StringUtils.isNotEmpty((String)colorString) && this.matcher.match("/^([CG])(\\d+)/", colorString)) {
            MatchResult result = this.matcher.getMatch();
            color = StringUtils.equals((String)result.group(1), (String)"C");
            depth = Integer.valueOf(result.group(2));
        }
        return new Display(width, height, depth, color);
    }

    @Override
    protected void parse() throws UnknownMobileException {
        String[] agent = StringUtils.split((String)this.userAgent, (String)" ");
        this.matcher.match("/^(?:(SOFTBANK|SEMULATOR|VODAFONE|VEMULATOR|J-PHONE|J-EMULATOR)/\\d\\.\\d|MOT-|MOTEMULATOR)/i", agent[0]);
        MatchResult result = this.matcher.getMatch();
        int privateCarrier = result.group(1) != null ? this.getPrivateCarrier(result.group(1)) : this.getPrivateCarrier("Motorola");
        switch (privateCarrier) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.parseVodafone(agent);
                break;
            }
            case 5: 
            case 6: {
                this.parseJphone(agent);
                break;
            }
            case 7: 
            case 8: {
                this.parseMotorola(agent);
                break;
            }
            default: {
                throw new UnknownMobileException();
            }
        }
        this.msname = this.xJphoneMsName;
    }

    private void parseJphone(String[] agent) throws UnknownMobileException {
        int count = agent.length;
        this.is3G = false;
        if (count > 1) {
            String serialNumberString;
            this.packetCompliant = true;
            String[] s = StringUtils.split((String)agent[0], (String)"/");
            this.name = s[0];
            this.version = s[1];
            this.rawModel = s[2];
            String string = serialNumberString = s.length > 3 ? s[3] : null;
            if (StringUtils.isNotEmpty((String)serialNumberString)) {
                if (!this.matcher.match("!^SN(.+)!", serialNumberString)) {
                    throw new UnknownMobileException();
                }
                MatchResult result = this.matcher.getMatch();
                this.serialNumber = result.group(1);
            }
            s = StringUtils.split((String)agent[1], (String)"/");
            this.vendor = s[0];
            this.vendorVersion = s[1];
            int i = 2;
            while (i < count) {
                if (this.javaInfo == null) {
                    this.javaInfo = new HashMap<String, String>();
                }
                s = StringUtils.split((String)agent[i], (String)"/");
                this.javaInfo.put(s[0], s[1]);
                ++i;
            }
        } else {
            MatchResult result;
            String serialNumberString;
            String[] s = StringUtils.split((String)agent[0], (String)"/");
            this.name = s[0];
            this.version = s[1];
            this.rawModel = s[2];
            String string = serialNumberString = s.length > 3 ? s[3] : null;
            if (StringUtils.isNotEmpty((String)serialNumberString)) {
                if (!this.matcher.match("!^SN(.+)!", serialNumberString)) {
                    throw new UnknownMobileException();
                }
                result = this.matcher.getMatch();
                this.serialNumber = result.group(1);
            }
            if (StringUtils.isNotEmpty((String)this.rawModel)) {
                if (this.matcher.match("/V\\d+([A-Z]+)/", this.rawModel)) {
                    result = this.matcher.getMatch();
                    this.vendor = result.group(1);
                } else if (this.matcher.match("/J-([A-Z]+)/", this.rawModel)) {
                    result = this.matcher.getMatch();
                    this.vendor = result.group(1);
                }
            }
        }
    }

    private void parseMotorola(String[] agent) {
        int count = agent.length;
        this.packetCompliant = true;
        this.vendor = "MOT";
        String[] s = StringUtils.split((String)agent[0], (String)"/");
        this.rawModel = s[0];
        this.vendorVersion = s[1];
        this.model = StringUtils.substring((String)StringUtils.substringAfterLast((String)this.rawModel, (String)"-"), (int)1);
        int i = 2;
        while (i < count) {
            if (this.javaInfo == null) {
                this.javaInfo = new HashMap<String, String>();
            }
            s = StringUtils.split((String)agent[i], (String)"/");
            this.javaInfo.put(s[0], s[1]);
            ++i;
        }
    }

    private void parseVodafone(String[] agent) throws UnknownMobileException {
        MatchResult result;
        String serialNumberString;
        int count = agent.length;
        this.packetCompliant = true;
        String[] s = StringUtils.split((String)agent[0], (String)"/");
        this.name = s[0];
        this.version = s[1];
        this.rawModel = s[2];
        String modelVersion = s.length > 3 ? s[3] : null;
        String string = serialNumberString = s.length > 4 ? s[4] : null;
        if (StringUtils.isNotEmpty((String)serialNumberString)) {
            if (!this.matcher.match("/^SN(.+)/", serialNumberString)) {
                throw new UnknownMobileException();
            }
            result = this.matcher.getMatch();
            this.serialNumber = result.group(1);
        }
        if (!this.matcher.match("/^([a-z]+)((?:[a-z]|\\d){4})/i", modelVersion)) {
            throw new UnknownMobileException();
        }
        result = this.matcher.getMatch();
        this.vendor = result.group(1);
        this.vendorVersion = result.group(2);
        int i = 2;
        while (i < count) {
            if (StringUtils.indexOf((String)agent[i], (String)"Nokia") < 0) {
                if (this.javaInfo == null) {
                    this.javaInfo = new HashMap<String, String>();
                }
                s = StringUtils.split((String)agent[i], (String)"/");
                this.javaInfo.put(s[0], s[1]);
            }
            ++i;
        }
    }

    @Override
    protected void setHeaders(HttpServletRequest request) {
        this.xJphoneDisplay = request.getHeader("X-JPHONE-DISPLAY");
        this.xJphoneColor = request.getHeader("X-JPHONE-COLOR");
        this.xJphoneMsName = request.getHeader("X-JPHONE-MSNAME");
        super.setHeaders(request);
    }

    private int getPrivateCarrier(String name) {
        if (PRIVATE_CARRIERS.containsKey(name)) {
            return PRIVATE_CARRIERS.get(name);
        }
        return 0;
    }
}

