/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jpmobileutil;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.jpmobileutil.Au;
import jp.sourceforge.jpmobileutil.DoCoMo;
import jp.sourceforge.jpmobileutil.Mobile;
import jp.sourceforge.jpmobileutil.SoftBank;
import jp.sourceforge.jpmobileutil.UnKnown;
import jp.sourceforge.jpmobileutil.Willcom;
import jp.sourceforge.jpmobileutil.enums.Carrier;
import jp.sourceforge.jpmobileutil.exception.UnknownMobileException;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class JpMobileUtils {
    private static final Logger logger = Logger.getLogger(JpMobileUtils.class);
    private static final Map<Carrier, String> USER_AGENT_REGEX = new HashMap<Carrier, String>();

    static {
        USER_AGENT_REGEX.put(Carrier.DOCOMO, "^DoCoMo\\/\\d\\.\\d[ \\/]?");
        USER_AGENT_REGEX.put(Carrier.SOFTBANK, "^(?:(?:SoftBank|Vodafone|J-PHONE)\\/\\d\\.\\d|MOT-)");
        USER_AGENT_REGEX.put(Carrier.AU, "^(?:KDDI-[A-Z]+\\d+[A-Z]?\\s)?UP\\.Browser\\/");
        USER_AGENT_REGEX.put(Carrier.WILLCOM, "^Mozilla/3\\.0\\((?:DDIPOCKET|WILLCOM);");
    }

    private JpMobileUtils() {
    }

    private static Carrier detectCarrire(String userAgent) {
        for (Map.Entry<Carrier, String> entry : USER_AGENT_REGEX.entrySet()) {
            Pattern p = Pattern.compile(entry.getValue());
            Matcher m = p.matcher(userAgent);
            if (!m.find()) continue;
            return entry.getKey();
        }
        return Carrier.UNKNOWN;
    }

    public static Carrier getCarrier(HttpServletRequest request) {
        return JpMobileUtils.getCarrier(JpMobileUtils.getUserAgent(request));
    }

    public static Carrier getCarrier(String userAgent) {
        return JpMobileUtils.detectCarrire(userAgent);
    }

    public static Mobile getMobile(HttpServletRequest request) throws UnknownMobileException {
        Mobile instance = null;
        switch (JpMobileUtils.detectCarrire(JpMobileUtils.getUserAgent(request))) {
            case DOCOMO: {
                instance = new DoCoMo();
                break;
            }
            case AU: {
                instance = new Au();
                break;
            }
            case SOFTBANK: {
                instance = new SoftBank();
                break;
            }
            case WILLCOM: {
                instance = new Willcom();
                break;
            }
            default: {
                instance = new UnKnown();
            }
        }
        instance.create(request);
        return instance;
    }

    private static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static boolean isAu(String userAgent) {
        Perl5Util matcher = new Perl5Util();
        return matcher.match("/" + USER_AGENT_REGEX.get((Object)Carrier.AU) + "/", userAgent);
    }

    public static boolean isDoCoMo(String userAgent) {
        Perl5Util matcher = new Perl5Util();
        return matcher.match("/" + USER_AGENT_REGEX.get((Object)Carrier.DOCOMO) + "/", userAgent);
    }

    public static boolean isSoftBank(String userAgent) {
        Perl5Util matcher = new Perl5Util();
        return matcher.match("/" + USER_AGENT_REGEX.get((Object)Carrier.SOFTBANK) + "/", userAgent);
    }

    public static boolean isWillcom(String userAgent) {
        Perl5Util matcher = new Perl5Util();
        return matcher.match("/" + USER_AGENT_REGEX.get((Object)Carrier.WILLCOM) + "/", userAgent);
    }
}

