/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jpmobileutil;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.sourceforge.jpmobileutil.Display;
import jp.sourceforge.jpmobileutil.DoCoMoDisplayMap;
import jp.sourceforge.jpmobileutil.Mobile;
import jp.sourceforge.jpmobileutil.enums.Carrier;
import jp.sourceforge.jpmobileutil.exception.UnknownMobileException;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.MatchResult;

public class DoCoMo
extends Mobile {
    private static final int DEFAULT_CACHE_SIZE = 5;
    private static Set<String> GPS_MODELS = new TreeSet<String>();
    private static Map<String, String> HTML_VERSION_MAP = new LinkedHashMap<String, String>();
    private static Map<String, String> XHTML_VERSION_MAP = new LinkedHashMap<String, String>();
    private Integer bandwidth;
    private Integer cacheSize;
    private String cardId;
    private String comment;
    private String displayBytes;
    private boolean foma = false;
    private String htmlVersion;
    private String serialNumber;
    private String status;

    static {
        GPS_MODELS.add("F661i");
        GPS_MODELS.add("F505iGPS");
        HTML_VERSION_MAP.put("[DFNP]501i", "1.0");
        HTML_VERSION_MAP.put("502i|821i|209i|651|691i|(F|N|P|KO)210i|^F671i$", "2.0");
        HTML_VERSION_MAP.put("(D210i|SO210i)|503i|211i|SH251i|692i|200[12]|2101V", "3.0");
        HTML_VERSION_MAP.put("504i|251i|^F671iS|212i|2051|2102V|661i|2701|672i|SO213i|850i", "4.0");
        HTML_VERSION_MAP.put("eggy|P751v", "3.2");
        HTML_VERSION_MAP.put("505i|252i|900i|506i|880i|253i|P213i|901i|700i|^(SH|P)851i|701i|881i|^SA800i|600i|^L601i|^M702i(S|G)|^L602i", "5.0");
        HTML_VERSION_MAP.put("902i|702i|851i|882i|^N601i|^D800iDS|^P703imyu|^P704imyu|^L70[45]i|^F883i$", "6.0");
        HTML_VERSION_MAP.put("903i|703i|904i|704i|883i|801i|^[FD]705i", "7.0");
        HTML_VERSION_MAP.put("905i|705i", "7.1");
        XHTML_VERSION_MAP.put("4.0", "1.0");
        XHTML_VERSION_MAP.put("5.0", "1.1");
        XHTML_VERSION_MAP.put("6.0", "2.0");
        XHTML_VERSION_MAP.put("7.0", "2.1");
        XHTML_VERSION_MAP.put("7.1", "2.2");
    }

    public DoCoMo() {
        this.carrier = Carrier.DOCOMO;
    }

    public Integer getBandwidth() {
        return this.bandwidth;
    }

    public Integer getCacheSize() {
        if (this.cacheSize != null) {
            return this.cacheSize;
        }
        return 5;
    }

    public String getCardId() {
        return this.cardId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getHTMLVersion() {
        if (this.htmlVersion == null) {
            for (Map.Entry<String, String> entry : HTML_VERSION_MAP.entrySet()) {
                if (!this.matcher.match("/" + entry.getKey() + "/", this.rawModel)) continue;
                this.htmlVersion = entry.getValue();
                break;
            }
        }
        return this.htmlVersion;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSeries() {
        if (this.foma && this.matcher.match("/(\\d{4})/", this.rawModel)) {
            return "FOMA";
        }
        if (this.matcher.match("/(\\d{3}i)/", this.rawModel)) {
            MatchResult result = this.matcher.getMatch();
            return result.group(1);
        }
        if (StringUtils.equals((String)"P651ps", (String)this.rawModel)) {
            return "651";
        }
        return null;
    }

    public String getStatus() {
        return this.status;
    }

    public String getVendor() {
        if (this.matcher.match("/([A-Z]+)\\d/", this.rawModel)) {
            MatchResult result = this.matcher.getMatch();
            return result.group(1);
        }
        return null;
    }

    public String getXHTMLVersion() {
        if (!this.isXHTMLCompliant()) {
            return null;
        }
        return XHTML_VERSION_MAP.get(this.getHTMLVersion());
    }

    public boolean isDoCoMo() {
        return true;
    }

    public boolean isFOMA() {
        return this.foma;
    }

    public boolean isGPS() {
        return GPS_MODELS.contains(this.rawModel);
    }

    public boolean isXHTMLCompliant() {
        return this.foma && (!StringUtils.isNotEmpty((String)this.getHTMLVersion()) || !StringUtils.equals((String)"3.0", (String)this.getHTMLVersion()));
    }

    protected Display makeDisplay() {
        Display display = DoCoMoDisplayMap.getInstance().getDisplay(this.getModel());
        if (this.displayBytes != null) {
            String[] s = StringUtils.split((String)this.displayBytes, (String)"*");
            display = new Display(display.getWidth(), display.getHeight(), display.getDepth(), display.isColor(), Integer.valueOf(s[0]), Integer.valueOf(s[1]));
        }
        return display;
    }

    protected void parse() throws UnknownMobileException {
        String fomaOrComment;
        String[] s = StringUtils.split((String)this.userAgent, (String)" ", (int)2);
        String main = s[0];
        String string = fomaOrComment = 2 == s.length ? s[1] : "";
        if (StringUtils.isNotEmpty((String)fomaOrComment) && this.matcher.match("/^\\((.*)\\)$/", fomaOrComment)) {
            MatchResult result = this.matcher.getMatch();
            this.comment = result.group(1);
            this.parseMain(main);
        } else if (StringUtils.isNotEmpty((String)fomaOrComment)) {
            this.foma = true;
            String[] ss = StringUtils.split((String)main, (String)"/");
            this.name = ss[0];
            this.version = ss[1];
            this.parseFOMA(fomaOrComment);
        } else {
            this.parseMain(main);
        }
    }

    private void parseFOMA(String foma) throws UnknownMobileException {
        if (!this.matcher.match("/^([^(\\s]+)/", foma)) {
            throw new UnknownMobileException();
        }
        MatchResult result = this.matcher.getMatch();
        this.rawModel = result.group(1);
        if (StringUtils.equals((String)this.rawModel, (String)"MST_v_SH2101V")) {
            this.model = "SH2101V";
        }
        if (this.matcher.match("/^[^(\\s]+\\s?\\((.*?)\\)$/", foma)) {
            String[] rests;
            result = this.matcher.getMatch();
            String restString = result.group(1);
            if (this.matcher.match("/^compatible/", result.group(1))) {
                this.comment = result.group(1);
                return;
            }
            String[] stringArray = rests = StringUtils.split((String)restString, (String)";");
            int n = rests.length;
            int n2 = 0;
            while (n2 < n) {
                String rest = stringArray[n2];
                if (this.matcher.match("/^c(\\d+)/", rest)) {
                    result = this.matcher.getMatch();
                    this.cacheSize = Integer.valueOf(result.group(1));
                } else if (this.matcher.match("/^ser(\\w{15})/", rest)) {
                    result = this.matcher.getMatch();
                    this.serialNumber = result.group(1);
                } else if (this.matcher.match("/^(T[CDBJ])/", rest)) {
                    result = this.matcher.getMatch();
                    this.status = result.group(1);
                } else if (this.matcher.match("/^icc(\\w{20})?/", rest)) {
                    result = this.matcher.getMatch();
                    if (result.group(1) != null) {
                        this.cardId = result.group(1);
                    }
                } else if (this.matcher.match("/^W(\\d+)H(\\d+)/", rest)) {
                    result = this.matcher.getMatch();
                    this.displayBytes = String.valueOf(result.group(1)) + "*" + result.group(2);
                } else {
                    throw new UnknownMobileException();
                }
                ++n2;
            }
        }
    }

    private void parseMain(String main) throws UnknownMobileException {
        MatchResult result;
        String restString;
        String[] s = StringUtils.split((String)main, (String)"/", (int)5);
        this.name = s[0];
        this.version = s[1];
        this.rawModel = s[2];
        String cacheString = s.length > 3 ? s[3] : "";
        String string = restString = s.length > 4 ? s[4] : "";
        if (StringUtils.equals((String)"SH505i2", (String)this.rawModel)) {
            this.model = "SH505i";
        }
        if (StringUtils.equals((String)"N2701", (String)this.rawModel)) {
            this.foma = true;
        }
        if (StringUtils.isNotEmpty((String)cacheString)) {
            if (!this.matcher.match("/^c(\\d+)$/", cacheString)) {
                throw new UnknownMobileException();
            }
            result = this.matcher.getMatch();
            this.cacheSize = Integer.valueOf(result.group(1));
        }
        if (StringUtils.isNotEmpty((String)restString)) {
            String[] rests;
            String[] stringArray = rests = StringUtils.split((String)restString, (String)"/");
            int n = rests.length;
            int n2 = 0;
            while (n2 < n) {
                String rest = stringArray[n2];
                if (this.matcher.match("/^ser(\\w{11})/", rest)) {
                    result = this.matcher.getMatch();
                    this.serialNumber = result.group(1);
                } else if (this.matcher.match("/^(T[CDBJ])/", rest)) {
                    result = this.matcher.getMatch();
                    this.status = result.group(1);
                } else if (this.matcher.match("/^s(\\d+)/", rest)) {
                    result = this.matcher.getMatch();
                    this.bandwidth = Integer.valueOf(result.group(1));
                } else if (this.matcher.match("/^W(\\d+)H(\\d+)/", rest)) {
                    result = this.matcher.getMatch();
                    this.displayBytes = String.valueOf(result.group(1)) + "*" + result.group(2);
                }
                ++n2;
            }
        }
    }
}

