/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.groupware.model.MTeam;
import jpiere.plugin.groupware.model.MToDo;
import jpiere.plugin.groupware.model.MToDoMemberAdditional;
import jpiere.plugin.groupware.model.MToDoTeam;
import jpiere.plugin.groupware.util.GroupwareTeamUtil;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class CreateToDoFromTeamToDo
extends SvrProcess {
    private int p_JP_ToDo_Team_ID = 0;
    private int p_JP_Team_ID = 0;
    private String p_JP_ToDo_Member_Additional_ID = null;

    protected void prepare() {
        this.p_JP_ToDo_Team_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_Team_ID")) {
                    this.p_JP_Team_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ToDo_Member_Additional_ID")) {
                    this.p_JP_ToDo_Member_Additional_ID = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MToDoTeam teamToDo = new MToDoTeam(this.getCtx(), this.p_JP_ToDo_Team_ID, this.get_TrxName());
        MUser[] users = teamToDo.getAdditionalTeamMemberUser();
        if (this.p_JP_ToDo_Member_Additional_ID != null) {
            String[] additionalUser_IDs = this.p_JP_ToDo_Member_Additional_ID.split(",");
            boolean isAlreadyMember = false;
            int additionalUser_ID = 0;
            int i = 0;
            while (i < additionalUser_IDs.length) {
                isAlreadyMember = false;
                additionalUser_ID = Integer.valueOf(additionalUser_IDs[i]);
                int j = 0;
                while (j < users.length) {
                    if (users[j].getAD_User_ID() == additionalUser_ID) {
                        isAlreadyMember = true;
                        break;
                    }
                    ++j;
                }
                if (!isAlreadyMember) {
                    MToDoMemberAdditional user = new MToDoMemberAdditional(this.getCtx(), 0, this.get_TrxName());
                    user.setAD_Org_ID(teamToDo.getAD_Org_ID());
                    user.setAD_User_ID(additionalUser_ID);
                    user.setJP_ToDo_Team_ID(teamToDo.getJP_ToDo_Team_ID());
                    user.saveEx(this.get_TrxName());
                }
                ++i;
            }
            users = teamToDo.getAdditionalTeamMemberUser(true);
        }
        int JP_Team_ID = teamToDo.getJP_Team_ID();
        if (teamToDo.getJP_Team_ID() != 0) {
            MTeam team = new MTeam(this.getCtx(), JP_Team_ID, this.get_TrxName());
            MUser[] teammember = team.getTeamMemberUser();
            users = GroupwareTeamUtil.addTeamMember(users, teammember);
        }
        if (users.length == 0) {
            if (this.getTable_ID() == 0) {
                return "JP_ToDo_NoUserToCreatePersonalToDo";
            }
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ToDo_NoUserToCreatePersonalToDo"));
        }
        MToDo[] toDoes = teamToDo.getToDoes();
        boolean isAlreadyRegistered = false;
        int created = 0;
        int i = 0;
        while (i < users.length) {
            isAlreadyRegistered = false;
            int j = 0;
            while (j < toDoes.length) {
                if (users[i].getAD_User_ID() == toDoes[j].getAD_User_ID()) {
                    isAlreadyRegistered = true;
                    break;
                }
                ++j;
            }
            if (!isAlreadyRegistered) {
                MToDo newToDo = new MToDo(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)teamToDo, (PO)newToDo);
                newToDo.setAD_Org_ID(teamToDo.getAD_Org_ID());
                newToDo.setJP_ToDo_Team_ID(teamToDo.getJP_ToDo_Team_ID());
                newToDo.setAD_User_ID(users[i].getAD_User_ID());
                newToDo.setJP_ToDo_Status("NY");
                newToDo.setJP_ToDo_StartTime(null);
                newToDo.setJP_ToDo_EndTime(null);
                newToDo.setProcessed(false);
                newToDo.saveEx(this.get_TrxName());
                ++created;
            }
            ++i;
        }
        if (this.getTable_ID() == 0) {
            return "Success";
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Success")) + " " + Msg.getMsg((Properties)this.getCtx(), (String)"Created") + ":" + created;
    }
}

