/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.base;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Properties;
import jpiere.plugin.groupware.model.MToDoTeam;
import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.validator.WindowValidator;
import org.adempiere.webui.adwindow.validator.WindowValidatorEvent;
import org.adempiere.webui.adwindow.validator.WindowValidatorEventType;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class TeamToDoWindowValidator
implements WindowValidator {
    public void onWindowEvent(WindowValidatorEvent event, Callback<Boolean> callback) {
        if (event.getName().equals(WindowValidatorEventType.BEFORE_SAVE.getName())) {
            GridTab gridTab = event.getWindow().getADWindowContent().getActiveGridTab();
            int Record_ID = gridTab.getRecord_ID();
            if (gridTab.getTabNo() == 0 && Record_ID > 0) {
                ArrayList<MToDoTeam> list;
                final MToDoTeam m_ToDo = new MToDoTeam(Env.getCtx(), Record_ID, null);
                Timestamp old_ScheduledStartTime = m_ToDo.getJP_ToDo_ScheduledStartTime();
                Timestamp old_ScheduledEndTime = m_ToDo.getJP_ToDo_ScheduledEndTime();
                GridField gf_JP_ToDo_ScheduledStartDate = gridTab.getField("JP_ToDo_ScheduledStartDate");
                GridField gf_JP_ToDo_ScheduledStartTime = gridTab.getField("JP_ToDo_ScheduledStartTime");
                GridField gf_IsStartDateAllDayJP = gridTab.getField("IsStartDateAllDayJP");
                GridField gf_JP_ToDo_ScheduledEndDate = gridTab.getField("JP_ToDo_ScheduledEndDate");
                GridField gf_JP_ToDo_ScheduledEndTime = gridTab.getField("JP_ToDo_ScheduledEndTime");
                GridField gf_IsEndDateAllDayJP = gridTab.getField("IsEndDateAllDayJP");
                Timestamp new_ScheduledStartDate = (Timestamp)gf_JP_ToDo_ScheduledStartDate.getValue();
                Timestamp new_ScheduledStartTime = (Timestamp)gf_JP_ToDo_ScheduledStartTime.getValue();
                final boolean isStartDateAllDayJP = (Boolean)gf_IsStartDateAllDayJP.getValue();
                new_ScheduledStartTime = isStartDateAllDayJP ? Timestamp.valueOf(LocalDateTime.of(new_ScheduledStartDate.toLocalDateTime().toLocalDate(), LocalTime.MIN)) : Timestamp.valueOf(LocalDateTime.of(new_ScheduledStartDate.toLocalDateTime().toLocalDate(), new_ScheduledStartTime.toLocalDateTime().toLocalTime()));
                Timestamp new_ScheduledEndDate = (Timestamp)gf_JP_ToDo_ScheduledEndDate.getValue();
                Timestamp new_ScheduledEndTime = (Timestamp)gf_JP_ToDo_ScheduledEndTime.getValue();
                final boolean isEndDateAllDayJP = (Boolean)gf_IsEndDateAllDayJP.getValue();
                new_ScheduledEndTime = isEndDateAllDayJP ? Timestamp.valueOf(LocalDateTime.of(new_ScheduledEndDate.toLocalDateTime().toLocalDate(), LocalTime.MIN)) : Timestamp.valueOf(LocalDateTime.of(new_ScheduledEndDate.toLocalDateTime().toLocalDate(), new_ScheduledEndTime.toLocalDateTime().toLocalTime()));
                GridField gf_JP_ToDo_Type = gridTab.getField("JP_ToDo_Type");
                String JP_ToDo_Type = gf_JP_ToDo_Type.getValue().toString();
                if ("T".equals(JP_ToDo_Type)) {
                    new_ScheduledStartTime = new_ScheduledEndTime;
                }
                if ((new_ScheduledStartTime.compareTo(old_ScheduledStartTime) != 0 || new_ScheduledEndTime.compareTo(old_ScheduledEndTime) != 0) && (list = MToDoTeam.getRelatedTeamToDos(Env.getCtx(), m_ToDo, null, old_ScheduledStartTime, true, null)).size() > 0) {
                    final long between_ScheduledStartMins = ChronoUnit.MINUTES.between(old_ScheduledStartTime.toLocalDateTime(), new_ScheduledStartTime.toLocalDateTime());
                    final long between_ScheduledEndMins = ChronoUnit.MINUTES.between(old_ScheduledEndTime.toLocalDateTime(), new_ScheduledEndTime.toLocalDateTime());
                    Callback<Boolean> isRelaredToDoUpdate = new Callback<Boolean>(){

                        public void onCallback(Boolean result) {
                            if (result.booleanValue()) {
                                Timestamp scheduledStartTime = null;
                                Timestamp scheduledEndTime = null;
                                for (MToDoTeam todo : list) {
                                    if (m_ToDo.getJP_ToDo_Team_ID() == todo.getJP_ToDo_Team_ID()) continue;
                                    scheduledStartTime = Timestamp.valueOf(todo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().plusMinutes(between_ScheduledStartMins));
                                    scheduledEndTime = Timestamp.valueOf(todo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().plusMinutes(between_ScheduledEndMins));
                                    todo.setJP_ToDo_ScheduledStartDate(scheduledStartTime);
                                    todo.setJP_ToDo_ScheduledStartTime(scheduledStartTime);
                                    todo.setIsStartDateAllDayJP(isStartDateAllDayJP);
                                    todo.setJP_ToDo_ScheduledEndDate(scheduledEndTime);
                                    todo.setJP_ToDo_ScheduledEndTime(scheduledEndTime);
                                    todo.setIsEndDateAllDayJP(isEndDateAllDayJP);
                                    if (todo.save()) continue;
                                }
                            }
                        }
                    };
                    FDialog.ask((int)gridTab.getWindowNo(), null, (String)"JP_ToDo_Update_CreatedRepeatedly1", (String)Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToDo_Update_CreatedRepeatedly2"), (Callback)isRelaredToDoUpdate);
                }
            }
        } else if (event.getName().equals(WindowValidatorEventType.BEFORE_DELETE.getName())) {
            GridTab gridTab = event.getWindow().getADWindowContent().getActiveGridTab();
            int Record_ID = gridTab.getRecord_ID();
            if (gridTab.getTabNo() == 0 && Record_ID > 0) {
                MToDoTeam m_ToDo = new MToDoTeam(Env.getCtx(), Record_ID, null);
                final ArrayList<MToDoTeam> list = MToDoTeam.getRelatedTeamToDos(Env.getCtx(), m_ToDo, null, m_ToDo.getJP_ToDo_ScheduledStartTime(), true, null);
                if (list.size() > 0) {
                    Callback<Boolean> isRelaredToDoUpdate = new Callback<Boolean>(){

                        public void onCallback(Boolean result) {
                            if (result.booleanValue()) {
                                for (MToDoTeam todo : list) {
                                    if (todo.delete(false)) continue;
                                }
                            }
                        }
                    };
                    FDialog.ask((int)gridTab.getWindowNo(), null, (String)"JP_ToDo_Update_CreatedRepeatedly1", (String)Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ToDo_Delete_CreatedRepeatedly2"), (Callback)isRelaredToDoUpdate);
                }
            }
        }
        callback.onCallback((Object)true);
    }
}

