/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.text.SimpleDateFormat;
import java.util.Properties;
import jpiere.plugin.groupware.form.ReminderMenuPopup;
import jpiere.plugin.groupware.model.I_ToDoReminder;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;

public class ReminderMenuRowRenderer
implements RowRenderer<I_ToDoReminder> {
    private static int reminderType_Reference_ID = 0;
    private static int mailFrequency_Reference_ID = 0;
    private static int broadcastFrequency_Reference_ID = 0;
    private ReminderMenuPopup reminderMenuPopup = null;

    public ReminderMenuRowRenderer(ReminderMenuPopup reminderMenuPopup) {
        this.reminderMenuPopup = reminderMenuPopup;
    }

    public void render(Row row, I_ToDoReminder i_ToDoReminder, int index) throws Exception {
        Cell cell = new Cell();
        Button reminderBtn = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            reminderBtn.setIconSclass("z-icon-Request");
        } else {
            reminderBtn.setImage(ThemeManager.getThemeResource((String)"images/Request16.png"));
        }
        reminderBtn.setClass("btn-small");
        reminderBtn.setName("UPDATE_REMINDER");
        reminderBtn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Reminder"));
        reminderBtn.addEventListener("onClick", (EventListener)this.reminderMenuPopup);
        reminderBtn.setAttribute("I_ToDoReminder", (Object)i_ToDoReminder);
        cell.appendChild((Component)reminderBtn);
        row.appendChild((Component)cell);
        cell = new Cell();
        SimpleDateFormat sdfV = DisplayType.getDateFormat();
        String date = sdfV.format(i_ToDoReminder.getJP_ToDo_RemindTime());
        cell.appendChild((Component)new Label(String.valueOf(date) + " " + i_ToDoReminder.getJP_ToDo_RemindTime().toLocalDateTime().toLocalTime().toString().substring(0, 5)));
        row.appendChild((Component)cell);
        cell = new Cell();
        if (reminderType_Reference_ID == 0) {
            int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"JP_ToDo_ReminderType");
            MColumn col_JP_ToDo_ReminderType = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
            reminderType_Reference_ID = col_JP_ToDo_ReminderType.getAD_Reference_Value_ID();
        }
        String JP_ToDo_ReminderType = MRefList.getListName((Properties)Env.getCtx(), (int)reminderType_Reference_ID, (String)i_ToDoReminder.getJP_ToDo_ReminderType());
        cell.appendChild((Component)new Label(JP_ToDo_ReminderType));
        row.appendChild((Component)cell);
        cell = new Cell();
        if ("M".equals(i_ToDoReminder.getJP_ToDo_ReminderType())) {
            if (mailFrequency_Reference_ID == 0) {
                int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"JP_MailFrequency");
                MColumn col_JP_MailFrequency = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
                mailFrequency_Reference_ID = col_JP_MailFrequency.getAD_Reference_Value_ID();
            }
            String JP_MailFrequency = MRefList.getListName((Properties)Env.getCtx(), (int)mailFrequency_Reference_ID, (String)i_ToDoReminder.getJP_MailFrequency());
            cell.appendChild((Component)new Label(JP_MailFrequency));
        } else {
            if (broadcastFrequency_Reference_ID == 0) {
                int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo_Reminder", (String)"BroadcastFrequency");
                MColumn col_BroadcastFrequency = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
                broadcastFrequency_Reference_ID = col_BroadcastFrequency.getAD_Reference_Value_ID();
            }
            String BroadcastFrequency = MRefList.getListName((Properties)Env.getCtx(), (int)broadcastFrequency_Reference_ID, (String)i_ToDoReminder.getBroadcastFrequency());
            cell.appendChild((Component)new Label(BroadcastFrequency));
        }
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setStyle("text-align:center;");
        Checkbox cb = new Checkbox();
        cb.setChecked(i_ToDoReminder.isSentReminderJP());
        cb.setDisabled(true);
        cell.appendChild((Component)cb);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setStyle("text-align:center;");
        cb = new Checkbox();
        cb.setChecked(i_ToDoReminder.isProcessed());
        cb.setDisabled(true);
        cell.appendChild((Component)cb);
        row.appendChild((Component)cell);
        if ("JP_ToDo_Reminder".equals(i_ToDoReminder.get_TableName())) {
            cell = new Cell();
            cell.setStyle("text-align:center;");
            cb = new Checkbox();
            cb.setChecked(i_ToDoReminder.isConfirmed());
            cb.setDisabled(true);
            cell.appendChild((Component)cb);
            row.appendChild((Component)cell);
        }
    }
}

