/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.MToDo;
import jpiere.plugin.groupware.model.MToDoCategory;
import jpiere.plugin.groupware.model.MToDoMemberAdditional;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import jpiere.plugin.groupware.model.X_JP_ToDo_Team;
import org.compiere.model.MMessage;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MToDoTeam
extends X_JP_ToDo_Team
implements I_ToDo {
    protected MUser[] m_AdditionalTeamMemberUser = null;
    protected MToDoMemberAdditional[] m_AdditionalTeamMember = null;
    protected MToDoTeamReminder[] m_TeamToDoReminders = null;
    protected MToDo[] m_ToDoes = null;

    public MToDoTeam(Properties ctx, int JP_ToDo_Team_ID, String trxName) {
        super(ctx, JP_ToDo_Team_ID, trxName);
    }

    public MToDoTeam(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        String msg = this.beforeSavePreCheck(newRecord);
        if (!Util.isEmpty((String)msg)) {
            this.log.saveError("Error", msg);
            return false;
        }
        if (newRecord || this.is_ValueChanged("JP_ToDo_Status")) {
            if ("NY".equals(this.getJP_ToDo_Status())) {
                this.setJP_ToDo_StartTime(null);
                this.setJP_ToDo_EndTime(null);
                this.setProcessed(false);
            } else if ("WP".equals(this.getJP_ToDo_Status())) {
                if (this.getJP_ToDo_StartTime() == null) {
                    this.setJP_ToDo_StartTime(new Timestamp(System.currentTimeMillis()));
                }
                this.setJP_ToDo_EndTime(null);
                this.setProcessed(false);
            } else if ("CO".equals(this.getJP_ToDo_Status())) {
                if (this.getJP_ToDo_StartTime() == null) {
                    this.setJP_ToDo_StartTime(new Timestamp(System.currentTimeMillis()));
                }
                this.setJP_ToDo_EndTime(new Timestamp(System.currentTimeMillis()));
                this.setProcessed(true);
            }
        }
        return true;
    }

    @Override
    public String beforeSavePreCheck(boolean newRecord) {
        int loginUser;
        if (!newRecord && (loginUser = Env.getAD_User_ID((Properties)this.getCtx())) != this.getAD_User_ID() && loginUser != this.getCreatedBy()) {
            MMessage msg = MMessage.get((Properties)this.getCtx(), (String)"AccessCannotUpdate");
            return String.valueOf(msg.get_Translation("MsgText")) + " - " + msg.get_Translation("MsgTip");
        }
        if (Util.isEmpty((String)this.getJP_ToDo_Type())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_Type")};
            return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
        }
        if (this.getJP_ToDo_Category_ID() != 0 && (newRecord || this.is_ValueChanged("JP_ToDo_Category_ID")) && MToDoCategory.get(this.getCtx(), this.getJP_ToDo_Category_ID()).getAD_User_ID() != 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"JP_Personal_ToDo_Category");
        }
        if (newRecord || this.is_ValueChanged("JP_ToDo_Type") || this.is_ValueChanged("IsStartDateAllDayJP") || this.is_ValueChanged("IsEndDateAllDayJP") || this.is_ValueChanged("JP_ToDo_ScheduledStartDate") || this.is_ValueChanged("JP_ToDo_ScheduledEndDate") || this.is_ValueChanged("JP_ToDo_ScheduledStartTime") || this.is_ValueChanged("JP_ToDo_ScheduledEndTime")) {
            if ("S".equals(this.getJP_ToDo_Type())) {
                if (this.getJP_ToDo_ScheduledStartDate() == null) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledStartDate")};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                LocalDate localStartDate = this.getJP_ToDo_ScheduledStartDate().toLocalDateTime().toLocalDate();
                LocalTime localStartTime = null;
                if (this.isStartDateAllDayJP()) {
                    localStartTime = LocalTime.MIN;
                } else {
                    if (this.getJP_ToDo_ScheduledStartTime() == null) {
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledStartTime")};
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    }
                    localStartTime = this.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalTime();
                }
                this.setJP_ToDo_ScheduledStartTime(Timestamp.valueOf(LocalDateTime.of(localStartDate, localStartTime)));
                this.setJP_ToDo_ScheduledStartDate(this.getJP_ToDo_ScheduledStartTime());
            }
            if ("T".equals(this.getJP_ToDo_Type()) || "S".equals(this.getJP_ToDo_Type())) {
                if (this.getJP_ToDo_ScheduledEndDate() == null) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledEndDate")};
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                }
                LocalDate localEndDate = this.getJP_ToDo_ScheduledEndDate().toLocalDateTime().toLocalDate();
                LocalTime localEndTime = null;
                if (this.isEndDateAllDayJP()) {
                    localEndTime = LocalTime.MIN;
                } else {
                    if (this.getJP_ToDo_ScheduledEndTime() == null) {
                        Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_ScheduledEndTime")};
                        return Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                    }
                    localEndTime = this.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalTime();
                }
                this.setJP_ToDo_ScheduledEndTime(Timestamp.valueOf(LocalDateTime.of(localEndDate, localEndTime)));
                this.setJP_ToDo_ScheduledEndDate(this.getJP_ToDo_ScheduledEndTime());
                if ("S".equals(this.getJP_ToDo_Type())) {
                    if (this.getJP_ToDo_ScheduledStartTime().after(this.getJP_ToDo_ScheduledEndTime())) {
                        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledStartTime")) + " > " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ToDo_ScheduledEndTime");
                    }
                } else if ("T".equals(this.getJP_ToDo_Type())) {
                    this.setJP_ToDo_ScheduledStartDate(this.getJP_ToDo_ScheduledEndDate());
                    this.setJP_ToDo_ScheduledStartTime(this.getJP_ToDo_ScheduledEndTime());
                }
            } else if ("M".equals(this.getJP_ToDo_Type())) {
                this.setJP_ToDo_ScheduledStartDate(null);
                this.setJP_ToDo_ScheduledStartTime(null);
                this.setJP_ToDo_ScheduledEndDate(null);
                this.setJP_ToDo_ScheduledEndTime(null);
            }
        }
        return null;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        block7: {
            MToDoTeamReminder[] reminders;
            block8: {
                if (!newRecord && success) {
                    String sql = "UPDATE JP_ToDo t SET JP_ToDo_Category_ID = ? , JP_ToDo_Type = ?  , Name = ?  , Description = ?  , URL = ?  , JP_ToDo_ScheduledStartDate = ?  , IsStartDateAllDayJP = ?  , JP_ToDo_ScheduledStartTime = ?  , JP_ToDo_ScheduledEndDate = ?  , IsEndDateAllDayJP = ?  , JP_ToDo_ScheduledEndTime = ?  , C_Project_ID = ?  , C_ProjectPhase_ID = ?  , C_ProjectTask_ID = ?  , AD_Org_ID = ?  , IsOpenToDoJP = ? WHERE JP_ToDo_Team_ID= ? ";
                    Object[] para = new Object[]{this.getJP_ToDo_Category_ID() == 0 ? null : Integer.valueOf(this.getJP_ToDo_Category_ID()), this.getJP_ToDo_Type(), this.getName(), this.getDescription(), this.getURL(), this.getJP_ToDo_ScheduledStartDate(), this.isStartDateAllDayJP() ? "Y" : "N", this.getJP_ToDo_ScheduledStartTime(), this.getJP_ToDo_ScheduledEndDate(), this.isEndDateAllDayJP() ? "Y" : "N", this.getJP_ToDo_ScheduledEndTime(), this.getC_Project_ID() == 0 ? null : Integer.valueOf(this.getC_Project_ID()), this.getC_ProjectPhase_ID() == 0 ? null : Integer.valueOf(this.getC_ProjectPhase_ID()), this.getC_ProjectTask_ID() == 0 ? null : Integer.valueOf(this.getC_ProjectTask_ID()), this.getAD_Org_ID(), this.isOpenToDoJP() ? "Y" : "N", this.getJP_ToDo_Team_ID()};
                    DB.executeUpdate((String)sql, (Object[])para, (boolean)false, (String)this.get_TrxName());
                }
                if (!success || newRecord || !this.is_ValueChanged("JP_ToDo_Status")) break block7;
                if (!"CO".equals(this.getJP_ToDo_Status())) break block8;
                reminders = this.getReminders();
                int i = 0;
                while (i < reminders.length) {
                    reminders[i].setProcessed(true);
                    reminders[i].saveEx(this.get_TrxName());
                    ++i;
                }
                MToDo[] todoes = this.getToDoes(true);
                int i2 = 0;
                while (i2 < todoes.length) {
                    todoes[i2].setProcessed(true);
                    todoes[i2].saveEx(this.get_TrxName());
                    ++i2;
                }
                break block7;
            }
            if (!"CO".equals(this.get_ValueOld("JP_ToDo_Status"))) break block7;
            reminders = this.getReminders();
            int i = 0;
            while (i < reminders.length) {
                if (!reminders[i].isSentReminderJP()) {
                    reminders[i].setProcessed(false);
                    reminders[i].saveEx(this.get_TrxName());
                }
                ++i;
            }
            MToDo[] todoes = this.getToDoes(true);
            int i3 = 0;
            while (i3 < todoes.length) {
                if (!"CO".equals(todoes[i3].getJP_ToDo_Status())) {
                    todoes[i3].setProcessed(false);
                    todoes[i3].saveEx(this.get_TrxName());
                }
                ++i3;
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        String msg = this.beforeDeletePreCheck();
        if (!Util.isEmpty((String)msg)) {
            this.log.saveError("Error", msg);
            return false;
        }
        return true;
    }

    @Override
    public String beforeDeletePreCheck() {
        int loginUser = Env.getAD_User_ID((Properties)this.getCtx());
        if (loginUser != this.getAD_User_ID() && loginUser != this.getCreatedBy()) {
            MMessage msg = MMessage.get((Properties)this.getCtx(), (String)"AccessCannotUpdate");
            return String.valueOf(msg.get_Translation("MsgText")) + " - " + msg.get_Translation("MsgTip");
        }
        return null;
    }

    public MUser[] getAdditionalTeamMemberUser() {
        return this.getAdditionalTeamMemberUser(false);
    }

    public MUser[] getAdditionalTeamMemberUser(boolean requery) {
        ArrayList<MUser> list;
        block7: {
            if (this.m_AdditionalTeamMemberUser != null && this.m_AdditionalTeamMemberUser.length >= 0 && !requery) {
                return this.m_AdditionalTeamMemberUser;
            }
            list = new ArrayList<MUser>();
            String sql = "SELECT u.* FROM JP_ToDo_Member_Additional m INNER JOIN AD_User u ON (m.AD_User_ID=u.AD_User_ID) WHERE m.JP_ToDo_Team_ID=? AND m.IsActive='Y' AND u.IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getJP_ToDo_Team_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUser(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_AdditionalTeamMemberUser = list.toArray(new MUser[list.size()]);
        return this.m_AdditionalTeamMemberUser;
    }

    public MToDoMemberAdditional[] getAdditionalTeamMember() {
        return this.getAdditionalTeamMember(false);
    }

    public MToDoMemberAdditional[] getAdditionalTeamMember(boolean requery) {
        if (this.m_AdditionalTeamMember != null && this.m_AdditionalTeamMember.length >= 0 && !requery) {
            return this.m_AdditionalTeamMember;
        }
        StringBuilder whereClauseFinal = new StringBuilder("JP_ToDo_Team_ID =?");
        List list = new Query(this.getCtx(), "JP_ToDo_Member_Additional", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_AdditionalTeamMember = list.toArray(new MToDoMemberAdditional[list.size()]);
        return this.m_AdditionalTeamMember;
    }

    public MToDoTeamReminder[] getReminders() {
        return this.getReminders(false);
    }

    public MToDoTeamReminder[] getReminders(boolean requery) {
        if (this.m_TeamToDoReminders != null && this.m_TeamToDoReminders.length >= 0 && !requery) {
            return this.m_TeamToDoReminders;
        }
        StringBuilder whereClauseFinal = new StringBuilder("JP_ToDo_Team_ID =? AND IsActive = 'Y'");
        List list = new Query(this.getCtx(), "JP_ToDo_Team_Reminder", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_TeamToDoReminders = list.toArray(new MToDoTeamReminder[list.size()]);
        return this.m_TeamToDoReminders;
    }

    public MToDo[] getToDoes() {
        return this.getToDoes(false);
    }

    public MToDo[] getToDoes(boolean requery) {
        if (this.m_ToDoes != null && this.m_ToDoes.length >= 0 && !requery) {
            return this.m_ToDoes;
        }
        StringBuilder whereClauseFinal = new StringBuilder("JP_ToDo_Team_ID =?");
        List list = new Query(this.getCtx(), "JP_ToDo", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_ToDoes = list.toArray(new MToDo[list.size()]);
        return this.m_ToDoes;
    }

    public static ArrayList<MToDoTeam> getRelatedTeamToDos(Properties ctx, MToDoTeam m_TeamToDo, ArrayList<MToDoTeam> list_ToDoTeam, Timestamp time, boolean isIncludingIndirectRelationships, String trxName) {
        if (list_ToDoTeam == null) {
            list_ToDoTeam = new ArrayList();
        }
        StringBuilder whereClauseFinal = null;
        String orderClause = "JP_ToDo_ScheduledStartTime";
        List list = null;
        if (m_TeamToDo.getJP_Processing3().equals("N")) {
            whereClauseFinal = new StringBuilder(" JP_ToDo_Team_Related_ID =? AND JP_ToDo_Team_ID <> ?");
            if (time == null) {
                list = new Query(ctx, "JP_ToDo_Team", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_TeamToDo.getJP_ToDo_Team_Related_ID(), m_TeamToDo.getJP_ToDo_Team_ID()}).setOrderBy(orderClause).list();
            } else {
                whereClauseFinal = whereClauseFinal.append(" AND JP_ToDo_ScheduledStartTime >= ?");
                list = new Query(ctx, "JP_ToDo_Team", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_TeamToDo.getJP_ToDo_Team_Related_ID(), m_TeamToDo.getJP_ToDo_Team_ID(), time}).setOrderBy(orderClause).list();
            }
        } else {
            whereClauseFinal = new StringBuilder(" (JP_ToDo_Team_Related_ID =? OR JP_ToDo_Team_Related_ID =?) AND JP_ToDo_Team_ID <> ?");
            if (time == null) {
                list = new Query(ctx, "JP_ToDo_Team", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_TeamToDo.getJP_ToDo_Team_Related_ID(), m_TeamToDo.getJP_ToDo_Team_ID(), m_TeamToDo.getJP_ToDo_Team_ID()}).setOrderBy(orderClause).list();
            } else {
                whereClauseFinal = whereClauseFinal.append(" AND JP_ToDo_ScheduledStartTime >= ?");
                list = new Query(ctx, "JP_ToDo_Team", whereClauseFinal.toString(), trxName).setParameters(new Object[]{m_TeamToDo.getJP_ToDo_Team_Related_ID(), m_TeamToDo.getJP_ToDo_Team_ID(), m_TeamToDo.getJP_ToDo_Team_ID(), time}).setOrderBy(orderClause).list();
            }
        }
        boolean isContained = false;
        for (MToDoTeam teamToDo : list) {
            isContained = false;
            for (MToDoTeam td : list_ToDoTeam) {
                if (teamToDo.getJP_ToDo_Team_ID() != td.getJP_ToDo_Team_ID()) continue;
                isContained = true;
            }
            if (isContained) continue;
            list_ToDoTeam.add(teamToDo);
            if (!isIncludingIndirectRelationships || !teamToDo.getJP_Processing3().equals("Y")) continue;
            list_ToDoTeam = MToDoTeam.getRelatedTeamToDos(ctx, teamToDo, list_ToDoTeam, time, true, trxName);
        }
        return list_ToDoTeam;
    }

    @Override
    public int getParent_Team_ToDo_ID() {
        return 0;
    }

    @Override
    public void setComments(String Comments) {
    }

    @Override
    public void setJP_Statistics_YesNo(String JP_Statistics_YesNo) {
    }

    @Override
    public void setJP_Statistics_Choice(String JP_Statistics_Choice) {
    }

    @Override
    public void setJP_Statistics_DateAndTime(Timestamp JP_Statistics_DateAndTime) {
    }

    @Override
    public void setJP_Statistics_Number(BigDecimal JP_Statistics_Number) {
    }

    @Override
    public String getJP_Statistics_YesNo() {
        return null;
    }

    @Override
    public String getJP_Statistics_Choice() {
        return null;
    }

    @Override
    public Timestamp getJP_Statistics_DateAndTime() {
        return null;
    }

    @Override
    public BigDecimal getJP_Statistics_Number() {
        return null;
    }

    @Override
    public String getComments() {
        return null;
    }

    @Override
    public void setUpdated(Timestamp updated) {
        this.set_ValueNoCheck("Updated", updated);
    }

    @Override
    public boolean isCreatedToDoRepeatedly() {
        return this.getJP_Processing3().equals("Y");
    }

    @Override
    public void setisCreatedToDoRepeatedly(boolean Processed) {
        this.setJP_Processing3(Processed ? "Y" : "N");
    }

    @Override
    public int getRelated_ToDo_ID() {
        return this.getJP_ToDo_Team_Related_ID();
    }
}

