/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.window;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import jpiere.plugin.groupware.model.MToDoTeam;
import jpiere.plugin.groupware.window.PersonalToDoListWindow;
import jpiere.plugin.groupware.window.PersonalToDoModel;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;

public class PersonalToDoListRowRenderer
implements RowRenderer<PersonalToDoModel> {
    private PersonalToDoListWindow personalToDoListWindow = null;
    private Radiogroup radioGroup = null;
    private MToDoTeam m_TeamToDo = null;

    public PersonalToDoListRowRenderer(PersonalToDoListWindow personalToDoListWindow, Radiogroup radioGroup) {
        this.personalToDoListWindow = personalToDoListWindow;
        this.m_TeamToDo = personalToDoListWindow.getMToDoTeam();
        this.radioGroup = radioGroup;
    }

    public void render(Row row, PersonalToDoModel data, int index) throws Exception {
        this.personalToDoListWindow.setJP_ToDo_ID(0);
        Cell cell = new Cell();
        Radio radio = new Radio();
        radio.setRadiogroup(this.radioGroup);
        radio.setAttribute("JP_ToDo_ID", (Object)data.JP_ToDo_ID);
        radio.addEventListener("onCheck", (EventListener)this.personalToDoListWindow);
        cell.appendChild((Component)radio);
        row.appendChild((Component)cell);
        cell = new Cell();
        Button reminderBtn = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            reminderBtn.setIconSclass("z-icon-Request");
        } else {
            reminderBtn.setImage(ThemeManager.getThemeResource((String)"images/Request16.png"));
        }
        reminderBtn.setClass("btn-small");
        reminderBtn.setName("REMINDER");
        reminderBtn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Reminder"));
        reminderBtn.addEventListener("onClick", (EventListener)this.personalToDoListWindow);
        reminderBtn.setAttribute("JP_ToDo_ID", (Object)data.JP_ToDo_ID);
        cell.appendChild((Component)reminderBtn);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.appendChild((Component)new Label(data.user));
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.appendChild((Component)new Label(data.status));
        row.appendChild((Component)cell);
        if (!"NO".equals(this.m_TeamToDo.getJP_Mandatory_Statistics_Info())) {
            cell = new Cell();
            if ("YN".equals(this.m_TeamToDo.getJP_Mandatory_Statistics_Info())) {
                if (Util.isEmpty((String)data.JP_Statistics_YesNo)) {
                    cell.appendChild((Component)new Label(""));
                } else {
                    int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo", (String)"JP_Statistics_YesNo");
                    MColumn column = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
                    int reference_ID = column.getAD_Reference_Value_ID();
                    String statistics_info = MRefList.getListName((Properties)Env.getCtx(), (int)reference_ID, (String)data.JP_Statistics_YesNo);
                    cell.appendChild((Component)new Label(statistics_info));
                }
            } else if ("CC".equals(this.m_TeamToDo.getJP_Mandatory_Statistics_Info())) {
                if (Util.isEmpty((String)data.JP_Statistics_Choice)) {
                    cell.appendChild((Component)new Label(""));
                } else {
                    int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo", (String)"JP_Statistics_Choice");
                    MColumn column = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
                    int reference_ID = column.getAD_Reference_Value_ID();
                    String statistics_info = MRefList.getListName((Properties)Env.getCtx(), (int)reference_ID, (String)data.JP_Statistics_Choice);
                    cell.appendChild((Component)new Label(statistics_info));
                }
            } else if ("DT".equals(this.m_TeamToDo.getJP_Mandatory_Statistics_Info())) {
                if (data.JP_Statistics_DateAndTime != null) {
                    SimpleDateFormat sdfV = DisplayType.getDateFormat();
                    Date dateAndTime = new Date(data.JP_Statistics_DateAndTime.getTime());
                    String string_Date = sdfV.format(dateAndTime);
                    String string_Time = data.JP_Statistics_DateAndTime.toLocalDateTime().toLocalTime().toString();
                    cell.appendChild((Component)new Label(String.valueOf(string_Date) + " " + string_Time));
                }
            } else if ("NM".equals(this.m_TeamToDo.getJP_Mandatory_Statistics_Info()) && data.JP_Statistics_Number != null) {
                cell.appendChild((Component)new Label(data.JP_Statistics_Number.toString()));
            }
            row.appendChild((Component)cell);
        }
        cell = new Cell();
        cell.appendChild((Component)new Label(data.comments));
        row.appendChild((Component)cell);
    }
}

