/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.groupware.model.MGroupwareUser;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Layout;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Vlayout;

public class GroupwareMenuGadgetFlat
extends DashboardPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 8398216266900311289L;
    private static final String NODE_ID = "Node_ID";
    private Layout vLayout_ToDoMenu;
    private Map<Integer, MTreeNode> nodeMap;
    private MTreeNode rootNode;

    public GroupwareMenuGadgetFlat() {
        this.init();
        Panel panel = new Panel();
        this.appendChild((Component)panel);
        Panelchildren toDoMenuContent = new Panelchildren();
        panel.appendChild((Component)toDoMenuContent);
        this.vLayout_ToDoMenu = new Vlayout();
        this.setSclass("favourites-box");
        toDoMenuContent.appendChild((Component)this.vLayout_ToDoMenu);
        this.createToDoMenuPanel();
    }

    private void init() {
        this.nodeMap = new LinkedHashMap<Integer, MTreeNode>();
        MGroupwareUser gUser = MGroupwareUser.get(Env.getCtx(), Env.getAD_User_ID((Properties)Env.getCtx()));
        int AD_Tree_ID = 0;
        AD_Tree_ID = gUser != null ? MGroupwareUser.get(Env.getCtx(), Env.getAD_User_ID((Properties)Env.getCtx())).getAD_Tree_Menu_ID() : 0;
        if (AD_Tree_ID == 0) {
            return;
        }
        MTree vTree = new MTree(Env.getCtx(), AD_Tree_ID, false, true, false, null);
        this.rootNode = vTree.getRoot();
        Enumeration enTop = this.rootNode.children();
        while (enTop.hasMoreElements()) {
            MTreeNode ndTop = (MTreeNode)enTop.nextElement();
            Enumeration en = ndTop.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)en.nextElement();
                if (nd.isSummary()) continue;
                this.nodeMap.put(nd.getNode_ID(), nd);
            }
        }
    }

    private void createToDoMenuPanel() {
        ArrayList<MTreeNode> list = new ArrayList<MTreeNode>();
        for (int key : this.nodeMap.keySet()) {
            list.add(this.nodeMap.get(key));
        }
        this.setSclass("views-box");
        Grid grid = GridFactory.newGridLayout();
        grid.setMold("paging");
        grid.setPageSize(20);
        grid.setPagingPosition("top");
        this.vLayout_ToDoMenu.appendChild((Component)grid);
        Rows gridRows = grid.newRows();
        for (MTreeNode node : list) {
            Row row = gridRows.newRow();
            ToolBarButton btn = new ToolBarButton(node.toString().trim());
            btn.setSclass("link");
            btn.setLabel(node.toString().trim());
            if (ThemeManager.isUseFontIconForImage()) {
                btn.setIconSclass(this.getIconFile(node));
            } else {
                btn.setImage(ThemeManager.getThemeResource((String)this.getIconFile(node)));
            }
            btn.addEventListener("onClick", (EventListener)this);
            int node_ID = node.getNode_ID();
            btn.setAttribute(NODE_ID, (Object)String.valueOf(node_ID));
            row.appendChild((Component)btn);
        }
    }

    public void onEvent(Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            this.doOnClick(comp);
        }
    }

    private void doOnClick(Component comp) {
        if (comp instanceof Toolbarbutton) {
            Toolbarbutton btn = (Toolbarbutton)comp;
            int menuId = 0;
            try {
                menuId = Integer.valueOf((String)btn.getAttribute(NODE_ID));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (menuId > 0) {
                SessionManager.getAppDesktop().onMenuSelected(menuId);
            }
        }
    }

    private String getIconFile(MTreeNode mt) {
        if (ThemeManager.isUseFontIconForImage()) {
            return this.getIconSclass(mt);
        }
        if (mt.isWindow()) {
            return "images/mWindow.png";
        }
        if (mt.isReport()) {
            return "images/mReport.png";
        }
        if (mt.isProcess() || mt.isTask()) {
            return "images/mProcess.png";
        }
        if (mt.isWorkFlow()) {
            return "images/mWorkFlow.png";
        }
        if (mt.isForm()) {
            return "images/mForm.png";
        }
        if (mt.isInfo()) {
            return "images/mInfo.png";
        }
        return "images/mWindow.png";
    }

    private String getIconSclass(MTreeNode mt) {
        if (mt.isWindow()) {
            return "z-icon-Window";
        }
        if (mt.isReport()) {
            return "z-icon-Report";
        }
        if (mt.isProcess() || mt.isTask()) {
            return "z-icon-Task";
        }
        if (mt.isWorkFlow()) {
            return "z-icon-WorkFlow";
        }
        if (mt.isForm()) {
            return "z-icon-Form";
        }
        if (mt.isInfo()) {
            return "z-icon-Info";
        }
        return "z-icon-Window";
    }
}

