/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jpiere.plugin.groupware.form.CalendarEventPopup;
import jpiere.plugin.groupware.form.I_ToDoCalendarGadget;
import jpiere.plugin.groupware.form.ToDoCalendar;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.MGroupwareUser;
import jpiere.plugin.groupware.model.MToDo;
import jpiere.plugin.groupware.model.MToDoTeam;
import jpiere.plugin.groupware.util.GroupwareToDoUtil;
import jpiere.plugin.groupware.window.I_ToDoCalendarEventReceiver;
import jpiere.plugin.groupware.window.I_ToDoPopupwindowCaller;
import jpiere.plugin.groupware.window.ToDoPopupWindow;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MForm;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;

public class ToDoGadget
extends DashboardPanel
implements I_ToDoCalendarGadget,
I_ToDoPopupwindowCaller,
I_ToDoCalendarEventReceiver,
EventListener<Event>,
ValueChangeListener {
    private Properties ctx = Env.getCtx();
    private String p_JP_ToDo_Calendar = "P";
    private int p_AD_User_ID = 0;
    private int login_User_ID = 0;
    private String p_JP_ToDo_Type = "T";
    private LocalDateTime p_LocalDateTime = null;
    private Timestamp today = null;
    private Language lang = Env.getLanguage((Properties)Env.getCtx());
    private WDateEditor editor_Date = null;
    private static final String EDITOR_DATE = "DATE";
    private WNumberEditor editor_Days = null;
    private int p_Days = 5;
    private static final String EDITOR_DAYS = "DAYS";
    private List<I_ToDo> list_ToDoes = null;
    private boolean isDashboardGadget = false;
    private Div headerArea = new Div();
    private Div messageArea = new Div();
    private Div contentsArea = new Div();
    private Div footerArea = new Div();
    private MGroupwareUser p_GroupwareUser = null;
    private boolean p_IsToDoMouseoverPopup = true;
    private CalendarEventPopup popup_CalendarEvent = new CalendarEventPopup();
    private static final String BUTTON_NAME_PREVIOUS_DAY = "PREVIOUSDAY";
    private static final String BUTTON_NAME_NEXT_DAY = "NEXTDAY";
    private static final String BUTTON_NAME_NEW_TODO = "NEW";
    private static final String BUTTON_NAME_REFRESH = "REFRESH";
    private static final String BUTTON_NAME_CALENDER = "CALENDER";
    private String team = "[" + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_Team_ID") + "] ";
    I_ToDoPopupwindowCaller i_ToDoPopupwindowCaller;
    private List<I_ToDoCalendarEventReceiver> list_ToDoCalendarEventReceiver = new ArrayList<I_ToDoCalendarEventReceiver>();
    int p_Delete_ToDo_ID = 0;

    public ToDoGadget() {
        this.p_GroupwareUser = MGroupwareUser.get(this.ctx, Env.getAD_User_ID((Properties)this.ctx));
        if (this.p_GroupwareUser != null) {
            if (!Util.isEmpty((String)this.p_GroupwareUser.getJP_ToDo_Type())) {
                this.init(this.p_GroupwareUser.getJP_ToDo_Type(), this.p_GroupwareUser.getJP_ToDo_Calendar(), true);
            }
            this.p_IsToDoMouseoverPopup = this.p_GroupwareUser.isToDoMouseoverPopupJP();
        } else {
            this.init("T", "P", true);
        }
    }

    public ToDoGadget(String JP_ToDo_Type, String JP_ToDo_Calendar) {
        this.p_GroupwareUser = MGroupwareUser.get(this.ctx, Env.getAD_User_ID((Properties)this.ctx));
        if (this.p_GroupwareUser != null) {
            this.p_IsToDoMouseoverPopup = this.p_GroupwareUser.isToDoMouseoverPopupJP();
        }
        this.init(JP_ToDo_Type, JP_ToDo_Calendar, false);
    }

    public void setIsToDoMouseoverPopup(boolean IsToDoMouseoverPopup) {
        this.p_IsToDoMouseoverPopup = IsToDoMouseoverPopup;
    }

    public void init(String JP_ToDo_Type, String JP_ToDo_Calendar, Boolean isDashboardGadget) {
        this.isDashboardGadget = isDashboardGadget;
        this.p_JP_ToDo_Calendar = JP_ToDo_Calendar;
        this.setSclass("views-box");
        this.p_JP_ToDo_Type = JP_ToDo_Type;
        this.login_User_ID = this.p_AD_User_ID = Env.getAD_User_ID((Properties)this.ctx);
        this.p_LocalDateTime = LocalDateTime.of(LocalDateTime.now().toLocalDate(), LocalTime.MIN);
        this.editor_Date = new WDateEditor(EDITOR_DATE, false, false, true, "");
        this.editor_Date.setValue((Object)Timestamp.valueOf(this.p_LocalDateTime));
        this.editor_Date.addValueChangeListener((ValueChangeListener)this);
        this.editor_Days = new WNumberEditor(EDITOR_DAYS, true, false, true, 11, "");
        this.editor_Days.setValue((Object)this.p_Days);
        this.editor_Days.addValueChangeListener((ValueChangeListener)this);
        this.today = Timestamp.valueOf(LocalDateTime.of(LocalDateTime.now().toLocalDate(), LocalTime.MIN));
        this.createHeader();
        this.createMessage();
        this.createContents();
        this.appendChild((Component)this.headerArea);
        this.appendChild((Component)this.messageArea);
        this.appendChild((Component)this.contentsArea);
        this.appendChild((Component)this.footerArea);
    }

    private void createHeader() {
        if (!this.isDashboardGadget) {
            return;
        }
        Grid grid = GridFactory.newGridLayout();
        this.headerArea.appendChild((Component)grid);
        Rows gridRows = grid.newRows();
        Row row = gridRows.newRow();
        MLookup lookup_JP_ToDo_Calendar = MLookupFactory.get((Properties)this.ctx, (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_GroupwareUser", (String)"JP_ToDo_Calendar"), (int)17);
        WTableDirEditor editor_JP_ToDo_Calendar = new WTableDirEditor("JP_ToDo_Calendar", true, false, true, (Lookup)lookup_JP_ToDo_Calendar);
        editor_JP_ToDo_Calendar.setValue((Object)this.p_JP_ToDo_Calendar);
        editor_JP_ToDo_Calendar.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)editor_JP_ToDo_Calendar.getComponent(), (String)"true");
        Label label_JP_ToDo_Calendar = new Label(Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Calendar"));
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv((WEditor)editor_JP_ToDo_Calendar, label_JP_ToDo_Calendar, false), 1);
        row.appendCellChild((Component)editor_JP_ToDo_Calendar.getComponent(), 1);
        row = gridRows.newRow();
        MLookup lookupUser = MLookupFactory.get((Properties)this.ctx, (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo", (String)"AD_User_ID"), (int)30);
        WSearchEditor userSearchEditor = new WSearchEditor("AD_User_ID", true, false, true, (Lookup)lookupUser);
        userSearchEditor.setValue((Object)this.p_AD_User_ID);
        userSearchEditor.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)userSearchEditor.getComponent(), (String)"true");
        Label label_User = new Label(Msg.translate((Properties)this.ctx, (String)"AD_User_ID"));
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv((WEditor)userSearchEditor, label_User, false), 1);
        row.appendCellChild((Component)userSearchEditor.getComponent(), 1);
        MLookup lookupToDoType = MLookupFactory.get((Properties)this.ctx, (int)0, (int)0, (int)MColumn.getColumn_ID((String)"JP_ToDo", (String)"JP_ToDo_Type"), (int)17);
        WTableDirEditor toDoListEditor = new WTableDirEditor("JP_ToDo_Type", true, false, true, (Lookup)lookupToDoType);
        toDoListEditor.setValue((Object)this.p_JP_ToDo_Type);
        toDoListEditor.addValueChangeListener((ValueChangeListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)toDoListEditor.getComponent(), (String)"true");
        Label label_ToDoType = new Label(Msg.translate((Properties)this.ctx, (String)"JP_ToDo_Type"));
        row.appendCellChild((Component)GroupwareToDoUtil.createLabelDiv((WEditor)toDoListEditor, label_ToDoType, false), 1);
        row.appendCellChild((Component)toDoListEditor.getComponent(), 1);
    }

    private void createMessage() {
        WStringEditor editor_Text;
        if (this.messageArea.getFirstChild() != null) {
            this.messageArea.getFirstChild().detach();
        }
        if (!this.isDashboardGadget && ("T".equals(this.p_JP_ToDo_Type) || "M".equals(this.p_JP_ToDo_Type))) {
            return;
        }
        Hlayout hlayout = new Hlayout();
        this.messageArea.appendChild((Component)hlayout);
        hlayout.appendChild((Component)GroupwareToDoUtil.getDividingLine());
        if (this.p_AD_User_ID == 0) {
            editor_Text = new WStringEditor();
            editor_Text.setReadWrite(false);
            editor_Text.setValue((Object)(String.valueOf(Msg.getMsg((Properties)this.ctx, (String)"enter")) + ":" + Msg.getElement((Properties)this.ctx, (String)"AD_User_ID")));
            hlayout.appendChild((Component)editor_Text.getComponent());
        } else if ("T".equals(this.p_JP_ToDo_Type)) {
            editor_Text = new WStringEditor();
            editor_Text.setReadWrite(false);
            editor_Text.setValue((Object)Msg.getMsg((Properties)this.ctx, (String)"JP_UnfinishedTasks"));
            hlayout.appendChild((Component)editor_Text.getComponent());
        } else if ("S".equals(this.p_JP_ToDo_Type)) {
            Button leftBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                leftBtn.setIconSclass("z-icon-MoveLeft");
            } else {
                leftBtn.setImage(ThemeManager.getThemeResource((String)"images/MoveLeft16.png"));
            }
            leftBtn.setClass("btn-small");
            leftBtn.setName(BUTTON_NAME_PREVIOUS_DAY);
            leftBtn.addEventListener("onClick", (EventListener)this);
            hlayout.appendChild((Component)leftBtn);
            this.editor_Date.setValue((Object)Timestamp.valueOf(this.p_LocalDateTime));
            hlayout.appendChild((Component)this.editor_Date.getComponent());
            hlayout.appendChild((Component)GroupwareToDoUtil.createLabelDiv(null, " - ", true));
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.editor_Days.getComponent(), (String)"50px");
            hlayout.appendChild((Component)this.editor_Days.getComponent());
            hlayout.appendChild((Component)GroupwareToDoUtil.createLabelDiv(null, Msg.getMsg((Properties)this.ctx, (String)"JP_Days"), true));
            Button rightBtn = new Button();
            if (ThemeManager.isUseFontIconForImage()) {
                rightBtn.setIconSclass("z-icon-MoveRight");
            } else {
                rightBtn.setImage(ThemeManager.getThemeResource((String)"images/MoveRight16.png"));
            }
            rightBtn.setClass("btn-small");
            rightBtn.addEventListener("onClick", (EventListener)this);
            rightBtn.setName(BUTTON_NAME_NEXT_DAY);
            hlayout.appendChild((Component)rightBtn);
        } else if ("M".equals(this.p_JP_ToDo_Type)) {
            editor_Text = new WStringEditor();
            editor_Text.setReadWrite(false);
            editor_Text.setValue((Object)Msg.getMsg((Properties)this.ctx, (String)"JP_UnfinishedMemo"));
            hlayout.appendChild((Component)editor_Text.getComponent());
        } else {
            editor_Text = new WStringEditor();
            editor_Text.setReadWrite(false);
            editor_Text.setValue((Object)(String.valueOf(Msg.getMsg((Properties)this.ctx, (String)"enter")) + ":" + Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Type")));
            hlayout.appendChild((Component)editor_Text.getComponent());
        }
        hlayout.appendChild((Component)GroupwareToDoUtil.getDividingLine());
        if (!this.isDashboardGadget) {
            return;
        }
        Button createNewToDo = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            createNewToDo.setIconSclass("z-icon-New");
        } else {
            createNewToDo.setImage(ThemeManager.getThemeResource((String)"images/New16.png"));
        }
        createNewToDo.setClass("btn-small");
        createNewToDo.setName(BUTTON_NAME_NEW_TODO);
        createNewToDo.addEventListener("onClick", (EventListener)this);
        createNewToDo.setId(String.valueOf(0));
        hlayout.appendChild((Component)createNewToDo);
        Button refresh = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            refresh.setIconSclass("z-icon-Refresh");
        } else {
            refresh.setImage(ThemeManager.getThemeResource((String)"images/Refresh16.png"));
        }
        refresh.setClass("btn-small");
        refresh.setName(BUTTON_NAME_REFRESH);
        refresh.addEventListener("onClick", (EventListener)this);
        hlayout.appendChild((Component)refresh);
        Button calander = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            calander.setIconSclass("z-icon-Calendar");
        } else {
            calander.setImage(ThemeManager.getThemeResource((String)"images/Calendar16.png"));
        }
        calander.setClass("btn-small");
        calander.setName(BUTTON_NAME_CALENDER);
        calander.addEventListener("onClick", (EventListener)this);
        hlayout.appendChild((Component)calander);
        hlayout.appendChild((Component)GroupwareToDoUtil.getDividingLine());
    }

    public void createContents() {
        if (this.contentsArea.getFirstChild() != null) {
            this.contentsArea.getFirstChild().detach();
        }
        StringBuilder whereClause = null;
        StringBuilder orderClause = null;
        ArrayList<Object> list_parameters = new ArrayList<Object>();
        Object[] parameters = null;
        if ("T".equals(this.p_JP_ToDo_Type) || "M".equals(this.p_JP_ToDo_Type)) {
            whereClause = new StringBuilder(" AD_Client_ID =? AND AD_User_ID = ? AND JP_ToDo_Type = ? AND IsActive='Y' AND JP_ToDo_Status <> ?");
            orderClause = new StringBuilder("JP_ToDo_ScheduledEndTime");
            list_parameters.add(Env.getAD_Client_ID((Properties)this.ctx));
            list_parameters.add(this.p_AD_User_ID);
            list_parameters.add(this.p_JP_ToDo_Type);
            list_parameters.add("CO");
        } else if ("S".equals(this.p_JP_ToDo_Type)) {
            whereClause = new StringBuilder(" AD_Client_ID =? AND AD_User_ID = ? AND JP_ToDo_Type = ? AND IsActive='Y' AND JP_ToDo_ScheduledStartTime < ? AND JP_ToDo_ScheduledEndTime >= ?");
            orderClause = new StringBuilder("JP_ToDo_ScheduledStartTime");
            LocalDateTime toDayMin = LocalDateTime.of(this.p_LocalDateTime.toLocalDate(), LocalTime.MIN);
            LocalDateTime toDayMax = LocalDateTime.of(this.p_LocalDateTime.toLocalDate().plusDays(this.p_Days), LocalTime.MAX);
            list_parameters.add(Env.getAD_Client_ID((Properties)this.ctx));
            list_parameters.add(this.p_AD_User_ID);
            list_parameters.add(this.p_JP_ToDo_Type);
            list_parameters.add(Timestamp.valueOf(toDayMax));
            list_parameters.add(Timestamp.valueOf(toDayMin));
        } else {
            whereClause = new StringBuilder(" AD_Client_ID =? AND AD_User_ID = ? ");
            orderClause = new StringBuilder("JP_ToDo_ScheduledEndTime");
            list_parameters.add(Env.getAD_Client_ID((Properties)this.ctx));
            list_parameters.add(this.p_AD_User_ID);
        }
        if (this.p_Delete_ToDo_ID != 0) {
            whereClause = "P".equals(this.p_JP_ToDo_Calendar) ? whereClause.append(" AND JP_ToDo_ID <> ?") : whereClause.append(" AND JP_ToDo_Team_ID <> ?");
            list_parameters.add(this.p_Delete_ToDo_ID);
        }
        if (this.login_User_ID != this.p_AD_User_ID) {
            whereClause = whereClause.append(" AND (IsOpenToDoJP='Y' OR CreatedBy = ?)");
            list_parameters.add(this.login_User_ID);
        }
        parameters = list_parameters.toArray(new Object[list_parameters.size()]);
        this.list_ToDoes = this.getToDoes(whereClause.toString(), orderClause.toString(), parameters);
        this.p_Delete_ToDo_ID = 0;
        if (this.list_ToDoes.size() <= 0) {
            this.contentsArea.appendChild((Component)new Label(Msg.getMsg((Properties)this.ctx, (String)"not.found")));
            return;
        }
        Grid grid = GridFactory.newGridLayout();
        grid.setMold("paging");
        if (this.isDashboardGadget) {
            grid.setPageSize(20);
        } else {
            grid.setPageSize(10);
        }
        grid.setPagingPosition("top");
        this.contentsArea.appendChild((Component)grid);
        Rows gridRows = grid.newRows();
        int counter = 0;
        for (I_ToDo toDo : this.list_ToDoes) {
            Row row = gridRows.newRow();
            ToolBarButton btn = new ToolBarButton(toDo.getName());
            btn.setSclass("link");
            this.createTitle(toDo, btn);
            btn.addEventListener("onClick", (EventListener)this);
            btn.addEventListener("onMouseOver", (EventListener)this);
            btn.setAttribute("index", (Object)counter);
            ++counter;
            row.appendChild((Component)btn);
        }
    }

    private void createTitle(I_ToDo toDo, ToolBarButton btn) {
        if ("T".equals(this.p_JP_ToDo_Type)) {
            Timestamp scheduledEndDay = Timestamp.valueOf(LocalDateTime.of(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalDate(), LocalTime.MIN));
            if (this.today.compareTo(scheduledEndDay) < 0) {
                if (ThemeManager.isUseFontIconForImage()) {
                    btn.setIconSclass("z-icon-Info-Circle");
                } else {
                    btn.setImage(ThemeManager.getThemeResource((String)"images/InfoIndicator16.png"));
                }
            } else if (this.today.compareTo(scheduledEndDay) == 0) {
                if (ThemeManager.isUseFontIconForImage()) {
                    btn.setIconSclass("z-icon-Exclamation-Triangle");
                } else {
                    btn.setImage(ThemeManager.getThemeResource((String)"images/mSetVariable.png"));
                }
            } else if (this.today.compareTo(scheduledEndDay) > 0) {
                if (ThemeManager.isUseFontIconForImage()) {
                    btn.setIconSclass("z-icon-Minus-Circle");
                } else {
                    btn.setImage(ThemeManager.getThemeResource((String)"images/ErrorIndicator16.png"));
                }
            }
            if (toDo.getParent_Team_ToDo_ID() == 0) {
                btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime())) + " " + toDo.getName());
            } else {
                btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime())) + " [" + Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Team_ID") + "] " + toDo.getName());
            }
        } else if ("S".equals(this.p_JP_ToDo_Type)) {
            Timestamp scheduledStartTime = toDo.getJP_ToDo_ScheduledStartTime();
            LocalDate startDate = scheduledStartTime.toLocalDateTime().toLocalDate();
            LocalTime startTime = scheduledStartTime.toLocalDateTime().toLocalTime();
            Timestamp scheduledEndTime = toDo.getJP_ToDo_ScheduledEndTime();
            LocalDate endDate = scheduledEndTime.toLocalDateTime().toLocalDate();
            LocalTime endTime = scheduledEndTime.toLocalDateTime().toLocalTime();
            boolean isTeamToDo = false;
            boolean isOneDaySchedule = false;
            boolean isAllDaySchedule = false;
            if (toDo.getParent_Team_ToDo_ID() > 0) {
                isTeamToDo = true;
            }
            if (startDate.compareTo(endDate) == 0) {
                isOneDaySchedule = true;
            }
            isAllDaySchedule = startTime.compareTo(LocalTime.MIN) == 0 && endTime.compareTo(LocalTime.MIN) == 0;
            if (isOneDaySchedule) {
                if (ThemeManager.isUseFontIconForImage()) {
                    btn.setIconSclass("z-icon-Clock");
                } else {
                    btn.setImage(ThemeManager.getThemeResource((String)"images/InfoSchedule16.png"));
                }
                if (isAllDaySchedule) {
                    btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime())) + " " + (isTeamToDo ? this.team : "") + toDo.getName());
                } else {
                    btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime())) + " " + startTime.toString() + " - " + endTime.toString() + " " + (isTeamToDo ? this.team : "") + toDo.getName());
                }
            } else {
                if (ThemeManager.isUseFontIconForImage()) {
                    btn.setIconSclass("z-icon-Calendar-O");
                } else {
                    btn.setImage(ThemeManager.getThemeResource((String)"images/Register16.png"));
                }
                if (isAllDaySchedule) {
                    btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime())) + " - " + this.formattedDate(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime()) + " " + (isTeamToDo ? this.team : "") + toDo.getName());
                } else if (startTime.compareTo(LocalTime.MIN) == 0) {
                    btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime())) + " - " + this.formattedDate(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime()) + " " + endTime.toString() + " " + (isTeamToDo ? this.team : "") + toDo.getName());
                } else if (endTime.compareTo(LocalTime.MIN) == 0) {
                    btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime())) + " " + startTime.toString() + " - " + this.formattedDate(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime()) + " " + (isTeamToDo ? this.team : "") + toDo.getName());
                } else {
                    btn.setLabel(String.valueOf(this.formattedDate(toDo.getJP_ToDo_ScheduledStartTime().toLocalDateTime())) + " " + startTime.toString() + " - " + this.formattedDate(toDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime()) + " " + endTime.toString() + " " + (isTeamToDo ? this.team : "") + toDo.getName());
                }
            }
        } else if ("M".equals(this.p_JP_ToDo_Type)) {
            if (ThemeManager.isUseFontIconForImage()) {
                btn.setIconSclass("z-icon-Edit");
            } else {
                btn.setImage(ThemeManager.getThemeResource((String)"images/Editor16.png"));
            }
            if (toDo.getParent_Team_ToDo_ID() == 0) {
                btn.setLabel(toDo.getName());
            } else {
                btn.setLabel(" [" + Msg.getElement((Properties)this.ctx, (String)"JP_ToDo_Team_ID") + "] " + toDo.getName());
            }
        }
    }

    private String formattedDate(LocalDateTime dateTime) {
        return this.lang.getDateFormat().format(Timestamp.valueOf(dateTime));
    }

    public void valueChange(ValueChangeEvent evt) {
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if ("AD_User_ID".equals(name)) {
            this.p_AD_User_ID = value == null ? 0 : Integer.parseInt(value.toString());
        } else if ("JP_ToDo_Type".equals(name)) {
            this.p_JP_ToDo_Type = "T".equals(value) ? "T" : ("S".equals(value) ? "S" : ("M".equals(value) ? "M" : null));
        } else if (EDITOR_DATE.equals(name)) {
            if (value == null) {
                this.p_LocalDateTime = LocalDateTime.of(LocalDateTime.now().toLocalDate(), LocalTime.MIN);
                this.editor_Date.setValue((Object)Timestamp.valueOf(this.p_LocalDateTime));
            } else {
                this.p_LocalDateTime = ((Timestamp)value).toLocalDateTime();
            }
        } else if (EDITOR_DAYS.equals(name)) {
            if (value == null) {
                WNumberEditor comp = (WNumberEditor)evt.getSource();
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory");
                throw new WrongValueException((Component)comp.getComponent(), msg);
            }
            if (value instanceof Integer) {
                this.p_Days = (Integer)value;
                if (this.p_Days <= 0 || this.p_Days >= 32) {
                    WNumberEditor comp = (WNumberEditor)evt.getSource();
                    String msg = "1 \uff5e 31";
                    throw new WrongValueException((Component)comp.getComponent(), msg);
                }
            }
        } else if ("JP_ToDo_Calendar".equals(name)) {
            if (value == null) {
                WTableDirEditor comp = (WTableDirEditor)evt.getSource();
                String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ToDo_Calendar");
                throw new WrongValueException((Component)comp.getComponent(), msg);
            }
            this.p_JP_ToDo_Calendar = value.toString();
        }
        this.createMessage();
        this.createContents();
    }

    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if ("onClick".equals(eventName)) {
            if (comp instanceof Button) {
                Button btn = (Button)comp;
                String btnName = btn.getName();
                if (BUTTON_NAME_PREVIOUS_DAY.equals(btnName)) {
                    this.p_LocalDateTime = this.p_LocalDateTime.minusDays(1L);
                    this.createMessage();
                    this.createContents();
                } else if (BUTTON_NAME_NEXT_DAY.equals(btnName)) {
                    this.p_LocalDateTime = this.p_LocalDateTime.plusDays(1L);
                    this.createMessage();
                    this.createContents();
                } else if (BUTTON_NAME_NEW_TODO.equals(btnName)) {
                    ToDoPopupWindow todoWindow = new ToDoPopupWindow(this, -1);
                    todoWindow.addToDoCalenderEventReceiver(this);
                    if (this.i_ToDoPopupwindowCaller instanceof ToDoCalendar) {
                        ToDoCalendar todocalendar = (ToDoCalendar)this.i_ToDoPopupwindowCaller;
                        todoWindow.addToDoCalenderEventReceiver(todocalendar);
                    }
                    SessionManager.getAppDesktop().showWindow((Window)todoWindow);
                } else if (BUTTON_NAME_REFRESH.equals(btnName)) {
                    this.createContents();
                } else if (BUTTON_NAME_CALENDER.equals(btnName)) {
                    MForm form = GroupwareToDoUtil.getToDoCallendarForm();
                    SessionManager.getAppDesktop().openForm(form.getAD_Form_ID());
                }
            } else if (comp instanceof ToolBarButton) {
                Object list_index = comp.getAttribute("index");
                int index = Integer.valueOf(list_index.toString());
                ToDoPopupWindow todoWindow = new ToDoPopupWindow(this, index);
                todoWindow.addToDoCalenderEventReceiver(this);
                if (this.i_ToDoPopupwindowCaller instanceof ToDoCalendar) {
                    ToDoCalendar todocalendar = (ToDoCalendar)this.i_ToDoPopupwindowCaller;
                    todoWindow.addToDoCalenderEventReceiver(todocalendar);
                }
                SessionManager.getAppDesktop().showWindow((Window)todoWindow);
            }
        } else if ("onMouseOver".equals(eventName) && this.p_IsToDoMouseoverPopup) {
            Object list_index = comp.getAttribute("index");
            int index = Integer.valueOf(list_index.toString());
            this.popup_CalendarEvent.setToDoCalendarEvent(this.list_ToDoes.get(index), null);
            this.popup_CalendarEvent.setPage(this.getPage());
            this.popup_CalendarEvent.open(comp, "end_before");
        }
    }

    private List<I_ToDo> getToDoes(String whereClause, String orderClause, Object ... parameters) {
        if ("P".equals(this.p_JP_ToDo_Calendar)) {
            List m_list = new Query(this.ctx, "JP_ToDo", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause).list();
            ArrayList<I_ToDo> i_list = new ArrayList<I_ToDo>();
            for (MToDo todo : m_list) {
                i_list.add(todo);
            }
            return i_list;
        }
        List m_list = new Query(this.ctx, "JP_ToDo_Team", whereClause.toString(), null).setParameters(parameters).setOrderBy(orderClause).list();
        ArrayList<I_ToDo> i_list = new ArrayList<I_ToDo>();
        for (MToDoTeam todo : m_list) {
            i_list.add(todo);
        }
        return i_list;
    }

    @Override
    public int getDefault_AD__User_ID() {
        return this.p_AD_User_ID;
    }

    @Override
    public String getDefault_JP_ToDo_Type() {
        return this.p_JP_ToDo_Type;
    }

    @Override
    public List<I_ToDo> getToDoList() {
        return this.list_ToDoes;
    }

    public void setToDoPopupwindowCaller(I_ToDoPopupwindowCaller todoPopupwindowcaller) {
        this.i_ToDoPopupwindowCaller = todoPopupwindowcaller;
    }

    public void addToDoCalenderEventReceiver(I_ToDoCalendarEventReceiver calendar) {
        this.list_ToDoCalendarEventReceiver.add(calendar);
    }

    @Override
    public boolean update(I_ToDo todo) {
        if (this.p_AD_User_ID == todo.getAD_User_ID()) {
            if ("S".equals(todo.getJP_ToDo_Type()) && "S".equals(this.p_JP_ToDo_Type)) {
                LocalDate start = this.p_LocalDateTime.toLocalDate();
                LocalDate end = start.plusDays(this.p_Days);
                if (start.compareTo(todo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalDate()) <= 0 & end.compareTo(todo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalDate()) >= 0) {
                    if (todo instanceof MToDo) {
                        if ("P".equals(this.p_JP_ToDo_Calendar)) {
                            this.createContents();
                        }
                    } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                        this.createContents();
                    }
                }
            } else if ("T".equals(todo.getJP_ToDo_Type()) && "T".equals(this.p_JP_ToDo_Type)) {
                if (!"CO".equals(todo.getJP_ToDo_Status())) {
                    if (todo instanceof MToDo) {
                        if ("P".equals(this.p_JP_ToDo_Calendar)) {
                            this.createContents();
                        }
                    } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                        this.createContents();
                    }
                }
            } else if ("M".equals(todo.getJP_ToDo_Type()) && "M".equals(this.p_JP_ToDo_Type) && !"CO".equals(todo.getJP_ToDo_Status())) {
                if (todo instanceof MToDo) {
                    if ("P".equals(this.p_JP_ToDo_Calendar)) {
                        this.createContents();
                    }
                } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                    this.createContents();
                }
            }
        }
        return true;
    }

    @Override
    public boolean create(I_ToDo todo) {
        if (this.p_AD_User_ID == todo.getAD_User_ID()) {
            if ("S".equals(todo.getJP_ToDo_Type()) && "S".equals(this.p_JP_ToDo_Type)) {
                LocalDate start = this.p_LocalDateTime.toLocalDate();
                LocalDate end = start.plusDays(this.p_Days);
                if (start.compareTo(todo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalDate()) <= 0 & end.compareTo(todo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalDate()) >= 0) {
                    if (todo instanceof MToDo) {
                        if ("P".equals(this.p_JP_ToDo_Calendar)) {
                            this.createContents();
                        }
                    } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                        this.createContents();
                    }
                }
            } else if ("T".equals(todo.getJP_ToDo_Type()) && "T".equals(this.p_JP_ToDo_Type)) {
                if (!"CO".equals(todo.getJP_ToDo_Status())) {
                    if (todo instanceof MToDo) {
                        if ("P".equals(this.p_JP_ToDo_Calendar)) {
                            this.createContents();
                        }
                    } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                        this.createContents();
                    }
                }
            } else if ("M".equals(todo.getJP_ToDo_Type()) && "M".equals(this.p_JP_ToDo_Type) && !"CO".equals(todo.getJP_ToDo_Status())) {
                if (todo instanceof MToDo) {
                    if ("P".equals(this.p_JP_ToDo_Calendar)) {
                        this.createContents();
                    }
                } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                    this.createContents();
                }
            }
        }
        return true;
    }

    @Override
    public boolean delete(I_ToDo todo) {
        int todo_AD_User_ID = todo.getAD_User_ID();
        if (this.p_AD_User_ID == todo_AD_User_ID) {
            if ("S".equals(todo.getJP_ToDo_Type()) && "S".equals(this.p_JP_ToDo_Type)) {
                LocalDate start = this.p_LocalDateTime.toLocalDate();
                LocalDate end = start.plusDays(this.p_Days);
                if (start.compareTo(todo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalDate()) <= 0 & end.compareTo(todo.getJP_ToDo_ScheduledStartTime().toLocalDateTime().toLocalDate()) >= 0) {
                    if (todo instanceof MToDo) {
                        if ("P".equals(this.p_JP_ToDo_Calendar)) {
                            this.p_Delete_ToDo_ID = todo.get_ID();
                            this.createContents();
                        }
                    } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                        this.p_Delete_ToDo_ID = todo.get_ID();
                        this.createContents();
                    }
                }
            } else if ("T".equals(todo.getJP_ToDo_Type()) && "T".equals(this.p_JP_ToDo_Type)) {
                if (!"CO".equals(todo.getJP_ToDo_Status())) {
                    if (todo instanceof MToDo) {
                        if ("P".equals(this.p_JP_ToDo_Calendar)) {
                            this.p_Delete_ToDo_ID = todo.get_ID();
                            this.createContents();
                        }
                    } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                        this.p_Delete_ToDo_ID = todo.get_ID();
                        this.createContents();
                    }
                }
            } else if ("M".equals(todo.getJP_ToDo_Type()) && "M".equals(this.p_JP_ToDo_Type) && !"CO".equals(todo.getJP_ToDo_Status())) {
                if (todo instanceof MToDo) {
                    if ("P".equals(this.p_JP_ToDo_Calendar)) {
                        this.p_Delete_ToDo_ID = todo.get_ID();
                        this.createContents();
                    }
                } else if ("T".equals(this.p_JP_ToDo_Calendar)) {
                    this.p_Delete_ToDo_ID = todo.get_ID();
                    this.createContents();
                }
            }
        }
        return true;
    }

    @Override
    public boolean refresh(I_ToDo todo) {
        if (todo == null) {
            this.createContents();
            return true;
        }
        return this.update(todo);
    }

    @Override
    public Timestamp getDefault_JP_ToDo_ScheduledStartTime() {
        return Timestamp.valueOf(LocalDateTime.of(this.p_LocalDateTime.toLocalDate(), LocalTime.NOON));
    }

    @Override
    public Timestamp getDefault_JP_ToDo_ScheduledEndTime() {
        return Timestamp.valueOf(LocalDateTime.of(this.p_LocalDateTime.toLocalDate(), LocalTime.NOON));
    }

    @Override
    public void setAD_User_ID(int AD_User_ID) {
        this.p_AD_User_ID = AD_User_ID;
        this.createContents();
    }

    @Override
    public int getDefault_JP_ToDo_Category_ID() {
        return 0;
    }

    @Override
    public int getWindowNo() {
        if (this.i_ToDoPopupwindowCaller != null) {
            return this.i_ToDoPopupwindowCaller.getWindowNo();
        }
        return 0;
    }

    @Override
    public String getJP_ToDo_Calendar() {
        return this.p_JP_ToDo_Calendar;
    }
}

