/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Properties;
import jpiere.plugin.groupware.model.I_ToDo;
import jpiere.plugin.groupware.model.MGroupwareUser;
import jpiere.plugin.groupware.model.MToDoCategory;
import jpiere.plugin.groupware.util.GroupwareToDoUtil;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.zkoss.calendar.impl.SimpleCalendarEvent;

public class ToDoCalendarEvent
extends SimpleCalendarEvent {
    private static final long serialVersionUID = 2289841014956779967L;
    private I_ToDo i_ToDo = null;
    private static final int INITIAL_TASK_HOUR = 1;
    private static final long JUDGMENT_Middle_TIME_HOURES = 12L;
    private static final long JUDGMENT_SHORT_TIME_MINUTE = 30L;
    private LocalDate begin_LocalDate = null;
    private LocalTime begin_LocalTime = null;
    private LocalTime end_LocalTime = null;
    private LocalDate end_LocalDate = null;
    private boolean isSameDate = false;
    public boolean isLongTime = false;
    public boolean isMiddleTime = false;
    public boolean isShortTime = false;
    public String personal_Month_Long_Title = null;
    public String personal_Month_Long_Content = null;
    public String personal_Month_Middle_Title = null;
    public String personal_Month_Middle_Content = null;
    public String personal_Month_Short_Title = null;
    public String personal_Month_Short_Content = null;
    public String team_Month_Long_Title = null;
    public String team_Month_Long_Content = null;
    public String team_Month_Middle_Title = null;
    public String team_Month_Middle_Content = null;
    public String team_Month_Short_Title = null;
    public String team_Month_Short_Content = null;
    public String personal_Default_Long_Title = null;
    public String personal_Default_Long_Content = null;
    public String personal_Default_Middle_Title = null;
    public String personal_Default_Middle_Content = null;
    public String personal_Default_Short_Title = null;
    public String personal_Default_Short_Content = null;
    public String team_Default_Long_Title = null;
    public String team_Default_Long_Content = null;
    public String team_Default_Middle_Title = null;
    public String team_Default_Middle_Content = null;
    public String team_Default_Short_Title = null;
    public String team_Default_Short_Content = null;
    public String personal_Month_Long_HeaderColor = null;
    public String personal_Month_Long_ContentColor = null;
    public String personal_Month_Middle_HeaderColor = null;
    public String personal_Month_Middle_ContentColor = null;
    public String personal_Month_Short_HeaderColor = null;
    public String personal_Month_Short_ContentColor = null;
    public String team_Month_Long_HeaderColor = null;
    public String team_Month_Long_ContentColor = null;
    public String team_Month_Middle_HeaderColor = null;
    public String team_Month_Middle_ContentColor = null;
    public String team_Month_Short_HeaderColor = null;
    public String team_Month_Short_ContentColor = null;
    public String personal_Default_Long_HeaderColor = null;
    public String personal_Default_Long_ContentColor = null;
    public String personal_Default_Middle_HeaderColor = null;
    public String personal_Default_Middle_ContentColor = null;
    public String personal_Default_Short_HeaderColor = null;
    public String personal_Default_Short_ContentColor = null;
    public String team_Default_Long_HeaderColor = null;
    public String team_Default_Long_ContentColor = null;
    public String team_Default_Middle_HeaderColor = null;
    public String team_Default_Middle_ContentColor = null;
    public String team_Default_Short_HeaderColor = null;
    public String team_Default_Short_ContentColor = null;

    public ToDoCalendarEvent(I_ToDo toDo) {
        this.i_ToDo = toDo;
        this.adjustTimeToZK();
        this.adjustDisplayText();
        this.setColor();
        if (toDo.getParent_Team_ToDo_ID() > 0) {
            this.setLocked(true);
        } else {
            int login_AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            if (toDo.getAD_User_ID() == login_AD_User_ID || this.i_ToDo.getCreatedBy() == login_AD_User_ID) {
                this.setLocked(false);
            } else {
                this.setLocked(true);
            }
        }
    }

    private void adjustTimeToZK() {
        Timestamp begin_Timestamp = this.i_ToDo.getJP_ToDo_ScheduledStartTime();
        Timestamp end_Timestamp = this.i_ToDo.getJP_ToDo_ScheduledEndTime();
        if (this.i_ToDo.getJP_ToDo_Type().equals("S")) {
            this.begin_LocalDate = begin_Timestamp.toLocalDateTime().toLocalDate();
            this.begin_LocalTime = begin_Timestamp.toLocalDateTime().toLocalTime();
            this.setBeginDate(new Date(begin_Timestamp.getTime()));
            end_Timestamp = this.i_ToDo.getJP_ToDo_ScheduledEndTime();
            this.end_LocalDate = end_Timestamp.toLocalDateTime().toLocalDate();
            this.end_LocalTime = end_Timestamp.toLocalDateTime().toLocalTime();
            this.isSameDate = this.begin_LocalDate.compareTo(this.end_LocalDate) == 0;
            this.isShortTime = this.judgmentOfShortTime(begin_Timestamp, end_Timestamp);
            if (this.end_LocalTime.compareTo(LocalTime.MIN) == 0) {
                this.end_LocalTime = LocalTime.MAX;
            }
            if (begin_Timestamp.compareTo(end_Timestamp) >= 0) {
                if (begin_Timestamp.compareTo(end_Timestamp) == 0 && this.begin_LocalTime.equals(LocalTime.MIN)) {
                    this.end_LocalTime = LocalTime.MAX;
                } else {
                    this.end_LocalTime = this.begin_LocalTime.plusMinutes(30L);
                    if (this.begin_LocalTime.compareTo(this.end_LocalTime) >= 0) {
                        this.end_LocalTime = LocalTime.MAX;
                    }
                }
            } else if (this.isShortTime) {
                this.end_LocalTime = this.begin_LocalTime.plusMinutes(30L);
            }
            end_Timestamp = Timestamp.valueOf(LocalDateTime.of(end_Timestamp.toLocalDateTime().toLocalDate(), this.end_LocalTime));
            this.setEndDate(new Date(end_Timestamp.getTime()));
            this.isMiddleTime = this.judgmentOfMiddleTime(begin_Timestamp, end_Timestamp);
        } else if (this.i_ToDo.getJP_ToDo_Type().equals("T")) {
            this.begin_LocalTime = end_Timestamp.toLocalDateTime().toLocalTime();
            this.setBeginDate(new Date(end_Timestamp.getTime()));
            this.end_LocalTime = end_Timestamp.toLocalDateTime().toLocalTime();
            if (this.i_ToDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalTime() == LocalTime.MIN) {
                this.end_LocalTime = LocalTime.MAX;
            } else {
                this.end_LocalTime = this.begin_LocalTime.plusHours(1L);
                if (this.begin_LocalTime.compareTo(this.end_LocalTime) >= 0) {
                    this.end_LocalTime = LocalTime.MAX;
                }
            }
            end_Timestamp = Timestamp.valueOf(LocalDateTime.of(end_Timestamp.toLocalDateTime().toLocalDate(), this.end_LocalTime));
            this.setEndDate(new Date(end_Timestamp.getTime()));
        }
    }

    private void adjustDisplayText() {
        String userName = " [" + GroupwareToDoUtil.trimName(MUser.get((Properties)Env.getCtx(), (int)this.i_ToDo.getAD_User_ID()).getName()) + "] ";
        if ("S".equals(this.i_ToDo.getJP_ToDo_Type())) {
            if (this.isSameDate) {
                if (this.isMiddleTime) {
                    String end_FormatTime;
                    this.isLongTime = false;
                    this.isMiddleTime = true;
                    this.isShortTime = false;
                    String begin_FormatTime = this.begin_LocalTime == null ? null : this.begin_LocalTime.toString().substring(0, 5);
                    String string = end_FormatTime = this.end_LocalTime == null ? null : this.end_LocalTime.toString().substring(0, 5);
                    if (this.begin_LocalTime == LocalTime.MIN && this.end_LocalTime == LocalTime.MAX) {
                        this.personal_Month_Middle_Title = this.i_ToDo.getName();
                        this.personal_Month_Middle_Content = " " + this.i_ToDo.getName();
                        this.team_Month_Middle_Title = this.i_ToDo.getName();
                        this.team_Month_Middle_Content = String.valueOf(userName) + this.i_ToDo.getName();
                        this.personal_Default_Middle_Title = this.personal_Month_Middle_Title;
                        this.personal_Default_Middle_Content = this.personal_Month_Middle_Content;
                        this.team_Default_Middle_Title = this.team_Month_Middle_Title;
                        this.team_Default_Middle_Content = this.team_Month_Middle_Content;
                    } else {
                        this.personal_Month_Middle_Title = this.i_ToDo.getName();
                        this.personal_Month_Middle_Content = String.valueOf(begin_FormatTime) + " - " + end_FormatTime + " " + this.i_ToDo.getName();
                        this.team_Month_Middle_Title = this.i_ToDo.getName();
                        this.team_Month_Middle_Content = String.valueOf(begin_FormatTime) + " - " + end_FormatTime + userName + " ";
                        this.personal_Default_Middle_Title = this.personal_Month_Middle_Title;
                        this.personal_Default_Middle_Content = this.personal_Month_Middle_Content;
                        this.team_Default_Middle_Title = this.team_Month_Middle_Title;
                        this.team_Default_Middle_Content = this.team_Month_Middle_Content;
                    }
                } else {
                    this.isLongTime = false;
                    this.isMiddleTime = false;
                    this.isShortTime = true;
                    this.personal_Month_Short_Title = null;
                    this.personal_Month_Short_Content = " " + this.i_ToDo.getName();
                    this.team_Month_Short_Title = null;
                    this.team_Month_Short_Content = String.valueOf(userName) + this.i_ToDo.getName();
                    this.personal_Default_Short_Title = this.i_ToDo.getName();
                    this.personal_Default_Short_Content = this.i_ToDo.getDescription();
                    this.team_Default_Short_Title = userName;
                    this.team_Default_Short_Content = this.i_ToDo.getName();
                }
            } else {
                this.isLongTime = true;
                this.isMiddleTime = false;
                this.isShortTime = false;
                String begin_FromatDate = this.begin_LocalTime == null ? null : GroupwareToDoUtil.dateFormat(this.begin_LocalDate);
                String end_FromatDate = this.end_LocalTime == null ? null : GroupwareToDoUtil.dateFormat(this.end_LocalDate);
                this.setTitle(null);
                if (this.begin_LocalTime == LocalTime.MIN) {
                    if (this.end_LocalTime == LocalTime.MAX) {
                        this.personal_Month_Long_Title = null;
                        this.personal_Month_Long_Content = String.valueOf(begin_FromatDate) + " - " + end_FromatDate + " " + this.i_ToDo.getName();
                        this.team_Month_Long_Title = null;
                        this.team_Month_Long_Content = String.valueOf(begin_FromatDate) + " - " + end_FromatDate + userName + this.i_ToDo.getName();
                        this.personal_Default_Long_Title = this.personal_Month_Long_Title;
                        this.personal_Default_Long_Content = this.personal_Month_Long_Content;
                        this.team_Default_Long_Title = this.team_Month_Long_Title;
                        this.team_Default_Long_Content = this.team_Month_Long_Content;
                    } else {
                        this.personal_Month_Long_Title = null;
                        this.personal_Month_Long_Content = String.valueOf(begin_FromatDate) + " - " + end_FromatDate + " " + this.end_LocalTime.toString().substring(0, 5) + " " + " " + this.i_ToDo.getName();
                        this.team_Month_Long_Title = null;
                        this.team_Month_Long_Content = String.valueOf(begin_FromatDate) + " - " + end_FromatDate + " " + this.end_LocalTime.toString().substring(0, 5) + " " + userName + this.i_ToDo.getName();
                        this.personal_Default_Long_Title = this.personal_Month_Long_Title;
                        this.personal_Default_Long_Content = this.personal_Month_Long_Content;
                        this.team_Default_Long_Title = this.team_Month_Long_Title;
                        this.team_Default_Long_Content = this.team_Month_Long_Content;
                    }
                } else if (this.end_LocalTime == LocalTime.MAX) {
                    this.personal_Month_Long_Content = String.valueOf(begin_FromatDate) + " " + this.begin_LocalTime.toString().substring(0, 5) + " - " + end_FromatDate + " " + this.i_ToDo.getName();
                    this.team_Month_Long_Content = String.valueOf(begin_FromatDate) + " " + this.begin_LocalTime.toString().substring(0, 5) + " - " + end_FromatDate + userName + this.i_ToDo.getName();
                    this.personal_Default_Long_Content = this.personal_Month_Long_Content;
                    this.team_Default_Long_Content = this.team_Month_Long_Content;
                } else {
                    this.personal_Month_Long_Content = String.valueOf(begin_FromatDate) + " " + this.begin_LocalTime.toString().substring(0, 5) + " - " + end_FromatDate + " " + this.end_LocalTime.toString().substring(0, 5) + " " + " " + this.i_ToDo.getName();
                    this.team_Month_Long_Content = String.valueOf(begin_FromatDate) + " " + this.begin_LocalTime.toString().substring(0, 5) + " - " + end_FromatDate + " " + this.end_LocalTime.toString().substring(0, 5) + " " + userName + this.i_ToDo.getName();
                    this.personal_Default_Long_Content = this.personal_Month_Long_Content;
                    this.team_Default_Long_Content = this.team_Month_Long_Content;
                }
            }
        } else if ("T".equals(this.i_ToDo.getJP_ToDo_Type())) {
            this.isLongTime = false;
            if (this.i_ToDo.getJP_ToDo_ScheduledEndTime().toLocalDateTime().toLocalTime() == LocalTime.MIN) {
                this.isMiddleTime = true;
                this.isShortTime = false;
                this.personal_Month_Middle_Title = null;
                this.personal_Month_Middle_Content = " " + this.i_ToDo.getName();
                this.team_Month_Middle_Title = null;
                this.team_Month_Middle_Content = String.valueOf(userName) + this.i_ToDo.getName();
                this.personal_Default_Middle_Title = null;
                this.personal_Default_Middle_Content = String.valueOf(this.i_ToDo.getName()) + " " + this.i_ToDo.getDescription();
                this.team_Default_Middle_Title = null;
                this.team_Default_Middle_Content = String.valueOf(userName) + " " + this.i_ToDo.getName();
            } else {
                this.isMiddleTime = false;
                this.isShortTime = true;
                this.personal_Month_Short_Title = null;
                this.personal_Month_Short_Content = " " + this.i_ToDo.getName();
                this.team_Month_Short_Title = null;
                this.team_Month_Short_Content = String.valueOf(userName) + this.i_ToDo.getName();
                this.personal_Default_Short_Title = this.i_ToDo.getName();
                this.personal_Default_Short_Content = String.valueOf(this.i_ToDo.getName()) + " " + this.i_ToDo.getDescription();
                this.team_Default_Short_Title = userName;
                this.team_Default_Short_Content = String.valueOf(userName) + " " + this.i_ToDo.getName();
            }
        }
    }

    private void setColor() {
        MGroupwareUser gUser;
        if (this.i_ToDo.getJP_ToDo_Category_ID() > 0) {
            MToDoCategory category = MToDoCategory.get(Env.getCtx(), this.i_ToDo.getJP_ToDo_Category_ID());
            this.personal_Month_Long_HeaderColor = category.getJP_ColorPicker();
            this.personal_Month_Long_ContentColor = category.getJP_ColorPicker();
            this.personal_Month_Middle_HeaderColor = category.getJP_ColorPicker();
            this.personal_Month_Middle_ContentColor = category.getJP_ColorPicker();
            this.personal_Month_Short_HeaderColor = category.getJP_ColorPicker();
            this.personal_Month_Short_ContentColor = category.getJP_ColorPicker();
            this.personal_Default_Long_HeaderColor = category.getJP_ColorPicker();
            this.personal_Default_Long_ContentColor = category.getJP_ColorPicker();
            this.personal_Default_Middle_HeaderColor = category.getJP_ColorPicker();
            this.personal_Default_Middle_ContentColor = category.getJP_ColorPicker();
            this.personal_Default_Short_HeaderColor = category.getJP_ColorPicker();
            this.personal_Default_Short_ContentColor = category.getJP_ColorPicker2();
        }
        if ((gUser = MGroupwareUser.get(Env.getCtx(), this.i_ToDo.getAD_User_ID())) != null) {
            this.team_Month_Long_HeaderColor = gUser.getJP_ColorPicker();
            this.team_Month_Long_ContentColor = gUser.getJP_ColorPicker();
            this.team_Month_Middle_HeaderColor = gUser.getJP_ColorPicker();
            this.team_Month_Middle_ContentColor = gUser.getJP_ColorPicker();
            this.team_Month_Short_HeaderColor = gUser.getJP_ColorPicker();
            this.team_Month_Short_ContentColor = gUser.getJP_ColorPicker();
            this.team_Default_Long_HeaderColor = gUser.getJP_ColorPicker();
            this.team_Default_Long_ContentColor = gUser.getJP_ColorPicker();
            this.team_Default_Middle_HeaderColor = gUser.getJP_ColorPicker();
            this.team_Default_Middle_ContentColor = gUser.getJP_ColorPicker();
            this.team_Default_Short_HeaderColor = gUser.getJP_ColorPicker();
            this.team_Default_Short_ContentColor = gUser.getJP_ColorPicker2();
        }
    }

    private boolean judgmentOfMiddleTime(Timestamp begin, Timestamp end) {
        LocalDate begin_LocalDate = begin.toLocalDateTime().toLocalDate();
        LocalTime begin_LocalTime = begin.toLocalDateTime().toLocalTime();
        LocalDate end_LocalDate = end.toLocalDateTime().toLocalDate();
        LocalTime end_LocalTime = end.toLocalDateTime().toLocalTime();
        if (begin_LocalDate.compareTo(end_LocalDate) == 0) {
            int scheduleTime = end_LocalTime.minusHours(begin_LocalTime.getHour()).getHour();
            return (long)scheduleTime >= 12L;
        }
        return true;
    }

    private boolean judgmentOfShortTime(Timestamp begin, Timestamp end) {
        LocalDate begin_LocalDate = begin.toLocalDateTime().toLocalDate();
        LocalTime begin_LocalTime = begin.toLocalDateTime().toLocalTime();
        LocalDate end_LocalDate = end.toLocalDateTime().toLocalDate();
        LocalTime end_LocalTime = end.toLocalDateTime().toLocalTime();
        if (begin_LocalDate.compareTo(end_LocalDate) == 0) {
            int scheduleHour = end_LocalTime.minusHours(begin_LocalTime.getHour()).getHour();
            if (scheduleHour < 1) {
                int sheduleMinute = end_LocalTime.minusMinutes(begin_LocalTime.getMinute()).getMinute();
                return (long)sheduleMinute < 30L;
            }
            return false;
        }
        return false;
    }

    public I_ToDo getToDo() {
        return this.i_ToDo;
    }
}

