CREATE TABLE AD_Document_Action_Access (
    AD_CLIENT_ID NUMBER(10,0) NOT NULL , 
 	AD_ORG_ID NUMBER(10,0) NOT NULL , 
  	ISACTIVE CHAR(1 BYTE) DEFAULT 'Y' NOT NULL , 
  	CREATED DATE DEFAULT SYSDATE NOT NULL , 
  	CREATEDBY NUMBER(10,0) NOT NULL , 
  	UPDATED DATE DEFAULT SYSDATE NOT NULL , 
  	UPDATEDBY NUMBER(10,0) NOT NULL , 
  	C_DocType_ID NUMBER(10,0) NOT NULL,
   	AD_Role_ID NUMBER(10,0) NOT NULL,
   	AD_Ref_List_ID NUMBER(10,0) NOT NULL
);

COMMIT;

SET DEFINE OFF;
INSERT INTO AD_VAL_RULE(AD_VAL_RULE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,TYPE,CODE,ENTITYTYPE)VALUES(51002,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),100,TO_DATE('2007-08-27','RRRR-MM-DD'),100,'AD_Ref_List_ID (Document Actions)','all document actions','S','AD_Ref_List.AD_Reference_ID=135','D');
INSERT INTO AD_TABLE(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID,COPYCOLUMNSFROMTABLE)VALUES(53012,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),100,TO_DATE('2007-08-27','RRRR-MM-DD'),100,'Document Action Access','Define access to document type / document action / role combinations.','Define access rules (add roles with access) for client/role/doctype/document action combinations. If no rules are defined for a client/doctype/doc action combination all roles can access the document action.','AD_Document_Action_Access','N','6','D',NULL,NULL,0,'N','Y','N','N','N','L',NULL,'N');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)VALUES(53011,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),100,TO_DATE('2007-08-27','RRRR-MM-DD'),100,'AD_Document_Action_Access','Table AD_Document_Action_Access',NULL,'Y',1,1000000,1000001,50000,'N','Y',NULL,NULL,'N');

INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53222,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',53012,19,NULL,NULL,22,'@AD_Client_ID@','N','N','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',102,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53223,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',53012,19,NULL,104,22,'@AD_Org_ID@','N','N','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',113,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53224,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',53012,20,NULL,NULL,1,NULL,'N','N','Y','Y',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',348,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53225,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',53012,16,NULL,NULL,7,NULL,'N','N','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',245,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53226,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',53012,18,110,NULL,22,NULL,'N','N','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',246,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53227,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',53012,16,NULL,NULL,7,NULL,'N','N','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',607,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53228,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',53012,18,110,NULL,22,NULL,'N','N','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',608,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53229,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Document Type','Document type or rules','The Document Type determines document sequence and processing rules',0,'D','C_DocType_ID',53012,19,NULL,NULL,22,NULL,'N','Y','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',196,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53230,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Role','Responsibility Role','The Role determines security and access a user who has this Role will have in the System.',0,'D','AD_Role_ID',53012,19,NULL,NULL,22,NULL,'N','Y','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',123,NULL,'N','N',NULL,NULL);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)VALUES(53231,0,0,'Y',TO_DATE('2007-08-27','RRRR-MM-DD'),TO_DATE('2007-08-27','RRRR-MM-DD'),100,100,'Reference List','Reference List based on Table',NULL,0,'D','AD_Ref_List_ID',53012,19,NULL,51002,22,NULL,'N','Y','Y','N',NULL,'N',NULL,'N','N',NULL,NULL,NULL,NULL,'N',119,NULL,'N','N',NULL,NULL);

INSERT INTO AD_TAB(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB)VALUES(53013,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Document Action Access','Define access to document type / document action / role combinations.','Define access to document type / document action / role combinations.',53012,111,90,1,'N','N','N','N',53230,'N',NULL,NULL,NULL,NULL,'N',NULL,'N',NULL,NULL,'N','D',NULL,NULL,NULL,'Y','N');

INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)VALUES(53241,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.','Y',53013,53224,NULL,'Y',NULL,1,'N',50,NULL,'N','N','N','N','D',NULL,NULL,NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)VALUES(53242,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y',53013,53222,NULL,'Y',NULL,22,'N',10,NULL,'N','N','N','N','D',NULL,NULL,NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)VALUES(53244,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Document Type','Document type or rules','The Document Type determines document sequence and processing rules','Y',53013,53229,NULL,'Y',NULL,22,'N',30,NULL,'N','N','N','N','D',NULL,NULL,NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)VALUES(53245,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y',53013,53223,NULL,'Y',NULL,22,'N',20,NULL,'N','N','N','N','D',NULL,NULL,NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)VALUES(53246,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Reference List','Reference List based on Table','The Reference List field indicates a list of reference values from a database tables.  Reference lists populate drop down list boxes in data entry screens','Y',53013,53231,NULL,'Y',NULL,22,'N',40,NULL,'N','N','N','N','D',NULL,NULL,NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)VALUES(53247,0,0,'Y',TO_DATE('2007-08-29','RRRR-MM-DD'),100,TO_DATE('2007-08-29','RRRR-MM-DD'),100,'Role','Responsibility Role','The Role determines security and access a user who has this Role will have in the System.','Y',53013,53230,NULL,'N',NULL,22,'N',0,NULL,'N','N','N','N','D',NULL,NULL,NULL);


COMMIT;


UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM AD_COLUMN
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM AD_FIELD
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';
 
 
 UPDATE AD_SEQUENCE
    SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                            FROM AD_COLUMN
                           WHERE ad_column_id < 1000000)
  WHERE NAME = 'AD_Sequence';
 
 UPDATE AD_SEQUENCE
    SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                            FROM AD_FIELD
                           WHERE ad_field_id < 1000000)
  WHERE NAME = 'AD_Tab';
  
  UPDATE AD_SEQUENCE
     SET currentnextsys = (SELECT MAX (ad_message_id) + 1
                             FROM AD_MESSAGE
                            WHERE ad_message_id < 1000000)
 WHERE NAME = 'AD_Table';
 
  UPDATE AD_SEQUENCE
     SET currentnextsys = (SELECT MAX (ad_element_id) + 1
                             FROM AD_ELEMENT
                            WHERE ad_element_id < 1000000)
   WHERE NAME = 'AD_Window';
  
  UPDATE AD_SEQUENCE
     SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                             FROM AD_COLUMN
                            WHERE ad_column_id < 1000000)
   WHERE NAME = 'AD_Val_Rule';
  
   
 COMMIT;
 
 DELETE FROM AD_Document_Action_Access;
 
 INSERT INTO  AD_DOCUMENT_ACTION_ACCESS  ( 
 AD_CLIENT_ID , 
 AD_ORG_ID , 
 ISACTIVE , 
 CREATED , 
 CREATEDBY , 
 UPDATED , 
 UPDATEDBY , 
 C_DOCTYPE_ID , 
 AD_ROLE_ID , 
 AD_REF_LIST_ID 
 ) 
 SELECT
 client.AD_Client_ID,
 0,
 'Y',
 SYSDATE,
 0,
 SYSDATE,
 0,
 doctype.C_DocType_ID,
 rol.AD_Role_ID,
 action.AD_Ref_List_ID
 FROM AD_CLIENT client
 INNER JOIN C_DOCTYPE doctype ON (doctype.AD_Client_ID=client.AD_Client_ID)
 INNER JOIN AD_REF_LIST action ON (action.AD_Reference_ID=135)
 INNER JOIN AD_ROLE rol ON (rol.AD_Client_ID=client.AD_Client_ID)
 ;


COMMIT;
