/******************************************************************************
 * Product: iDempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.KeyNamePair;

/** Generated Interface for C_RevenueRecognition_Run
 *  @author iDempiere (generated) 
 *  @version Release 6.2
 */
public interface I_C_RevenueRecognition_Run 
{

    /** TableName=C_RevenueRecognition_Run */
    public static final String Table_Name = "C_RevenueRecognition_Run";

    /** AD_Table_ID=444 */
    public static final int Table_ID = 444;

    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);

    /** AccessLevel = 1 - Org 
     */
    BigDecimal accessLevel = BigDecimal.valueOf(1);

    /** Load Meta Data */

    /** Column name AD_Client_ID */
    public static final String COLUMNNAME_AD_Client_ID = "AD_Client_ID";

	/** Get Client.
	  * Client/Tenant for this installation.
	  */
	public int getAD_Client_ID();

    /** Column name AD_Org_ID */
    public static final String COLUMNNAME_AD_Org_ID = "AD_Org_ID";

	/** Set Organization.
	  * Organizational entity within client
	  */
	public void setAD_Org_ID (int AD_Org_ID);

	/** Get Organization.
	  * Organizational entity within client
	  */
	public int getAD_Org_ID();

    /** Column name Created */
    public static final String COLUMNNAME_Created = "Created";

	/** Get Created.
	  * Date this record was created
	  */
	public Timestamp getCreated();

    /** Column name CreatedBy */
    public static final String COLUMNNAME_CreatedBy = "CreatedBy";

	/** Get Created By.
	  * User who created this records
	  */
	public int getCreatedBy();

    /** Column name C_RevenueRecognition_Plan_ID */
    public static final String COLUMNNAME_C_RevenueRecognition_Plan_ID = "C_RevenueRecognition_Plan_ID";

	/** Set Revenue Recognition Plan.
	  * Plan for recognizing or recording revenue
	  */
	public void setC_RevenueRecognition_Plan_ID (int C_RevenueRecognition_Plan_ID);

	/** Get Revenue Recognition Plan.
	  * Plan for recognizing or recording revenue
	  */
	public int getC_RevenueRecognition_Plan_ID();

	public org.compiere.model.I_C_RevenueRecognition_Plan getC_RevenueRecognition_Plan() throws RuntimeException;

    /** Column name C_RevenueRecognition_Run_ID */
    public static final String COLUMNNAME_C_RevenueRecognition_Run_ID = "C_RevenueRecognition_Run_ID";

	/** Set Revenue Recognition Run.
	  * Revenue Recognition Run or Process
	  */
	public void setC_RevenueRecognition_Run_ID (int C_RevenueRecognition_Run_ID);

	/** Get Revenue Recognition Run.
	  * Revenue Recognition Run or Process
	  */
	public int getC_RevenueRecognition_Run_ID();

    /** Column name C_RevenueRecognition_Run_UU */
    public static final String COLUMNNAME_C_RevenueRecognition_Run_UU = "C_RevenueRecognition_Run_UU";

	/** Set C_RevenueRecognition_Run_UU	  */
	public void setC_RevenueRecognition_Run_UU (String C_RevenueRecognition_Run_UU);

	/** Get C_RevenueRecognition_Run_UU	  */
	public String getC_RevenueRecognition_Run_UU();

    /** Column name C_RevenueRecog_Service_ID */
    public static final String COLUMNNAME_C_RevenueRecog_Service_ID = "C_RevenueRecog_Service_ID";

	/** Set Revenue Recognition Service	  */
	public void setC_RevenueRecog_Service_ID (int C_RevenueRecog_Service_ID);

	/** Get Revenue Recognition Service	  */
	public int getC_RevenueRecog_Service_ID();

	public org.compiere.model.I_C_RevenueRecog_Service getC_RevenueRecog_Service() throws RuntimeException;

    /** Column name DateRecognized */
    public static final String COLUMNNAME_DateRecognized = "DateRecognized";

	/** Set Recognition Date	  */
	public void setDateRecognized (Timestamp DateRecognized);

	/** Get Recognition Date	  */
	public Timestamp getDateRecognized();

    /** Column name GL_Journal_ID */
    public static final String COLUMNNAME_GL_Journal_ID = "GL_Journal_ID";

	/** Set Journal.
	  * General Ledger Journal
	  */
	public void setGL_Journal_ID (int GL_Journal_ID);

	/** Get Journal.
	  * General Ledger Journal
	  */
	public int getGL_Journal_ID();

	public org.compiere.model.I_GL_Journal getGL_Journal() throws RuntimeException;

    /** Column name IsActive */
    public static final String COLUMNNAME_IsActive = "IsActive";

	/** Set Active.
	  * The record is active in the system
	  */
	public void setIsActive (boolean IsActive);

	/** Get Active.
	  * The record is active in the system
	  */
	public boolean isActive();

    /** Column name RecognizedAmt */
    public static final String COLUMNNAME_RecognizedAmt = "RecognizedAmt";

	/** Set Recognized Amount	  */
	public void setRecognizedAmt (BigDecimal RecognizedAmt);

	/** Get Recognized Amount	  */
	public BigDecimal getRecognizedAmt();

    /** Column name Updated */
    public static final String COLUMNNAME_Updated = "Updated";

	/** Get Updated.
	  * Date this record was updated
	  */
	public Timestamp getUpdated();

    /** Column name UpdatedBy */
    public static final String COLUMNNAME_UpdatedBy = "UpdatedBy";

	/** Get Updated By.
	  * User who updated this records
	  */
	public int getUpdatedBy();
}
