﻿DROP VIEW c_project_header_vt;

CREATE OR REPLACE VIEW c_project_header_vt AS 
SELECT p.ad_client_id,
    p.ad_org_id,
    p.isactive,
    p.created,
    p.createdby,
    p.updated,
    p.updatedby,
    ptt.ad_language,
    p.c_project_id,
    p.value,
    p.name                           AS projectname,
    p.description,
    p.note,
    p.issummary,
    p.projectcategory,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    p.c_projecttype_id,
    pjt.name                         AS projecttypename,
    p.c_phase_id,
    pjp.name                         AS projectphasename,
    p.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    p.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    bpgt.greeting                    AS bpgreeting,
    bp.name,
    bp.name2,
    bpcgt.greeting                   AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    ptt.name                         AS paymentterm,
    ptt.documentnote                 AS paymenttermnote,
    p.poreference,
    p.c_currency_id,
    p.m_pricelist_version_id,
    p.c_campaign_id,
    p.plannedamt,
    p.plannedqty,
    p.plannedmarginamt,
    p.invoicedamt,
    p.invoicedqty,
    p.projectbalanceamt,
    p.iscommitment,
    p.committedamt,
    p.committedqty,
    p.datecontract,
    p.datefinish,
    p.iscommitceiling,
    p.m_warehouse_id,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    p.ad_user_id,
    p.c_bpartner_location_id,
    p.copyfrom,
    p.c_paymentterm_id               AS c_project_c_paymentterm_id,
    p.generateto,
    p.processed                      AS c_project_processed,
    p.processing                     AS c_project_processing,
    p.projectlinelevel,
    p.projinvoicerule,
    bp.acqusitioncost                AS c_bp_acqusitioncost,
    bp.actuallifetimevalue           AS c_bp_actuallifetimevalue,
    bp.ad_language                   AS c_bp_ad_language,
    bp.ad_orgbp_id                   AS c_bp_ad_orgbp_id,
    bp.ad_org_id                     AS c_bp_ad_org_id,
    bp.bpartner_parent_id            AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bp_c_bp_group_id,
    bp.c_dunning_id                  AS c_bp_c_dunning_id,
    bp.c_greeting_id                 AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bp_c_paymentterm_id,
    bp.created                       AS c_bp_created,
    bp.createdby                     AS c_bp_createdby,
    bp.c_taxgroup_id                 AS c_bp_c_taxgroup_id,
    bp.deliveryrule                  AS c_bp_deliveryrule,
    bp.deliveryviarule               AS c_bp_deliveryviarule,
    bp.description                   AS c_bp_description,
    bp.dunninggrace                  AS c_bp_dunninggrace,
    bp.firstsale                     AS c_bp_firstsale,
    bp.flatdiscount                  AS c_bp_flatdiscount,
    bp.freightcostrule               AS c_bp_freightcostrule,
    bp.invoicerule                   AS c_bp_invoicerule,
    bp.isactive                      AS c_bp_isactive,
    bp.iscustomer                    AS c_bp_iscustomer,
    bp.isdiscountprinted             AS c_bp_isdiscountprinted,
    bp.isemployee                    AS c_bp_isemployee,
    bp.ismanufacturer                AS c_bp_ismanufacturer,
    bp.isonetime                     AS c_bp_isonetime,
    bp.ispotaxexempt                 AS c_bp_ispotaxexempt,
    bp.isprospect                    AS c_bp_isprospect,
    bp.issalesrep                    AS c_bp_issalesrep,
    bp.issummary                     AS c_bp_issummary,
    bp.istaxexempt                   AS c_bp_istaxexempt,
    bp.isvendor                      AS c_bp_isvendor,
    bp.logo_id                       AS c_bp_logo_id,
    bp.m_discountschema_id           AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                AS c_bp_m_pricelist_id,
    bp.numberemployees               AS c_bp_numberemployees,
    bp.paymentrule                   AS c_bp_paymentrule,
    bp.paymentrulepo                 AS c_bp_paymentrulepo,
    bp.po_discountschema_id          AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id             AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bp_po_pricelist_id,
    bp.poreference                   AS c_bp_poreference,
    bp.potentiallifetimevalue        AS c_bp_potentiallifetimevalue,
    bp.rating                        AS c_bp_rating,
    bp.salesrep_id                   AS c_bp_salesrep_id,
    bp.salesvolume                   AS c_bp_salesvolume,
    bp.sendemail                     AS c_bp_sendemail,
    bp.shareofcustomer               AS c_bp_shareofcustomer,
    bp.shelflifeminpct               AS c_bp_shelflifeminpct,
    bp.so_creditlimit                AS c_bp_so_creditlimit,
    bp.socreditstatus                AS c_bp_socreditstatus,
    bp.so_creditused                 AS c_bp_so_creditused,
    bp.so_description                AS c_bp_so_description,
    bp.totalopenbalance              AS c_bp_totalopenbalance,
    bp.updated                       AS c_bp_updated,
    bp.updatedby                     AS c_bp_updatedby,
    bp.url                           AS c_bp_url,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    pjt.ad_org_id                    AS c_projecttype_ad_org_id,
    pjt.description                  AS c_projecttype_description,
    pjt.help                         AS c_projecttype_help,
    pjt.isactive                     AS c_projecttype_isactive,
    pjt.projectcategory              AS c_projecttype_projectcategory,
    pjp.ad_org_id                    AS c_phase_ad_org_id,
    pjp.c_phase_id                   AS c_phase_c_phase_id,
    pjp.c_projecttype_id             AS c_phase_c_projecttype_id,
    pjp.description                  AS c_phase_description,
    pjp.help                         AS c_phase_help,
    pjp.isactive                     AS c_phase_isactive,
    pjp.m_product_id                 AS c_phase_m_product_id,
    pjp.seqno                        AS c_phase_seqno,
    pjp.standardqty,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bp_acqusitioncost,
    ubp.actuallifetimevalue          AS salesrep_bp_actuallifevalue,
    ubp.ad_language                  AS salesrep_bp_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bp_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bp_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bp_bpartner_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_dunning_id                 AS salesrep_bp_c_dunning_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_c_invoicesched_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bp_created,
    ubp.createdby                    AS salesrep_bp_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bp_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bp_deliveryviarule,
    ubp.description                  AS salesrep_bp_description,
    ubp.dunninggrace                 AS salesrep_bp_dunninggrace,
    ubp.duns                         AS salesrep_bp_duns,
    ubp.firstsale                    AS salesrep_bp_firstsale,
    ubp.flatdiscount                 AS salesrep_bp_flatdiscount,
    ubp.freightcostrule              AS salesrep_bp_freightcostrule,
    ubp.invoicerule                  AS salesrep_bp_invoicerule,
    ubp.isactive                     AS salesrep_bp_isactive,
    ubp.iscustomer                   AS salesrep_bp_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bp_isdiscountprinted,
    ubp.isemployee                   AS salesrep_bp_isemployee,
    ubp.ismanufacturer               AS salesrep_bp_ismanufacturer,
    ubp.isonetime                    AS salesrep_bp_isonetime,
    ubp.ispotaxexempt                AS salesrep_bp_ispotaxexempt,
    ubp.isprospect                   AS salesrep_bp_isprospect,
    ubp.issalesrep                   AS salesrep_bp_issalesrep,
    ubp.issummary                    AS salesrep_bp_issummary,
    ubp.istaxexempt                  AS salesrep_bp_istaxexempt,
    ubp.isvendor                     AS salesrep_bp_isvendor,
    ubp.logo_id                      AS salesrep_bp_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_m_discountschm_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bp_naics,
    ubp.name2                        AS salesrep_bp_name2,
    ubp.numberemployees              AS salesrep_bp_numberemployees,
    ubp.paymentrule                  AS salesrep_bp_paymentrule,
    ubp.paymentrulepo                AS salesrep_bp_paymentrulepo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountschm_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bp_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bp_potentiallifevalue,
    ubp.rating                       AS salesrep_bp_rating,
    ubp.referenceno                  AS salesrep_bp_referenceno,
    ubp.salesrep_id                  AS salesrep_bp_salesrep_id,
    ubp.salesvolume                  AS salesrep_bp_salesvolume,
    ubp.sendemail                    AS salesrep_bp_sendemail,
    ubp.shareofcustomer              AS salesrep_bp_shareofcustomer,
    ubp.shelflifeminpct              AS salesrep_bp_shelflifeminpct,
    ubp.so_creditlimit               AS salesrep_bp_so_creditlimit,
    ubp.socreditstatus               AS salesrep_bp_socreditstatus,
    ubp.so_creditused                AS salesrep_bp_so_creditused,
    ubp.so_description               AS salesrep_bp_so_description,
    ubp.taxid                        AS salesrep_bp_taxid,
    ubp.totalopenbalance             AS salesrep_bp_totalopenbalance,
    ubp.updated                      AS salesrep_bp_updated,
    ubp.updatedby                    AS salesrep_bp_updatedby,
    ubp.url                          AS salesrep_bp_url,
    ubp.value                        AS salesrep_bp_value,
    bpgt.ad_org_id                   AS c_greeting_ad_org_id,
    bpgt.isactive                    AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpgt.name                        AS c_greeting_name,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcgt.ad_org_id                  AS c_user_greeting_ad_org_id,
    bpcgt.c_greeting_id              AS c_user_greeting_c_greeting_id,
    bpcgt.isactive                   AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcgt.name                       AS c_user_greeting_name,
    bpl.ad_org_id                    AS c_bp_location_ad_org_id,
    bpl.c_bpartner_id                AS c_bp_location_c_bpartner_id,
    bpl.created                      AS c_bp_location_created,
    bpl.createdby                    AS c_bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bp_location_fax,
    bpl.isactive                     AS c_bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bp_location_name,
    bpl.phone                        AS c_bp_location_phone,
    bpl.phone2                       AS c_bp_location_phone2,
    bpl.updated                      AS c_bp_location_updated,
    bpl.updatedby                    AS c_bp_location_updatedby,
    ptt.ad_org_id                    AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id              AS c_paymentterm_c_paymentterm_id,
    ptt.description                  AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    ptt.isactive                     AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS c_paymentterm_value 
FROM c_project p 
        LEFT JOIN c_bpartner bp 
        ON p.c_bpartner_id = bp.c_bpartner_id 
        JOIN ad_orginfo oi 
        ON p.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON p.ad_client_id = ci.ad_client_id 
        LEFT JOIN c_paymentterm pt 
        ON p.c_paymentterm_id = pt.c_paymentterm_id 
        LEFT JOIN c_paymentterm_trl ptt 
        ON p.c_paymentterm_id = ptt.c_paymentterm_id 
        LEFT JOIN c_projecttype pjt 
        ON p.c_projecttype_id = pjt.c_projecttype_id 
        LEFT JOIN c_phase pjp 
        ON p.c_phase_id = pjp.c_phase_id 
        LEFT JOIN ad_user u 
        ON p.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id 
        LEFT JOIN ad_user bpc 
        ON p.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpcgt 
        ON bpc.c_greeting_id = bpcgt.c_greeting_id 
        LEFT JOIN c_bpartner_location bpl 
        ON p.c_bpartner_location_id = bpl.c_bpartner_location_id
;
