package jongs;

import java.net.URL;
import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.OutputStream ;
import java.io.FileOutputStream ;
import java.io.BufferedOutputStream ;

import java.io.FileNotFoundException;
import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;

// 
// JONGS - Java Open Novels Game Script
// 
//    jongsNet.java 
//
//  Copyright 2007  DENZI TOMIZKA
//
//  ver 1.00 Create by DENZI TOMIZKA 2007.6.25
//
/*
 *-----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *----------------------------------------------------------------------
 */

public class jongsNet  {
	String local_dir ;
	String server_url ;

	public jongsNet(String url , String dir) {
		super();
		this.server_url = url;
		this.local_dir = dir;
		this.mkdirs(local_dir);
	}

	public void mkdirs(String dir) {
		File tmpdir;
		tmpdir = new File(dir);
		if ( tmpdir.exists() ) {
			if ( !tmpdir.isDirectory() ) tmpdir.delete();
		}
		tmpdir = new File(dir);
		if ( ! tmpdir.exists() ) {
			System.out.println("mkdirs:"+dir);
			tmpdir.mkdirs();
		}		
	}
	
	public void getServerFile( String file_path ) {
		String filename = local_dir + "/" + file_path ;
		File tmpfile = new File(filename);
		if ( tmpfile.exists() ) return ;

		String sv_file = this.server_url +"/"+ this.local_dir +"/"+ file_path ;
		int pos = filename.lastIndexOf('/');
		String ldir = filename.substring(0 , filename.lastIndexOf('/'));
		this.mkdirs(ldir);
		
		InputStream inp_strm = null;
		OutputStream out_strm = null;
		try {
			URL url = new URL(sv_file);
			inp_strm = new BufferedInputStream(url.openStream());
			out_strm = new BufferedOutputStream(new FileOutputStream(filename));
			int b;
			while ((b = inp_strm.read()) != -1) {
				out_strm.write(b);
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
			System.exit(0);
		} catch (FileNotFoundException e) {
			System.out.println("File not Found "+sv_file);
			e.printStackTrace();
			System.exit(0);
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(0);
		} finally {
			try {
				if (inp_strm != null) {
					inp_strm.close();
				}
				if (out_strm != null) {
					out_strm.flush();
					out_strm.close();
				}
			} catch (Exception e) {
			}
		}
	}
}
