package jongs;

import java.util.Vector ;
import java.util.HashMap ;
import java.util.Stack ;
import java.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.IOException;


// 
// JONGS - Java Open Novels Game Script
// 
//    JongScripter.java 
//
//  Copyright 2007  DENZI TOMIZKA
//
//  ver 1.00 Create by DENZI TOMIZKA 2007.5.25
//  ver 1.01           DENZI TOMIZKA 2007.5.26
//  ver 1.02           DENZI TOMIZKA 2007.5.28
//  ver 1.03           DENZI TOMIZKA 2007.5.31
//  ver 1.04           DENZI TOMIZKA 2007.6.02
//
/*
 *-----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *----------------------------------------------------------------------
 */


public class JongScripter extends Thread {	
	//fñR[h
	public final static int LGK_and		= 1;
	public final static int LGK_or		= 2;

	//ϐ^̃R[h
	public final static int TYPE_int   =  100 ;
	public final static int TYPE_str   =  200 ;
	
	//{ñR[h
	public final static int CMD_if					= 1001;
	public final static int CMD_else					= 1002;
	public final static int CMD_while					= 1003;
	public final static int CMD_for					= 1004;
	public final static int CMD_goto					= 1005;
	public final static int CMD_gosub					= 1006;
	public final static int CMD_goScript				= 1007;
	public final static int CMD_return				= 1008;
	public final static int CMD_begin		   			= 1009;
	public final static int CMD_end					= 1010;
	public final static int CMD_set					= 1011;
	public final static int CMD_exit					= 1012;
	public final static int CMD_input					= 1013;
	public final static int CMD_switch				= 1014;
	public final static int CMD_case					= 1015;
	public final static int CMD_label					= 1016;
	public final static int CMD_break					= 1017;
	public final static int CMD_continue				= 1018;
	public final static int CMD_text					= 1019;
	public final static int CMD_WaitText				= 1020;
	public final static int CMD_print					= 1021;
	
	
	//ʏñR[h
	public final static int CMD_setCellNumber			= 2001;
	public final static int CMD_setCellImage			= 2002;
	public final static int CMD_setCellPosition		= 2003;
	public final static int CMD_setCellSize			= 2004;
	public final static int CMD_setCellTransColor		= 2005;
	public final static int CMD_setCellFlag			= 2006;
	public final static int CMD_setCellCanvas			= 2007;
	public final static int CMD_setCellTextParam		= 2008;
	public final static int CMD_setCellText			= 2009;
	public final static int CMD_setShiftView			= 2010;
	public final static int CMD_setShiftHide			= 2011;
	public final static int CMD_viewDisplay			= 2012;
	public final static int CMD_transitionDisplay		= 2013;
	public final static int CMD_setDisplaySize		= 2014;
	public final static int CMD_wait					= 2015;
	public final static int CMD_setFontColor			= 2016;
	public final static int CMD_setFont				= 2017;
	public final static int CMD_setTextArea			= 2018;
	public final static int CMD_setTextInterval		= 2019;
	public final static int CMD_select				= 2020;
	public final static int CMD_setSelectArea			= 2021;
	public final static int CMD_setSelectColor		= 2022;
	public final static int CMD_setSelectFont			= 2039;
	public final static int CMD_midiPlay				= 2023;
	public final static int CMD_midiLoad				= 2024;
	public final static int CMD_midiStop				= 2025;
	public final static int CMD_audioPlay				= 2026;
	public final static int CMD_audioLoop				= 2027;
	public final static int CMD_audioStop				= 2028;
	public final static int CMD_clipLoop				= 2029;
	public final static int CMD_clipStop				= 2030;
	public final static int CMD_setWaitTime			= 2031;
	public final static int CMD_cellClick				= 2032;
	public final static int CMD_debug					= 2033;
	public final static int CMD_display				= 2034;
	public final static int CMD_save		 			= 2035;
	public final static int CMD_load		 			= 2036;
	public final static int CMD_random				= 2037;
	public final static int CMD_abs					= 2038;
			

	Vector < Vector<String> > scriptParams ;
	Vector <int[]> scriptCode ;
	int scriptPointer ;
	HashMap <String , int[] > typeMap , basicMap, cmdMap , labelMap  ;
	HashMap <String , Object > varIntMap ,varStrMap ;
	Stack <int[]> parStack , subroutineStack;

	
	int th_wtime ;
	int debug  ;
	String Text;
	String Groot;

	//L[͗p
    BufferedReader bread ;
    //݉͒̍s
    String now_Line;
    	
    //ʋyщʊǗ
    jongsDisplayManagement dmng; 
    jongsSound sound ;
    jongsNet jongsnet = null ;
	
	public JongScripter() {
		super("JONGS");
		this.initJongScripter(800,600);
	}
	
	
	public JongScripter(String scfile, String code , String win) {
		int w , h ;
		String wsize = win.trim().toLowerCase() ;		
		w = 800 ; h = 600;
		if ( wsize.equals("vga") ) {w=640; h=480;}	
		else if ( wsize.equals("sga") ) {w=800; h=600;}
		else if ( wsize.equals("xga") ) {w=1024; h=768;}
		this.initJongScripter(w,h);
		String script ="display("+w+","+h+");"+this.getFirstScript()+";goScript("+scfile+","+code+");";
		this.getScript(script, "string");
	}
	
	
	/**
	 * XNv^̏
	 * @param w
	 * @param h
	 */
	public void initJongScripter(int w , int h) {
		//L[͗pobt@[h[_[쐬
		this.bread = new BufferedReader(new InputStreamReader(System.in));
		//ϐi[NA
		varIntMap = new HashMap <String , Object >() ;
		varStrMap = new HashMap <String , Object >() ;
		//{n̕\o^
		this.initBasicCode();
		//R}hƃR[h̑Δ\o^
		this.initCommandCode();
		th_wtime = 0;
		debug = 0 ;
		Text = "";
		//TEhǗn
		sound = new jongsSound();
	}

	
	/**
	 *^E{n\̓o^ 
	 */
	private void initBasicCode() {		
		//^̓o^
		typeMap = new HashMap <String , int[] >() ;	
		typeMap.put("int", this.getIntArray(TYPE_int) );
		typeMap.put("integer", this.getIntArray(TYPE_int) );
		typeMap.put("str", this.getIntArray(TYPE_str) );
		typeMap.put("string", this.getIntArray(TYPE_str) );

		//{n\̓o^
		basicMap = new HashMap <String , int[] >() ;
		basicMap.put("if", this.getIntArray(CMD_if) );
		basicMap.put("else", this.getIntArray(CMD_else) );
		basicMap.put("while", this.getIntArray(CMD_while) );
		basicMap.put("for", this.getIntArray(CMD_for) );
		basicMap.put("goto", this.getIntArray(CMD_goto) );
		basicMap.put("gosub", this.getIntArray(CMD_gosub) );
		basicMap.put("goscript", this.getIntArray(CMD_goScript) );
		basicMap.put("return", this.getIntArray(CMD_return) );
		basicMap.put("begin", this.getIntArray(CMD_begin) );
		basicMap.put("end", this.getIntArray(CMD_end) );
		basicMap.put("set", this.getIntArray(CMD_set) );
		basicMap.put("exit", this.getIntArray(CMD_exit) );
		basicMap.put("input", this.getIntArray(CMD_input) );
		basicMap.put("switch", this.getIntArray(CMD_switch) );
		basicMap.put("case", this.getIntArray(CMD_case) );
		basicMap.put("label", this.getIntArray(CMD_label) );
		basicMap.put("break", this.getIntArray(CMD_break) );
		basicMap.put("continue", this.getIntArray(CMD_continue) );
		basicMap.put("text", this.getIntArray(CMD_text) );
		basicMap.put("waittext", this.getIntArray(CMD_WaitText) );
		basicMap.put("print", this.getIntArray(CMD_print) );
		basicMap.put("printf", this.getIntArray(CMD_print) );
	}
	
	
	/**
	 *R}hƃR[h̑Δ\o^ 
	 */
	private void initCommandCode(){
		cmdMap = new HashMap <String , int[]>();

		cmdMap.put("setcellnumber", this.getIntArray(CMD_setCellNumber) );
		cmdMap.put("setcellimage", this.getIntArray(CMD_setCellImage) );
		cmdMap.put("setcellposition", this.getIntArray(CMD_setCellPosition) );
		cmdMap.put("setcellsize", this.getIntArray(CMD_setCellSize) );
		cmdMap.put("setcelltranscolor", this.getIntArray(CMD_setCellTransColor) );
		cmdMap.put("setcellflag", this.getIntArray(CMD_setCellFlag) );
		cmdMap.put("setcellcanvas", this.getIntArray(CMD_setCellCanvas) );
		cmdMap.put("setcelltextparam", this.getIntArray(CMD_setCellTextParam) );
		cmdMap.put("setcelltext", this.getIntArray(CMD_setCellText) );
		cmdMap.put("setshiftview", this.getIntArray(CMD_setShiftView) );
		cmdMap.put("setshifthide", this.getIntArray(CMD_setShiftHide) );
		cmdMap.put("viewdisplay", this.getIntArray(CMD_viewDisplay) );
		cmdMap.put("transitiondisplay", this.getIntArray(CMD_transitionDisplay) );
		cmdMap.put("showimage", this.getIntArray(CMD_viewDisplay) );
		cmdMap.put("setdisplaysize", this.getIntArray(CMD_setDisplaySize) );
		cmdMap.put("wait", this.getIntArray(CMD_wait) );
		cmdMap.put("setfontcolor", this.getIntArray(CMD_setFontColor) );
		cmdMap.put("settextfont", this.getIntArray(CMD_setFont) );
		cmdMap.put("setfont", this.getIntArray(CMD_setFont) );
		cmdMap.put("settextarea", this.getIntArray(CMD_setTextArea) );
		cmdMap.put("settextinterval", this.getIntArray(CMD_setTextInterval) );
		cmdMap.put("select", this.getIntArray(CMD_select) );
		cmdMap.put("setselectarea", this.getIntArray(CMD_setSelectArea) );
		cmdMap.put("setselectcolor", this.getIntArray(CMD_setSelectColor) );
		cmdMap.put("setselectfont", this.getIntArray(CMD_setSelectFont) );
		cmdMap.put("midiload", this.getIntArray(CMD_midiLoad) );
		cmdMap.put("midiplay", this.getIntArray(CMD_midiPlay) );
		cmdMap.put("midistop", this.getIntArray(CMD_midiStop) );
		cmdMap.put("audioloop", this.getIntArray(CMD_audioLoop) );
		cmdMap.put("audioplay", this.getIntArray(CMD_audioPlay) );
		cmdMap.put("audiostop", this.getIntArray(CMD_audioStop) );
		cmdMap.put("soundloop", this.getIntArray(CMD_audioLoop) );
		cmdMap.put("soundplay", this.getIntArray(CMD_audioPlay) );
		cmdMap.put("soundstop", this.getIntArray(CMD_audioStop) );
		cmdMap.put("cliploop", this.getIntArray(CMD_clipLoop) );
		cmdMap.put("clipstop", this.getIntArray(CMD_clipStop) );
		cmdMap.put("setwaittime", this.getIntArray(CMD_setWaitTime) );
		cmdMap.put("cellclick", this.getIntArray(CMD_cellClick) );
		cmdMap.put("debug", this.getIntArray(CMD_debug) );
		cmdMap.put("display", this.getIntArray(CMD_display) );
		cmdMap.put("save", this.getIntArray(CMD_save) );
		cmdMap.put("load", this.getIntArray(CMD_load) );		
		cmdMap.put("random", this.getIntArray(CMD_random) );
		cmdMap.put("abs", this.getIntArray(CMD_abs) );
		
		
		/* R}h`t@Cǂݍޏ͂Ƃ肠Ȃ
		try {
			FileInputStream fis = new FileInputStream(Groot+CMD_file);
			InputStreamReader isr = new InputStreamReader(fis , "MS932");
			BufferedReader br = new BufferedReader(isr);
			while ( (line= br.readLine()) != null ) {
				line = line.trim();
				if ( line.length() == 0 ) continue ;
				if ( line.charAt(0) == '#') continue ;
				if ( line.charAt(0) == '/' && line.charAt(1) == '/' ) continue ;
				st = new StringTokenizer(line ,",= :",false);
				cmd = st.nextToken().trim().toLowerCase();
				cmdMap.put(cmd , this.getIntArray(Integer.parseInt(st.nextToken() ,10)) );
				//System.err.println("Command:"+cmd+" / "+code[0]+"/"+cmdMap.get(cmd).toString());
			}
			isr.close();
			fis.close();
		} catch (Exception e) {
		}*/
		
		return ;
	}

	/**
	 * XNvg
	 *
	 */
	public void initScript() {
		this.scriptParams = new Vector < Vector<String> > () ;
		this.scriptCode = new Vector <int[]> () ;
		this.scriptPointer = 0 ;
		//x
		this.labelMap = new HashMap <String,int[]> () ;
		//Begin'{'End'{'X^bN
		this.parStack = new Stack <int[]> () ;
		//Gosub ReturnX^bN
		this.subroutineStack = new Stack <int[]> () ;		
	}
	
	
	/**
	 * XNvgǂݍݕAxƃR[hƃp[^ɂ
	 * @param scfile
	 */
	public void getScript(String scpath,String txtcode) {
		String line  , label ;
		Vector <String> vct0 , vct1 , vct2 , scr ;
		int code , pos , bpos , epos , funcpos , fcode;
		String scfile ;
		
		//XNvg
		this.initScript();
		
		if ( txtcode.equals("string") ) {
			//ɂXNvg̏ꍇ
			this.setScriptOneLine(scpath);
		} else {
			System.out.println("SCRIPT_PATH:"+scpath);
			scr = this.urlSeparator(scpath);
			System.out.println("URL:"+scr.get(0));
			System.out.println("DIR:"+scr.get(1));
			System.out.println("SCR:"+scr.get(2));
			scfile = scr.get(2);
			//GameRecroot𓾂
			this.Groot = scr.get(1) +"/" ;
			if (this.sound != null) sound.setGameRoot(this.Groot);
			if (this.dmng != null) dmng.setGameRoot(this.Groot);
			if ( scr.get(0).trim().length() > 0 ) {
				this.jongsnet = new jongsNet(scr.get(0),scr.get(1));
			}
			//T[oXNvgt@C𓾂
			if ( this.jongsnet != null) this.jongsnet.getServerFile(scfile);
			
			//XNvgt@Cǂ
			try {
				FileInputStream fis = new FileInputStream(Groot+scfile);
				System.out.println("JONGS GetScript:"+Groot+scfile+":CODE:"+txtcode);
	            InputStreamReader isr = new InputStreamReader(fis, txtcode);
				BufferedReader br = new BufferedReader(isr);
				while ( (line= br.readLine()) != null ) {
					line = line.trim();
					if ( line.length() == 0 ) continue ;
					//s̃XNvg𕪉o^
					this.setScriptOneLine(line) ;
				}
				isr.close();
				fis.close();
			} catch (Exception e) {
				Error(8,"XNvgt@C["+scfile+"]ǂݍ߂܂");
			}			
		}

		//{ }̂Ȃ if else for while Ɂ@{@}t
		for (pos = 0 ; pos < this.scriptCode.size() ; pos++ ) {
			code = this.scriptCode.get(pos)[0];
			switch (code) {
			case CMD_if:
			case CMD_else:
			case CMD_while:
			case CMD_for:
				bpos = pos+1 ;
				if ( bpos == this.scriptCode.size() ) break ;
				code = this.scriptCode.get(bpos)[0];
				// if else for while@̎ {łȂꍇ
				if (code != CMD_begin) {
					
					this.scriptCode.add(pos+2,this.getIntArray(CMD_end));
					vct0 = new Vector <String> ();
					vct0.add("end");
					this.scriptParams.add(pos+2,vct0);					

					this.scriptCode.add(pos+1,this.getIntArray(CMD_begin));
					vct0 = new Vector <String> ();
					vct0.add("begin");
					this.scriptParams.add(pos+1,vct0);					
				}
				
				break ;
			default :
				break ;
			}
		}
		
		//xo^
		for (pos = 0 ; pos < this.scriptCode.size() ; pos++ ) {
			code = this.scriptCode.get(pos)[0];
			if ( code == CMD_label ){
				vct0 = this.scriptParams.get(pos);
				label = vct0.get(1);
				if ( label.length() > 0 ) {
					if ( this.labelMap.containsKey(label) ) 
						this.Error(8, "x["+label+"]dĂ܂B");	
					this.labelMap.put(label, this.getIntArray(pos));
				}
			}
		}
		

		//XNvgŜ{(begin) }(end)̑ΉÂ
		this.parStack.clear();
		for (pos = 0 ; pos < this.scriptCode.size() ; pos++ ) {
			code = this.scriptCode.get(pos)[0];
			if ( code == CMD_begin ) {
				this.parStack.push(this.getIntArray(pos));
			} else if ( code == CMD_end ) {
				//XNvg{Ȃ̂}oꂵ
				if ( this.parStack.size() == 0) 
					this.Error(8, "XNvǵop̑ΉƂĂ܂Ap悤ł");
				bpos = this.parStack.pop()[0];
				epos = pos ;
				funcpos = bpos - 1 ;
				
				//{}̏@\𓾂
				if ( funcpos < 0 ) 
					this.Error(8, "op̋Lqʒusł");
				
				//{(begin)ɂ }(end)w
				vct1 = this.scriptParams.get(bpos);
				vct1.add( Integer.toString(epos) );
				
				//}(end)ɂ {(begin)w
				vct2 = this.scriptParams.get(epos);
				vct2.add( Integer.toString(bpos) );

				//(begin)(end)𓝊@\R}h𕡎
				vct0 = this.scriptParams.get(funcpos);
				fcode = this.scriptCode.get(funcpos)[0];
				//@\
				vct1.add( vct0.get(0) ) ;
				vct2.add( vct0.get(0) ) ;
				if ( fcode == CMD_while ) {
					if ( vct0.size() < 2 )
						this.Error(8, "WHILE̍\Ɍ肪܂B");
					vct2.add( vct0.get(1) ) ;
				} else if ( fcode == CMD_for ) {
					if ( vct0.size() < 4 )
						this.Error(8, "FOR̍\Ɍ肪܂B");
					vct2.add( vct0.get(2) ) ;					
					vct2.add( vct0.get(3) ) ;										
				}
			}
		}
		//XNvg}s
		if ( this.parStack.size() > 0) {
			this.scriptPointer = this.parStack.pop()[0];
			this.Error(8, "XNvǵop̑ΉƂĂ܂B}sł");
		}
				
		return ;		
	}
	

	/**
	 * XNvgURLURLAfBNgAXNvg𓾂
	 * @param scr_url
	 * @return
	 */
	public Vector<String> urlSeparator(String scr_url) {
		Vector<String> vs = new Vector<String>();
		int pos1 , pos2 ;		
		String url,dir,scr ;
		
		scr_url = scr_url.trim();
		
		pos1 = scr_url.lastIndexOf('/');
		if ( pos1 > -1  ) {
			dir = scr_url.substring(0, pos1).trim();
			scr = scr_url.substring(pos1+1).trim();
			pos2 = dir.lastIndexOf('/');
			if ( pos2 > -1 && dir.charAt(pos2+1) != '~' ) {
				url = dir.substring(0,pos2);
				dir = dir.substring(pos2+1);
			} else {
				url = "";
			}
		} else {
			url = "";
			dir = "";
			scr =  scr_url.trim();
		}
		
		vs.add(url);
		vs.add(dir);
		vs.add(scr);
		
		return vs ;
	}

	
	/**
	 * s;ŋ؂XNvgo^
	 * @param line
	 */
	private void setScriptOneLine (String line) {
		StringTokenizer st ;
		String token ;
		st = new StringTokenizer(line ,";",false);
		while (st.countTokens() > 0) {
			token = st.nextToken().trim();
			if ( token.length() > 0 ) this.setScriptOneCommand( token ) ;			
		}
	}
	
	
	/**
	 * s̃XNvg𕪉F
	 * @param ln
	 */
	private void setScriptOneCommand(String ln) {
		int pos , pos1 , pos2 ;
		int [] bcode;
		boolean flag ;
		String line , label , token1 , token2 , token3;
		Vector <String> vc;

		now_Line = line = ln.trim() ;
		if ( line.length() == 0 ) return ;
		
		//߈ʒu
		pos = line.indexOf("//") ;
		//s̒߂폜
		if ( pos != -1 ) {
			flag =true ;
			// () ̓//͍폜Ȃ
			pos1 = line.indexOf('(') ;
			pos2 = line.indexOf(')') ;
			if  ( pos1 < pos && pos2 != -1 && pos < pos2 ) flag = false ;
			// "" ̓//͍폜Ȃ
			pos1 = line.indexOf('\"') ;			
			if ( pos1 != -1 ) {
				pos2 = line.indexOf('\"', pos1) ;
				if ( pos2 != -1 ) {
					if ( pos1 < pos && pos < pos2 ) flag = false ;
				}
			}
			if ( flag ) {
				line = line.substring(0,pos); 
				line = line.trim() ;
				if ( line.length() == 0 ) return ;								
			}
 		}

		//x
		pos = line.indexOf(':') ;
		pos1 = line.indexOf('(') ;
		pos2 = line.indexOf('\"') ;
		
		//xCASEo^
		if ( pos != -1 ) {
			flag =true ;
			// () ̓:̓xECASEƔFȂ
			pos1 = line.indexOf('(') ;
			pos2 = line.indexOf(')') ;
			if  ( pos1 < pos && pos2 != -1 && pos < pos2 ) flag = false ;
			// "" ̓:̓xECASEƔFȂ
			pos1 = line.indexOf('\"') ;			
			if ( pos1 != -1 ) {
				pos2 = line.indexOf('\"', pos1) ;
				if ( pos2 != -1 ) {
					if ( pos1 < pos && pos < pos2 ) flag = false ;
				}
			}
			//x݂̑𔻒肵ꍇ
			if ( flag ) {
				label = line.substring(0,pos).trim();			
				//CASEH
				pos2 = label.indexOf(' ');
				if ( pos2 < 0 ) pos2 = label.indexOf('\t');		
				if ( pos2 > 0  ){
					token1 = label.substring(0,pos2).toLowerCase();
					if ( basicMap.get(token1)[0] == CMD_case ) {
						token2 = label.substring(pos2).trim();
						this.scriptCode.add(basicMap.get(token1));
						this.scriptParams.add(this.getParams(token1+","+token2));
						line = line.substring(pos+1).trim();
						//CASĚɍ\݂Ή͂p
						//if ( line.length() == 0 ) return ;
						if (line.length() > 0 ) setScriptOneLine(line);
						return ;
					} else {
						Error(16,"xɋ󔒂TAB̊܂܂镶gpł܂["+line+"]");
					}
				} else {
					//xƂēo^iʒu͖mj
					token1 = "label";
					token2 = line.substring(0,pos).trim();
					this.checkLabelName(token2);
					this.scriptCode.add(basicMap.get(token1));
					this.scriptParams.add(this.getParams(token1+","+token2));
					line = line.substring(pos+1).trim();
					//x̌ɍ\݂Ή͂p
					//if ( line.length() == 0 ) return ;
					if (line.length() > 0 ) setScriptOneLine(line);
					return ;				
				}
			}
		}
		
				
		//{beginƂ
		if ( line.charAt(0) == '{' ) {
			token1 = "begin" ;
			this.scriptCode.add(basicMap.get(token1));
			vc = new Vector <String> ();
			vc.add(token1);
			this.scriptParams.add(vc);
			line = line.substring(1).trim();
			if (line.length() > 0 ) setScriptOneLine(line);
			return ;
		}
		
		//}endƂ
		if ( line.charAt(0) == '}' ) {
			token1 = "end" ;
			this.scriptCode.add(basicMap.get(token1));
			vc = new Vector <String> ();
			vc.add(token1);
			this.scriptParams.add(vc);			
			line = line.substring(1).trim();
			if (line.length() > 0 ) setScriptOneLine(line);
			return ;
		}		
		
		//ϐ錾Ȃׂ
		pos = line.indexOf(' ');
		if ( pos < 0 ) pos = line.indexOf('\t');
		pos2 = line.indexOf('(');
		//s'('Ȃp󔒂TABΐ錾ł͂ȂƃA^B
		if ( pos > 0 && ( pos2 < 0 || pos < pos2 ) ) {
			token1 = line.substring(0,pos).trim().toLowerCase();
			//擪̕񂪕ϐ^ɑ݂邩ǂŐ錾̗L𔻒fB
			if (typeMap.containsKey(token1)) {
				//ϐ̓o^
				token2 = line.substring(pos).trim();
				this.VarResist(token2,typeMap.get(token1)[0]);
				return ;
			} else if( basicMap.containsKey(token1) ) {
				//ڂ̃g[N{n̗\ꂾꍇ
				bcode = basicMap.get(token1);
				//elsȅꍇ
				if ( bcode[0] == CMD_else ) {
					//sR[hXNvgɓo^
					this.scriptCode.add(bcode);					
					this.scriptParams.add( this.getParams(token1) );
					token3 = line.substring(pos).trim();
					if (token3.length() > 0 ) setScriptOneLine(token3);
					return  ;
				}
			}
		}

		//s̉
		//System.out.println("setScriptOneLine:"+line);
		pos1 = line.indexOf('(');
		if ( pos1 > 0 ) {
			//(̎ÕR}ho
			token1 = line.substring(0,pos1).trim().toLowerCase();
			pos2 = this.ParenthesesIndexOf(line, pos1 , '(', ')' );
			//p[^o
			token2 = line.substring(pos1+1,pos2);
			if ( basicMap.containsKey(token1) ) {
				//ڂ̃g[N{n̗\ꂾꍇ
				//sR[hXNvgɓo^
				this.scriptCode.add(basicMap.get(token1));
				this.scriptParams.add( this.getParams(token1+","+token2));
				//{ň͌pĎ̍sƌȂ
				if ( pos2 > 0 && pos2 < line.length()) {
					token3 = line.substring(pos2+1).trim();
					if (token3.length() > 0 )
						setScriptOneLine(token3);	
				}	
				return  ;
			} else if ( cmdMap.containsKey(token1) ) {
				//ڂ̃g[NR}h̗\ꂾꍇ
				//̍sR[hXNvgɓo^
				this.scriptCode.add(cmdMap.get(token1));
				this.scriptParams.add( this.getParams(token1+","+token2) );
				return  ;
			}
		} else {
			pos1 = line.indexOf('{');
			if ( pos1 < 0 ) pos1 = line.length();
			token1 = line.substring(0,pos1).trim().toLowerCase();
			if ( basicMap.containsKey(token1) ) {
				//ڂ̃g[N{n̗\ꂾꍇ
				//sR[hXNvgɓo^
				this.scriptCode.add(basicMap.get(token1));
				this.scriptParams.add( this.getParams(token1));
				//{ň͌pĎ̍sƌȂ
				if ( pos1 > 0 && pos1 < line.length()) {
					token3 = line.substring(pos1).trim();
					if (token3.length() > 0 )
						setScriptOneLine(token3);	
				}	
				return  ;
			}			
		}
		
		if ( this.isSubstitution(line) ) {
			//̓oȂ΁A{R}h̑ƂĈ
			token1 = "set";
			this.scriptCode.add(basicMap.get(token1));
			vc = new Vector <String> ();
			vc.add(token1);
			vc.add(line);
			this.scriptParams.add(vc);
		} else {
			//SĂɈȂ΃XNvg̑䎌Ɖ߂
			token1 = "text";
			this.scriptCode.add(basicMap.get(token1));
			vc = new Vector <String> ();
			vc.add(token1);
			vc.add(line);			
			this.scriptParams.add(vc);
		}
		
		return  ;
	}

	
	/**
	 * 񂪃xƂēK؂ۂf
	 * @param lblstr
	 */
	private void checkLabelName (String lblstr) {
		String cannotUseChar = "!\"#$%&'()*+,-./:;<=>?[\\]^`{|}~";
		int n ;
		String lbl = lblstr.trim();
		if (this.labelMap.containsKey(lbl))
			Error(8,"x["+lblstr+"]͏dĂ܂B");
		if (this.basicMap.containsKey(lbl))
			Error(8,"x["+lblstr+"]͗\ło^ł܂B");
		if (this.cmdMap.containsKey(lbl))
			Error(8,"x["+lblstr+"]͗\ło^ł܂B");
		if (this.typeMap.containsKey(lbl))
			Error(8,"x["+lblstr+"]͗\ło^ł܂B");
		for ( n = 0 ; n < lbl.length() ; n++ ) {
			if ( cannotUseChar.indexOf(lbl.charAt(n)) > -1 ) 
				Error(8,"xɎgpĂ͂ȂȂgpĂ܂B["+lblstr+"]");
		}
	}
	
	/**
	 * 񂪕ϐƂēK؂ۂf
	 * @param lblstr
	 */
	private void checkVariableName (String vstr) {
		String cannotUseChar = "!\"#$%&'()*+,-./:;<=>?[\\]^`{|}~";
		int n ;
		String var = vstr.trim();
		if (this.varIntMap.containsKey(var))
			Error(8,"ϐ["+var+"]͏dĂ܂B");
		if (this.varStrMap.containsKey(var))
			Error(8,"ϐ["+var+"]͏dĂ܂B");
		if (this.basicMap.containsKey(var))
			Error(8,"ϐ["+var+"]͗\ło^ł܂B");
		if (this.cmdMap.containsKey(var))
			Error(8,"ϐ["+var+"]͗\ło^ł܂B");
		if (this.typeMap.containsKey(var))
			Error(8,"ϐ["+var+"]͗\ło^ł܂B");
		if ( '0' <= var.charAt(0) && var.charAt(0) <= '9')
			Error(8,"ϐ̐擪ɔpgpĂ܂B["+var+"]");			
		for ( n = 0 ; n < var.length() ; n++ ) {
			if ( cannotUseChar.indexOf(var.charAt(n)) > -1 ) 
				Error(8,"ϐɎgpĂ͂ȂȂgpĂ܂B["+var+"]");
		}
	}
	
	
	
	/**
	 * ̍sǂ\z肷
	 * @param line
	 * @return
	 */
	private boolean isSubstitution(String line) {
		int pos0 , pos1 ;
		String token;
		
		//Zq̑݉\T
		pos0 = line.indexOf('=');
		//System.out.println("isSubstitution:"+line+":"+pos0);
		/*
		if ( pos0 < 0 ) pos0 = line.indexOf("++");
		if ( pos0 < 0 ) pos0 = line.indexOf("--");
		if ( pos0 < 0 ) pos0 = line.indexOf("+=");
		if ( pos0 < 0 ) pos0 = line.indexOf("-=");
		if ( pos0 < 0 ) pos0 = line.indexOf("*=");
		if ( pos0 < 0 ) pos0 = line.indexOf("/=");
		if ( pos0 < 0 ) pos0 = line.indexOf("%=");
		*/
		
		//Zq
		if (pos0 > 0) {
			//zϐ
			pos1 = line.indexOf('[');
			if ( pos1 > 0 && pos1 < pos0 ) {
				pos0 = pos1 ;
			}
			
			//Ă̂錾ꂽϐǂ肷
			token = line.substring(0,pos0).trim();
			if ( this.varIntMap.containsKey(token) ) return true ;
			if ( this.varStrMap.containsKey(token) ) return true ;	
		}
		
		return false ;
	}
	
	
	/**
	 * ϐo^
	 * @param line
	 * @param varkind
	 */
	private void VarResist(String line , int varkind) {
		int n , pos , epos ;
		int vmat ;
		String varName , var  , vl ;
		Vector <String> vc = this.getParams(line);
		
		for (n = 0 ; n < vc.size() ; n++) {
			var = vc.get(n);
			varName = var ;
			vmat = 0 ;
			if ( var.indexOf('[') > 0 ) {
				pos = var.indexOf('[');
				varName = var.substring(0,pos).trim();
				//[]̃yAƂ
				epos = this.ParenthesesIndexOf(var, pos , '[', ']');
				vl = var.substring(pos+1,epos);
				//[]̐l𓾂
				vmat = this.Calc(vl) ;
			}
			
			//ϐƂĐ錾łȂϐ̏ꍇ̓G[Ƃ
			this.checkVariableName(varName);
			
			//^̏
			switch ( varkind ) {
			case TYPE_int:								
				switch (vmat) {
				
				case 0:
					int [] intVar0 = new int[1];
					this.varIntMap.put(varName, intVar0);
					break ;
				
				default :
					int [] intVar1 = new int[vmat];
					this.varIntMap.put(varName, intVar1);				
					break ;
				
				}
				break ;
			
			case TYPE_str:				
				switch (vmat) {
				case 0:
					String [] strVar0 = new String[1];
					varStrMap.put(varName, strVar0);				
					break ;
				
				default :
					String [] strVar1 = new String[vmat];
					varStrMap.put(varName, strVar1);				
					break ;
				
				}
				break ;
			
			}
		}		
	}
	
	
	/**
	 * []ŋ؂ꂽ𕪉VectorɂĕԂ
	 * @param var
	 * @return
	 */
	public Vector <String> getArrayMatrixParams(String var) {
		Vector <String> vc = new Vector <String>() ;
		String token ;
		int pos , pos1  ;
		pos = var.indexOf('[');
		
		//[]ŋ؂ꂽvf͂Ȃ
		if ( pos < 0 ) {
			vc.add(var.trim());
			return vc ;
		}

		//vfVectorɊi[
		token = var.substring(0,pos).trim();
		vc.add(token);
		
		while ( pos > 0 ) {
			//'['ɑΉ']'̈ʒu
			pos1 = this.ParenthesesIndexOf(var, pos, '[', ']');
			if (pos1 == -1 ) this.Error(8, "[]̑ΉƂĂ܂["+var+"]");
			token = var.substring(pos+1,pos1);
			vc.add(token);
			pos = var.indexOf('[',pos1);
		}
		
		return vc ;
	}

	
	/**
	 * ,ŋ؂ꂽp[^𕪉VectorɂĕԂ
	 * @param pline
	 * @return
	 */
	private Vector <String> getParams(String pline) {
		StringTokenizer st ;
		Vector <String>params = new Vector <String>();
		st = new StringTokenizer(pline ,",",false);
		while (st.countTokens() > 0) 
			params.add( st.nextToken().trim() ) ;
		return params;
	}
	

	private Vector <String> stringToVector(String pline , String pt) {
		Vector <String> vct = new Vector <String>();
		int pb , pe , ptlen ;
		
		ptlen = pt.length();
		pb = 0 ;
		
		while ( ( pe = pline.indexOf(pt,pb) ) >= 0) {
			vct.add(pline.substring(pb,pe));
			pb = pe + ptlen  ;
		}
		vct.add(pline.substring(pb) );
		
		return vct;
	}
	
	
	/**
	 * 	݂̃XNvg̏Ԃ\(fobOp)
	 *
	 */
	public void outScriptState() {
		Object [] keys;
		
		System.err.println("----------------------------");
		System.err.println("----- JONG Script State-----");
		System.err.println("----------------------------");
		
		System.err.println("{^");
		keys = this.typeMap.keySet().toArray();
		for ( int n = 0 ; n < keys.length ; n ++  ) {
			System.err.print("KEY:"+keys[n]);
			System.err.println(" CODE:"+this.typeMap.get(keys[n])[0]);
		}		
		System.err.println();
		
		System.err.println("{R}h");
		keys = this.basicMap.keySet().toArray();
		for ( int n = 0 ; n < keys.length ; n ++  ) {
			System.err.print("KEY:"+keys[n]);
			System.err.println(" CODE:"+this.basicMap.get(keys[n])[0]);
		}		
		System.err.println();
		
		System.err.println("o^R}h");
		keys = this.cmdMap.keySet().toArray();
		for ( int n = 0 ; n < keys.length ; n ++  ) {
			System.err.print("KEY:"+keys[n]);
			System.err.println(" CODE:"+this.cmdMap.get(keys[n])[0]);
		}		
		System.err.println();
		
		System.err.println("x");
		keys = this.labelMap.keySet().toArray();
		for ( int n = 0 ; n < keys.length ; n ++  ) {
			System.err.print("KEY:"+keys[n]);
			System.err.println(" CODE:"+this.labelMap.get(keys[n])[0]);
		}		
		System.err.println();

		System.err.println("XNvg");
		for ( int n = 0 ; n < this.scriptCode.size() ; n ++  ) {
			int [] code  = this.scriptCode.get(n);
			Vector vct = this.scriptParams.get(n);
			String cs = "0000"+code[0] ;
			String ln = "000"+n ;
			System.err.print(ln.substring(ln.length()-3));
			System.err.print(" Cmd:"+cs.substring(cs.length()-4));
			System.err.println(" Param["+vct.size()+"]"+vct.toString());
		}	
	}
	
	
	/**
	 * 	Zq̍ӂɉEӂ
	 * @param line
	 */
	private void setVariable(String line) {
		int pos0 ;
		String varName , param ;
		//Zq̈ʒu𓾂
		pos0 = line.indexOf('=');
		
		varName = line.substring(0,pos0);
		param = line.substring(pos0+1).trim();
		if ( this.isIntVar(varName) ) {
			this.setVarIntValue(varName, this.Calc(param));			
		} else if ( this.isStrVar(varName) ) {
			this.setVarStrValue(varName, this.getStrValue(param));						
		}
	}

	/**
	 * ŕ\Pڂ̐lԋp
	 * @param intstr
	 * @return
	 */
	private int getIntValue(String intstr) {
		int value ;
		String str = intstr.trim();
		if ( this.isIntVar(str) ) {
			//ϐȂΒlԂ
			return getVarIntValue(str);
		} else {
			//łȂΐlƂĕԂ
			value = strToInt(str) ;
			if ( value != 0 ) return value ;
			if ( str.charAt(0) != '0') {
				this.Error(8,"["+str+"]Ƃl^̕ϐ݂͑܂");
			}
			return 0;		
		}
	}
		
	/**
	 * XNvgŕ\镶ԋp
	 * @param scrtext
	 * @return
	 */
	private String getStrValue(String scrtext) {
		String str = scrtext.trim();
		char tc = str.charAt(0);
		if ( tc == '+' ) str = str.substring(1);
		
		if ( this.isStrVar(str) )
			str = this.getVarStrValue(str);
		else if ( this.isIntVar(str) )
			str = ""+ this.getVarIntValue(str) ;
		else if ( str.indexOf('+') >= 0 ) 
			str = this.strToStr(str);
		else {
			if ( str.charAt(0) == '\"' && str.charAt(str.length()-1)== '\"') 
				str = str.substring(1,str.length()-1);  
		}
		
		if ( tc == '+' ) str = "+" + str;

		return str;
	}

	
	/**
	 * +sԋp
	 * @param str
	 * @return
	 */
	private String strToStr(String str) {
		String text , token;
		StringTokenizer st ;
		st = new StringTokenizer(str ,"\"+",false);
		text = "";
		while ( st.hasMoreTokens() ) {
			token = st.nextToken();
			if ( this.isIntVar(token) ) {
				text = text + this.getIntValue(token);
			} else if ( this.isStrVar(token) ) { 
				text = text + this.getVarStrValue(token);
			} else {
				text = text + token ;
			}
		}
		return text;
	}
	
	/**
	 * PUi̕ȂPUiԂB
	 * POi̕ȂPOiԂB
	 * łȂ0Ԃ
	 * @param str
	 * @return
	 */
	private int strToInt (String str) {
		int DataVAL = 0 ;
		String DataStr ;
		if ( str.length() == 0 ) return 0;
		if ( str.charAt(0) == '-' ||  str.charAt(0) == '+' )
			DataStr = str.substring(1);
		else 
			DataStr = str ;
		try {
			if ( DataStr.length() > 2 && DataStr.charAt(0)=='0' &&  DataStr.charAt(1)=='x' ){
				//DataVAL =Integer.parseInt( DataStr.substring(2) ,16);
				DataVAL = ( int ) ( Long.parseLong( DataStr.substring(2) , 16 ) & 0x00ffffffff ) ;
				//System.out.println("strToInt:"+DataStr+"="+ DataVAL +":"+Integer.toHexString(DataVAL));
			} else if ( DataStr.charAt(0) >= '0' &&  DataStr.charAt(0) <= '9' ){
				DataVAL =Integer.parseInt( DataStr , 10 );
				//System.out.print("strToInt:"+DataStr+"="+ DataVAL);
			} else DataVAL = 0 ;
		} catch(NumberFormatException murle) {
			return 0;
		}
		
		if ( str.charAt(0) == '-') DataVAL = -DataVAL ;	
		return DataVAL ;
	}

	/**
	 * l^ϐ̒lԂ
	 * @param str
	 * @return
	 */
	private int getVarIntValue(String str) {
		int [] varMat ;
		int m ;
		Vector <String> vc = this.getArrayMatrixParams(str);
		varMat = (int []) this.varIntMap.get(vc.get(0).trim());
		if (varMat == null) this.Error(8, "ϐ"+vc.get(0).trim()+"݂͑܂B");
		//złȂϐ
		if ( vc.size() == 1 ) return varMat[0];
	
		//1z̕ϐ
		m = this.Calc( vc.get(1) );				
		return varMat[m];
	}

	/**
	 * ^ϐ̒lԂ
	 * @param str
	 * @return
	 */
	private String getVarStrValue(String str) {
		String [] varMat ;
		int m ;
		Vector <String> vc = this.getArrayMatrixParams(str);
		varMat = (String []) this.varStrMap.get( vc.get(0).trim() ) ;
		if (varMat == null) this.Error(8, "ϐ"+vc.get(0).trim()+"݂͑܂B");
		//złȂϐ
		if ( vc.size() == 1 ) return varMat[0];
	
		//1z̕ϐ
		m = this.getIntValue( vc.get(1) );				
		return varMat[m];
	}


	/**
	 * l^ϐɒlZbg
	 * @param str
	 * @param val
	 */
	private void setVarIntValue(String str , int val) {
		int [] varMat ;
		int m ;
		Vector <String> vc = this.getArrayMatrixParams(str);
		varMat = (int []) this.varIntMap.get(vc.get(0).trim());
		//System.out.print("setVarIntName"+vc.get(0)+":"+varMat[0]);
		//złȂϐ
		if ( vc.size() == 1 ) {
			varMat[0] = val ;
		} else {
			//1z̕ϐ
			m = this.Calc( vc.get(1) );
			if ( m < varMat.length )
				varMat[m] = val;
			else 
				this.Error(8, "ϐ"+str+"̔zYI[o["+m+"܂");
		}
		return ;
	}
	
	/**
	 * ^ϐɒlZbg
	 * @param str
	 * @param val
	 */
	private void setVarStrValue(String str , String val) {
		String [] varMat ;
		int m ;
		Vector <String> vc = this.getArrayMatrixParams(str);
		varMat = (String[]) this.varStrMap.get(vc.get(0).trim());
		//złȂϐ
		if ( vc.size() == 1 ) {
			varMat[0] = val ;
		} else {
			//1z̕ϐ
			m = this.Calc( vc.get(1) );
			if ( m < varMat.length )
				varMat[m] = val;
			else 
				this.Error(8, "ϐ"+str+"̔zYI[o["+m+"܂");
		}
		return ;
	}

	
	/**
	 * 񂪐l^ϐƂđ݂true
	 * łȂfalseԂ
	 * @param str
	 * @return
	 */
	private boolean isIntVar(String str) {
		String varName ;
		int pos ;
		if ( str.length() == 0 ) return false ;
		pos = str.indexOf('[');
		if ( pos > 0 ) varName = str.substring(0,pos).trim() ;
		else varName = str.trim() ;
		return  this.varIntMap.containsKey(varName);
	}

	/**
	 * 񂪕^ϐƂđ݂true
	 * łȂfalseԂ
	 * @param str
	 * @return
	 */
	private boolean isStrVar(String str) {
		String varName ;
		int pos ;
		if ( str.length() == 0 ) return false ;
		pos = str.indexOf('[');
		if ( pos > 0 ) varName = str.substring(0,pos).trim() ;
		else varName = str.trim() ;
		//System.out.println("\nisStrVar:"+varName);
		return  this.varStrMap.containsKey(varName);
	}

	/**
	 * vZƂĔFAvZʂԂ
	 * @param calcStr
	 * @return
	 */
	public int Calc ( String calcStr ){
		int ans = 0;
		if ( calcStr.indexOf('(') < 0 ) {
			//System.out.print("Calc:" +calcStr);
			ans = singleCalc(calcStr) ;
		} else {
			ans = parenthesesCalc(calcStr);
			//System.out.println("Calc:"+calcStr);
		}
		return ans;
	}
	
	
	/**
	 * ()łꂽvf̂vZƂĔFAvZʂԂ
	 * @param str
	 * @return
	 */
	public int parenthesesCalc( String str ) {
		int ans = 0;
		int pos0 , pos1 , n , val0 ;
		Vector <String> cObj  ;
		Vector <int[]> valObj  ;
		String opeObj , objStr ;
		String calcStr = str.trim();
		char c ;
		
		String operator = "+-*/%";
		if ( calcStr.charAt(0) == '-' ) 
			calcStr = "0"+str.trim() ;
				
		cObj = new Vector <String> () ;
		opeObj = "";
		pos0 = pos1 = 0 ;
		
		while (  pos1 < calcStr.length()  ) {
			c = calcStr.charAt(pos1);
			if ( operator.indexOf(c) >= 0) {
				objStr = calcStr.substring(pos0,pos1).trim() ;
				if ( objStr.charAt(0) == '(' ) {
					objStr = objStr.substring(1,objStr.length()-1).trim();
				}
				cObj.add( objStr );
				pos0 = pos1 + 1;
				opeObj = opeObj + calcStr.substring(pos1,pos0) ;
			} else if ( c == '(' ) {
				//()͂Ƃ΂
				pos1 = this.ParenthesesIndexOf(calcStr, pos1 , '(', ')');
			} else if ( c == '[' ) {
				//zϐ[]͂Ƃ΂
				pos1 = this.ParenthesesIndexOf(calcStr, pos1 , '[', ']');
			} 
			pos1 ++ ;
		}
		cObj.add(calcStr.substring(pos0,pos1).trim() );		

		valObj = new Vector <int[]> () ;
		for ( n = 0 ; n < cObj.size() ; n++ ) {
			val0 = Calc( cObj.get(n) );
			valObj.add(this.getIntArray(val0));
		}

		ans = this.vectorCalc(valObj, opeObj);
		
		return ans;
		
	}
	
	/**
	 * 𕡐vf̂vZƂĔFAvZʂԂ
	 * @param str
	 * @return
	 */
	private int singleCalc( String str ) {
		int ans = 0;
		int pos0 , pos1 , n , val0 ;
		Vector <String> cObj  ;
		Vector <int[]> valObj  ;
		String opeObj ;
		String calcStr = str.trim();
		char c ;
		
		String operator = "+-*/%";
		
		if ( calcStr.charAt(0) == '-' ) calcStr = "0"+str.trim() ;
				
		cObj = new Vector <String> () ;
		opeObj = "";
		pos0 = pos1 = 0 ;
		
		while (  pos1 < calcStr.length()  ) {
			c = calcStr.charAt(pos1);
			if ( operator.indexOf(c) >= 0) {
				cObj.add(new String( calcStr.substring(pos0,pos1) ) );
				pos0 = pos1 + 1;
				opeObj = opeObj + calcStr.substring(pos1,pos0) ; ;
			} else if ( c == '[' ) {
				//zϐ[]͖
				pos1 = this.ParenthesesIndexOf(calcStr, pos1 , '[', ']');
			}
			pos1 ++ ;
		}
		cObj.add(new String( calcStr.substring(pos0,pos1).trim() ) );
				
		valObj = new Vector <int[]> () ;
		for ( n = 0 ; n < cObj.size() ; n++ ) {
			val0 = this.getIntValue(cObj.get(n));
			valObj.add(this.getIntArray(val0));
			//System.out.println("singleCalc:"+n+":"+cObj.get(n)+"=>"+val0);
		}
		ans = this.vectorCalc(valObj, opeObj);
		return ans;	
	}

	
	/**
	 * lZs
	 * @param valObj vZ̐lvf
	 * @param opeObj vZ̉Zq
	 * @return
	 */
	private int vectorCalc(Vector <int[]> valObj ,String opeObj) {
		int n , val0 , val1 , ans , ans0 ;
		char [] oplst ;
		char c;
		
		oplst = opeObj.toCharArray();
		// * / % 
		for ( n = 0 ; n < oplst.length ; n++ ) {
			c = oplst[n];
			switch (c) {
			case '*':
				val0 = valObj.get(n)[0];
				val1 = valObj.get(n+1)[0];
				ans0 = val0 * val1 ;
				valObj.get(n)[0] = valObj.get(n+1)[0] = ans0 ;
				oplst[n] = ' ';
				break ;
			case '/':
				val0 = valObj.get(n)[0];
				val1 = valObj.get(n+1)[0];
				ans0 = val0 / val1 ;
				valObj.get(n)[0] = valObj.get(n+1)[0] = ans0 ;
				oplst[n] = ' ';
				break ;
			case '%':
				val0 = valObj.get(n)[0];
				val1 = valObj.get(n+1)[0];
				ans0 = val0 % val1 ;
				valObj.get(n)[0] = valObj.get(n+1)[0] = ans0 ;
				oplst[n] = ' ';
				break ;
			}
		}
		for ( n = oplst.length-1 ; n >= 0 ; n-- ) { 
			if (oplst[n] == ' ') {
				valObj.get(n)[0] = valObj.get(n+1)[0] ;
			}
		}
	
		for ( n = 0 ; n < oplst.length ; n++ ) {
			c = oplst[n];
			switch (c) {
			case '+':
				val0 = valObj.get(n)[0];
				val1 = valObj.get(n+1)[0];
				ans0 = val0 + val1 ;
				valObj.get(n)[0] = valObj.get(n+1)[0] = ans0 ;
				oplst[n] = ' ';
				break ;
			case '-':
				val0 = valObj.get(n)[0];
				val1 = valObj.get(n+1)[0];
				ans0 = val0 - val1 ;
				valObj.get(n)[0] = valObj.get(n+1)[0] = ans0 ;
				oplst[n] = ' ';
				break ;
			case ' ':
				valObj.get(n+1)[0] = valObj.get(n)[0];
				break ;
			}
		}
		ans = valObj.get(valObj.size()-1)[0];		
		return ans;	
	}

	
	
	
	/**
	 * \rƂĔfAfʂԂ
	 * @param judgeStr
	 * @return
	 */
	private boolean judge ( String judgeStr ){
		boolean rjudge = false ;
		if (judgeStr.indexOf("&&") > 0 || judgeStr.indexOf("||") > 0 ) {
			rjudge = someJudge(judgeStr);			
		} else {
			rjudge = singleJudge(judgeStr);
		}
		return rjudge;
	}
	
	
	
	/**
	 * ̔rɂ锻fʂԂ
	 * @param str
	 * @return
	 */
	private boolean someJudge ( String str ){
		Vector<String> vct = new Vector<String>();
		String token ;
		StringBuffer opeObj ;
		int pos0 , pos1 , n ;
		char [] opeArray;
		boolean [] logicArray ;
		boolean rjudge , flg0;
	
		opeObj = new StringBuffer();

		//&&||ŋ؂ꂽ𕪉AVector
		for ( pos0 = pos1 = 0 ; pos1 < str.length() ; pos1++ ) {
			switch ( str.charAt(pos1)) {
			case '(' :
				pos1 = this.ParenthesesIndexOf(str, pos1, '(' ,')');
				break ;
			case '[' :
				pos1 = this.ParenthesesIndexOf(str, pos1, '[' ,']');
				break ;
			case '"' :
				pos1 = this.ParenthesesIndexOf(str, pos1, '"' ,'"');
				break ;
			case '&' :
				if ( str.charAt(pos1+1) == '&' ) {
					token = str.substring(pos0,pos1).trim();
					if ( token.length() > 2 && token.charAt(0) == '(' && token.charAt(token.length()-1) == ')') {
						token = token.substring(1,token.length()-1).trim();
					}
					if ( token.length() > 0 ) {
						vct.add(token);
						pos0 = pos1 = pos1 + 2;					
					}
				}
				opeObj.append('&');
				break ;
				
			case '|' :
				if ( str.charAt(pos1+1) == '|' ) {
					token = str.substring(pos0,pos1).trim();
					if ( token.length() > 2 && token.charAt(0) == '(' && token.charAt(token.length()-1) == ')') {
						token = token.substring(1,token.length()-1).trim();
					}
					if ( token.length() > 0 ) {
						vct.add(token);
						pos0 = pos1 = pos1 + 2;					
					}
				}
				opeObj.append('|');
				break ;
				
			}
		}
		//Ō̗vfo^
		token = str.substring(pos0,pos1).trim();
		if ( token.length() > 2 && token.charAt(0) == '(' && token.charAt(token.length()-1) == ')') {
			token = token.substring(1,token.length()-1).trim();
		}
		if ( token.length() > 0 ) {
			vct.add(token);
			pos0 = pos1 = pos1 + 2;					
		}
				
		opeArray = opeObj.toString().toCharArray();
		logicArray = new boolean[vct.size()];
		
		//VectoȓSvf̃WbNo
		for ( n = 0 ; n < vct.size() ; n ++ ) {
			logicArray[n] = this.judge(vct.get(n));
		}
				
		for ( n = 0 ; n < opeArray.length ; n ++ ) {
			if ( opeArray[n] == '&') {
				flg0 = logicArray[n] && logicArray[n+1];
				logicArray[n] = logicArray[n+1] = flg0 ;
			} else if ( opeArray[n] == '|') {
				flg0 = logicArray[n] && logicArray[n+1];
				logicArray[n] = logicArray[n+1] = flg0 ;
			}
		}
		
		rjudge =  logicArray[opeArray.length];
		
		return rjudge ;
	}
	
	
	
	/**
	 * P̔rɂ錋ʂԂ
	 * @param judgeStr
	 * @return
	 */
	private boolean singleJudge( String judgeStr ) {
		int w , pos , type ;
		String left , right ;
		int lintval , rintval ;
		String lstrval , rstrval ;
		boolean judge = false ;
		String jstr ;
		
		if ( judgeStr.trim().charAt(0) == '!' ) 
			jstr = judgeStr.substring(1).trim();
		else 
			jstr = judgeStr.trim();
		
		w = 2; pos= jstr.indexOf("=="); type = 0; 
		if ( pos < 0 ) { w = 2;pos = jstr.indexOf("!=");type = 1;}
		if ( pos < 0 ) { w = 2;pos = jstr.indexOf("=!");type = 2;}
		if ( pos < 0 ) { w = 2;pos = jstr.indexOf("<=");type = 3;}
		if ( pos < 0 ) { w = 2;pos = jstr.indexOf("=<");type = 4;}
		if ( pos < 0 ) { w = 2;pos = jstr.indexOf(">=");type = 5;}
		if ( pos < 0 ) { w = 2;pos = jstr.indexOf("=>");type = 6;}
		if ( pos < 0 ) { w = 1;pos = jstr.indexOf("<");type = 7;}
		if ( pos < 0 ) { w = 1;pos = jstr.indexOf(">");type = 8;}
		
		if ( pos < 0 ) {
			this.Error(8,"r̋LqɌ肪܂B");
		}
		
		left = jstr.substring(0,pos).trim();
		right = jstr.substring(pos+w).trim();
				
		if ( this.isStrVar(left) || this.isStrVar(right) ) {
			//̔r
			lstrval = this.getStrValue(left);
			rstrval = this.getStrValue(right);
			if ( type == 0 ) judge = lstrval.equals(rstrval);
			else judge = ! lstrval.equals(rstrval);			
		} else {
			//l̔r
			lintval = this.Calc(left);
			rintval = this.Calc(right);
			
			switch (type) {
			case 0:
				judge = ( lintval == rintval );
				break ;
			case 1:
			case 2:
				judge = ( lintval != rintval );
				break ;
			case 3:
			case 4:
				judge = ( lintval <= rintval );
				break ;
			case 5:
			case 6:
				judge = ( lintval >= rintval );
				break ;
			case 7:
				judge = ( lintval < rintval );
				break ;
			case 8:
				judge = ( lintval > rintval );
				break ;
			}
		}	

		if ( judgeStr.trim().charAt(0) == '!' )
			judge = !judge ;
		
		return judge ;
		
	}

	

		
	/**
	 * 	intint[1]̌`ɂAIuWFNgƂĈ悤ɂ
	 * @param cd
	 * @return
	 */
	private int[] getIntArray (int cd) {
		int [] code = new int[1];
		code[0] = cd ;
		return code ;
	}
	

	/**
	 * 񒆂̂̃yȂΉƂB
	 * @param S 
	 * @param n Jnʒu
	 * @param begin ʂ̎n܂蕶
	 * @param end ʂ̏I
	 * @return
	 */
	private int ParenthesesIndexOf(String S, int n , char begin , char end)
	{
		int n0 ,n1 ,len ;
		len = S.length();
		for ( n0 = 0,  n1 = n; n1 < len ; n1++ )
		{	
			if ( S.charAt(n1) == begin ) n0++ ;
			else if ( S.charAt(n1) == end )
			{
				n0-- ;
				if ( n0 == 0 ) return n1 ;
			}
		}
		this.Error(8,"ʂ̑ΉƂĂ܂B("+S+")"); 
		return -1;
	}

	
	public String loadText(String file , String code ) {
		FileInputStream fis;
		InputStreamReader isr;
		BufferedReader br;
		String line;
		StringBuffer sb = new StringBuffer();		
		try {
			fis = new FileInputStream(Groot+file);
			isr = new InputStreamReader(fis, code);
			br = new BufferedReader(isr);
			
			sb = new StringBuffer();
			while ( (line= br.readLine()) != null ) {
				line = line.trim();
				sb.append(line);
			}
			isr.close();
			fis.close();
		} catch (Exception e) {
			Error(8,"t@C["+file+"]ǂݍ߂܂");
		}
		return sb.toString();
	}

	
	public void saveText(String file , String text , String code){
		FileOutputStream fos ;
		OutputStreamWriter osw ;
		BufferedWriter bw;
		try {
			fos = new FileOutputStream(Groot+file);
			osw = new OutputStreamWriter(fos ,code);
			bw = new BufferedWriter(osw);
			bw.write(text);
			bw.close();
			osw.close();
			fos.close();
		} catch (Exception e) {
			Error(8,"t@C["+file+"]߂܂");
		}
	}
	

	/**
	 * w肳ꂽϐQ̓et@Cɕۑ
	 * @param vct
	 */
	public void saveVariable( Vector vct ) {
		int n , i ,  num , pb , pe , vn ,ival[];
		StringBuffer sb = new StringBuffer();
		String file , vwk , var , vns , sval[];
		file = this.getStrValue((String) vct.get(1));
		num = vct.size() - 2;
		for ( n = 0 ; n < num ; n++ ) {
			vwk = (String) vct.get(n+2);
			//System.out.println("saveVariable:"+vwk);
			if ( ( pb = vwk.indexOf('[') ) > 0 ) {
				pe = this.ParenthesesIndexOf(vwk, pb,'[',']');
				vns = vwk.substring(pb+1, pe).trim();
				vn = this.Calc(vns);
				var = vwk.substring(0,pb);
			} else {
				vn = -1 ;
				var = vwk.trim();
			}
						
			if ( this.isIntVar(var) ) {
				ival = (int []) this.varIntMap.get(var);
				if ( vn >= 0)  {
					sb.append(ival[vn]);
					sb.append("\t");					
				} else {
					for ( i = 0 ; i < ival.length ; i++ ) {
						sb.append(ival[i]);
						sb.append('\t');					
					}
				}
			} else if (this.isStrVar(var)) {
				sval = (String []) this.varStrMap.get(var);
				if ( vn >= 0)  {
					sb.append(sval[vn]);
					sb.append('\t');					
				} else {
					for ( i = 0 ; i < sval.length ; i++ ) {
						sb.append(sval[i]);
						sb.append('\t');					
					}
				}
			} else 
				Error(8,var+"Ƃϐ݂͑܂B");
			sb.deleteCharAt(sb.length()-1);
			sb.append("\n");
		}
		this.saveText(file, sb.toString() , "EUC_JP");
	}
	
	
	/**
	 * w肳ꂽϐQɃt@Cǂݍ񂾒lZbg
	 * @param vct
	 */
	public void loadVariable( Vector vct  ) {
		FileInputStream fis;
		InputStreamReader isr;
		BufferedReader br;
		String line , file , vname[] , vwk , var , vns , sval[];
		int n , m  , vnum[] , pb , pe , vn , ival[];
		Vector <String> vc;
		
		file = this.getStrValue((String) vct.get(1));
		vname = new String[vct.size() - 2];
		vnum = new int[vct.size() - 2];
		
		for ( n = 0 ; n < vname.length ; n++ ) {
			vwk = (String) vct.get(n+2);
			if ( ( pb = vwk.indexOf('[') ) > 0 ) {
				pe = this.ParenthesesIndexOf(vwk, pb,'[',']');
				vns = vwk.substring(pb+1, pe).trim();
				vnum[n] = this.Calc(vns);
				vname[n] = vwk.substring(0,pb);
			} else {
				vnum[n] = -1 ;
				vname[n] = vwk.trim();
			}			
			//System.out.println("loadVariable:"+vname[n]+"/"+vnum[n]);
		}
				
		try {
			fis = new FileInputStream(Groot+file);
			isr = new InputStreamReader(fis, "EUC_JP");
			br = new BufferedReader(isr);
			n = 0;
			while ( (line= br.readLine()) != null && n < vname.length ) {				
				vc = this.stringToVector(line, "\t");
				//System.out.println("loadVariable:"+vc.toString());
				var = vname[n];
				vn = vnum[n];
				
				if ( this.isIntVar(vname[n]) ) {
					ival = (int []) this.varIntMap.get(var);
					if ( vn == -1 ) {
						for ( m = 0 ; m < ival.length && m < vc.size() ; m ++ ) 
							ival[m] = Integer.parseInt(vc.get(m));
					} else {
						ival[vn] = Integer.parseInt(vc.get(0));
					}
				} else if ( this.isStrVar(vname[n]) ) {
					sval = (String []) this.varStrMap.get(var);
					if ( vn == -1 ) {
						for ( m = 0 ; m < sval.length && m < vc.size() ; m ++ ) 
							sval[m] = vc.get(m);						
					} else {
						sval[vn] = vc.get(0);						
					}
				} else 
					Error(8,var+"Ƃϐ݂͑܂B");
				
				n++ ;
			}
			isr.close();
			fis.close();
		} catch (Exception e) {
			Error(8,"t@C["+file+"]ǂݍ߂܂");
		}
	}
	
	
	//
	//@XNvg̎s
	//

	
	/**
	 * 	R\[蕶͂
	 * @param txt
	 */
	private void inputValue (String str) {
        String val = "";
		try {
	          val = bread.readLine();
		}catch(IOException e){
			this.Error(8, "L[͂Ɏs");
		}
		if ( this.isStrVar(str) ) {
			this.setVarStrValue(str, val);
		} else if ( this.isIntVar(str) ) {
			this.setVarIntValue(str, this.strToInt(val));			
		}
	}
	

	/**
	 * 	{^őI
	 * @param vct 
	 */
	private void buttonSelect(Vector<String> vct ) {
		String rvect , tkn , val ;
		Vector <String> vect ;
		int n ;
		
		vect = new Vector <String>() ;
		rvect = new String( vct.get(1) );
		
		//p[^𕶎ɕϊ
		for ( n = 2 ; n < vct.size() ; n++ ) {
			tkn = vct.get(n);
			val = this.strToStr(tkn);
			//System.out.println("buttonSelect:"+tkn+":"+val);
			vect.add(val);
		}
		
		dmng.setSelectParam(vect);
		//lAĂ̂҂
		this.waitDisplayExec();	
		//ϐɒlZbg
		if ( this.isIntVar(rvect))
			this.setVarIntValue(rvect,dmng.getSelectButton());
		else if ( this.isStrVar(rvect))
			this.setVarStrValue(rvect,dmng.getSelectText());
	}

	
	/**
	 * 	͂҂NbNZԍ𓾂ĕϐɊi[
	 * @param vct 
	 */
	private void cellClick(Vector<String> vct ) {
		int  cellvalue  ;
		String rvect ;
		rvect = vct.get(1);
		if ( dmng.visibleCellNum() == 0 ) {
			//SZsȂϐɊi[̂-1
			this.setVarIntValue(rvect,-1);
			return ;
		}	
		
		//ʂɃNbNCxg̗v
		//dmng.commandCode == CMD_cellclick
		dmng.cellClick();
		//ǂ̃ZNbN܂Ń[v
		cellvalue = -1 ;
		while (cellvalue == -1 ) {
			//CxgAĂ̂҂
			this.waitDisplayExec();
			cellvalue = dmng.getSelectCell();
		}
		//ϐɃZ̒lZbg
		this.setVarIntValue(rvect,cellvalue);
	}
	

	/**
	 * ʑ̏I҂
	 *
	 */
	private void waitDisplayExec() {
		while ( dmng.diaplayBusy() ) 
			this.waitMiliSec(100);
	}	


	private void waitTime(int w) {
		if (w == 0 ) return ;
		long start = System.currentTimeMillis();
		long wtime = w;
		long now ;
		do {
			this.waitMiliSec(10);
			now = System.currentTimeMillis();
		}while ( wtime > ( now - start) );
		//System.out.println("waitMiliSec:START"+start);
		//System.out.println("waitMiliSec:  END"+now);
		//System.out.println("waitMiliSec:WTIME"+wtime);
	}

	/**
	 * Xbh~Ďԑ҂
	 * @param w
	 */
	public void waitMiliSec(int w) {
		long wait ;
		wait = (long) w;
		try { sleep(wait);} 
		catch  ( InterruptedException ie) {}
	}
	
	
	/**
	 * 	ʂ̓R\[ɏo
	 * @param txt
	 */
	private void drawText(String txt, boolean wait , int wtime) {
		String text = txt.trim();		
		if (dmng == null) {
			if ( text.charAt(0) == '+') 
				Text = text + text.substring(1);
			else
				Text = text ;
			//ʂȂꍇR\[ɏo
			System.out.println(Text);
		} else {
			if ( wait ) {
				//ʂւ̏o͂B
				dmng.drawText(text);
				//dmng.commandCode = CMD_text
				//}EXNbN܂ő҂
				this.waitDisplayExec();				
			} else {
				//ʂւ̏o͂
				dmng.drawWaitText(text,wtime);				
			}
		}
	}

	
	
	/**
	 * ŝݎs
	 *
	 */
	private void oneLineExec () {
		int code = this.scriptCode.get(scriptPointer)[0];
		Vector <String> params = this.scriptParams.get(scriptPointer);
		Vector <String> vcs ;
		int   iwk0 , iwk1  , iwk2 , iwk3 , iwk4 , iwk5 , iwk6 , iwk7 ;
		String swk0 , swk1  ;
		boolean bwk0 ;
		
		//System.err.println(this.getName()+ ":"+ scriptPointer+ " "+ params.toString());
		
		//R}hR[h̕
		switch (code) {
		case CMD_display:
			if (dmng != null) {
				if (params.size() != 2) this.Error(8,"̉ʂoƂ͂ł܂B");				
			}
			if (params.size() == 3) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				//ʂo
				dmng = new jongsDisplayManagement(iwk0, iwk1);
			} else {
				dmng = new jongsDisplayManagement();
			}
			if (this.dmng != null) dmng.setGameRoot(this.Groot);
			scriptPointer ++ ;
			break ;
		
		
		case CMD_goto:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			//Gotȏp[^[xɓo^Ă΂ɔ
			if ( this.labelMap.containsKey(this.getStrValue(params.get(1))) ) 
				scriptPointer =  this.labelMap.get(params.get(1))[0];
			else 
				this.Error(8, this.getStrValue(params.get(1))+"Ƃx̓XNvgɑ݂܂B");			
			break ;
			
		case CMD_gosub:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			//Gusub̑p[^[xɓo^Ă΂ɔ
			if ( this.labelMap.containsKey(this.getStrValue(params.get(1))) ) {
				this.subroutineStack.add(this.getIntArray(scriptPointer));
				scriptPointer =  this.labelMap.get(params.get(1))[0];
			} else 
				this.Error(8, this.getStrValue(params.get(1))+"Ƃx̓XNvgɑ݂܂B");			
			break ;
			
		case CMD_return:
			//ĂяoꂽGusub̖߂ɖ߂
			if ( this.subroutineStack.empty() ) 
				this.Error(8, "return̖߂悪܂");			
			scriptPointer = this.subroutineStack.pop()[0] + 1;
			break ;
			
		case CMD_goScript:
			if (params.size() == 2) {
				swk0 = this.getStrValue(params.get(1));
				this.getScript(swk0,"EUC_JP");
			} else if (params.size() == 3) {
				swk0 = this.getStrValue(params.get(1));
				swk1 = this.getStrValue(params.get(2));
				this.getScript(swk0,swk1);
			} else {
				this.Error(8,"p[^Ă܂");
			}
			scriptPointer = 0;
			break ;
			
		case CMD_text:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			swk0 = this.strToStr(params.get(1));//
			this.drawText(swk0,true,0); //҂tOnmŌĂ
			scriptPointer ++ ;
			break ;

		case CMD_print:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			swk0 = this.strToStr(params.get(1));
			System.out.println(swk0); //System.outɏo
			scriptPointer ++ ;
			break ;

		case CMD_WaitText:
			if ( params.size() == 2 ) {
				swk0 = this.getStrValue(params.get(1));
				this.drawText(swk0,false,2000);//҂tOneeŌĂ				
			} else if ( params.size() == 3 ) {
				swk0 = this.getStrValue(params.get(1));
				iwk0 = this.Calc(params.get(2));
				this.drawText(swk0,false,iwk0);//҂tOneeŌĂ
			} else {
				if (params.size() != 2) this.Error(8,"p[^Ă܂");				
			}
			
			scriptPointer ++ ;
			break ;
			
			
		case CMD_input:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			this.inputValue(params.get(1));
			scriptPointer ++ ;			
			break ;

		case CMD_set:	
			this.setVariable(params.get(1));
			scriptPointer ++ ;
			break ;
			
		case CMD_if:		
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			if ( judge(params.get(1)) ) {
				//̕]ʂtrueȂ{̏΂
				scriptPointer ++;					
			} else {
				//̕]ʂfalsȅꍇp̎̍s܂Ŕ΂
				vcs = this.scriptParams.get(scriptPointer+1);
				scriptPointer = Integer.parseInt(vcs.get(1)) ;
			}
			scriptPointer ++;
			break ;
		
		case CMD_while:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			if ( judge(params.get(1)) ) {
				//̕]ʂtrueꍇ{΂
				scriptPointer ++;
			} else {
				//̕]ʂfalseꍇp̎̍s܂Ŕ΂
				vcs = this.scriptParams.get(scriptPointer+1);
				scriptPointer = Integer.parseInt(vcs.get(1)) ;
			}
			scriptPointer ++ ;
			break ;


		case CMD_for:
			if (params.size() != 4) this.Error(8,"p[^Ă܂");
			this.setVariable(params.get(1));
			if ( judge(params.get(2)) ) {
				//_̕]ʂtrueꍇ {̏΂
				scriptPointer ++;
			} else {
				//_̕]ʂfalseꍇp̎̍s܂Ŕ΂
				vcs = this.scriptParams.get(scriptPointer+1);
				scriptPointer = Integer.parseInt(vcs.get(1)) ;
			}
			scriptPointer ++ ;
			break ;

		
		case CMD_end:
			//́pƑ΂Ȃöʒu𓾂
			iwk1 = Integer.parseInt(params.get(1));
			//́p̏R[h𓾂
			iwk0 = this.basicMap.get(params.get(2))[0] ;
			
			switch ( iwk0 ) {
			case CMD_while :
				if ( judge(params.get(3)) ) scriptPointer = iwk1+1 ;
				else scriptPointer ++ ;				
				break ;
				
			case CMD_for :
				this.setVariable(params.get(4));
				if ( judge(params.get(3)) ) scriptPointer = iwk1+1 ;
				else scriptPointer ++ ;				
				break ;
				
			case CMD_if :
				if ( this.scriptCode.get(scriptPointer+1)[0] == CMD_else ) {
					vcs = this.scriptParams.get(scriptPointer+2);
					scriptPointer = Integer.parseInt(vcs.get(1))+1 ;
				} else {
					scriptPointer ++ ;					
				}
				break ;
				
			default :
				scriptPointer ++ ;				
			}
			
			break ;
			
		case CMD_debug:		
			if (debug == 0) debug =1 ;
			else debug = 0;
			scriptPointer ++ ;
			break ;
		
		case CMD_wait:
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			iwk0 = this.Calc(params.get(1));
			//if (dmng == null) this.waitMiliSec(iwk0);
			//else dmng.waitMiliSec(iwk0);
			this.waitTime(iwk0);
			scriptPointer ++ ;			
			break ;			

			
		case CMD_random:
			if ( params.size() != 3 ) this.Error(8,"p[^Ă܂");
			swk0 = params.get(1);
			if ( ! this.isIntVar(swk0) ) this.Error(8, swk0+"͐^̕ϐł͂܂");
			iwk0 = this.Calc(params.get(2));
			iwk2 = (int) ( Math.random() * (double ) iwk0 );
			this.setVarIntValue(swk0, iwk2);
			scriptPointer ++ ;
			break ;				
						
		case CMD_abs:
			if ( params.size() != 3 ) this.Error(8,"p[^Ă܂");
			swk0 = params.get(1);
			if ( ! this.isIntVar(swk0) ) this.Error(8, swk0+"͐^̕ϐł͂܂");
			iwk0 = this.Calc(swk0);
			iwk2 = Math.abs(iwk0);
			this.setVarIntValue(swk0, iwk2);
			scriptPointer ++ ;
			break ;				

		case CMD_save:
			if ( params.size() < 3 ) this.Error(8,"p[^Ă܂");
			this.saveVariable(params);
			scriptPointer ++ ;
			break ;							
			
		case CMD_load:
			if ( params.size() < 3 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			if ( this.jongsnet != null) this.jongsnet.getServerFile(swk0);			
			this.loadVariable(params);
			scriptPointer ++ ;
			break ;							
			
		case CMD_setCellNumber:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if (params.size() != 2) this.Error(8,"p[^Ă܂");
			iwk0 = this.Calc(params.get(1));
			dmng.setCellNumber(iwk0);
			scriptPointer ++ ;				
			break ;
			
		case CMD_setCellFlag:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if (params.size() == 2) {
				swk0 = this.getStrValue(params.get(1));
				dmng.setCellView(swk0);
			} else if (params.size() == 3) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				dmng.setCellView(iwk0,iwk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
		case CMD_setCellPosition:
			if (params.size() == 4) {
				iwk0 = this.Calc(params.get(1));
				swk0 = params.get(2).trim();
				//\ _LEFT _RIGHT _CENTER̒l𓾂
				iwk1 = dmng.getPositionCode(swk0);
				if ( iwk1 == 0 ) iwk1 = this.Calc(params.get(2));
				swk0 = params.get(3).trim();
				//\ _UPPER _LOWER _MIDDLE̒l𓾂
				iwk2 = dmng.getPositionCode(swk0);
				if ( iwk2 == 0 ) iwk2 = this.Calc(params.get(3));				
				dmng.setCellPosition(iwk0, iwk1, iwk2);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
		case CMD_setCellSize:
			if (params.size() == 4) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				dmng.setCellSize(iwk0, iwk1, iwk2);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
		case CMD_setCellImage:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 3) {
				iwk0 = this.Calc(params.get(1));
				swk0 = this.getStrValue(params.get(2));
				if ( this.jongsnet != null) this.jongsnet.getServerFile(swk0);
				bwk0 = dmng.setCellImage(iwk0, swk0);
				if ( bwk0 == false ) {
					this.Error(8,"摜t@C" + swk0 + "ǂݍ߂܂");									
				}
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
				
		case CMD_setCellCanvas:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 5) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				this.dmng.setCellCanvas(iwk0, iwk1, iwk2, iwk3);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;

		case CMD_setCellTextParam:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 6) {
				iwk0 = this.Calc(params.get(1));
				swk0 = this.getStrValue(params.get(2));
				swk1 = this.getStrValue(params.get(3));
				iwk1 = this.Calc(params.get(4));
				iwk2 = this.Calc(params.get(5));
				this.dmng.setCellTextParameter(iwk0, swk0, swk1, iwk1, iwk2 );
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
			
		case CMD_setCellText:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 3) {
				iwk0 = this.Calc(params.get(1));
				swk0 = this.getStrValue(params.get(2));
				this.dmng.setCellText(iwk0, swk0);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
		case CMD_setShiftView:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 2) {
				iwk0 = this.Calc(params.get(1));
				this.dmng.setShiftView(iwk0);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
		case CMD_setShiftHide:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 2) {
				iwk0 = this.Calc(params.get(1));
				this.dmng.setShiftHide(iwk0);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;				
			break ;
			
			
		case CMD_viewDisplay:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if (params.size() == 1) {
				dmng.viewDisplay();
			} else if ( params.size() == 2 ) {
				swk0 = this.getStrValue(params.get(1));
				dmng.viewDisplay(swk0);
			} else if ( params.size() == 3 ) {
				swk0 = this.getStrValue(params.get(1));
				swk1 = this.getStrValue(params.get(2));
				dmng.transitionDisplay(swk0,swk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			this.waitDisplayExec();
			scriptPointer ++ ;				
			break ;	
			
		case CMD_transitionDisplay:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if (params.size() == 2) {
				swk0 = this.getStrValue(params.get(1));
				dmng.transitionDisplay(swk0);
			} else if ( params.size() == 3 ) {
				swk0 = this.getStrValue(params.get(1));
				swk1 = this.getStrValue(params.get(2));
				dmng.transitionDisplay(swk0,swk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			this.waitDisplayExec();
			scriptPointer ++ ;				
			break ;	
			
		case CMD_setCellTransColor:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 3 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				dmng.setTransColor(iwk0, iwk1);				
			} else if ( params.size() == 4 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				dmng.setTransColor(iwk0, iwk1, iwk2);				
			} else if ( params.size() == 5 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				dmng.setTransColor(iwk0, iwk1, iwk2, iwk3);				
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;
			break ;	

		case CMD_cellClick :
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() != 2 ) this.Error(8,"p[^Ă܂");
			this.cellClick(params);
			scriptPointer ++ ;
			break ;				

			
		case CMD_setDisplaySize:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 3 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				dmng.createDisplay(iwk0, iwk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;
			break ;	
			
		case CMD_setFontColor:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 2 ) {
				iwk0 = this.Calc(params.get(1));
				dmng.setFontColor(iwk0, this.anotherColor(iwk0) );
			} else if ( params.size() == 3 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				dmng.setFontColor(iwk0, iwk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			//this.waitDisplayExec();
			scriptPointer ++ ;
			break ;	
		
		case CMD_setFont:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 4 ) {
				swk0 = this.getStrValue(params.get(1));
				swk1 = this.getStrValue(params.get(2));
				iwk1 = this.Calc(params.get(3));
				dmng.setTextFont(swk0, swk1,iwk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			//this.waitDisplayExec();
			scriptPointer ++ ;
			break ;	

			
		case CMD_setTextInterval:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 3 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				dmng.setTextInterval(iwk0, iwk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;
			break ;	

		case CMD_setTextArea:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 5 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				dmng.setTextArea(iwk0, iwk1,iwk2,iwk3);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			scriptPointer ++ ;
			break ;	

			
		case CMD_setSelectArea:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 5 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				dmng.setSelectArea(iwk0, iwk1,iwk2,iwk3);
			} else if ( params.size() == 7 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				iwk4 = this.Calc(params.get(5));
				iwk5 = this.Calc(params.get(6));
				dmng.setSelectArea(iwk0,iwk1,iwk2,iwk3,iwk4,iwk5);
			} else if ( params.size() == 9 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				iwk4 = this.Calc(params.get(5));
				iwk5 = this.Calc(params.get(6));
				iwk6 = this.Calc(params.get(7));
				iwk7 = this.Calc(params.get(8));
				dmng.setSelectArea(iwk0,iwk1,iwk2,iwk3,iwk4,iwk5,iwk6,iwk7);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			//this.waitDisplayExec();
			scriptPointer ++ ;
			break ;	

		case CMD_setSelectColor:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 5 ) {
				iwk0 = this.Calc(params.get(1));
				iwk1 = this.Calc(params.get(2));
				iwk2 = this.Calc(params.get(3));
				iwk3 = this.Calc(params.get(4));
				dmng.setSelectColor(iwk0, iwk1,iwk2,iwk3);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			//this.waitDisplayExec();
			scriptPointer ++ ;
			break ;	

		case CMD_setSelectFont:
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() == 4 ) {
				swk0 = this.getStrValue(params.get(1));
				swk1 = this.getStrValue(params.get(2));
				iwk1 = this.Calc(params.get(3));
				dmng.setSelectFont(swk0, swk1,iwk1);
			} else {
				this.Error(8,"p[^Ă܂");				
			}
			//this.waitDisplayExec();
			scriptPointer ++ ;
			break ;	

			
		case CMD_select :
			if ( dmng == null ) this.Error(8,"ʂ݂Ȃ̂ŁAʌn̏͂ł܂");
			if ( params.size() < 3 ) this.Error(8,"p[^Ă܂");
			this.buttonSelect(params);
			scriptPointer ++ ;
			break ;	
			
		case CMD_midiLoad :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			if ( this.jongsnet != null) this.jongsnet.getServerFile(swk0);
			iwk0 = sound.MIDIload(swk0);
			if ( iwk0 > 0 )
				Error(8,"MIDI ["+swk0+"] JƂł܂B("+iwk0+")");
			scriptPointer ++ ;
			break ;	

		case CMD_midiPlay :
			iwk0 = sound.Midiplay();
			if ( iwk0 > 0 )
				Error(8,"MIDItł܂B");
			this.th_wtime = 30;//Midî߂ɃXbh~鎞msݒ
			scriptPointer ++ ;
			break ;	

		case CMD_midiStop :
			sound.MIDIstop();
			this.th_wtime = 0;//Midî߂ɃXbh~鎞Ԃ
			scriptPointer ++ ;
			break ;	

		case CMD_audioLoop :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			if ( this.jongsnet != null) this.jongsnet.getServerFile(swk0);
			iwk0 = sound.AUDIOLoop(swk0);
			if ( iwk0 > 0 )
				Error(8,"̃I[fBIt@C ["+swk0+"] tł܂B("+iwk0+")");
			scriptPointer ++ ;
			break ;	

		case CMD_audioPlay :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			if ( this.jongsnet != null) this.jongsnet.getServerFile(swk0);
			iwk0 = sound.AUDIOPlay(swk0);
			if ( iwk0 > 0 )
				Error(8,"̃I[fBIt@C ["+swk0+"] tł܂B("+iwk0+")");
			scriptPointer ++ ;
			break ;	


		case CMD_audioStop :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			sound.AUDIOStop(swk0);
			scriptPointer ++ ;
			break ;	
	
		case CMD_clipLoop :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			if ( this.jongsnet != null) this.jongsnet.getServerFile(swk0);
			iwk0 = sound.CLIPLoop(swk0);
			if ( iwk0 > 0 )
				Error(8,"̃I[fBIt@C ["+swk0+"] tł܂B("+iwk0+")");
			scriptPointer ++ ;
			break ;	


		case CMD_clipStop :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			swk0 = this.getStrValue(params.get(1));
			sound.CLIPStop(swk0);
			scriptPointer ++ ;
			break ;	
	
			
		case CMD_setWaitTime :
			if ( params.size() < 2 ) this.Error(8,"p[^Ă܂");
			this.th_wtime = this.Calc(params.get(1));
			scriptPointer ++ ;
			break ;	
			

		default :
			scriptPointer ++ ;
		}
	}

	private int anotherColor(int col ) {
		int r = ( col >> 16 ) & 0x0000ff ; 
		int g = ( col >> 8 ) & 0x0000ff ; 
		int b = col & 0x0000ff ; 
		
		if ( r > 127 ) r = r / 2;
		else r = (r+127) / 2;
		if ( g > 127 ) g = g / 2;
		else g = (g+127) / 2;
		if ( b > 127 ) b = b / 2;
		else b = (b+127) / 2;
		
		int color = 0xff000000 | (r << 16) | (g << 8) | b ;
		return color ;
	}
	
	
	
	/**
	 * G[sxWȏ̏ꍇ͋I
	 * @param level
	 * @param t0
	 */
	private void Error(int level, String t0 ){
		if (this.scriptPointer == 0 || this.scriptParams == null )
			System.err.print("JONGS-Error:"+t0);
		else 
			System.err.print("JONGS-Error:"+t0+":"+this.scriptParams.get(this.scriptPointer));
		//MIDI~
		switch (level) {
		case 0:
			break ;
		case 4:
			break ;
		case 8:
			sound.MIDIclose();
			if ( dmng != null ) dmng.dispose();
			System.exit(level);
			break ;
		default :
			sound.MIDIclose();
			if ( dmng != null ) dmng.dispose();
			System.exit(level);
		}
		return ;
	}


	/**
	 * S̎s
	 */
	public void run() {
		//XNvgI܂ŌJԂ
		while (scriptPointer < scriptCode.size()) {
			//ss
			if ( debug > 0 ) {
				System.out.println("JONGS Line:"+scriptParams.get(this.scriptPointer).toString());				
			}
			this.oneLineExec();
			
			//Xbh~(MIDIr؂ʂ悤)
			if ( this.th_wtime > 0 ) waitMiliSec(th_wtime);
		}
		this.dispose();
	}
	
	
	public void dispose() {
		sound.MIDIclose();
		if ( dmng != null ) dmng.dispose();
	}
	
	public static void main(String[] args) {
		JongScripter js ;
		String txtCode = "EUC_JP";
		String mode = "sga";
		if ( args.length >= 2) txtCode = args[1];
		if ( args.length >= 3) mode = args[2];
		if ( args.length > 0 ) {
			js = new JongScripter(args[0],txtCode,mode);
			//js.outScriptState();
			js.start();
		}
	}
	
	private String getFirstScript() {
		String s = "SetCellNumber(1);setCellCanvas(0,200,40,0xffffff);setCellPosition(0,_CENTER,_MIDDLE);SetCellTextParam(0,Lucida Sans,italic,28,0xff8888);viewDisplay(1,_fadein);wait(200);SetCellText(0,J);viewDisplay();wait(200);SetCellText(0,Ja);viewDisplay();wait(200);SetCellText(0,Jav);viewDisplay();wait(200);SetCellText(0,Java);viewDisplay();wait(200);SetCellText(0,JavaO);viewDisplay();wait(200);SetCellText(0,JOpen);viewDisplay();wait(200);SetCellText(0,JOpensource);viewDisplay();wait(200);SetCellText(0,JOpensourceN);viewDisplay();wait(200);SetCellText(0,JOpensourceNov);viewDisplay();wait(200);SetCellText(0,JOpensourceNovels);viewDisplay();wait(200);SetCellText(0,JOpensourNovels);viewDisplay();wait(200);SetCellText(0,JOpensouNove);viewDisplay();wait(200);SetCellText(0,JOpensNovels);viewDisplay();wait(200);SetCellText(0,JOpenNovelsG);viewDisplay();wait(200);SetCellText(0,JOpNovelsGam);viewDisplay();wait(200);SetCellText(0,JONovelsGame);viewDisplay();wait(200);SetCellText(0,JONovelGameS);viewDisplay();wait(200);SetCellText(0,JONoveGameSc);viewDisplay();wait(200);SetCellText(0,JONoGameScri);viewDisplay();wait(200);SetCellText(0,JONGameScrip);viewDisplay();wait(200);SetCellText(0,JONGameScript);viewDisplay();wait(200);SetCellText(0,JONGamScript);viewDisplay();wait(200);SetCellText(0,JONGaScript);viewDisplay();wait(200);SetCellText(0,JONGScript);viewDisplay();wait(200);SetCellText(0,JONGS);viewDisplay();wait(200);SetCellTextParam(0,Lucida Sans,italic,34,0xff9999);SetCellText(0,JONGS);viewDisplay();wait(200);SetCellTextParam(0,Lucida Sans,italic,38,0xffbbbb);SetCellText(0,JONGS);viewDisplay();wait(200);SetCellTextParam(0,Lucida Sans,italic,38,0xffdddd);SetCellText(0,JONGS);viewDisplay();wait(200);SetCellTextParam(0,Lucida Sans,italic,38,0xffffff);SetCellText(0,JONGS);viewDisplay();wait(200);SetCellTextParam(0,Lucida Sans,italic,60,0x000000);SetCellText(0,JONGS);viewDisplay(1,_fadein);wait(200);viewDisplay(0,_fadein);";
		return s;
	}
	
	
}
