/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class jongsSound
implements MetaEventListener,
LineListener {
    private static final int MIDI_END = 47;
    private static final int MIDI_MAX = 128;
    private static final int AUDIO_MAX = 128;
    private static final int CLIP_MAX = 128;
    Sequencer MIDIsequencer;
    Synthesizer MIDIsynthesizer;
    Sequence MIDIsequence;
    String Groot;
    HashMap<String, Sequence> MIDIFiles;
    HashMap<String, Clip> CLIPFiles;
    HashMap<String, AudioClip> AUDIOFiles;

    public jongsSound() {
        this.initSequencer();
        this.MIDIFiles = new HashMap(128);
        this.AUDIOFiles = new HashMap(128);
        this.CLIPFiles = new HashMap(128);
    }

    public void setGameRoot(String string) {
        this.Groot = string;
    }

    private int initSequencer() {
        try {
            this.MIDIsequencer = MidiSystem.getSequencer();
            this.MIDIsequencer.open();
            this.MIDIsequencer.addMetaEventListener(this);
            if (!(this.MIDIsequencer instanceof Synthesizer)) {
                this.MIDIsynthesizer = MidiSystem.getSynthesizer();
                this.MIDIsynthesizer.open();
                Receiver receiver = this.MIDIsynthesizer.getReceiver();
                Transmitter transmitter = this.MIDIsequencer.getTransmitter();
                transmitter.setReceiver(receiver);
            } else {
                this.MIDIsynthesizer = (Synthesizer)((Object)this.MIDIsequencer);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            return 8;
        }
        return 0;
    }

    public void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47 && this.MIDIsequencer != null && this.MIDIsequencer.isOpen()) {
            this.MIDIsequencer.setMicrosecondPosition(0L);
            this.MIDIsequencer.start();
        }
    }

    public int MIDIload(String string) {
        if (this.MIDIFiles.size() >= 128) {
            return 8;
        }
        if (this.MIDIFiles.containsKey(string)) {
            this.MIDIsequence = this.MIDIFiles.get(string);
            this.MIDIstop();
            return 0;
        }
        File file = new File(this.Groot + string);
        try {
            this.MIDIsequence = MidiSystem.getSequence(file);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return 1;
        }
        catch (IOException iOException) {
            return 2;
        }
        catch (NullPointerException nullPointerException) {
            return 3;
        }
        this.MIDIstop();
        return 0;
    }

    public int CLIPload(String string) {
        if (this.CLIPFiles.size() >= 128) {
            return 8;
        }
        if (this.CLIPFiles.containsKey(string)) {
            return 0;
        }
        Clip clip = this.getClip(string);
        if (clip == null) {
            return 8;
        }
        return 0;
    }

    public int CLIPLoop(String string) {
        if (this.CLIPFiles.containsKey(string)) {
            Clip clip = this.CLIPFiles.get(string);
            clip.start();
            return 0;
        }
        if (this.CLIPFiles.size() >= 128) {
            return 8;
        }
        Clip clip = this.getClip(string);
        if (clip == null) {
            return 8;
        }
        clip.start();
        return 0;
    }

    private Clip getClip(String string) {
        Clip clip;
        File file = new File(this.Groot + string);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file.toURI().toURL());
            AudioFormat audioFormat = audioInputStream.getFormat();
            if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
                audioFormat = audioFormat2;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            clip = (Clip)AudioSystem.getLine(info);
            clip.addLineListener(this);
            clip.open(audioInputStream);
            audioInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
            return null;
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
            return null;
        }
        this.CLIPFiles.put(string, clip);
        return clip;
    }

    public void CLIPStop(String string) {
        if (this.CLIPFiles.containsKey(string)) {
            Clip clip = this.CLIPFiles.get(string);
            clip.stop();
        }
    }

    public int MIDIplay(String string) {
        int n = this.MIDIload(string);
        if (n == 0) {
            this.Midiplay();
            return 0;
        }
        return 8;
    }

    public int Midiplay() {
        if (this.MIDIsequence == null) {
            return 8;
        }
        return this.MIDIplay(this.MIDIsequence);
    }

    public int MIDIplay(Sequence sequence) {
        this.MIDIstop();
        if (this.MIDIsequencer != null && sequence != null) {
            try {
                this.MIDIsequencer.setSequence(sequence);
                this.MIDIsequencer.start();
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                return 8;
            }
            return 0;
        }
        return 8;
    }

    public void MIDIstop() {
        if (this.MIDIsequencer == null) {
            return;
        }
        if (this.MIDIsequencer.isRunning()) {
            this.MIDIsequencer.stop();
        }
    }

    public void MIDIclose() {
        this.MIDIstop();
        if (this.MIDIsequencer != null) {
            this.MIDIsequencer.removeMetaEventListener(this);
            this.MIDIsequencer.close();
        }
        this.MIDIsequencer = null;
    }

    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            Clip clip = (Clip)lineEvent.getSource();
            clip.stop();
            clip.setFramePosition(0);
        }
    }

    public int AUDIOload(String string) {
        if (this.AUDIOFiles.size() >= 128) {
            return 8;
        }
        if (this.AUDIOFiles.containsKey(string)) {
            return 0;
        }
        AudioClip audioClip = this.getAudioClip(string);
        if (audioClip == null) {
            return 8;
        }
        return 0;
    }

    public int AUDIOPlay(String string) {
        if (this.AUDIOFiles.containsKey(string)) {
            AudioClip audioClip = this.AUDIOFiles.get(string);
            audioClip.play();
            return 0;
        }
        if (this.AUDIOFiles.size() >= 128) {
            return 8;
        }
        AudioClip audioClip = this.getAudioClip(string);
        if (audioClip == null) {
            return 8;
        }
        audioClip.play();
        return 0;
    }

    public int AUDIOLoop(String string) {
        if (this.AUDIOFiles.containsKey(string)) {
            AudioClip audioClip = this.AUDIOFiles.get(string);
            audioClip.loop();
            return 0;
        }
        AudioClip audioClip = this.getAudioClip(string);
        if (audioClip == null) {
            return 8;
        }
        audioClip.loop();
        return 0;
    }

    private AudioClip getAudioClip(String string) {
        AudioClip audioClip;
        File file = new File(this.Groot + string);
        try {
            audioClip = Applet.newAudioClip(file.toURI().toURL());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        this.AUDIOFiles.put(string, audioClip);
        return audioClip;
    }

    public void AUDIOStop(String string) {
        if (this.AUDIOFiles.containsKey(string)) {
            AudioClip audioClip = this.AUDIOFiles.get(string);
            audioClip.stop();
        }
    }
}

