/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class jongsImage {
    private Vector<int[]> transColors;
    private BufferedImage image;
    private Rectangle posSize;
    private String filename;
    boolean view;
    boolean shiftview;
    private String text;
    private Font txtFont;
    private Point txtPos;
    private Color txtColor;

    public jongsImage() {
        this.resetTransColor();
        this.posSize = new Rectangle();
        this.view = false;
        this.shiftview = true;
        this.text = null;
        this.txtFont = null;
        this.txtColor = null;
        this.txtPos = null;
    }

    public void setImage(BufferedImage bufferedImage, ImageObserver imageObserver) {
        this.resetTransColor();
        this.posSize.x = 0;
        this.posSize.y = 0;
        this.posSize.width = bufferedImage.getWidth();
        this.posSize.height = bufferedImage.getHeight();
        this.image = new BufferedImage(this.posSize.width, this.posSize.height, 6);
        Graphics graphics = this.image.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, imageObserver);
        this.text = null;
        this.txtFont = null;
        this.txtColor = null;
        this.txtPos = null;
        this.view = false;
        this.shiftview = true;
    }

    public void setCanvas(int n, int n2, int n3) {
        this.posSize.x = 0;
        this.posSize.y = 0;
        this.posSize.width = n;
        this.posSize.height = n2;
        this.image = new BufferedImage(this.posSize.width, this.posSize.height, 6);
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(new Color(n3));
        graphics.fillRect(0, 0, n, n2);
        this.text = null;
        this.txtFont = null;
        this.txtColor = null;
        this.txtPos = null;
        this.view = false;
        this.shiftview = true;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public void setPoint(int n, int n2) {
        this.posSize.x = n;
        this.posSize.y = n2;
    }

    public void setPoint(Point point) {
        this.posSize.x = point.x;
        this.posSize.y = point.y;
    }

    public void setSize(int n, int n2) {
        this.posSize.width = n;
        this.posSize.height = n2;
    }

    public void setTextParam(String string, int n, int n2, int n3) {
        this.txtFont = new Font(string, n, n2);
        this.txtColor = new Color(n3);
        this.text = "";
    }

    public void setText(String string) {
        this.text = string;
        Graphics graphics = this.image.getGraphics();
        graphics.setFont(this.txtFont);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.txtFont);
        int n = (this.posSize.width - fontMetrics.stringWidth(string)) / 2;
        int n2 = (this.posSize.height + fontMetrics.getHeight()) / 2 - fontMetrics.getHeight() / 4;
        this.txtPos = new Point(n, n2);
    }

    public void drawText(Graphics graphics) {
        if (this.text == null || this.txtFont == null || this.txtColor == null) {
            return;
        }
        if (this.text.trim().length() == 0) {
            return;
        }
        int n = this.posSize.x + this.txtPos.x;
        int n2 = this.posSize.y + this.txtPos.y;
        graphics.setFont(this.txtFont);
        graphics.setColor(Color.WHITE);
        graphics.drawString(this.text, n + 1, n2 + 1);
        graphics.drawString(this.text, n - 1, n2 + 1);
        graphics.drawString(this.text, n + 1, n2 - 1);
        graphics.drawString(this.text, n - 1, n2 - 1);
        graphics.setColor(this.txtColor);
        graphics.drawString(this.text, n, n2);
    }

    public void setView(boolean bl) {
        this.view = bl;
    }

    public void setShiftView(boolean bl) {
        this.shiftview = bl;
    }

    public int getX() {
        return this.posSize.x;
    }

    public int getY() {
        return this.posSize.y;
    }

    public int getWidth() {
        return this.posSize.width;
    }

    public int getHeight() {
        return this.posSize.height;
    }

    public boolean getView() {
        return this.view;
    }

    public boolean getShiftView() {
        return this.shiftview;
    }

    public void setTransColor(int n) {
        if (this.image.getColorModel().getTransparency() == 3) {
            int[] nArray = new int[]{n};
            this.transColors.add(nArray);
            this.setTransImage(n);
        }
    }

    public void setTransColor(int n, int n2, int n3) {
        int n4 = this.image.getRGB(n, n2) & 0xFFFFFF;
        this.setTransColor(n4 |= n3 << 24);
    }

    public void setTransColor(int n, int n2) {
        int n3 = n & 0xFFFFFF;
        this.setTransColor(n3 |= n2 << 24);
    }

    public void setTransColors(Vector<int[]> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.transColors.add(vector.get(i));
            int n = vector.get(i)[0];
            this.setTransImage(n);
        }
    }

    public void resetTransColor() {
        this.transColors = new Vector();
    }

    public void setTransImage(int n) {
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        int n4 = n & 0xFFFFFF;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = this.image.getRGB(j, i) & 0xFFFFFF;
                if (n5 != n4) continue;
                this.image.setRGB(j, i, n);
            }
        }
    }

    public boolean checkImageClick(int n, int n2) {
        if (!this.view) {
            return false;
        }
        if (!this.posSize.contains(n, n2)) {
            return false;
        }
        int n3 = n - this.posSize.x;
        int n4 = n2 - this.posSize.y;
        int n5 = this.posSize.width != this.image.getWidth() ? n3 * this.image.getWidth() / this.posSize.width : n3;
        int n6 = this.posSize.height != this.image.getHeight() ? n4 * this.image.getHeight() / this.posSize.height : n4;
        if (n5 < 0 || n5 >= this.image.getWidth()) {
            return false;
        }
        if (n6 < 0 || n6 >= this.image.getHeight()) {
            return false;
        }
        int n7 = this.image.getRGB(n5, n6) >> 24;
        return n7 != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.filename);
        stringBuffer.append(" ");
        stringBuffer.append(this.posSize.x);
        stringBuffer.append(" ");
        stringBuffer.append(this.posSize.y);
        stringBuffer.append(" ");
        stringBuffer.append(this.posSize.width);
        stringBuffer.append(" ");
        stringBuffer.append(this.posSize.height);
        stringBuffer.append(" ");
        if (this.view) {
            stringBuffer.append("1 ");
        } else {
            stringBuffer.append("0 ");
        }
        if (this.shiftview) {
            stringBuffer.append("1 ");
        } else {
            stringBuffer.append("0 ");
        }
        for (int i = 0; i < this.transColors.size(); ++i) {
            int n = this.transColors.get(i)[0];
            stringBuffer.append(Integer.toHexString(n));
        }
        stringBuffer.append("(");
        return stringBuffer.toString();
    }
}

